#include <allegro.h>
#include "datafile.h"

/*
#include <std_disclaimer.h>

   "I do not accept responsibility for any effects, adverse or otherwise, 
    that this code may have on you, your computer, your sanity, your dog, 
    and anything else that you can think of. Use it at your own risk."
*/

static char copyright[]=
"Scrabster's Sneaky Game"
"by Pete October 2001"
"Created with Allegro [http://alleg.sourceforge.net]"
"You are free to copy and modify this code as you wish";

DATAFILE* dat;
BITMAP* sht=NULL;
BITMAP* info_area;

volatile int ticks;
static void ticker(void)
{
  ++ticks;
} END_OF_FUNCTION(ticker);

volatile int seconds;
static void countdown(void)
{
  if (seconds>0) --seconds;
} END_OF_FUNCTION(countdown);

SAMPLE *snd_mmm, *snd_oof, *snd_cannon;
 
void play_grg(void);	
void do_info(void);
int postmortem(void);
void status2(void);
extern int hiscore;

int main(void)
{
  int game_on;
  FONT* fnt_main;
  allegro_init();
  install_mouse();
  install_keyboard();
  install_timer();
  install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
  LOCK_FUNCTION(ticker);
  LOCK_VARIABLE(ticks);
  LOCK_FUNCTION(countdown);
  LOCK_VARIABLE(seconds);
  set_gfx_mode(GFX_AUTODETECT, 320, 200, 0,0);
  dat=load_datafile("ssgdata.dat");
  game_on=1;
  install_int_ex(ticker, BPS_TO_TIMER(25));
  install_int_ex(countdown, BPS_TO_TIMER(1));
  /* Initialise some stuff from the datafile */
  snd_oof=dat[DAT_Oof].dat;
  snd_mmm=dat[DAT_Mmm].dat;
  snd_cannon=dat[DAT_Cannon].dat;
  fnt_main=dat[DAT_Font].dat;
  hiscore=get_config_int("ssg", "hiscore", 0);
  font=fnt_main;
  info_area=create_bitmap(320, 52);
  while (game_on)
    {
      /* show splash screen */
      blit(dat[DAT_Splash].dat, screen, 0, 0, 0, 0, 320, 200);
      set_palette(dat[DAT_SplashPal].dat);
      status2();
      while (1)
	{
	  rest(100);
	  do_info();
	  if (key[KEY_ESC])
	    {	
	      game_on=0;
	      break;
	    }
	  if (mouse_b || key[KEY_ENTER])
	    {
	      play_grg();
	      break;
	    }
	}
    }
    set_config_int("ssg", "hiscore", hiscore);
    destroy_bitmap(info_area);
  set_gfx_mode(GFX_TEXT, 0 , 0,0,0);
  return 0;
} END_OF_MAIN();

short bx1[]={140,90, 172, 90, 140, 100, 172, 100, 120, 90, 120, 100};
short bx2[]={100,100,200,100,100,120,200,120,132,100,232,100,132,120,232,120};

short wv1[]={60,1, 58,2, 56,2, 40,3, 30,3, 20,5};
short wv2[]={90,4, 80,4, 85,6, 60,2, 58,3, 56,3, 40,4, 30,4, 20,6};
short wv3[]={110,2, 104,3, 102,3,  90,4, 80,4, 85,6, 60,2, 58,3, 56,3, 40,4, 30,4, 20,6};
short wv4[]={180,6, 170,4, 160,2, 150,4, 140,6, 120,1, 110,2, 104,3, 102,3, 90,4, 80,4, 85,6, 60,2, 58,3, 56,3, 40,4, 30,4, 20,6};
struct level
{
  char* desc;
  short init_time;
  short* wave;
  unsigned short n_wave;
  short* boxes;
  unsigned short n_boxes;
  int type[3];
} levels[4]={
  {"Level 1: Monday", 60, wv1, 6, bx1, 4, {DAT_Scrabster1, DAT_Scrabster1, 
					       DAT_Scrabster1}},
  {"Level 2: Tuesday", 90, wv2, 9, bx1, 6,  {DAT_Scrabster1, 
						     DAT_Scrabster3, DAT_Scrabster1}},
  {"Level 3: Wednesday", 120, wv3, 12, bx2, 4,  {DAT_Scrabster1, 
						    DAT_Scrabster2, DAT_Scrabster1}},
  {"Level 4: Thursday", 180, wv4, 18, bx2, 8,  {DAT_Scrabster1, 
						    DAT_Scrabster2, DAT_Scrabster3}},
}, *c_lev;
void setup_level(struct level*);

BITMAP* osb=NULL;
int score=0, hiscore=0;
int clr_fire, clr_stat;

inline void drw(RLE_SPRITE* s, int x, int y)
{
  draw_rle_sprite(osb, s, x-s->w/2, y-s->h/2);
}
 

struct scrabster
{
  RLE_SPRITE* img;
  int x, y;
  int mode;
  int tx, ty;
  fixed vx, vy;
  int t;
  struct scrabster* slave;
};

struct fireq
{
  int x, y;
} fire_queue[10];

int f_t, f_x0, f_y0;
int f_tx, f_ty;
fixed f_vx, f_vy;

static const int e_im[]={DAT_Exp0, DAT_Exp0, DAT_Exp1, DAT_Exp1, 
		       DAT_Exp2, DAT_Exp2, DAT_Exp3, DAT_Exp3 };
int e_x, e_y, e_t;
void do_fire(int b, int x, int y)
{
  fixed r,dx,dy;
  if (b && f_t<0)
    {
      f_x0=x<160 ? 0 : 320;
      f_y0=y<100 ? 0 : 200;
      f_tx=x;
      f_ty=y;
		  dx=itofix(x-f_x0);
		  dy=itofix(y-f_y0);
		  r=fsqrt(fadd(fmul(dx,dx), fmul(dy,dy)));
		  f_t=fixtoi(r);
		  f_vx=fdiv(dx, r);
		  f_vy=fdiv(dy, r);
      play_sample(snd_cannon, 255, 128, 1000, 0);
    }
}

void status(void)
{
  int c=seconds;
  textprintf(osb, font, 240, 0, clr_stat, "SC:%06d", score);
  textprintf(osb, font, 0, 0, clr_stat, "TM: %02d:%02d", c/60, c%60);
}

void status2(void)
{
	int clr_stat=makecol(0,255,255);
  if (score>hiscore) hiscore=score;
  textprintf(screen, font, 240, 0, clr_stat, "SC:%06d", score);
  textprintf(screen, font, 0, 0, clr_stat, "HI: %06d", hiscore);
}
struct scrabster* g_init(struct scrabster* g, int ii)
{
  g->x=rand()%320;
  g->y=rand()%200;
  g->img=dat[ii].dat;
  /* make sure that scrabster is at an edge */
  switch(rand()%4)
    {
    case 0:
      g->x=-g->img->w;
      break;
    case 1:
      g->x=320;
      break;
    case 2:
      g->y=-g->img->h;
      break;
    case 3:
      g->y=200;
      break;
    }
  g->tx=160;
  g->ty=100;
  g->vx=g->vy=itofix(0);
  g->t=1;
  g->mode=0;
  g->slave=NULL;
  return g;
}

#define N_FQ 10
struct scrabster* fqs[N_FQ];

struct scrabster* fq_new(int xx, int yy)
{
  struct scrabster* g=malloc(sizeof(struct scrabster));
  g->x=xx;
  g->y=yy;
  g->mode=5;
  g->img=dat[DAT_Stuff].dat;
  return g;
}

void g_find(struct scrabster* g)
     /* locate an FQ and home in on it */
{
  int i, b;
  fixed dx, dy;
  fixed r;
  b=rand()%N_FQ;
  for (i=0; i<N_FQ; ++i)
    {
      if (fqs[b])
	{
	  g->tx=fqs[b]->x;
	  g->ty=fqs[b]->y;
	  dx=itofix(g->tx-g->x);
	  dy=itofix(g->ty-g->y);
	  r=fsqrt(fadd(fmul(dx,dx), fmul(dy,dy)));
	  g->t=fixtoi(r);
	  g->vx=fdiv(dx, r);
	  g->vy=fdiv(dy, r);
	  g->mode=0;
	  return;
	}
      b=(b+1)%N_FQ;
    }
  /* didn't find one. Beetle off */
  g->mode=3;
}

void move_g(struct scrabster*);

int g_in(struct scrabster* g, int x, int y)
     /* return non-zero if (x,y) lies within this scrabster */
{
  if (g==NULL) return 0;
  x-=g->x;
  y-=g->y;
  return (x>-g->img->w/2 && y>-g->img->h/2 && x<g->img->w/2 && y<g->img->h/2);
}

#define N_G 10
int n_g=0;

void play_grg(void)
{
  int level=0;
  int alive=1;
  static RGB blackrgb={0,0,0,0};
  struct scrabster* gs[N_G], *tmp;
  int i,j, x, y;
  /* In Waves info:*/
  int g_img; /* Image of next scrabster */
  unsigned int nxg; /* index of the current position in the array */
  unsigned int g_waiting; /* number of Scrabsters waiting to be created */

  if (osb==NULL) osb=create_bitmap(320,200);
  set_palette(dat[DAT_GamePalette].dat);
  set_color(0, &blackrgb);
  clr_stat=makecol(255,255,0);
  clr_fire=makecol(0,255,0);
  if (sht==NULL)
  {
	  sht=create_bitmap(9,9);
	  clear(sht);
	  for (i=0; i<5; ++i)
  		circlefill(sht, 4,4,4-i,makecol(0,63*i,0));
  }
  for (i=0; i<N_G; ++i)
    {
      gs[i]=malloc(sizeof(struct scrabster));
    }
   n_g=0;
  score=0;
  text_mode(makecol(0,0,0));
  while(alive)
    {
      clear(screen);
      setup_level(c_lev=&levels[level%4]);
      textout(screen, font, c_lev->desc, 50, 100, clr_stat);
      textprintf(screen, font, 0, 110, clr_stat, 
		 "Time to next level %d:%02d", c_lev->init_time/60, c_lev->init_time%60);
      rest(2000);
      ticks=0;
      seconds=c_lev->init_time;
      f_t=-1;
      e_t=8;
      nxg=0;
      g_waiting=0;
      g_img=0;
      while(alive)
	{  
	  clear(osb);
	  /* Draw the explosion */
	  if (e_t<8)
	    drw(dat[e_im[e_t++]].dat, e_x, e_y);
	    /* draw the FQs */
	  for (i=0; i<N_FQ; ++i)
	    if (fqs[i])
	      {
		drw(fqs[i]->img, fqs[i]->x, fqs[i]->y);
	      }
	  for (i=0; i<n_g; ++i)
	  {
			move_g(gs[i]);
			drw(gs[i]->img, gs[i]->x, gs[i]->y);
		}
	  /* draw a shot */
	  if (f_t>=0)
	    {
	      if (f_t==0)
		{
		  f_t=-1;
/* Start an explosion */
		  e_x=f_tx;
		  e_y=f_ty;
		  e_t=0;
		  /* see if hit */
		  for (j=0; j<n_g; ++j)
			{
			  if (g_in(gs[j], f_tx, f_ty))
			    {
			      /* hit */
			      gs[j]->mode=1;
			      score+=100;
			      play_sample(snd_oof, 255, f_tx*256/320, 1000, 0);
			      break;
			    }
			}
		}
	      else
		{
		  f_t-=6;
		  if (f_t<0) f_t=0;
		  x=f_x0;
		  f_x0=f_tx-fixtoi(f_t*f_vx);
		  y=f_y0;
		  f_y0=f_ty-fixtoi(f_t*f_vy);
//		  line(osb, x, y, f_x0, f_y0, clr_fire);
		  draw_sprite(osb, sht, x-4, y-4);
		}
	      drw(dat[DAT_CrossHair].dat, mouse_x, mouse_y);
	      drw(dat[DAT_Circle].dat, f_tx, f_ty);
	    }
	  else
	    {
	      drw(dat[DAT_Circle].dat, mouse_x, mouse_y);
	      drw(dat[DAT_CrossHair].dat, mouse_x, mouse_y);
	    }
	  /* Think about creating new Scrabsters */
	  if (nxg<c_lev->n_wave && c_lev->wave[2*nxg]>=seconds)
	    {
	      g_waiting+=c_lev->wave[2*nxg+1];
	      ++nxg;
	    }
	  /* Create/destroy Scrabsters as appropriate */
    if (g_waiting>0 && n_g<N_G)
		{
			      g_init(gs[n_g], c_lev->type[g_img]);
			      g_img=(g_img+1)%3;
			      /* initial targetting */
			      g_find(gs[n_g]);
			      --g_waiting;
			      ++n_g;
		}
		/* Kill off old, used ones */
		for (i=0; i<n_g; ++i)
		{
	      if (gs[i]->mode==2)
				{
					--n_g;
					tmp=gs[i];
				  gs[i]=gs[n_g];
				  gs[n_g]=tmp;
				  break;
				}
	  }
	  do_fire(mouse_b, mouse_x, mouse_y);
	  status();
	  while (ticks<1)
	    { yield_timeslice(); }
	  ticks=0;
	  blit(osb, screen, 0, 0, 0, 0, 320, 200);
	  if (key[KEY_SPACE]) save_bitmap("snap.pcx", osb, dat[DAT_GamePalette].dat); 
	  if (key[KEY_ESC] || seconds==0)
	    alive=0;
	}
      if (seconds==0)
	{
	  alive=postmortem();
	  ++level;
	  if (level%4==0)
	   {
	   	/* done all levels */
	   	/* should make harder somehow... */
	   	score+=10000;
	   }
	}
    /* clear up memory for the FQs */
	 for (i=0; i<N_FQ; ++i)
	 {
 		free(fqs[i]);
 		fqs[i]=NULL;
		}
    }
  while (key[KEY_ESC] || mouse_b)
    { }
    /* clear up memory */
	 for (i=0; i<N_G; ++i)
	 {
 		free(gs[i]);
 		gs[i]=NULL;
 	}
}

void move_g(struct scrabster* g)
{
  int i;
  switch(g->mode)
    {
    case 0: /* normal */
      if ((g->t--)==0)
	{
	  /* got there - now find a slave and beetle off */
	  g->slave=NULL;
	  for (i=0; i<N_FQ; ++i)		
	    {
	      if (fqs[i] && g_in(fqs[i], g->x, g->y))
		{
		  g->slave=fqs[i];
		  break;
		}
	    }
	  if (g->slave)
	    {
	      g->mode=3;
	      play_sample(snd_mmm, 255, 128, 1000, 0);
	      return;
	    }
	  else
	    {
				/* another Scrabster snaffled it. */
				/* Find another */
	      g_find(g);
	    }
	}
	/* strictly this should be: */
	/* x=tx-fixtoi(fmul(itofix(t), vx)); */
	/* etc. */
		g->x=g->tx-fixtoi(g->t * g->vx);
		g->y=g->ty-fixtoi(g->t * g->vy);
      break;
    case 1: /* shot, and falling */
      if ((g->y+=10)> 200) g->mode=2;
      break;
    case 2: /* dead - wait here */
      break;
    case 3: /* running off the side of the screen */
      if (g->slave)
	{
	  g->slave->x=g->x;
	  g->slave->y=g->y;
	}
      if (g->x<160)
				g->x-=2;
      if (g->x>=160)
				g->x+=2;
      if (g->x<0 || g->x>320)
		{
		  g->mode=2;
	  	if (g->slave)
	    {
	      for (i=0; i<N_FQ; ++i)
					if (fqs[i]==g->slave)
				  {
				    free(g->slave);
		    		g->slave=fqs[i]=NULL;
		  		}
	    }
		}
      break;
    }
}

char* msg[]={
  "Your mission:",
  " Prevent Scrabster from stealing ",
  " all your stuff by giving him a ",
  " good blast of what's good for him.",
  "",
  "",
  "Press the mouse button to start",
  "Press ESC to exit"
  "",
  "",
  ""};
#define I_TOP 135
void do_info(void)
{
	static int bg=-1, fg;
  static int ln=0, tc=0;
  text_mode(bg);
  if (bg<0) {
	bg=getpixel(screen,319,199);
	fg=makecol(255,255,255);
	clear_to_color(info_area, bg);
  }
  if (tc++ > 10)
    {
      textout(info_area, font, msg[ln], 0, info_area->h-text_height(font), fg);
      ln=(ln+1)%(sizeof(msg)/sizeof(*msg));
      tc=0;
    }
  blit(info_area, info_area, 0, 1, 0, 0, info_area->w, info_area->h);
  hline(info_area, 0, info_area->h-1, info_area->w, bg);
  blit(info_area, screen, 0, 0, 0, I_TOP, info_area->w, 40);
}
	
	
void setup_level(struct level* l)
{
  short* pq=l->boxes;
  short nq=l->n_boxes;
  int x,y;
  int i;
  for (i=0; i<N_FQ; ++i)
    fqs[i]=NULL;
  i=0; 
  while (nq-- && i<N_FQ)
    {
      x=(int) *pq++;
      y=(int) *pq++;
      fqs[i++]=fq_new(x, y);
    }
}

int postmortem(void)
     /* evaluate what's left, return 0 if all FQs gone */
{
  int ct=0;
  int i;
  clear(screen);
  for (i=0; i<N_FQ; ++i)
    {
      if (fqs[i])
	{
	  draw_rle_sprite(screen, dat[DAT_Stuff].dat, 30+10*(ct++), 100);
	  rest(200);
	}
    }
  textprintf(screen, font, 30, 140, makecol(0,255,0), "Bonus %d", 1000*ct);
  rest(2000);
  return ct;
}


