#include "guigsdef.h"
#include "allegro.h"

#include "c_hexbut.h"

c_hexbut::c_hexbut(int _x, int _y, int _l, int _tipo)
{
  x = _x;
  y = _y;
  l = _l;
  t = l*2+1;
  tipo = _tipo;
  normal = create_bitmap(t, t);
  //clear_to_color(normal, RGB(31, 0, 31));
  clear_to_color(normal, MASK_COLOR_16);
  pressionado = create_bitmap(t, t);
  clear_to_color(pressionado, MASK_COLOR_16);
  //clear_to_color(pressionado, RGB(31, 0, 31));
  estado = 0; // neutro
  atualizar = true;
}

bool c_hexbut::avalia()
{
  bool apontado;
  bool mousebot;
  int mx = mouse_x - x-1;
  int my = mouse_y - y-1;
  
  // verifica se o mouse esta sobre o botao
  if (tipo == 2) {
    if (my > 0 && my < int(2*0.866*l)) {
      if (my <= int(0.866*l)) { // metade de cima
        if (mx > l/2 -my/2 && mx <= l+l/2+ my/2)
          apontado = true;
        else
          apontado = false;
      }
      else { // metade de baixo
        if (mx > int((my-0.866*l)/2) && mx-l-l/2 <= int(0.866*l-my/2))
          apontado = true;
        else
          apontado = false;
      }
    }
    else // esta muito longe do botao
      apontado = false;
  } // fim da verificacao de botao do tipo 2 semdo apontado
  
  mousebot = mouse_b & 1;
  switch(estado) {
    case 0:
      if (apontado && mousebot) {
        estado = 1; // apertando no botao
        atualizar = true;
      }
      else if (mousebot)
        estado = 2; // apertando fora do botao
      break;
    case 1:
      if (!apontado) {
        if (mousebot)
          estado = 3; // estava apertando no botao, mas agora esta apontando fora
        else
          estado = 0;
        atualizar = true;
      }
      else if (!mousebot) {
        atualizar = true;
        estado = 0;
        return true; // gotcha!
      }
      break;
    case 2:
      if (!mousebot)
        estado = 0;
      break;
    case 3:
      if (apontado && mousebot) {
        estado = 1;
        atualizar = true;
      }
      else if (!mousebot)
        estado = 0;
      break;
  }
  return false;
}

void c_hexbut::atualiza()
{
  if (atualizar) {
    if (estado == 1)
      //masked_blit (pressionado, screen, 0, 0, x, y, t, t);
      draw_sprite (screen, pressionado, x, y);
    else
      //masked_blit (normal, screen, 0, 0, x, y, t, t);
      draw_sprite (screen, normal, x, y);
    atualizar = false;
  //  textprintf(screen, font, x+5, y+8, RGB(1, 2, 1), "%d ", estado);
  }
}

void c_hexbut::fazbut(int r, int g, int b, int e, const char *tex) {
  clear_to_color(normal, MASK_COLOR_16);
  clear_to_color(pressionado, MASK_COLOR_16);
  //clear_to_color(normal, RGB(31, 0, 31));
  //clear_to_color(pressionado, RGB(31, 0, 31));
  desenhahexn2 (normal,      0, 0, l, r, g, b, e);
  desenhahexp2 (pressionado, 0, 0, l, r, g, b, e);
  text_mode(-1);
  textprintf_centre(normal     , font, t/2,   int(l*0.866)-4, RGB(max(r- 7, 0), max(g-14, 0), max(b- 7, 0)), "%s", tex);
  textprintf_centre(pressionado, font, t/2+1, int(l*0.866)-3, RGB(max(r-10, 0), max(g-20, 0), max(b-10, 0)), "%s", tex);
}


c_hexbut::~c_hexbut()
{
  destroy_bitmap(normal);
  destroy_bitmap(pressionado);
}


// tipo de hexagono
//      /\          __
// 1 = |  |   2 =  /  \
//      \/         \__/

// desenha um hexagono em bmp
// nas coordenadas x, y (canto superior esquerdo do quadrado em volta do hexagono)
// com lado de tamanho l
// com a cor definida por r = red (0-31) g = green(0-63) b = blue(0-31)
// e espessura da borda = e

void desenhahexn1(BITMAP *bmp, int x, int y, int l, int r, int g, int b) {
  vline (bmp,                    x,     y + l/2,                       y + l/2 + l, RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
  line  (bmp,                    x,     y + l/2, int(x + l * 0.866),             y, RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
  line  (bmp, int(x + l * 0.866)+1,           y, int(x + 2*l*0.866)+1,     y + l/2, RGB(min(r+1, 31), min(g+ 2, 63), min(b+1, 31)));
  vline (bmp, int(x + 2*l*0.866)+1,     y + l/2,                       y + l/2 + l, RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
  line  (bmp, int(x + 2*l*0.866)+1, y + l/2 + l, int(x + l * 0.866)+1,     y + 2*l, RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
  line  (bmp,   int(x + l * 0.866),     y + 2*l,                    x, y + l/2 + l, RGB(min(r+1, 31), min(g+ 2, 63), min(b+1, 31)));
  floodfill (bmp, x + int(l*0.866), y + l, RGB(r, g, b));
}

void desenhahexp1(BITMAP *bmp, int x, int y, int l, int r, int g, int b) {
  vline (bmp,                    x,     y + l/2,                       y + l/2 + l, RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
  line  (bmp,                    x,     y + l/2, int(x + l * 0.866),             y, RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
  line  (bmp, int(x + l * 0.866)+1,           y, int(x + 2*l*0.866)+1,     y + l/2, RGB(min(r+1, 31), min(g+ 2, 63), min(b+1, 31)));
  vline (bmp, int(x + 2*l*0.866)+1,     y + l/2,                       y + l/2 + l, RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
  line  (bmp, int(x + 2*l*0.866)+1, y + l/2 + l, int(x + l * 0.866)+1,     y + 2*l, RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
  line  (bmp,   int(x + l * 0.866),     y + 2*l,                    x, y + l/2 + l, RGB(min(r+1, 31), min(g+ 2, 63), min(b+1, 31)));
  floodfill (bmp, x + int(l*0.866), y + l, RGB(max(r-5, 0), max(g-10, 0), max(b-5, 0)));
}

void desenhahexn2(BITMAP *bmp, int x, int y, int l, int r, int g, int b, int e) {
  int i;
  for (i=0; i<e; i++) {
    line  (bmp, x+i, int(y + 0.866*l), x + l/2,  y+i,                           RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
    hline (bmp, x + l/2,          y+i, x + l + l/2,                             RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
    line  (bmp, x + l + l/2,      y+i, x + 2*l-i, int(y + 0.866*l),             RGB(max(r-1,  0), max(g- 2,  0), max(b-1,  0)));
    line  (bmp, x + 2*l-i, int(y + 0.866*l), x + l + l/2, int(y + 2*0.866*l)-i, RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
    hline (bmp, x + l + l/2, int(y + 2*0.866*l)-i, x + l/2,                     RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
    line  (bmp, x + l/2, int (y + 2*0.866*l)-i, x+i, int(y + 0.866*l),          RGB(max(r-1,  0), max(g- 2,  0), max(b-1,  0)));
  }
  floodfill (bmp, x + l, int(y + 0.866*l), RGB(r, g, b));
}

void desenhahexp2(BITMAP *bmp, int x, int y, int l, int r, int g, int b, int e) {
  int i;
  for (i=0; i<e; i++) {
    line  (bmp, x+i, int(y + 0.866*l), x + l/2,  y+i,                           RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
    hline (bmp, x + l/2,          y+i, x + l + l/2,                             RGB(max(r-9,  0), max(g-18,  0), max(b-9,  0)));
    line  (bmp, x + l + l/2,      y+i, x + 2*l-i, int(y + 0.866*l),             RGB(max(r-1,  0), max(g- 2,  0), max(b-1,  0)));
    line  (bmp, x + 2*l-i, int(y + 0.866*l), x + l + l/2, int(y + 2*0.866*l)-i, RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
    hline (bmp, x + l + l/2, int(y + 2*0.866*l)-i, x + l/2,                     RGB(min(r+5, 31), min(g+10, 63), min(b+5, 31)));
    line  (bmp, x + l/2, int (y + 2*0.866*l)-i, x+i, int(y + 0.866*l),          RGB(max(r-1,  0), max(g- 2,  0), max(b-1,  0)));
  }
  floodfill (bmp, x + l, int(y + 0.866*l), RGB(max(r-5, 0), max(g-10, 0), max(b-5, 0)));
}
