// CAMPO MINADO HEXAGONAL
// ----------------------
// VERSAO 1.3
//    por
// Guilherme Goettems Schneider
// guigs@via-rs.net
// Setembro de 2001 (inicio Maio)

// Meus melhores tempos (ate' 04/10/2001)
// Facil:   lado  5,  10 minas  recorde: 0'00"32
// Medio:   lado 10,  50 minas  recorde: 0'35"10
// Dificil: lado 13, 100 minas  recorde: 1'27"92


#define LARGURA 800//640  //Largura em pixels da tela
#define ALTURA 600//480   //Altura em pixels da tela

// cor do fundo
#define FR 8
#define FG 30
#define FB 20

// linguas
#define LINGLES     0
#define LPORTUGUES  1
#define LESLOVAQUIO 2

#define LPS 50      //Lacos por segundo
#include "guigsdef.h"

#include <stdio.h>
//#include <bios.h>
#include <time.h>
#include <stdlib.h>
#include "allegro.h"
#include "cpmihex.h"
#include "cpmihx2.h"
#include "hex.h"
#include "c_hexbut.h"
#include "c_melhor.h"

/*
BEGIN_GFX_DRIVER_LIST
  GFX_DRIVER_VBEAF
  GFX_DRIVER_VESA3
  GFX_DRIVER_VESA2L
  GFX_DRIVER_VESA2B
  GFX_DRIVER_VESA1
END_GFX_DRIVER_LIST
*/


BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_16
END_COLOR_DEPTH_LIST

BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST


//typedef struct {
//  int x, y; // coordenadas
//  int estado;
//} hexagono;

//void abrir(int x, int y, int cv[MAX_X][MAX_Y], int cr[MAX_X][MAX_Y]);
void abrir(int x, int y);
char *texto(char *l1, char *l2, char *l3);


volatile int counter;
volatile int cronometro;
volatile int fps;          // frames per second
volatile int frame_count;  // contador dos frames
volatile int rc;
volatile int rc_count;


void func_tempo() // Executa LPS vezes por segundo
{
  counter++;
  cronometro++;
}
END_OF_FUNCTION(func_tempo);

void func_fps() // Executa a cada segundo
{
  fps = frame_count;
  rc = rc_count;
  rc_count = 0;
  frame_count = 0;
}
END_OF_FUNCTION(func_fps);

int lingua = 0;

int vivo;

int campo[MAX_X][MAX_Y];     // campo visivel
int campor[MAX_X][MAX_Y];    // campo real


//hexagono lhm[MAX_X*MAX_Y]; // lista de hex modificados
//int pti, ptf; // ponteiros p/ inicio e fim da lista de
c_lista_hex lhm;

int aberto;
int totminas = 50;
int tothex;

/*
BITMAP *tela;
void salvatela () {
  tela = create_bitmap(LARGURA, ALTURA);
  blit (screen, tela, 0, 0, 0, 0, LARGURA, ALTURA);
}
void resumetela () {
  acquire_screen();
  scare_mouse();
  blit (tela, screen, 0, 0, 0, 0, LARGURA, ALTURA);
  destroy_bitmap(tela);
  unscare_mouse();
  release_screen();
}
*/

int main()
{
  //Variaveis
  //BITMAP *tela;
  BITMAP *janela;
  BITMAP *janelabuf;
  DATAFILE *dados;
  FILE *arqmelhores;
  FILE *arqpref;
  int fpsp; // ltimo mostrado na tela
  int i,j,n;
  int e;
  int x,y;
  int z;
  int nivel; // 0 - personalizado, 1 - facil, 2 - medio, 3 - dificil
  c_melhor melhorestempos[3];
  
//  int campo[MAX_X][MAX_Y];     // campo visivel
//  int campor[MAX_X][MAX_Y];    // campo real
  int campox, campoy;
  int cron, crona;
  int faltam, faltama; // numero de hexagonos que faltam abrir
  int mb, mx, my; // mouse_b, mouse_x, mouse_y
  bool mb1clk, mb2clk, mb1hld, mb2hld;
  bool mb1, mb2;
  bool mb1unclk, mb2unclk;
  bool mbbhld;

  /*
   campor = 0 -> hexagono inexistente (invisivel)
   campor = 1 -> hexagono sem mina (ainda nao foi contado quantas tem ao redor)
   campor = 9 -> hexagono com mina
   campor = 10 -> hexagono sem mina e sem vizinhos com mina
   compor = 11 -> hexagono sem mina com um vizinho com mina
   etc.
  
   campo = 0 -> hexagono inexistente (invisivel)
   campo = 1 -> hexagono nao aberto
   campo = 2 -> hexagono sendo pressionado
   campo = 3 -> hexagono sendo pressionado (piscando)
   campo = 7 -> hexagono marcado errado
   campo = 8 -> hexagono marcado
   campo = 9 -> hexagono com mina aberta
   campo = 10 -> hexagono vazio aberto sem vizinhos com mina
   campo = 11 -> hexagono vazio aberto com um vizinho com mina
   campo = 12 -> hexagono vazio aberto com dois vizinhos com mina
   etc.
  */
  
  int lado = 10;
  int continua;
  int sair;
  //int jabot2;
  bool ja_comecou;
  int posicao = 0;
  bool procvenc = false;
  bool mostramelhores = false;
  bool usavsync = true;
  bool primeiravez = true; // e' o primeiro jogo (para inicializar srand())
  bool ja_achou_hex_apontado; // nome ja' diz tudo :-)
  bool dclk = false; // usado para saber se h hexagonos piscando (no duplo clique)
  int axapont; // antigo hexagono (coord x) apontado
  int ayapont; // antigo hexagono (coord y) apontado
  bool comecouaapontar = false; // quando o hexagono comecou a ser apontado

  //Inicializacao do Allegro
  set_uformat(U_ASCII);
  allegro_init();
  install_keyboard();
  install_timer();
  install_mouse();

  set_color_depth(16);
  if (set_gfx_mode(GFX_AUTODETECT, LARGURA, ALTURA, 0, 0)) {
    allegro_message("GFX error: %s", allegro_error);
    allegro_exit();
    //printf ("GFX error\n");
    return 1;
  }

  //set_display_switch_callback(SWITCH_OUT, salvatela);
  //set_display_switch_callback(SWITCH_IN, resumetela);
  show_mouse(screen);

  //tela = create_bitmap(LARGURA, ALTURA);

  //Controle de tempo
  LOCK_VARIABLE(counter);
  LOCK_VARIABLE(cronometro);
  LOCK_VARIABLE(fps);
  LOCK_VARIABLE(frame_count);
  LOCK_VARIABLE(rc);
  LOCK_VARIABLE(rc_count);
  LOCK_FUNCTION(func_tempo);
  LOCK_FUNCTION(func_fps);

  install_int_ex(func_tempo,BPS_TO_TIMER(LPS));
  install_int_ex(func_fps,BPS_TO_TIMER(1));

  text_mode(RGB(FR, FG, FB));

  dados = load_datafile("cpmihex.dat");
  if (dados == NULL) {
    allegro_message ("cpmihex.dat couldn't be loaded.");
    allegro_exit();
    //printf ("cpmihex.dat couldn't be loaded.\n");
    return 1;
  }

  font = (FONT *)dados[FONTE].dat;

  for (i=0; i<3; i++)
    melhorestempos[i].direcao = 2;

  arqmelhores = fopen("melhores.cmh", "rb");
  if (arqmelhores != NULL) {
    if (fread(melhorestempos, sizeof(c_melhor), 3, arqmelhores) < 3) {
      for (i=0; i<3; i++) {
        melhorestempos[i].zera("Nobody", 600*LPS-1);
      }
    }
    fclose(arqmelhores);
  } else {
    for (i=0; i<3; i++) {
      melhorestempos[i].zera("Nobody", 600*LPS-1);
    }
  }


  // cria botoes

  //                  (  x,   y, lado, tipo)
  c_hexbut iniciobut  (73,   70,   34,  2);
  c_hexbut sairbut    (73,  130,   34,  2);
  c_hexbut facilbut   (20,  100,   34,  2);
  c_hexbut mediobut   (73,   10,   34,  2);
  c_hexbut dificilbut (126, 100,   34,  2);
  c_hexbut melhoresbut(20,   40,   34,  2);
  c_hexbut sobrebut   (126,  40,   34,  2);
  
  c_hexbut lingport(20, ALTURA-100, 21, 2);
  desenhahexn2 (lingport.normal,      0, 0, 21, 18, 42, 12, 2);
  desenhahexp2 (lingport.pressionado, 0, 0, 21, 18, 42, 12, 2);
  blit((BITMAP *)dados[PORT].dat, lingport.normal,      0, 0,  8, 10, 26, 16);
  blit((BITMAP *)dados[PORT].dat, lingport.pressionado, 0, 0,  9, 11, 26, 16);

  c_hexbut lingingles(53, ALTURA-119, 21, 2);
  desenhahexn2 (lingingles.normal,      0, 0, 21, 18, 42, 12, 2);
  desenhahexp2 (lingingles.pressionado, 0, 0, 21, 18, 42, 12, 2);
  blit((BITMAP *)dados[INGLES].dat, lingingles.normal,      0, 0,  8, 10, 26, 16);
  blit((BITMAP *)dados[INGLES].dat, lingingles.pressionado, 0, 0,  9, 11, 26, 16);

  c_hexbut lingeslov(53, ALTURA-81, 21, 2);
  desenhahexn2 (lingeslov.normal,      0, 0, 21, 18, 42, 12, 2);
  desenhahexp2 (lingeslov.pressionado, 0, 0, 21, 18, 42, 12, 2);
  blit((BITMAP *)dados[ESLOV].dat, lingeslov.normal,      0, 0, 8, 10, 26, 16);
  blit((BITMAP *)dados[ESLOV].dat, lingeslov.pressionado, 0, 0, 9, 11, 26, 16);


  c_hexbut maislado(LARGURA-230, 14, 11, 2);
  maislado.fazbut(16,42,14, 1, "+");
  c_hexbut menoslado(LARGURA-230, 34, 11, 2);
  menoslado.fazbut(16,42,14, 1, "-");
  
  c_hexbut maismina(LARGURA-230, 60, 11, 2);
  maismina.fazbut(16,42,14, 1, "+");
  c_hexbut menosmina(LARGURA-230, 80, 11, 2);
  menosmina.fazbut(16,42,14, 1, "-");

  arqpref = fopen("prefere.cmh", "rb");
  if (arqpref != NULL) {
    fread(&nivel, sizeof(int), 1, arqpref);
    fread(&lado, sizeof(int), 1, arqpref);
    fread(&totminas, sizeof(int), 1, arqpref);
    fread(&usavsync, sizeof(bool), 1, arqpref);
    fread(&lingua, sizeof(int), 1, arqpref);
    switch (nivel) {
      case 1: facilbut.estado = 1; break;
      case 2: mediobut.estado = 1; break;
      case 3: dificilbut.estado = 1; break;
    }
    fclose(arqpref);
  }
  else {
    mediobut.estado = 1;
    nivel = 2;
  }

  text_mode(RGB(FR, FG, FB));

  //inicio:
  do { // inicio do jogo

    if (lingua == LESLOVAQUIO)
      font = (FONT *)dados[FONTEESLOV].dat;
    else
      font = (FONT *)dados[FONTE].dat;
      
    //                (r, g, b, esp, texto)
    iniciobut.fazbut  (14,36,18, 2, texto("Start", "Incio", "tart"));
    sairbut.fazbut    (12,32,15, 2, texto("Quit", "Sair", "Koniec"));
    facilbut.fazbut   (14,46,14, 2, texto("Easy", "Fcil", "Mal"));
    mediobut.fazbut   (20,40,10, 2, texto("Medium", "Mdio", "Stredn"));
    dificilbut.fazbut (24,34,10, 2, texto("Hard", "Difcil", "Vek"));
    melhoresbut.fazbut(18,38,20, 2, texto("Heroes", "Melhores", "Vazi"));
    sobrebut.fazbut   (18,38,20, 2, texto("About", "Sobre", "O hre"));

    switch (nivel) {
      case 1: lado =  5; totminas =  10; break;
      case 2: lado = 10; totminas =  50; break;
      case 3: lado = 13; totminas = 100; break;
    }

    for (i=0;i<MAX_X;i++) for (j=0; j<MAX_Y; j++) {
      campo[i][j] = 0;
      campor[i][j] = 0;
    }

    if (lado < 2) lado = 2;
    if (totminas < 2) totminas = 2;

    if (lado*2-1 > MAX_X || lado*2-1 > MAX_Y) lado = min(MAX_X, MAX_Y)/2;
    // numero total de hexagonos = 3lado^2-3lado+1
    tothex = 3*lado*lado-3*lado+1;
    if (totminas*100/tothex > 70) totminas = tothex*7/10+1;
    //if (totminas >= tothex-2) totminas = tothex-2;


    // cria um campo hexagonal
    for (j=0; j<lado; j++) {
      for (i=-j/2+((j+1)%2); i<j/2+lado+1; i++) {
        if (i+lado/2-1 < 0) exit(22);
        campo[i+lado/2-1][j] = 1;
        campor[i+lado/2-1][j] = 1;
      }
    }
    for (j=lado-2; j>=0; j--) {
      for (i=-j/2+((j+1)%2); i<j/2+lado+1; i++) {
        campo[i+lado/2-1][lado*2-2-j] = 1;
        campor[i+lado/2-1][lado*2-2-j] = 1;
      }
    }

    campox = (LARGURA-20*(lado*2-1))/2;      // 160
    campoy = (ALTURA-12*(lado*2-1))/2-5;   // 110

    acquire_screen();
    scare_mouse();
    clear_to_color(screen, RGB(FR, FG, FB));

    //masked_blit((BITMAP *)dados[TEMPO].dat, screen, 0,0, LARGURA/2-58, 2, 116, 135);
    draw_sprite(screen, (BITMAP *)dados[TEMPO].dat, LARGURA/2-58, 2);

    //masked_blit (sairbut.normal, screen, 0, 0, 20, 50, sairbut.t, sairbut.t);

    switch (lingua) {
      case LINGLES     : lingingles.estado = 1; break;
      case LPORTUGUES  : lingport.estado   = 1; break;
      case LESLOVAQUIO : lingeslov.estado  = 1; break;
      default          : lingingles.estado = 1; lingua = LINGLES;
    }

    switch(nivel) {
      case 1: facilbut.estado   = 1; break;
      case 2: mediobut.estado   = 1; break;
      case 3: dificilbut.estado = 1; break;
    }

    textprintf(screen, font, LARGURA-200, 25, 63000, texto("Size: ", "Lado: ", "Vek.: "));
    textprintf(screen, font, LARGURA-200, 40, 63000, texto("          Hexagons: %d", "Total de hexgonos: %d", "         Hexagonov: %d"), tothex);
    //masked_blit((BITMAP *)dados[HEX9].dat, screen, 0,0, LARGURA-203, 67, 20,22);
    draw_sprite(screen, (BITMAP *)dados[HEX9].dat, LARGURA-203, 67);
    textprintf(screen, font, LARGURA-181, 73, 63000, ": %d (%d%%)", totminas, totminas*100/tothex);
    if (usavsync)
      textprintf(screen, font, LARGURA-80, ALTURA-10, 63000, "vsync on ");
    else
      textprintf(screen, font, LARGURA-80, ALTURA-10, 63000, "vsync off");

    text_mode(-1);
    for (i=0; i<lado; i++) {
      desenhahexn1 (screen, LARGURA-155+i*10, 24, 5, 20, 40, 10);
      textprintf(screen, (FONT *)dados[SMALLNUM].dat, LARGURA-155+i*10, 26, RGB(10, 20, 5), "%2d", i+1);
    }
    text_mode(RGB(FR, FG, FB));


    sairbut.atualizar     = true; sairbut.atualiza();
    iniciobut.atualizar   = true; iniciobut.atualiza();
    facilbut.atualizar    = true; facilbut.atualiza();
    mediobut.atualizar    = true; mediobut.atualiza();
    dificilbut.atualizar  = true; dificilbut.atualiza();
    melhoresbut.atualizar = true; melhoresbut.atualiza();
    sobrebut.atualizar    = true; sobrebut.atualiza();
    maislado.atualizar    = true; maislado.atualiza();
    menoslado.atualizar   = true; menoslado.atualiza();
    maismina.atualizar    = true; maismina.atualiza();
    menosmina.atualizar   = true; menosmina.atualiza();
    lingport.atualizar    = true; lingport.atualiza();
    lingingles.atualizar  = true; lingingles.atualiza();
    lingeslov.atualizar   = true; lingeslov.atualiza();
    


    //vline (screen,                  x,       y + z/2,                        y + z/2 + z, RGB(27, 54, 0));
    //line  (screen,                  x,       y + z/2,   int(x + z * 0.866),            y, RGB(27, 54, 0));
    //line  (screen, int(x + z * 0.866)+1,           y,  int(x + 2*z*0.866)+1,     y + z/2, RGB(23, 46, 0));
    //vline (screen, int(x + 2*z*0.866)+1,     y + z/2,                        y + z/2 + z, RGB(14, 28, 0));
    //line  (screen, int(x + 2*z*0.866)+1, y + z/2 + z, int(x + z * 0.866)+1,    y + 2*z, RGB(14, 28, 0));
    //line  (screen, int(x + z * 0.866),       y + 2*z,                   x, y + z/2 + z, RGB(23, 46, 0));
    //floodfill (screen, x + int(z*0.866), y + z, RGB(22, 44, 0));

    // imprime hexagonos na tela
    for (i=0; i<MAX_X; i++) {
      for (j=0; j<MAX_Y; j++) {
        if (campo[i][j] == 1)
          //masked_blit ((BITMAP *)dados[HEX1].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22);
          draw_sprite (screen, (BITMAP *)dados[HEX1].dat, campox+i*20+10*(j%2), campoy+17*j);
        //else
        //  masked_blit ((BITMAP *)dados[HEX7].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22);
      }
    }

    //show_mouse(screen);
    unscare_mouse();
    release_screen();

    //show_mouse(tela);
    crona = -1;
    cron = 0;
    ja_comecou = false;
    vivo = 1;
    continua = 1;
    sair = 0;
    aberto = 0; // no. de hexagonos abertos
    faltama = -1;
    //aberto2 = 0;
    //jabot2 = 0;
    mb1clk = false; mb2clk = false; mb1hld = false; mb2hld = false;
    mb1unclk = false;
    mbbhld = 0;
    procvenc = false;
    axapont = -1;
    ayapont = -1;


    while (continua) {
      //Saida: Graficos
      acquire_screen();
      scare_mouse();
      //show_mouse(NULL);
      //if (ja_comecou && vivo) {
        if (!ja_comecou) cronometro = 0;
        if (cronometro/LPS>=600) cronometro = 600*LPS-1;
        //if (vivo) textprintf(screen, font, 300, 70, 63000, "Tempo: %1d,%02ds   ", cronometro/LPS, (cronometro%LPS)*100/LPS);

        if (vivo) cron = cronometro;
        if (cron != crona) {
          text_mode(0);
          textprintf(screen, (FONT *)dados[NUMHEX].dat, LARGURA/2-52, 44, RGB( 8, 6, 2), "8888888");
          text_mode(-1);
          textprintf(screen, (FONT *)dados[NUMHEX].dat, LARGURA/2-52, 44, RGB(31, 20, 8), "%1d'%02d\"%02d", min(9, cron/LPS/60), (cron/LPS)%60, (cron%LPS)*100/LPS);
          text_mode(RGB(FR, FG, FB));
          crona = cron;
        }
        //aberto2 = 0;
        //for (i=0; i<MAX_X; i++) {
        //  for (j=0; j<MAX_Y; j++) {
        //    if (campo[i][j] >= 10) aberto2++;
        //  }
        //}
        faltam = tothex-totminas-aberto;
        if (faltam != faltama) {
          textprintf(screen, font, LARGURA-230, 110, 63000, texto ("There are %d empty hexagons. ", " Faltam abrir %d hexgonos.   ", "Poet przdnych %d hexagnov.    "), faltam);
          faltama = faltam;
        }

        if (fpsp != fps) {
          text_mode(RGB(FR, FG, FB));
          textprintf(screen, font, LARGURA-80, ALTURA-20, 63000, "FPS: %d   ", fpsp);
          if (usavsync)
            textprintf(screen, font, LARGURA-80, ALTURA-10, 63000, "vsync on ");
          else
            textprintf(screen, font, LARGURA-80, ALTURA-10, 63000, "vsync off");

          //textprintf(screen, font, 10, 20, 63000, "Setas para cima/baixo: aumenta/diminui o lado");
          //textprintf(screen, font, 10, 30, 63000, "Telcas +/-: aumenta/diminui numero de minas");
          //textprintf(screen, font, 10, 40, 63000, "Telca I: inicia novo jogo");
          //textprintf(screen, font, 10, 50, 63000, "Telca ESC: termina");
          fpsp = fps;
        }
        /*
        textprintf(screen, font, 005, ALTURA-20, 63000, "                                                                        ");
        if (mb1clk) textprintf(screen, font, 005, ALTURA-20, 63000, "mb1clk");
        if (mb1hld) textprintf(screen, font, 105, ALTURA-20, 63000, "mb1hld");
        if (mb2clk) textprintf(screen, font, 205, ALTURA-20, 63000, "mb2clk");
        if (mb2hld) textprintf(screen, font, 305, ALTURA-20, 63000, "mb2hld");
        if (mbbhld) textprintf(screen, font, 405, ALTURA-20, 63000, "mbbhld");
        if (mb1unclk) textprintf(screen, font, 505, ALTURA-20, 63000, "mb1unclk");
//        if (mb1clk) textprintf(screen, font, 305, ALTURA-20, 63000, "mb1clk");
        //*/

        sairbut.atualiza();
        iniciobut.atualiza();
        if (nivel == 0 || nivel == 2 || nivel == 3) facilbut.atualiza();
        if (nivel == 0 || nivel == 1 || nivel == 3) mediobut.atualiza();
        if (nivel == 0 || nivel == 1 || nivel == 2) dificilbut.atualiza();
        if (lingua != LINGLES)     lingingles.atualiza();
        if (lingua != LPORTUGUES)  lingport.atualiza();
        if (lingua != LESLOVAQUIO) lingeslov.atualiza();

        melhoresbut.atualiza();
        sobrebut.atualiza();

        maislado.atualiza();
        menoslado.atualiza();
        maismina.atualiza();
        menosmina.atualiza();



      //}

      while (lhm.pop(i, j, e)) { // atualiza hexagonos
        campo[i][j] = e;
        switch (e) {
          case  1: //masked_blit((BITMAP *)dados[HEX1].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX1].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case  2: case 10:
                   //masked_blit((BITMAP *)dados[HEX2].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX2].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case  3: draw_sprite (screen, (BITMAP *)dados[HEX3].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case  7: //masked_blit((BITMAP *)dados[HEX7].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX7].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case  8: //masked_blit((BITMAP *)dados[HEX8].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX8].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case  9: //masked_blit((BITMAP *)dados[HEX9].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX9].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          //case 10: //masked_blit((BITMAP *)dados[HEX2].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
          //         draw_sprite (screen, (BITMAP *)dados[HEX2].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 11: //masked_blit((BITMAP *)dados[HEX11].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX11].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 12: //masked_blit((BITMAP *)dados[HEX12].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX12].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 13: //masked_blit((BITMAP *)dados[HEX13].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX13].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 14: //masked_blit((BITMAP *)dados[HEX14].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX14].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 15: //masked_blit((BITMAP *)dados[HEX15].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX15].dat, campox+i*20+10*(j%2),campoy+17*j); break;
          case 16: //masked_blit((BITMAP *)dados[HEX16].dat, screen, 0,0, campox+i*20+10*(j%2),campoy+17*j, 20,22); break;
                   draw_sprite (screen, (BITMAP *)dados[HEX16].dat, campox+i*20+10*(j%2),campoy+17*j); break;
        }
      }

      /*
      for (j=0; j<MAX_Y; j++) {
        for (i=0; i<MAX_X; i++) {
          switch (campo[i][j]) {
            case 1: masked_blit (dados[HEX1].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 2: masked_blit (dados[HEX2].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 9: masked_blit (dados[HEX9].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 10: masked_blit (dados[HEX2].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 11: masked_blit (dados[HEX11].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 12: masked_blit (dados[HEX12].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 13: masked_blit (dados[HEX13].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 14: masked_blit (dados[HEX14].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 15: masked_blit (dados[HEX15].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
            case 16: masked_blit (dados[HEX16].dat, tela, 0,0, 160+i*20+10*(j%2),110+17*j, 20,22); break;
          }
        }
      }
      */

      unscare_mouse();
      release_screen();
      //show_mouse(screen);

      if (usavsync) vsync();
      else
        while (counter == 0);

      //Fim da saida

      if (sobrebut.avalia()) {
        text_mode(-1);
        janela = create_bitmap(400,300);
        janelabuf = create_bitmap(400, 300);
        clear_to_color(janela, RGB(0, 18, 18));

        textprintf_centre(janela, font, 200,  20, 63000, texto("HEXAGONAL MINESWEEPER", "CAMPO MINADO HEXAGONAL", "Hadanie mn - HEXAGON"));
        textprintf_centre(janela, font, 200,  35, 63000, texto("Version: 1.3 (Windows)", "Verso 1.3 (Windows)", "Verzia: 1.3 (Windows)"));
        textprintf_centre(janela, font, 200,  60, 63000, texto("by", "por", "napsal"));
        textprintf_centre(janela, font, 200,  85, 63000, "Guilherme Goettems Schneider");
        textprintf_centre(janela, font, 200, 110, 63000, "guigs@via-rs.net");
        textprintf_centre(janela, font, 200, 125, 63000, "www.geocities.com/guibocca");
        textprintf_centre(janela, font, 200, 160, 63000, texto("Written in C++, using DJGPP 2.03 from DJ Delorie", "Feito em C++ com DJGPP 2.03 de DJ Delorie", "S pouitm C++ DJGPP 2.03 od DJ Delorie"));
        textprintf_centre(janela, font, 200, 180, 63000, texto("and Allegro 3.9.38 (WIP) by Shawn Hargreaves", "e com Allegro 3.9.38 (WIP) de Shawn Hargreaves", "a Allegro 3.9.38 (WIP) od Shawn Hargreaves"));
        textprintf_centre(janela, font, 200, 220, 63000, texto("October 2001", "Outubro de 2001", "October 2001"));

        scare_mouse();
        blit(screen, janelabuf, LARGURA/2-200, ALTURA/2-150, 0, 0, 400, 300);
        blit(janela, screen, 0,0, LARGURA/2-200, ALTURA/2-150, 400, 300);

        c_hexbut okbut(LARGURA/2-25, ALTURA/2+90, 20, 2);
        okbut.fazbut(18,42,12, 2,"Ok");
        unscare_mouse();

        do {
          if (okbut.atualizar) {
            scare_mouse();
            okbut.atualiza();
            unscare_mouse();
          }
        } while (!okbut.avalia());

        scare_mouse();
        blit(janelabuf, screen, 0,0, LARGURA/2-200, ALTURA/2-150, 400, 300);
        unscare_mouse();
        destroy_bitmap(janela);
        destroy_bitmap(janelabuf);
        counter = 0;
        mb1hld = false;
      }

      if (!vivo && aberto+totminas == tothex && !procvenc && nivel != 0) {
        procvenc = true;
        if (nivel != 0) {
          if (posicao = melhorestempos[nivel-1].insere("", crona)) {
            mostramelhores = true;
          }
        }
      }

      if ((melhoresbut.avalia() || mostramelhores) && nivel != 0) {
        mostramelhores = false;
        text_mode(-1);
        janela = create_bitmap(500,300);
        janelabuf = create_bitmap(500, 300);
        clear_to_color(janela, RGB(0, 18, 18));
        switch (nivel) {
          case 1: textprintf_centre(janela, font, 250, 15, RGB(10,50,10), texto("Hall of fame (easy)", "Melhores tempos nvel Fcil", "Palc slvy (mal)")); break;
          case 2: textprintf_centre(janela, font, 250, 15, RGB(26,44,10), texto("Hall of fame (medium)", "Melhores tempos nvel Mdio", "Palc slvy (streadn)")); break;
          case 3: textprintf_centre(janela, font, 250, 15, RGB(26,30,10), texto("Hall of fame (hard)", "Melhores tempos nvel Difcil", "Palc slvy (vek)")); break;
        }
        for (i=0; i<10; i++) {
          if (posicao == i+1) {
            desenhahexn1(janela, 10+i%2*10, 40+18*i, 10, 28, 46, 10);
            textprintf_centre(janela, font, 19+i%2*10, 46+18*i, RGB(18, 24, 4), "%d", i+1);
          }
          else {
            desenhahexn1(janela, 10+i%2*10, 40+18*i, 10, 24, 44, 14);
            textprintf_centre(janela, font, 19+i%2*10, 46+18*i, RGB(11, 22, 7), "%d", i+1);
          }
          z = 1;
          for (j=0; j<15; j++) {
            if (melhorestempos[nivel-1].melhor[i].nome[j] == '\0') z = 0;
            if (z) {
              desenhahexn1(janela, 30+i%2*10+j*20, 40+18*i, 10, 20, 40, 14);
              textprintf_centre(janela, font, 39+i%2*10+j*20, 46+18*i, RGB(31, 63, 21), "%c", melhorestempos[nivel-1].melhor[i].nome[j]);
            }
            else desenhahexp1(janela, 30+i%2*10+j*20, 40+18*i, 10, 22, 44, 16);
          }
          j = 0;
          desenhahexn1(janela, 330+i%2*10+j*20, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 339+i%2*10+j*20, 46+18*i, RGB(24, 63, 31), "%d", min(9, melhorestempos[nivel-1].melhor[i].pontos/LPS/60));

          desenhahexn1(janela, 350+i%2*10, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 359+i%2*10, 46+18*i, RGB(24, 63, 31), "'");

          desenhahexn1(janela, 370+i%2*10+j*20, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 379+i%2*10+j*20, 46+18*i, RGB(24, 63, 31), "%d", ((melhorestempos[nivel-1].melhor[i].pontos/LPS)%60)/10);
          desenhahexn1(janela, 390+i%2*10+j*20, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 399+i%2*10+j*20, 46+18*i, RGB(24, 63, 31), "%d", ((melhorestempos[nivel-1].melhor[i].pontos/LPS)%60)%10);

          desenhahexn1(janela, 410+i%2*10, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 419+i%2*10, 46+18*i, RGB(24, 63, 31), "\"");

          desenhahexn1(janela, 430+i%2*10+j*20, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 439+i%2*10+j*20, 46+18*i, RGB(24, 63, 31), "%d", ((melhorestempos[nivel-1].melhor[i].pontos%LPS)*100/LPS)/10);
          desenhahexn1(janela, 450+i%2*10+j*20, 40+18*i, 10, 14, 40, 20);
          textprintf_centre(janela, font, 459+i%2*10+j*20, 46+18*i, RGB(24, 63, 31), "%d", ((melhorestempos[nivel-1].melhor[i].pontos%LPS)*100/LPS)%10);


          //textprintf(janela, font, 10+i*8, 15+16*i, RGB(21, 63, 31), "%d) %-23s %1d'%02d\"%02d", i+1, melhorestempos[nivel-1].melhor[i].nome, min(9, melhorestempos[nivel-1].melhor[i].pontos/LPS/60), (melhorestempos[nivel-1].melhor[i].pontos/LPS)%60, (melhorestempos[nivel-1].melhor[i].pontos%LPS)*100/LPS);
        }
        scare_mouse();
        blit(screen, janelabuf, LARGURA/2-250, ALTURA/2-150, 0, 0, 500, 300);
        blit(janela, screen, 0,0, LARGURA/2-250, ALTURA/2-150, 500, 300);
        unscare_mouse();

        // inserir nome nos recordes
        if (posicao) {
          int cursor = 0;
          char c;
          textprintf_centre(screen, font, LARGURA/2, ALTURA/2+110, RGB(10,58,10), texto("Enter your name and press ENTER", "Entre com o seu nome e tecle ENTER", "Vlo svoje meno a stla ENTER"));
          clear_keybuf();
          text_mode(RGB(22, 44, 16));
          do {
            c = readkey() & 0xFF;
            switch (c) {
              case 8 : // backspace
                cursor--;
                if (cursor < 0) cursor = 0;
                scare_mouse();
                textprintf_centre(screen, font, LARGURA/2-250+39+(posicao-1)%2*10+cursor*20, ALTURA/2-150+46+18*(posicao-1), RGB(31, 63, 21), " ");
                desenhahexp1(screen, LARGURA/2-250+30+(posicao-1)%2*10+cursor*20, ALTURA/2-150+40+18*(posicao-1), 10, 22, 44, 16);
                unscare_mouse();
                break;
              case 13: // enter
                break;
              default :
                if (cursor > 14) cursor = 14;
                melhorestempos[nivel-1].melhor[posicao-1].nome[cursor] = c;
                scare_mouse();
                desenhahexn1(screen, LARGURA/2-250+30+(posicao-1)%2*10+cursor*20, ALTURA/2-150+40+18*(posicao-1), 10, 22, 44, 16);
                textprintf_centre(screen, font, LARGURA/2-250+39+(posicao-1)%2*10+cursor*20, ALTURA/2-150+46+18*(posicao-1), RGB(16, 20, 4), "%c", c);
                unscare_mouse();
                cursor++;
            }
          } while (c != 13);
          melhorestempos[nivel-1].melhor[posicao-1].nome[cursor] = '\0';
          // salva melhores tempos
          arqmelhores = fopen("melhores.cmh", "wb");
          fwrite (melhorestempos, sizeof(c_melhor), 3, arqmelhores);
          fclose(arqmelhores);

          scare_mouse();
          text_mode(RGB(0, 18, 18));
          textprintf_centre(screen, font, LARGURA/2, ALTURA/2+110, RGB(20,52,20), "                                  ");
          unscare_mouse();
        }

        scare_mouse();
        c_hexbut okbut(LARGURA/2-165, ALTURA/2+90, 25, 2);
        okbut.fazbut(18,42,12, 2,"Ok");
        c_hexbut limpabut(LARGURA/2+135, ALTURA/2+90, 25, 2);
        limpabut.fazbut(18,42,12, 2,texto("Clear", "Apaga", "Zam"));
        unscare_mouse();

        do {
          if (okbut.atualizar || limpabut.atualizar) {
            scare_mouse();
            okbut.atualiza();
            limpabut.atualiza();
            unscare_mouse();
          }
          if (limpabut.avalia()) {
            melhorestempos[nivel-1].zera(texto("Nobody", "Ningum", "Nobody"), 600*LPS-1);
            arqmelhores = fopen("melhores.cmh", "wb");
            fwrite (melhorestempos, sizeof(c_melhor), 3, arqmelhores);
            fclose(arqmelhores);
            mostramelhores = true;
            break;
          }
        } while (!okbut.avalia());

        //unscare_mouse();
        //while (!okbut.avalia());
        scare_mouse();
        blit(janelabuf, screen, 0,0, LARGURA/2-250, ALTURA/2-150, 500, 300);
        unscare_mouse();
        posicao = 0;
        destroy_bitmap(janela);
        destroy_bitmap(janelabuf);
        text_mode(RGB(FR, FG, FB));
        counter = 0;
        mb1hld = false;
      }

      if (facilbut.avalia() && nivel != 1)   { nivel = 1; continua = 0;}
      if (mediobut.avalia() && nivel != 2)   { nivel = 2; continua = 0;}
      if (dificilbut.avalia() && nivel != 3) { nivel = 3; continua = 0;}
      
      if (lingingles.avalia() && lingua != LINGLES)    {lingua = LINGLES; continua = 0;}
      if (lingport.avalia() && lingua != LPORTUGUES)   {lingua = LPORTUGUES; continua = 0;}
      if (lingeslov.avalia() && lingua != LESLOVAQUIO) {lingua = LESLOVAQUIO; continua = 0;}

      if (key[KEY_F9])  usavsync = false;
      if (key[KEY_F10]) usavsync = true;

      if (key[KEY_ESC]    || sairbut.avalia())   { continua = 0; sair = 1; }
      if (key[KEY_F2]     || iniciobut.avalia()) { continua = 0; }
      if (key[KEY_UP]     || maislado.avalia())  { lado++; continua = 0; nivel = 0;}
      if (key[KEY_DOWN]   || menoslado.avalia()) { lado--; continua = 0; nivel = 0;}
      if (key[KEY_EQUALS] || maismina.avalia())  { totminas++; continua = 0; nivel = 0;}
      if (key[KEY_MINUS]  || menosmina.avalia()) { totminas--; continua = 0; nivel = 0;}

      // espera soltar
      while (key[KEY_F2] || key[KEY_UP] || key[KEY_DOWN] || key[KEY_EQUALS] || key[KEY_MINUS]);

      while (counter > 0 && !vivo) {
        counter--;
      }

      while (counter > 0 && vivo) {
        // um laco do programa

        // dados do mouse
        mb = mouse_b; mx = mouse_x; my = mouse_y;

        //*
        mb1 = (mb & 1) || (mb > 2);
        mb2 = (mb & 2) || (mb > 2);
        mb1clk = !mb1hld && mb1 && !mb2;
        mb2clk = !mb2hld && mb2 && !mb1;
        mb1unclk = !mbbhld && !mb2hld && mb1hld && !mb1;
        //mb2unclk = !mbbhld && !mb1hld && mb2hld && !mb2;
        mbbhld = mb1 && mb2 || mbbhld && mb1hld && mb1 || mbbhld && mb2hld && mb2;
        mb1hld = mb1;
        mb2hld = mb2;
        //*/

        /*
        if (mb > 2)
          mbbhld = 2;
        else
          if (mb > 0 && mbbhld > 0)
            mbbhld = 1; // estava com os 2 botes pressionados, agora s um
          else
            mbbhld = 0; // soltou os dois

        if (!mbbhld && mb1hld && !(mb & 1)) mb1unclk = true;
        if ((mb & 1 && !mbbhld) && !mb1hld) {
          mb1clk = true;
          mb1hld = true;
        } else if (mb & 1 && !mbbhld) mb1clk = false; else mb1hld = false;
        if ((mb & 2 && !mbbhld) && !mb2hld) {
          mb2clk = true;
          mb2hld = true;
        } else if (mb & 2 && !mbbhld) mb2clk = false; else mb2hld = false;
        if (!(mb & 1) || mbbhld) mb1clk = false;
        if (!(mb & 2) || mbbhld) mb2clk = false;
        if (mbbhld || mb1hld) mb1unclk = false;
        //*/
        ja_achou_hex_apontado = false;
        for (j=0; j<MAX_Y; j++) {
          for (i=0; i<MAX_X; i++) {
            //if (campo[i][j] == 1 || campo[i][j] == 2 || campo[i][j] == 8)
              // tratamento para todos os hexagonos
              if (campo[i][j] == 3 && !dclk) { // estava sendo pressionado por estar piscando
                campo[i][j] = 1;
                lhm.push(i, j, campo[i][j]);
              }

              //if (campo[i][j] == 4) {
              //  campo[i][j] = 3;
              //  lhm.push(i, j, campo[i][j]);
              //}
              // verifica se o mouse esta' sobre o hexagono

              //if (mx > campox+i*20+10*(j%2) && mx < (campox+20)+i*20+10*(j%2) &&
              //    my > campoy+j*17 + abs(mx-((campox+10)+i*20+10*(j%2)))/2  &&
              //    my < (campoy+22)+j*17 - abs(mx-((campox+10)+i*20+10*(j%2)))/2 ) {

              if (!ja_achou_hex_apontado &&
                  mx >= campox+i*20+10*(j%2) && mx < (campox+20)+i*20+10*(j%2) &&
                  my >= campoy+j*17 + abs(mx-((campox+10)+i*20+10*(j%2)))/2  &&
                  my < (campoy+22)+j*17 - abs(mx-((campox+10)+i*20+10*(j%2)))/2 ) {

                ja_achou_hex_apontado = true;
                if (axapont != i || ayapont != j) {
                  comecouaapontar = true;
                  axapont = i;
                  ayapont = j;
                } else comecouaapontar = false;

                // tratamento para o hexagono apontado
                //text_mode(RGB(FR, FG, FB));
                //textprintf(screen, font, 305, ALTURA-20, 63000, "HEX=%d  ", campo[i][j]);
                //z = campo[i][j];
                //if (mbbhld==2 && campo[i][j] > 10) { // dois botoes pressionados
                if (mb1hld && mb2hld && campo[i][j] > 10) { // dois botoes pressionados

                  // conta quantas minas estao marcadas ao redor desse hexagono
                  n = 0;
                  if (i>0) if (campo[i-1][j]==8) n++;
                  if (i<MAX_X-1) if (campo[i+1][j]==8) n++;

                  if (j>0) {
                    if (campo[i][j-1]==8) n++;
                    if (j%2==0) {
                      if (i>0) if (campo[i-1][j-1] == 8) n++;
                    } else {
                      if (i<MAX_X-1) if (campo[i+1][j-1] == 8) n++;
                    }
                  }
                  if (j<MAX_Y-1) {
                    if (campo[i][j+1]==8) n++;
                    if (j%2==0) {
                      if (i>0) if (campo[i-1][j+1] == 8) n++;
                    } else {
                      if (i<MAX_X-1) if (campo[i+1][j+1] == 8) n++;
                    }
                  }

                  // se for igual ao numero de minas ao redor do hexagono entao abre ao redor
                  if (n == campo[i][j]-10) {

                    if (i>0) if (campo[i-1][j] == 1) abrir(i-1, j);
                    if (i<MAX_X-1) if (campo[i+1][j] == 1) abrir(i+1, j);
                    if (j>0) {
                      if (campo[i][j-1] == 1) abrir(i, j-1);
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j-1] == 1) abrir(i-1, j-1);
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j-1] == 1) abrir(i+1, j-1);
                      }
                    }
                    if (j<MAX_Y-1) {
                      if (campo[i][j+1] == 1) abrir(i, j+1);
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j+1] == 1) abrir(i-1, j+1);
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j+1] == 1) abrir(i+1, j+1);
                      }
                    }
                    dclk = false;
                  }
                  else { // nao pode abrir ao redor entao apenas pisca
                    if (!comecouaapontar) dclk = true; else dclk = false;
                    //if (!dclk) dclk = true; else dclk = false;

                    //if (!dclk) {
                    if (i>0) if (campo[i-1][j] == 1) { campo[i-1][j] = 3; lhm.push(i-1, j, campo[i-1][j]); }
                    if (j>0) {
                      if (campo[i][j-1] == 1) { campo[i][j-1] = 3; lhm.push(i, j-1, campo[i][j-1]); }
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j-1] == 1) { campo[i-1][j-1] = 3; lhm.push(i-1, j-1, campo[i-1][j-1]); }
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j-1] == 1) { campo[i+1][j-1] = 3; lhm.push(i+1, j-1, campo[i+1][j-1]); }
                      }
                    }
                    //}

                    //if (dclk) {
                    if (i<MAX_X-1) if (campo[i+1][j] == 1) { campo[i+1][j] = 3; lhm.push(i+1, j, campo[i+1][j]); }
                    if (j<MAX_Y-1) {
                      if (campo[i][j+1] == 1) { campo[i][j+1] = 3; lhm.push(i, j+1, campo[i][j+1]); }
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j+1] == 1) { campo[i-1][j+1] = 3; lhm.push(i-1, j+1, campo[i-1][j+1]); }
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j+1] == 1) { campo[i+1][j+1] = 3; lhm.push(i+1, j+1, campo[i+1][j+1]); }
                      }
                    }
                    //}

                    //repete
                    /*
                    if (i>0) if (campo[i-1][j] == 1) { campo[i-1][j] = 3; lhm.push(i-1, j, campo[i-1][j]); }
                    if (i<MAX_X-1) if (campo[i+1][j] == 1) { campo[i+1][j] = 4; }
                    if (j>0) {
                      if (campo[i][j-1] == 1) { campo[i][j-1] = 3; lhm.push(i, j-1, campo[i][j-1]); }
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j-1] == 1) { campo[i-1][j-1] = 3; lhm.push(i-1, j-1, campo[i-1][j-1]); }
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j-1] == 1) { campo[i+1][j-1] = 3; lhm.push(i+1, j-1, campo[i+1][j-1]); }
                      }
                    }
                    if (j<MAX_Y-1) {
                      if (campo[i][j+1] == 1) { campo[i][j+1] = 4; }
                      if (j%2==0) {
                        if (i>0) if (campo[i-1][j+1] == 1) { campo[i-1][j+1] = 4; }
                      }
                      else {
                        if (i<MAX_X-1) if (campo[i+1][j+1] == 1) { campo[i+1][j+1] = 4; }
                      }
                    }
                    //fim repete
                    */
                  }

                } // fim dois botoes pressionados
                else dclk = false;

                //if (mb1hld /*(mb & 1 /*|| mb > 2)*/ && campo[i][j] == 1) {
                if (mb1hld && !mbbhld && campo[i][j] == 1) {
                  // hexagono sendo pressionado
                  campo[i][j] = 2;
                  lhm.push(i, j, campo[i][j]);
                }
                if ((!mb1hld || mbbhld) && campo[i][j] == 2 && !mb1unclk) {
                  campo[i][j] = 1;
                  lhm.push(i, j, campo[i][j]);
                }

                if (mb2clk && campo[i][j] == 8) {
                  // desmarcar mina
                  mb2clk = false;
                  campo[i][j] = 1;
                  lhm.push(i, j, campo[i][j]);
                }
                if (mb2clk && campo[i][j] == 1 && ja_comecou) {
                  // marcar mina
                  campo[i][j] = 8;
                  lhm.push(i, j, campo[i][j]);
                }
                if (mb1unclk && (campo[i][j] == 1 || campo[i][j] == 2)) { // soltou o botao
                //if (mb1unclk && campo[i][j] == 2) {
                  if (!ja_comecou) { // comeca o jogo
                    if (primeiravez) {
                      primeiravez = false;
                      srand(time(0)+cronometro+counter);
                    }
                    ja_comecou = true;

                    for (n=0;n<totminas;n++) {
                      do {
                        x = rand()%MAX_X;
                        y = rand()%MAX_Y;
                      } while (campor[x][y] == 0 || campor[x][y] == 9 || (x == i && y == j));
                      campor[x][y] = 9; // eh uma bomba
                    }

                    // conta quantas minas tem em volta de cada hexagono
                    for (x=0;x<MAX_X;x++) {
                      for (y=0;y<MAX_Y;y++) {
                        if (campor[x][y] == 1) {
                          n=0;
                          if (x>0) if (campor[x-1][y] == 9) n++;
                          if (x<MAX_X-1) if (campor[x+1][y] == 9) n++;
                          if (y>0) {
                            if (campor[x][y-1] == 9) n++;
                            if (y%2==0) {
                              if (x>0) if (campor[x-1][y-1] == 9) n++; }
                            else
                              if (x<MAX_X-1) if (campor[x+1][y-1] == 9) n++;
                          }
                          if (y<MAX_Y-1) {
                            if (campor[x][y+1] == 9) n++;
                            if (y%2==0) {
                              if (x>0) if (campor[x-1][y+1] == 9) n++; }
                            else
                              if (x<MAX_X-1) if (campor[x+1][y+1] == 9) n++;
                          }
                        campor[x][y] = 10+n;
                        } // end if campor=1
                      }
                    } // end for
                    cronometro = 0;
                  } // end ja' comecou
                  //tchan tchan tchan tchan...
                  //if (campo[i][j] >= 10) textprintf(screen, font, 50, 550, 64000, "ERRO!");
                  abrir (i, j);
                } // fim abrir
              }
              else { // mouse nao esta sobre o hexagono
                // tratamento para hexagonos que nao estao sendo apontados
                if (campo[i][j] == 2) { // estava sendo pressionado, entao solta
                  campo[i][j] = 1;
                  lhm.push(i, j, campo[i][j]);
                }
              }
          }
        }
        rc_count++;
        counter--;
      }

      frame_count++;
    }

  } while (!sair); // comeca novo jogo ou termina
  //if (!sair) goto inicio;
  
  // salva preferencias
  arqpref = fopen("prefere.cmh", "wb");
  if (arqpref != NULL) {
    fwrite(&nivel, sizeof(int), 1, arqpref);
    fwrite(&lado, sizeof(int), 1, arqpref);
    fwrite(&totminas, sizeof(int), 1, arqpref);
    fwrite(&usavsync, sizeof(bool), 1, arqpref);
    fwrite(&lingua, sizeof(int), 1, arqpref);
    fclose(arqpref);
  }

  //Finalizacao
  //destroy_bitmap(tela);
  unload_datafile(dados);
  exit(0);

}

END_OF_MAIN();


void abrir(int x, int y) {
  int i, j;
  if (campo[x][y] != campor[x][y]) {
    campo[x][y] = campor[x][y];
    aberto = 0;
    for (i=0; i<MAX_X; i++) {
      for (j=0; j<MAX_Y; j++) {
        if (campo[i][j] >= 10) aberto++;
      }
    }
    //aberto++;
  }
  //if (campo[x][y] >= 10) aberto2++;
  lhm.push(x, y, campo[x][y]);
  if (campo[x][y] == 9) { // MINA!!!
    vivo = 0;
    // mostra todas as minas
    for (x = 0; x<MAX_X;x++) {
      for (y = 0; y<MAX_Y;y++) {
        if (campor[x][y] == 9) {
          if (campo[x][y] != 8) {
            campo[x][y] = 9; // sem marcacao -> mostra mina
            lhm.push(x, y, campo[x][y]);
          }
        }
        else {
          if (campo[x][y] == 8) {
            campo[x][y] = 7; // marcacao errada
            lhm.push(x, y, campo[x][y]);
          }
        }
      }
    }
    return;
  }
  if (aberto+totminas == tothex) { // venceu
    // marca todas as minas
    for (x = 0; x<MAX_X;x++) {
      for (y = 0; y<MAX_Y;y++) {
        if (campor[x][y] == 9) {
          campo[x][y] = 8;
          lhm.push(x, y, campo[x][y]);
        }
      }
    }
    vivo = 0;
  }
  if (campo[x][y] == 10) { // abrir os que estao em volta
    if (x>0) if (campo[x-1][y] == 1 || campo[x-1][y] == 2) abrir(x-1, y);
    if (x<MAX_X-1) if (campo[x+1][y] == 1 || campo[x+1][y] == 2) abrir(x+1, y);
    if (y>0) {
      if (campo[x][y-1] == 1 || campo[x][y-1] == 2) abrir(x, y-1);
      if (y%2==0) {
        if (x>0) if (campo[x-1][y-1] == 1 || campo[x-1][y-1] == 2) abrir(x-1, y-1);
      }
      else {
        if (x<MAX_X-1) if (campo[x+1][y-1] == 1 || campo[x+1][y-1] == 2) abrir(x+1, y-1);
      }
    }
    if (y<MAX_Y-1) {
      if (campo[x][y+1] == 1 || campo[x][y+1] == 2) abrir(x, y+1);
      if (y%2==0) {
        if (x>0) if (campo[x-1][y+1] == 1 || campo[x-1][y+1] == 2) abrir(x-1, y+1);
      }
      else {
        if (x<MAX_X-1) if (campo[x+1][y+1] == 1 || campo[x+1][y+1] == 2) abrir(x+1, y+1);
      }
    }
  }
}

char *texto(char *l1, char *l2, char *l3) {
  switch (lingua) {
    case LINGLES     : return l1;
    case LPORTUGUES  : return l2;
    case LESLOVAQUIO : return l3;
    default          : return l1;
  }
}
