#define DEG(n)    			((double)(n) * 180.0 / M_PI)
#define RAD(n)    			((double)(n) * M_PI / 180.0)
#ifndef M_PI
   #define M_PI   3.14159265358979323846
#endif

#define GLOBAL_VIEW					0 
#define LOCAL_VIEW					1

#define MARS_LIST1					10000
#define WIRE_MARS_LIST1				10001

#undef VIEW_DIST
#define VIEW_DIST					500
#define HEIGHT_DIV					4000.0

typedef struct CAMERA {
	double x, y, z;
	double xangle, yangle, zangle;
} CAMERA;

typedef struct VERTEX3D {
	float x, y, z;
} VERTEX3D;

typedef struct VERTEX2D {
	float x, y;
} VERTEX2D;

typedef struct SPHERE {
	int step;
	double radius;
} SPHERE;

typedef struct TERRAIN {
	int			w, h;
	int			tri_count;
	unsigned int *tri_index;
	VERTEX3D	*vertex_array;
	VERTEX3D	*normal_array;
} TERRAIN;

struct display {
	int color_depth,
		fullscreen, 
		width, 
		height, 
		use_hardware;
} display;

FONT *agl_font;
CAMERA g_camera, l_camera;
SPHERE mars, wire_mars;
TERRAIN terrain;
GLuint texture;
int water_level;
double rot_speed, move_speed;
int frames;
int view;
volatile int game_count, g_timer, l_timer;
float albedo[180][360], inertia[180][360], topo[180][360]; 
float min_albedo, max_albedo, min_inertia, max_inertia, min_topo, max_topo;
BITMAP *texture_bmp;

extern int create_local_view();
extern void do_local_view();
extern void process_local_view();
extern void draw_local_view();

extern int create_global_view();
extern void do_global_view();
extern void process_global_view();
extern void draw_global_view();

extern void set_texture(BITMAP *);
extern void _textprintf(FONT *font, float x, float y, float z, int c, char *format, ...);
