#include <allegro.h>
#include <math.h>
#include <stdio.h>
#include <alleggl.h>
#include <gl\\glu.h>
#include "aastr.h"
#include "mars.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_local_view (void)
{
	int x_mick, y_mick;

	while (game_count-l_timer>0) {
		l_timer++;

		get_mouse_mickeys(&x_mick, &y_mick);

		if (mouse_b&2) {
			l_camera.xangle+=y_mick;
			l_camera.yangle+=x_mick;
			
			if (key[KEY_UP]) {
				l_camera.x += sin(l_camera.yangle/180.0*M_PI)/10;
				l_camera.z -= cos(l_camera.yangle/180.0*M_PI)/10;
				//l_camera.y += sin(l_camera.zangle/180.0*M_PI);
			}
			if (key[KEY_DOWN]) {
				l_camera.x -= sin(l_camera.yangle/180.0*M_PI)/10;
				l_camera.z += cos(l_camera.yangle/180.0*M_PI)/10;
				//l_camera.z -= sin(l_camera.zangle/180.0*M_PI);	
			}

			if (l_camera.x<0) l_camera.x=359;
			if (l_camera.x>359) l_camera.x=0;
			if (l_camera.z<0) l_camera.z=179;
			if (l_camera.z>179) l_camera.z=0;
		}

		if (key[KEY_P] && water_level<max_topo) water_level+=100;
		if (key[KEY_O] && water_level>min_topo) water_level-=100;
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_local_view (void)
{
	int j;
	int x1, x2, y1, y2;												 
	int y;
	float light_pos[]={5, 50, 120, 0};

	allegro_gl_begin();											   

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	glRotatef (l_camera.xangle, 1, 0, 0);
	glRotatef (l_camera.yangle, 0, 1, 0);
	glRotatef (l_camera.zangle, 0, 0, 1);
	glTranslatef (-l_camera.x, -l_camera.y, -l_camera.z);

    glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glLightfv(GL_LIGHT0, GL_POSITION, light_pos);
	glColor3f(0.5, 0.3, 0.3);

	x1=l_camera.x-60; x2=l_camera.x+60;
	y1=l_camera.z-60; y2=l_camera.z+60;

	//glDrawElements(GL_TRIANGLES, 3*terrain.tri_count, GL_UNSIGNED_INT, terrain.tri_index);
	for (j=y1;j<y2-1;j++) {
		if (j<0) {
			glTranslatef(0, 0, -179);
			y=j+179;
		}
		else if (j>178) {
			glTranslatef(0, 0, +179);
			y=j-179;
		}
		else y=j;

		if (x1<0) {
			glTranslatef(-358, 0, 0);
			glDrawElements(GL_TRIANGLES, 3*2*(359-(359+x1)-1), GL_UNSIGNED_INT, &terrain.tri_index[y*3*2*359+(359+x1)*3*2]);
			glTranslatef(+358, 0, 0);
			glDrawElements(GL_TRIANGLES, 3*2*(x2-0-1), GL_UNSIGNED_INT, &terrain.tri_index[y*3*2*359+0*3*2]);
		}
		else if (x2>358) {
			glTranslatef(+358, 0, 0);
			glDrawElements(GL_TRIANGLES, 3*2*((x2-359)-0-1), GL_UNSIGNED_INT, &terrain.tri_index[y*3*2*359+0*3*2]);
			glTranslatef(-358, 0, 0);
			glDrawElements(GL_TRIANGLES, 3*2*(359-x1-1), GL_UNSIGNED_INT, &terrain.tri_index[y*3*2*359+x1*3*2]);
		}
		else glDrawElements(GL_TRIANGLES, 3*2*(x2-x1-1), GL_UNSIGNED_INT, &terrain.tri_index[y*3*2*359+x1*3*2]);

		if (j<0) glTranslatef(0, 0, +179);
		else if (j>178) glTranslatef(0, 0, -179);
	}

	glDisable(GL_FOG);
	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glColor4f(0.0, 0.0, 1.0, 0.3);

	glBegin(GL_QUADS);
		glVertex3f(x1, water_level/HEIGHT_DIV, y1);
		glVertex3f(x1, water_level/HEIGHT_DIV, y2);
		glVertex3f(x2, water_level/HEIGHT_DIV, y2);
		glVertex3f(x2, water_level/HEIGHT_DIV, y1);
	glEnd();

	glEnable(GL_BLEND);
	glColor4f(0.0, 1.0, 1.0, 0.5);

	allegro_gl_set_projection();
//	aglf_printf(agl_font, 10, 10, 1, 255, "Text - proba");
	glBegin(GL_TRIANGLES);
		glVertex3f(mouse_x, mouse_y, 1);
		glVertex3f(mouse_x+8, mouse_y+16, 1);
		glVertex3f(mouse_x+16, mouse_y+8, 1);
	glEnd();
	allegro_gl_unset_projection();

	_textprintf(agl_font, -64, 40, -64, 255, "Water level: %d", water_level);

	allegro_gl_end();

	frames++;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void do_local_view()
{
	process_local_view();

	allegro_gl_begin();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	draw_local_view();

	glFlush();
	allegro_gl_flip();
	allegro_gl_end();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int create_terrain(TERRAIN *t, int w, int h)
{
	int i, j;
    int apos;
    int tri = 0;
    int andx[4];

	VERTEX3D *face_normals, *vertex_normals;
	VERTEX3D *pt1, *pt2, *pt3, pt4, pt5;
	float incident;

	t->w=w;
	t->h=h;
	t->tri_count = (w - 1) * (h - 1) * 2; // 2 tris for each square
    t->tri_index = malloc(t->tri_count*3*sizeof(unsigned int));
	t->vertex_array = malloc(w*h*sizeof(VERTEX3D));
	
	if (!t->tri_index || !t->vertex_array) {
		allegro_message("Failed to create terrain!");
		return -1;
	}

	/*for (j=0;j<h;j++)
	for (i=0;i<w;i++) 
	if (_topo[j][i]!=-999999) {  
		for (l=j;l<h;l++) 
		for (k=i;k<w;k++) {
			if (_topo[l][k]!=_topo[j][i]) {
				_topo[l][k]=-999999;
				break;
			}
			_topo[l][k]=-9999999;
		}
	*/
   	for (j=0;j<h;j++)
		for (i=0;i<w;i++) {
			t->vertex_array[j*w+i].x=i;
			t->vertex_array[j*w+i].y=topo[j][i]/HEIGHT_DIV;
			t->vertex_array[j*w+i].z=j;

			if (i<w-1 && j<h-1) {
				andx[0]=(j*w)+i;
				andx[1]=(j*w)+(i+1);
				andx[2]=((j+1)*w)+(i+1);
				andx[3]=((j+1)*w)+i;
				apos=tri*3;
				t->tri_index[apos+0]=andx[2];
				t->tri_index[apos+1]=andx[1];
				t->tri_index[apos+2]=andx[0];
				tri++;
				apos=tri*3;
				t->tri_index[apos+0]=andx[3];
				t->tri_index[apos+1]=andx[2];
				t->tri_index[apos+2]=andx[0];
				tri++;
			}
		}

	face_normals=malloc(t->tri_count*sizeof(VERTEX3D));
	vertex_normals=malloc(w*h*sizeof(VERTEX3D));

	if (!face_normals || !vertex_normals) {
		allegro_message("Failed to create terrain!");
		return -1;
	}

	memset(vertex_normals, 0, w*h*sizeof(VERTEX3D));

	for (i = 0; i < t->tri_count; i++) {
		pt1 = &t->vertex_array[t->tri_index[i*3 + 0]];
		pt2 = &t->vertex_array[t->tri_index[i*3 + 1]];
		pt3 = &t->vertex_array[t->tri_index[i*3 + 2]];
     
		pt4.x=pt2->x-pt1->x;
		pt4.y=pt2->y-pt1->y;
		pt4.z=pt2->z-pt1->z;

		pt5.x=pt3->x-pt1->x;
		pt5.y=pt3->y-pt1->y;
		pt5.z=pt3->z-pt1->z;

		cross_product_f(pt4.x, pt4.y, pt4.z, pt5.x, pt5.y, pt5.z, &face_normals[i].x, &face_normals[i].y, &face_normals[i].z);
		normalize_vector_f(&face_normals[i].x, &face_normals[i].y, &face_normals[i].z);
	}
   
	for(i = 0; i < t->tri_count; i++) {
		vertex_normals[t->tri_index[i*3+0]].x+=face_normals[i].x;
		vertex_normals[t->tri_index[i*3+0]].y+=face_normals[i].y;
		vertex_normals[t->tri_index[i*3+0]].z+=face_normals[i].z;
		vertex_normals[t->tri_index[i*3+1]].x+=face_normals[i].x;
		vertex_normals[t->tri_index[i*3+1]].y+=face_normals[i].y;
		vertex_normals[t->tri_index[i*3+1]].z+=face_normals[i].z;
		vertex_normals[t->tri_index[i*3+2]].x+=face_normals[i].x;
		vertex_normals[t->tri_index[i*3+2]].y+=face_normals[i].y;
		vertex_normals[t->tri_index[i*3+2]].z+=face_normals[i].z;
	}

	for (j=0;j<h;j++)
		for (i=0;i<w;i++) {
			if (j==0 && i==0) incident=2;
			else if (j==0 && i==w-1) incident=1;
			else if (j==h-1 && i==0) incident=1;
			else if (j==h-1 && i==w-1) incident=2;
			else if (j==h-1) incident=3;
			else if (i==w-1) incident=3;
			else if (j==0) incident=3;
			else if (i==0) incident=3;
			else incident=6;
					
			vertex_normals[(j*w+i)].x /= incident;
			vertex_normals[(j*w+i)].y /= incident;
			vertex_normals[(j*w+i)].z /= incident;
			normalize_vector_f(&vertex_normals[i].x, &vertex_normals[i].y, &vertex_normals[i].z);
		}
	
		
   free(face_normals);
   
   t->normal_array = vertex_normals;

   return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int create_local_view()
{
	if (create_terrain(&terrain, 360, 180)<0) return -1;
	 
	
	glVertexPointer(3, GL_FLOAT, 0, terrain.vertex_array); 
    glNormalPointer(GL_FLOAT, 0, terrain.normal_array);
    
	return 0;
}	
