#include <allegro.h>
#include <math.h>
#include <stdio.h>
#include <alleggl.h>
#include <gl\\glu.h>
#include "aastr.h"
#include "mars.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_global_view(void)
{
	int x_mick, y_mick;
	float min, max;

	while (game_count-g_timer>0) {
		g_timer++;
	
		get_mouse_mickeys(&x_mick, &y_mick);
		
		if (mouse_b&1) {
			g_camera.xangle+=(y_mick*(g_camera.z-mars.radius)/25);
			g_camera.yangle+=(x_mick*(g_camera.z-mars.radius)/25);
		}
		else if (mouse_b&2) {
			g_camera.z+=(y_mick*mars.radius/50);
		}
		
		if (key[KEY_LEFT]) g_camera.yangle += rot_speed;
		if (key[KEY_RIGHT]) g_camera.yangle -= rot_speed;

		if (key[KEY_UP]) g_camera.xangle += rot_speed;
		if (key[KEY_DOWN]) g_camera.xangle -= rot_speed;

		if (key[KEY_PGUP]) g_camera.z -= move_speed;
		if (key[KEY_PGDN]) g_camera.z += move_speed;

		if (key[KEY_P] || key[KEY_O]) {
			BITMAP *temp;
			int i, j, c;
			float v;
			long g_timer=game_count;

			if (key[KEY_P] && water_level<max_topo) water_level+=100;
			if (key[KEY_O] && water_level>min_topo) water_level-=100;

			temp=create_bitmap(360, 180);

			for (j=0;j<180;j++) {
				for (i=0;i<360;i++) {
					v=topo[j][i];
					if (v<water_level) {
						c=(float)(v-min_topo)/(float)(water_level-min_topo)*255.0;
						c=makecol(0, 0, c);
					}
					else {
						c=(float)(v-min_topo)/(float)(max_topo-min_topo)*255.0;
						c=makecol(c, c, c);
					}

					putpixel(temp, i, j, c);
				}
			}

			if (view==GLOBAL_VIEW) aa_stretch_blit(temp, texture_bmp, 0, 0, 360, 180, 0, 0, 512, 256);
			else stretch_blit(temp, texture_bmp, 0, 0, 360, 180, 0, 0, 512, 256);
			
			glDeleteTextures(1, &texture);
			set_texture(texture_bmp);

			destroy_bitmap(temp);

			game_count=g_timer;
		}
		if (key[KEY_1] || key[KEY_2] || key[KEY_3]) {
			BITMAP *temp;
			int i, j, k, c;
			float v;
			long g_timer=game_count;

			if (key[KEY_1]) {min=min_topo; max=max_topo; k=1;}
			if (key[KEY_2]) {min=min_inertia; max=max_inertia; k=2;}
			if (key[KEY_3]) {min=min_albedo; max=max_albedo; k=3;}
			
			temp=create_bitmap(360, 180);

			for (j=0;j<180;j++) {
				for (i=0;i<360;i++) {
					if (k==1) v=topo[j][i];
					else if (k==2) v=inertia[j][i];
					else if (k==3) v=albedo[j][i];
					
					c=(float)(v-min)/(float)(max-min)*255.0;
					c=makecol(c, c, c);
					
					putpixel(temp, i, j, c);
				}
			}

			if (view==GLOBAL_VIEW) aa_stretch_blit(temp, texture_bmp, 0, 0, 360, 180, 0, 0, 512, 256);
			else stretch_blit(temp, texture_bmp, 0, 0, 360, 180, 0, 0, 512, 256);
			
			glDeleteTextures(1, &texture);
			set_texture(texture_bmp);

			destroy_bitmap(temp);

			game_count=g_timer;
		}
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_global_view (void)
{
	allegro_gl_begin();

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	glTranslatef (g_camera.x, g_camera.y, -g_camera.z);
	glRotatef (g_camera.xangle, 1, 0, 0);
	glRotatef (g_camera.yangle, 0, 1, 0);
	glRotatef (g_camera.zangle, 0, 0, 1);

    glCallList(MARS_LIST1);
	if (!key[KEY_G]) glCallList(WIRE_MARS_LIST1);

	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glColor4f(0.0, 1.0, 1.0, 0.5);

	allegro_gl_set_projection();
	glBegin(GL_TRIANGLES);
		glVertex3f(mouse_x, mouse_y, 1);
		glVertex3f(mouse_x+8, mouse_y+16, 1);
		glVertex3f(mouse_x+16, mouse_y+8, 1);
	glEnd();
	allegro_gl_unset_projection();
	
	allegro_gl_end();

	frames++;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void do_global_view()
{
	process_global_view();

	allegro_gl_begin();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	draw_global_view();

	glFlush();
	allegro_gl_flip();
	allegro_gl_end();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int create_global_view_lists(double radius, int step) 
{
	int i, j, k, ppl;
	float r, y;
	double v0, v1;
	double *vx, *vy, *vz;

	mars.radius=radius;
	mars.step=step;
	wire_mars.radius=radius;
	wire_mars.step=step;
	
	allegro_gl_begin();

	vx=malloc(360/step*180/step*sizeof(double)); if (!vx) return -1;
	vy=malloc(360/step*180/step*sizeof(double)); if (!vy) return -1;
	vz=malloc(360/step*180/step*sizeof(double)); if (!vz) return -1;

	k=0;
	for (j=step;j<180;j+=step) {
		r=sin(RAD(j))*radius;
		y=sin(RAD(90-j))*radius;

		for (i=0;i<360;i+=step) {
			vx[k]=cos(RAD(i))*r;
			vy[k]=y;
			vz[k]=sin(RAD(i))*r;

			k++;
		}
	}

	glNewList(MARS_LIST1, GL_COMPILE);

	glDisable(GL_BLEND);
    glEnable (GL_TEXTURE_2D);
	glBindTexture (GL_TEXTURE_2D, texture);

	ppl=360/step;
    for (j=0;j<ppl/2-2;j++)	{

		v0=1-(double)j/(double)(ppl/2-2);
		v1=1-(double)(j+1)/(double)(ppl/2-2);

		glBegin(GL_QUAD_STRIP);
		glTexCoord2f(0, v1); glVertex3f(vx[(j+1)*ppl], vy[(j+1)*ppl], vz[(j+1)*ppl]);
		glTexCoord2f(0, v0); glVertex3f(vx[j*ppl], vy[j*ppl], vz[j*ppl]);

		for (i=1;i<ppl;i++) {
			glTexCoord2f((double)i/(double)ppl, v1); glVertex3f(vx[i+(j+1)*ppl], vy[i+(j+1)*ppl], vz[i+(j+1)*ppl]);
			glTexCoord2f((double)i/(double)ppl, v0); glVertex3f(vx[i+j*ppl], vy[i+j*ppl], vz[i+j*ppl]);
		}

		glTexCoord2f(1, v1); glVertex3f(vx[(j+1)*ppl], vy[(j+1)*ppl], vz[(j+1)*ppl]);
		glTexCoord2f(1, v0); glVertex3f(vx[j*ppl], vy[j*ppl], vz[j*ppl]);
		glEnd();
	}
	glEndList();
	if (glIsList(MARS_LIST1)==GL_FALSE) {
		allegro_message("Failed to create display list");
		return -1;
	}
	
	step=10;
	radius+=0.02;
	k=0;
	for (j=step;j<180;j+=step) {
		r=sin(RAD(j))*radius;
		y=sin(RAD(90-j))*radius;

		for (i=0;i<360;i+=step) {
			vx[k]=cos(RAD(i))*r;
			vy[k]=y;
			vz[k]=sin(RAD(i))*r;

			k++;
		}
	}

	glNewList(WIRE_MARS_LIST1, GL_COMPILE);

	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glColor4f(0.0, 1.0, 0.0, 0.5);

	ppl=360/step;
 	glBegin(GL_LINES);
    for (j=0;j<ppl/2-2;j++)	{
		for (i=0;i<ppl;i++) {
			glVertex3f(vx[i+j*ppl], vy[i+j*ppl], vz[i+j*ppl]);
			glVertex3f(vx[(i+1)%ppl+j*ppl], vy[(i+1)%ppl+j*ppl], vz[(i+1)%ppl+j*ppl]);
			glVertex3f(vx[i+j*ppl], vy[i+j*ppl], vz[i+j*ppl]);
			glVertex3f(vx[i+(j+1)*ppl], vy[i+(j+1)*ppl], vz[i+(j+1)*ppl]);
		}
	}
	glEnd();
	glEndList();
	if (glIsList(WIRE_MARS_LIST1)==GL_FALSE) {
		allegro_message("Failed to create display list1");
		return -1;
	}
	free(vx); free(vy); free(vz);

	allegro_gl_end();

	return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int create_global_view()
{
	BITMAP *temp;
	int i, j, c;

	texture_bmp=create_bitmap(512, 256);
	if (!texture_bmp) {
		allegro_message("Could not create texture!");
		return -1;
	}
	clear(texture_bmp);

	temp=create_bitmap(360, 180);
	if (!temp) return -1;

	for (j=0;j<180;j++) 
	for (i=0;i<360;i++) {
		c=(float)(topo[j][i]-min_topo)/(float)(max_topo-min_topo)*255.0;
		c=makecol(c, c, c);
		putpixel(temp, i, j, c);
	}

	aa_stretch_blit(temp, texture_bmp, 0, 0, 360, 180, 0, 0, 512, 256);
	destroy_bitmap(temp);

	glDeleteTextures(1, &texture);
	set_texture(texture_bmp);

	return create_global_view_lists(5, 10);
}
