#include <allegro.h>
#include <math.h>
#include <stdio.h>
#include <alleggl.h>
#include <gl\\glu.h>
#include "aastr.h"
#include "mars.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void game_proc(void) 
{ 
	game_count++; 
} 
END_OF_FUNCTION(game_proc);
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void LOG(char *format, ...)
{
 FILE *f;
 char buf[512];

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);

 f=fopen("mars.log", "at");
 if	(!f) return;

 fputs(buf,	f);
 fflush(f);

 fclose(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void fputl(long l, FILE *f)
{
 unsigned char *c0, *c1, *c2, *c3;

 c0=(unsigned char *)&l;
 c1=c0+1;
 c2=c0+2;
 c3=c0+3;

 fputc(*c0, f);
 fputc(*c1, f);
 fputc(*c2, f);
 fputc(*c3, f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
long fgetl(FILE *f)
{
 long l;
 unsigned char c0, c1, c2, c3, *c;

 c0=fgetc(f);
 c1=fgetc(f);
 c2=fgetc(f);
 c3=fgetc(f);

 c=(unsigned char *)&l;

 *c=c0;
 *(c+1)=c1;
 *(c+2)=c2;
 *(c+3)=c3;

 return	l;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _textprintf(FONT *font, float x, float y, float z, int c, char *format, ...)
{
	char buf[512];

	va_list ap;
	va_start(ap, format);
	vsprintf(buf, format, ap);
	va_end(ap);

	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	allegro_gl_printf(agl_font, x, y, z, c, "%s", buf);

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glEnable(GL_DEPTH_TEST);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void switch_view(int new_view)
{
	if (new_view==view) return;
	
	if (new_view==GLOBAL_VIEW) {
		view=new_view;

		glDisable(GL_LIGHTING);
	}
	else if (new_view==LOCAL_VIEW) {
		float f[]={5, 50, 120, 0};

		view=new_view;

		l_camera.y=10;
		
		glEnable(GL_LIGHT0);
		glLightfv(GL_LIGHT0, GL_POSITION, f);
	    glEnable(GL_LIGHTING);
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void keyboard (void)
{
	if (key[KEY_HOME]) switch_view(LOCAL_VIEW);
	if (key[KEY_END]) switch_view(GLOBAL_VIEW);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_texture(BITMAP *bmp) 
{
	allegro_gl_begin();
	//glDisable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	texture = allegro_gl_make_texture (bmp);
	allegro_gl_end();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void read_data() 
{
	FILE *f;
	int i, j;
	
	f=fopen("albedo.dat", "rb");
	if (!f) exit(9);

	min_albedo=(float)fgetl(f)/1000.0;
	max_albedo=(float)fgetl(f)/1000.0;
	for (j=0;j<180;j++) {
		for (i=0;i<360;i++) {
			albedo[j][i]=(float)fgetl(f)/1000.0;
		}
	}

	fclose(f);

	f=fopen("inertia.dat", "rb");
	if (!f) exit(9);

	min_inertia=(float)fgetl(f)/1000.0;
	max_inertia=(float)fgetl(f)/1000.0;
	for (j=0;j<180;j++) {
		for (i=0;i<360;i++) {
			inertia[j][i]=(float)fgetl(f)/1000.0;
		}
	}

	fclose(f);

	f=fopen("topo.dat", "rb");
	if (!f) exit(9);

	min_topo=(float)fgetl(f)/1000.0;
	max_topo=(float)fgetl(f)/1000.0;
	for (j=0;j<180;j++) {
		for (i=0;i<360;i++) {
			topo[j][i]=(float)fgetl(f)/1000.0;
		}
	}

	fclose(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int init() 
{
	srand(time(0));
	allegro_init();
	
	set_config_file("mars.ini");

	display.color_depth	=get_config_int(NULL, "Color_depth", 16);
	display.fullscreen	=get_config_int(NULL, "Fullscreen", 0);
	display.width		=get_config_int(NULL, "Width", 640);
	display.height		=get_config_int(NULL, "Height", 480);
	display.use_hardware=get_config_int(NULL, "Use_hardware", 1);

	set_config_int(NULL, "Color_depth", display.color_depth);
	set_config_int(NULL, "Fullscreen", display.fullscreen);
	set_config_int(NULL, "Width", display.width);
	set_config_int(NULL, "Height", display.height);
	set_config_int(NULL, "Use_hardware", display.use_hardware);
	//display.use_hardware=0;
	
	install_allegro_gl();

	allegro_gl_clear_settings();
	allegro_gl_set (AGL_COLOR_DEPTH, display.color_depth);
	allegro_gl_set (AGL_Z_DEPTH, 16);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set (AGL_STENCIL_DEPTH, 0);	
	allegro_gl_set (AGL_RENDERMETHOD, display.use_hardware);	
	allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_STENCIL_DEPTH | AGL_RENDERMETHOD);
	
	set_color_depth (display.color_depth);
	if (set_gfx_mode(display.fullscreen?GFX_OPENGL:GFX_OPENGL_WINDOWED, display.width, display.height, 0, 0) < 0) {
		allegro_message ("Error setting graphics mode:\n%s\n", allegro_error);
		return -1;
	}

	install_keyboard();
	install_timer();
	install_mouse();

	set_mouse_speed(0, 0);
	
	//allegro_gl_screen_mode (AGL_MODE_DUPLEX);

	LOCK_FUNCTION(game_proc);
	LOCK_VARIABLE(game_count);
	install_int (game_proc, 20);
	  
	allegro_gl_begin();
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	glFrustum (-1.0, 1.0, -480.0/640.0, 480.0/640.0, 1, VIEW_DIST);
	glClearColor (0, 0, 0, 0);
	glPolygonMode (GL_FRONT, GL_FILL);
	glPolygonMode (GL_BACK, GL_POINTS);
	glShadeModel (GL_SMOOTH);
	glEnable (GL_DEPTH_TEST);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_NORMAL_ARRAY);
	
	rot_speed=10;
	move_speed=0.2;

	glFogi(GL_FOG_MODE, GL_LINEAR);
    glFogf(GL_FOG_DENSITY, 0.15);
	glFogi(GL_FOG_START, 35.0);
	glFogi(GL_FOG_END, 60.0);
	glHint(GL_FOG_HINT, GL_NICEST);
	{
		float f[4]={0, 0, 0, 0};
		glFogfv(GL_FOG_COLOR, f);
	}
	
	{
		float f[4]={1.0, 0.8, 0.8, 0};
		glLightfv(GL_LIGHT0, GL_DIFFUSE, f);
	}
	
	//allegro_gl_fix_font(font);
	agl_font = allegro_gl_convert_allegro_font(font, AGL_FONT_TYPE_TEXTURED);
	//agl_font=aglf_load_system_font("times", 0, 0.1, 0.1);
	//agl_font=aglf_load_system_font_ex("times", AGL_FONT_TYPE_OUTLINE, 0, 10, 10, 0, 32, 255);
	if (!agl_font) {
		allegro_message("Failed to load font!");
		return -1;
	}
	//aglf_set_font_generation_mode(AGL_FONT_LINES);


	allegro_gl_end();

	read_data();

	create_global_view();
	create_local_view();

	return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int main (int argc, char *argv[])
{
	if (init()<0) return 1;

	while (!key[KEY_ESC]) {
		if (view==GLOBAL_VIEW) do_global_view();
		else if (view==LOCAL_VIEW) do_local_view();

		keyboard();
	}
	
	set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);

	allegro_message("Frames: %i, Seconds: %i, FPS: %f", frames, game_count/50, (float)frames / ((float)game_count/50));

	return 0;
}
END_OF_MAIN();



