#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <float.h>
#include <math.h>
#include "texture.h"

// the original code for this was by F.Becker aka SLIQ... thanks goes to him,
// but while he seemed pretty pleased about the speed he achieved with it,
// well i've gone and made it a heap faster... and hopefully its also easy
// to use

void init_texture (text *the_text, int width, int height)
{
   int x;
   double const Fd2r = 3.1415926535/512;
   long *p1, *p2;

   the_text->width    = width;
   the_text->height   = height;

   the_text->table1 = malloc(128 * 16);
   the_text->table2 = malloc(the_text->width * 4);

   the_text->xo = 0;   // x offset
   the_text->yo = 0;   // y offset
   the_text->deg = 0;  // rotation amount

   p1 = (long *) the_text->table1;
   p2 = (long *) the_text->table1 + (128);

   for(x=0;x<(random()%512);x++) {
      the_text->deg += 2;
      the_text->xo+=(1253L<<5);
      the_text->yo+=(1534L<<5);
   }

   for( x=0 ; x <128; x++ ) {
      p1[x]=(sin((x<<3)*Fd2r)*65536.0);
      p2[x]=(cos((x<<3)*Fd2r)*65536.0);
   }
}

// the meat of the 'slimy texture mapping' - a part i was proud to vastly
// speed increase by reducing the inner loop to the simplicity of
//    pointer a++ gets value of (address pointer b points to plus value of
//    pointer c++)
// (does that make any sense?).... anyway, you can't go much faster (w/o
// going down into assembler) and its rather great considering how complex
// the thing is

void mainpart  (long dx, long dy, unsigned short adx2, unsigned short ady2,
                long xo, long yo, text *the_text,
                BITMAP *buffer, BITMAP *backpic)
{

   unsigned short y=0, *tmp;
   unsigned long ystart, xstart;
   long *p1, *p2;
   unsigned char *p, x1, *q, wo16;

   p1 = (long *) the_text->table1;  
   p2 = (long *) the_text->table1 + (128);

   wo16 = the_text->width / 16;

   // precalculate slime values for vertical line (used in inner loop)

   tmp     = (unsigned short *) the_text->table2;
   *tmp++  = ady2+(p1[y&127]>>8);
   for(y=1; y<the_text->width; y++) *tmp = (ady2+(p1[y&127]>>8) + *(tmp++ - 1));

   *tmp++ = 0;
   for(y=1; y<the_text->width; y++) *tmp = *(tmp++ - 1) + adx2;

   tmp = (unsigned short *) the_text->table2;
   for(y=0; y<the_text->width; y++) *tmp = (*tmp & 65280) + (*(tmp++ + the_text->width) >> 8);

   xstart = xo;
   ystart = yo;

   p = &buffer->line[0][0];

   // now lets do it!

   for(y=0; y<the_text->height; y++) {
      tmp = (unsigned short *) the_text->table2;
      q = &backpic->line[(ystart>>16)%256][(xstart>>16)%256];

      for(x1=0; x1<wo16; x1++) {
         *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++);
         *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++);
         *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++);
         *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++); *p++ = *(q + *tmp++);
      }
      // calc new start position for vertical line plus slime adjustment...
      xstart+=(dx+p2[y&127]);
      ystart+=dy;
   }
}

// this is the function you should call every frame - it just moves and
// skews the thing slightly and then calls mainpart to do the actual
// calculations (see texture.h for more info)

void texture (text *the_text, BITMAP *buffer, BITMAP *backpic, double fps)
{
   long dx, dy;
   double const Fd2r = 3.1415926535/512;

   dy = (sin(the_text->deg*Fd2r)*160000.0);
   dx = (cos(the_text->deg*Fd2r)*160000.0);
   mainpart (dx,dy, (unsigned short) (-dy >> 8),(unsigned short) (dx >> 8),
            (long) the_text->xo, (long) the_text->yo,
            the_text, buffer, backpic);
   the_text->deg += 2.0 * (10.0 / fps);
   the_text->xo+=(1253L<<5) * (13.0 / fps);
   the_text->yo+=(1534L<<5) * (13.0 / fps);
}
