#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <float.h>
#include <math.h>
#include "moveplas.h"

void init_plas (plas *the_plas, int width, int height, int range)
{
   int i = 0, j, l;
   long k;
   float temp;
   unsigned char *p, *q, *p2, *q2;

   the_plas->width    = width;
   the_plas->height   = height;

   the_plas->circle1 = (float)(random() % 65536) / 16384.0;
   the_plas->circle2 = (float)(random() % 65536) / 16384.0 * -1;
   the_plas->circle3 = (float)(random() % 65536) / 16384.0;
   the_plas->circle4 = (float)(random() % 65536) / 16384.0 * -1;
   the_plas->circle5 = (float)(random() % 65536) / 16384.0;
   the_plas->circle6 = (float)(random() % 65536) / 16384.0 * -1;
   the_plas->circle7 = (float)(random() % 65536) / 16384.0;
   the_plas->circle8 = (float)(random() % 65536) / 16384.0 * -1;
   the_plas->type = range / 4;

   the_plas->table1 = malloc(the_plas->width*the_plas->height*4);
   the_plas->table2 = malloc(the_plas->width*the_plas->height*4);
   p = the_plas->table1;
   q = the_plas->table2;
   l = the_plas->width*2;

   while(i<the_plas->height)
   {
      j=0;
      k = (the_plas->height-i) * (the_plas->height-i);

      while(j<the_plas->width)
      {
         temp = sqrt(16.0+k+(the_plas->width-j)*(the_plas->width-j))-4;
         *p++ = (temp * 5.4) / range;
         *q++ = (sin(temp/9.5)+1)*97 / range;
         j++;
      }
      p2 = p-1; q2 = q-1;
      while(j<l) {*p++ = *p2--; *q++ = *q2--; j++;}
      i++;
   }
   while(i<the_plas->height*2)
   {
      memcpy(&the_plas->table1[i*l], &the_plas->table1[(the_plas->height*2-i-1)*l], l);
      memcpy(&the_plas->table2[i*l], &the_plas->table2[(the_plas->height*2-i-1)*l], l);
      i++;
   }
}


void plasma (plas *the_plas, BITMAP *buffer, BITMAP *backpic, int backon, double fps)
{
   int i=0, xx1, xx2, xx3, xx4, x1,y1,x2,y2,x3,y3,x4,y4, wo16, wo2, ho2;
   unsigned long *p, *p1, *p2, *p3, *q, *q1;
   unsigned char j;

   wo16 = the_plas->width / 16;
   wo2  = the_plas->width / 2;
   ho2  = the_plas->height / 2;

   the_plas->circle1 += .0425 * 1.6 / fps; the_plas->circle2 -=   .05 * 1.6  / fps;
   the_plas->circle3 +=   .15 * 1.6 / fps; the_plas->circle4 -=   .10 * 1.6  / fps;
   the_plas->circle5 +=   .20 * 1.6 / fps; the_plas->circle6 -=  .075 * 1.6  / fps;
   the_plas->circle7 +=  .175 * 1.6 / fps; the_plas->circle8 -=  .025 * 1.6  / fps;

   x2 = wo2 + wo2 * sin(the_plas->circle1); y2 = ho2 + ho2 * cos(the_plas->circle2);
   x1 = wo2 + wo2 * cos(the_plas->circle3); y1 = ho2 + ho2 * sin(the_plas->circle4);
   x3 = wo2 + wo2 * cos(the_plas->circle5); y3 = ho2 + ho2 * sin(the_plas->circle6);
   x4 = wo2 + wo2 * cos(the_plas->circle7); y4 = ho2 + ho2 * sin(the_plas->circle8);

   xx1 = the_plas->width * 2 * y1 + x1; xx2 = the_plas->width * 2 * y2 + x2;
   xx3 = the_plas->width * 2 * y3 + x3; xx4 = the_plas->width * 2 * y4 + x4;

   for(i=0;i<the_plas->height;i++)
   {
      p = (unsigned long *) &buffer->line[i][0];

      x1 = the_plas->width*2*i;
      p1 = (unsigned long *) &the_plas->table1[x1 + xx1];
      p2 = (unsigned long *) &the_plas->table2[x1 + xx3];
      p3 = (unsigned long *) &the_plas->table2[x1 + xx4];
      q  = (unsigned long *) &the_plas->table2[x1 + xx2];

      if(!backon) {
         for(j=0;j<wo16;j++) {
            *p++ = *p1++ + *p2++ + *p3++ + *q++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++;
         }
      }

      else {
         q1 = (unsigned long *) &backpic->line[i][0];
         for(j=0;j<wo16;j++) {
            *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
            *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
         }
      }
   }
}
