// Allegro - C- code done with MichisDialogkiste
//                   MDK 3.01

//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int ok_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE) dialog=0;

 return ret;
}
//---------------------------------------------------------------------------
int save_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 save_defaults();
	 dialog=0;
	}

 return ret;
}
//---------------------------------------------------------------------------
int about_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 screen=screen_bk;
	 alert(FX_STR, "By Vasile Catalin (CataSoft)", "For details, read readme.txt", "Fine, fine...",	NULL, 0 , 0);
	 show_mouse(buffer);
	 screen=buffer;
	}

 return ret;
}
//---------------------------------------------------------------------------
int fx1_proc(int msg, DIALOG *d, int c)
{
 if (fx==0) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) fx=0;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int fx2_proc(int msg, DIALOG *d, int c)
{
 if (fx==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) fx=1;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int fx3_proc(int msg, DIALOG *d, int c)
{
 if (fx==2) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) fx=2;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int fx4_proc(int msg, DIALOG *d, int c)
{
 if (fx==3) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) fx=3;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int fx5_proc(int msg, DIALOG *d, int c)
{
 if (fx==4) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) fx=4;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res1_proc(int msg, DIALOG *d, int c)
{
 if (new_w==320 && new_h==200) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=320; new_h=200;}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res2_proc(int msg, DIALOG *d, int c)
{
 if (new_w==320 && new_h==240) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=320; new_h=240;}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res3_proc(int msg, DIALOG *d, int c)
{
 if (new_w==400 && new_h==300) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=400; new_h=300;}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res4_proc(int msg, DIALOG *d, int c)
{
 if (new_w==640 && new_h==400) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=640; new_h=400;}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res5_proc(int msg, DIALOG *d, int c)
{
 if (new_w==640 && new_h==480) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=640; new_h=480;}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res6_proc(int msg, DIALOG *d, int c)
{
/* if (new_w==800 && new_h==600) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=800; new_h=600;}
*/
 return D_O_K;//d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int res7_proc(int msg, DIALOG *d, int c)
{
/* if (new_w==1024 && new_h==768) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) {new_w=1024; new_h=768;}
*/
 return D_O_K;//d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int set_res_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE && (new_w!=w || new_h!=h)) set_res=1;

 return ret;
}
//---------------------------------------------------------------------------
int set_qd_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE && (new_quality!=quality || new_depth!=depth)) set_qd=1;

 return ret;
}
//---------------------------------------------------------------------------
int default_qd_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 new_quality=450;
	 new_depth=1000;
	}

 return ret;
}
//---------------------------------------------------------------------------
int default_rsf_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 rot_speed=276;
	 speed=276;
	 fx_speed=128;
	}

 return ret;
}
//---------------------------------------------------------------------------
int centre_rsf_proc(int msg, DIALOG *d, int c)
{
 int ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 rot_speed=256;
	 speed=256;
	 fx_speed=512;
	}

 return ret;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int texture_proc(int msg, DIALOG *d, int c)
{
 int ret;
 //char path[256];
 BITMAP *temp;

 ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 screen=screen_bk;

	 strcpy(loaded_image_path, "");
	 if (file_select("Choose an 8-bit image", loaded_image_path, "PCX;BMP;"))
	   	{
		 temp=load_bitmap(loaded_image_path, loaded_palette);
		 if (temp)
		   	{
			 if (loaded_image && (loaded_image!=local_image)) destroy_bitmap(loaded_image);
			 loaded_image=create_image(temp);
			 destroy_bitmap(temp);
			 if (use_image==1)
			   	{
				 image=loaded_image;
				 set_palette(loaded_palette);
				 palette=1;
				}
			}
		 else alert("The specified image could not be loaded !", "Please try only 8-bit images.", "", "Ok", NULL, 0, 0);
		}

	 show_mouse(buffer);
	 screen=buffer;

	 return D_REDRAW;
	}

 return	ret;
}
//---------------------------------------------------------------------------
int redraw_local_image_proc(int msg, DIALOG *d, int c)
{
 int ret;
 BITMAP *temp;

 ret=d_button_proc(msg, d, c);

 if (ret==D_CLOSE)
   	{
	 if (local_image) destroy_bitmap(local_image);
	 temp=still_plasma(256, 256, STILL_SEAMLESS);
	 if (!temp) exit(55);
	 local_image=create_image(temp);
	 if (use_image==2 || use_image==0) image=local_image;
	 destroy_bitmap(temp);

	 return D_REDRAW;
	}

 return	ret;
}

//---------------------------------------------------------------------------
int loaded_texture_proc(int msg, DIALOG *d, int c)
{
 if (use_image==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK && loaded_image)
   	{
	 set_palette(loaded_palette);
	 palette=1;

	 image=loaded_image;
	 use_image=1;
    }
 else if (msg==MSG_CLICK) msg=MSG_IDLE;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int local_texture_proc(int msg, DIALOG *d, int c)
{
 if (use_image==2) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK)
   	{
	 set_palette(local_palette);
	 palette=0;

	 image=local_image;
	 use_image=2;
	}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int no_texture_proc(int msg, DIALOG *d, int c)
{
 if (!use_image) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK)
   	{
	 set_palette(local_palette);
	 palette=0;

	 image=local_image;
	 use_image=0;
	}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int local_palette_proc(int msg, DIALOG *d, int c)
{
 if (palette==0) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK)
   	{
 	 set_palette(local_palette);
	 palette=0;
	}

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int loaded_palette_proc(int msg, DIALOG *d, int c)
{
 if (palette==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK && loaded_image)
   	{
 	 set_palette(loaded_palette);
	 palette=1;
	}
 else if (msg==MSG_CLICK) msg=MSG_IDLE;

 return d_radio_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int anim_hue_proc(int msg, DIALOG *d, int c)
{
 if (anim_hue==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) anim_hue=!anim_hue;

 return d_check_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int anim_saturation_proc(int msg, DIALOG *d, int c)
{
 if (anim_saturation==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) anim_saturation=!anim_saturation;

 return d_check_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int anim_value_proc(int msg, DIALOG *d, int c)
{
 if (anim_value==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) anim_value=!anim_value;

 return d_check_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int vsync_proc(int msg, DIALOG *d, int c)
{
 if (use_vsync==1 || anim_hue==1 || anim_saturation==1 || anim_value==1) d->flags|=D_SELECTED;
 else d->flags&=~D_SELECTED;

 if (msg==MSG_CLICK) use_vsync=!use_vsync;

 return d_check_proc(msg, d, c);
}
//---------------------------------------------------------------------------
int hue_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=hue;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int saturation_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=saturation;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int value_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=value;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int rot_speed_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=rot_speed;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int speed_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=speed;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int fx_speed_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=fx_speed;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int quality_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=new_quality;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int depth_proc(int msg, DIALOG *d, int c)
{
 int ret;

 d->d2=new_depth;

 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b_blink;
 ret=d_slider_proc(msg, d, c);
 if (msg==MSG_CLICK) gui_mouse_b=__mouse_b;

 return ret;
}
//---------------------------------------------------------------------------
int HUE_CALLBACK(void *dp3, int h)
{
 float _s=1.0*saturation/360;
 float _v=1.0*value/360;

 hue=h;

 hsv_to_rgb(hue, _s, _v, &max_r, &max_g, &max_b);

 create_palette();
 if (palette==0) set_palette(local_palette);

 return h;
}
//---------------------------------------------------------------------------
int SATURATION_CALLBACK(void *dp3, int s)
{
 float _s=1.0*s/360;
 float _v=1.0*value/360;

 saturation=s;

 hsv_to_rgb(hue, _s, _v, &max_r, &max_g, &max_b);

 create_palette();
 if (palette==0) set_palette(local_palette);

 return s;
}
//---------------------------------------------------------------------------
int VALUE_CALLBACK(void *dp3, int v)
{
 float _s=1.0*saturation/360;
 float _v=1.0*v/360;

 value=v;

 hsv_to_rgb(hue, _s, _v, &max_r, &max_g, &max_b);

 create_palette();
 if (palette==0) set_palette(local_palette);

 return v;
}
//---------------------------------------------------------------------------
int ROT_SPEED_CALLBACK(void *dp3, int v)
{
 rot_speed=v;

 return v;
}
//---------------------------------------------------------------------------
int SPEED_CALLBACK(void *dp3, int v)
{
 speed=v;

 return v;
}
//---------------------------------------------------------------------------
int FX_SPEED_CALLBACK(void *dp3, int v)
{
 fx_speed=v;

 return v;
}
//---------------------------------------------------------------------------
int QUALITY_CALLBACK(void *dp3, int v)
{
 new_quality=v;

 return v;
}
//---------------------------------------------------------------------------
int DEPTH_CALLBACK(void *dp3, int v)
{
 new_depth=v;

 return v;
}

//---------------------------------------------------------------------------


DIALOG MDK30_Dialog[]= { 
/* 0 */	{ d_shadow_box_proc ,	16 ,	18 ,	606 ,	438 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 1 */	{ d_shadow_box_proc ,	226 ,	24 ,	186 ,	108 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
///* 2 */	{ d_shadow_box_proc ,	394 ,	186 ,	90 ,	60 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 3 */	{ d_shadow_box_proc ,	22 ,	24 ,	186 ,	108 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 5 */	{ d_shadow_box_proc ,	22 ,	186 ,	168 ,	204 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 7 */	{ ok_proc ,	22 ,	426 ,	156 ,	24 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
/* 8 */	{ d_text_proc ,	532 ,	444 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "CataSoft FX" },
/* 13 */	{ fx1_proc ,	400 ,	192 ,	78 ,	12 ,	11,	254,	0 ,	0 ,	2 ,	0 ,	 "1" },
/* 14 */	{ fx2_proc ,	400 ,	204 ,	78 ,	12 ,	11,	254,	0 ,	0 ,	2 ,	0 ,	 "2" },
/* 15 */	{ fx3_proc ,	400 ,	216 ,	78 ,	12 ,	11,	254,	0 ,	0 ,	2 ,	0 ,	 "3" },
/* 16 */	{ fx4_proc ,	400 ,	228 ,	78 ,	12 ,	11,	254,	0 ,	0 ,	2 ,	0 ,	 "4" },
/* 16 */	{ fx5_proc ,	400 ,	240 ,	78 ,	12 ,	11,	254,	0 ,	0 ,	2 ,	0 ,	 "5" },
/* 17 */	{ quality_proc ,	232 ,	42 ,	174 ,	18 ,	11,	254,	0 ,	0 ,	1500 ,	0 ,	NULL, QUALITY_CALLBACK},
/* 18 */	{ d_shadow_box_proc ,	430 ,	24 ,	186 ,	108 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 19 */	{ depth_proc ,	232 ,	78 ,	174 ,	18 ,	11,	254,	0 ,	0 ,	4000 ,	0 ,	NULL, DEPTH_CALLBACK},
/* 20 */	{ speed_proc ,	436 ,	42 ,	174 ,	18 ,	11,	254,	0 ,	0 ,	512 ,	0 ,	NULL, SPEED_CALLBACK},
/* 21 */	{ rot_speed_proc ,	436 ,	78 ,	174 ,	18 ,	11,	254,	0 ,	0 ,	512 ,	0 ,	NULL, ROT_SPEED_CALLBACK},
/* 22 */	{ d_text_proc ,	232 ,	30 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Quality" },
/* 23 */	{ d_text_proc ,	232 ,	66 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Depth" },
/* 24 */	{ res1_proc ,	28 ,	42 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "320x240" },
/* 25 */	{ vsync_proc ,	28 ,	90 ,	66 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Vsync" },
/* 26 */	{ res2_proc ,	28 ,	30 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "320x200" },
/* 27 */	{ res3_proc ,	28 ,	54 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "400x300" },
/* 28 */	{ res4_proc ,	28 ,	66 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "640x400" },
/* 29 */	{ res5_proc ,	118 ,	30 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "640x480" },
/* 30 */	{ res6_proc ,	118 ,	42 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "800x600" },
/* 31 */	{ res7_proc ,	118 ,	54 ,	84 ,	12 ,	11,	254,	0 ,	0 ,	3 ,	0 ,	 "1024x768" },
/* 32 */	{ d_text_proc ,	436 ,	30 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Rotation" },
/* 33 */	{ d_text_proc ,	436 ,	66 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Speed" },
/* 34 */	{ set_res_proc ,	28 ,	108 ,	84 ,	18 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Set" },
/* 35 */	{ save_proc ,	184 ,	426 ,	156 ,	24 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Save" },
/* 36 */	{ about_proc ,	346 ,	426 ,	156 ,	24 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "About" },
/* 37 */	{ set_qd_proc ,	232 ,	108 ,	84 ,	18 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Set" },
/* 38 */	{ default_qd_proc ,	322 ,	108 ,	84 ,	18 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Default" },
/* 40 */	{ loaded_palette_proc ,	28 ,	282 ,	114 ,	12 ,	11,	254,	0 ,	0 ,	1 ,	0 ,	 "Loaded palette" },
/* 41 */	{ hue_proc ,	28 ,	318 ,	138 ,	18 ,	11,	254,	0 ,	0 ,	360 ,	0 ,	NULL, HUE_CALLBACK },
/* 42 */	{ local_palette_proc ,	28 ,	270 ,	114 ,	12 ,	11,	254,	0 ,	0 ,	1 ,	0 ,	 "Internal palette" },
/* 43 */	{ redraw_local_image_proc ,	176 ,	228 ,	12 ,	12 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "R" },
/* 44 */	{ texture_proc ,	28 ,	192 ,	156 ,	24 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Texture" },
/* 45 */	{ local_texture_proc ,	28 ,	228 ,	138 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Internal Texture" },
/* 46 */	{ loaded_texture_proc ,	28 ,	240 ,	156 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Loaded Texture" },
/* 47 */	{ no_texture_proc ,	28 ,	252 ,	114 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "No texture" },
/* 48 */	{ default_rsf_proc ,	526 ,	108 ,	84 ,	18 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Default" },
/* 49 */	{ d_shadow_box_proc ,	22 ,	138 ,	594 ,	42 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 50 */	{ fx_speed_proc ,	28 ,	156 ,	582 ,	18 ,	11,	254,	0 ,	0 ,	1024 ,	0 ,	NULL, FX_SPEED_CALLBACK},
/* 51 */	{ d_text_proc ,	28 ,	144 ,	12 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Fx Speed" },
/* 52 */	{ centre_rsf_proc ,	436 ,	108 ,	84 ,	18 ,	11,	254,	0 ,	D_EXIT ,	0 ,	0 ,	 "Centre" },
/* 53 */	{ saturation_proc ,	28 ,	342 ,	138 ,	18 ,	11,	254,	0 ,	0 ,	360 ,	0 ,	NULL, SATURATION_CALLBACK },
/* 54 */	{ value_proc ,	28 ,	366 ,	138 ,	18 ,	11,	254,	0 ,	0 ,	360 ,	0 ,	NULL, VALUE_CALLBACK },
/* 55 */	{ anim_hue_proc ,	170 ,	324 ,	18 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "" },
/* 56 */	{ anim_saturation_proc ,	170 ,	348 ,	18 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "" },
/* 57 */	{ anim_value_proc ,	170 ,	372 ,	18 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "" },
/* 58 */	{ d_text_proc ,	28 ,	306 ,	18 ,	12 ,	11,	254,	0 ,	0 ,	0 ,	0 ,	 "Internal Palette" },
 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
 };

