/* TEXTURE.C - generates a real-time moving plasma

   This is the header file and must be included in any file using texture.c
   ie #include "texture.h"

   You must also of course include the file texture.c (or texture.o) in
   your compilation command line.
   ie gcc -o myprog.exe myprog.c texture.o -lalleg -s -O3 -ffast-math etc

   Call function init_texture(texture *the_texture, int width, int height)
   with a texture structure, the width and the height. The width must be a
   multiple of 16 (this allows it to run real fast, and all normal screen
   modes ie width 320, 400, 640, 800, 1024 divide into it).

   Then for each frame call function texture, defined as -
      void texture (effect *the_effect, BITMAP *buffer, BITMAP *backpic,
         double fps);
   The texture structure should be the one you used with init_texture, as
   init_texture will have set it up appropriately. Buffer is the output
   bitmap and backpic is the picture to be 'texture mapped' onto it, with
   dimensions 256 x 512, with the second 256 rows a copy of the first, and
   frame rate. The most obvious picture to use is a still plasma (ie use my
   still plasma module), but it can produce cool effects on normal pictures
   as well.

   Requires - DJGPP, Allegro.
   Created by Michael Bevin, 1998.
   Please use but give credit.
*/


typedef struct text {
   int width, height;
   unsigned char *table1, *table2;
   double xo, yo, deg;
} text;

void init_texture (text *the_text, int width, int height);
void texture (text *the_text, BITMAP *buffer, BITMAP *backpic, double fps);
