#define MAXINT         65536

#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <float.h>
#include <math.h>
#include "stil.h"

int the_type, x_max, y_max, last_line;
short *b;

// recursive function written all by myself (aren't I proud), with the
// help of a graphics book from the library. i haven't actually found
// a similar function in any source, which is probably why i went to this
// last resort - it's worth using though, as it saves having a precalculated
// texture map taking up heaps of space

void cs(int il, int jl, int ih, int jh)
{
   int im, jm;

   im = (il+ih)/2;
   jm = (jl+jh)/2;

   if(jm > jl) {
      if(b[il*x_max + jm] == -10000) {
         b[il*x_max + jm] = (b[il*x_max+jl] + b[il*x_max+jh])/2 +
                            (random() % 65536 - 32768) / (32768 / (jh-jl));
         if(il == 0)
            if(the_type == STILL_SEAMLESS)
               b[last_line + jm] = b[il*x_max + jm];
      }
      if(il < ih && b[ih*x_max + jm] == -10000) {
         b[ih*x_max + jm] = (b[ih*x_max+jl] + b[ih*x_max+jh])/2 +
                            (random() % 65536 - 32768) / (32768 / (jh-jl));

      }
   }
   if(im > il) {
      if(b[im*x_max + jl] == -10000) {
         b[im*x_max + jl] = (b[il*x_max+jl] + b[ih*x_max+jl])/2 +
                            (random() % 65536 - 32768) / (32768 / (ih-il));
         if(jl == 0)
            if(the_type == STILL_SEAMLESS)
               b[im*x_max + (x_max - 1)] = b[im*x_max + jl]; 
      }
      if(jl < jh && b[im*x_max + jh] == -10000) {
         b[im*x_max + jh] = (b[il*x_max+jh] + b[ih*x_max+jh])/2 +
                            (random() % 65536 - 32768) / (32768 / (ih-il));

      }
   }

   if((jm > jl) && (im > il)) {
      if(b[im*x_max + jm] == -10000) {
         b[im*x_max + jm] = (b[il*x_max+jl] + b[ih*x_max+jl] +
                             b[il*x_max+jh] + b[ih*x_max+jh]) / 4 +
                             (random() % 65536 - 32768) / (32768 / (ih-il + jh-jl));

      }
   }

   if((jm > jl && jm < jh) || (im > il && im < ih)) {
      cs(il,jl,im,jm);
      cs(il,jm,im,jh);
      cs(im,jl,ih,jm);
      cs(im,jm,ih,jh);
   }
}


// w and h are best as powers of 2 + 1, ie 129, 257 etc
// with the bitmap being the same dimensions, but ignoring the last row
// and column, type can be either STILL_NORMAL or STILL_SEAMLESS

BITMAP *still_plasma(int w, int h, int type)
{
   long x, y;
   BITMAP *buff;
   short low, high, range, *q, w1, h1;
   unsigned char *p;
   float ratio;

   the_type = type;
   w1 = w; h1 = h;
   w++; h++; // increase width & height by one and then ignore last row & col
   x_max = w;
   y_max = h;
   last_line = (y_max-1)*x_max;

   b = malloc(w * h * 4);
   buff = create_bitmap_ex(8, w1, h1);

   for(x=0;x<w*h;x++) {
      b[x] = -10000; // magic number
   }

   b[0]                = 128 + random() % 32; // initialize first four corners
   b[w-1]              = 128 + random() % 32;
   b[w-1 + (h-1) * w]  = 128 + random() % 32;
   b[(h-1) * w]        = 128 + random() % 32;

   cs(0, 0, w-1, h-1);                   // calls recursive function

   // normalize the plasma to range 0 - 255

   low = 10000; high = -10000;

   for(y=0;y<h1;y++) {
      q = &b[y*w];
      for(x=0;x<w1;x++) {
         if(q[x] < low) low = q[x];
         if(q[x] > high) high = q[x];
      }
   }

   range = high - low;

   ratio = (float) ((float)255.0 / (float)range);
   for(y=0;y<h1;y++) {
      p = &buff->line[y][0];
      q = &b[y*w];
      for(x=0;x<w1;x++) p[x] = (unsigned char) ((float)(q[x]-low) * (float)ratio);
   }

   free(b);
   return(buff);
}
