#define FX_STR "FX v2.0"
#include "includes.h"


//----------------------------------------------------------------------------
void my_timer(void)
{
 game_time++;
}
END_OF_FUNCTION(my_timer);
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
int __mouse_x()
{
 return mouse_x;
}
//----------
int __mouse_y()
{
 return mouse_y;
}
//----------
int __mouse_b_blink()
{
 static int o=0;

 if (mouse_b&2) return 0;

 if (o==1) {o=0; return 0;}
 else {o++; return mouse_b;}

 return mouse_b;
}
//----------
int __mouse_b()
{
 if (mouse_b&2) return 0;

 return mouse_b;
}
//----------------------------------------------------------------------------
void dialog_at(DIALOG *dialog, int x, int y)
{
   int min_x = 10000;
   int min_y = 10000;
   int max_x = -10000;
   int max_y = -10000;
   int xc, yc;
   int c;

   /* find the extents of the dialog */ 
   for (c=0; dialog[c].proc; c++) {
      if (dialog[c].x < min_x)
	 min_x = dialog[c].x;

      if (dialog[c].y < min_y)
	 min_y = dialog[c].y;

      if (dialog[c].x + dialog[c].w > max_x)
	 max_x = dialog[c].x + dialog[c].w;

      if (dialog[c].y + dialog[c].h > max_y)
	 max_y = dialog[c].y + dialog[c].h;
   }

   /* how much to move by? */
   xc = x - min_x;
   yc = y - min_y;

   /* move it */
   for (c=0; dialog[c].proc; c++) {
      dialog[c].x += xc;
      dialog[c].y += yc;
   }
}
//----------------------------------------------------------------------------
void animate_palette()
{
 float _s=1.0*saturation/360;
 float _v=1.0*value/360;

 if (palette!=0) return;

 if (anim_hue) {hue++; hue%=360;}
 if (anim_saturation) {saturation++; saturation%=360;}
 if (anim_value) {value++; value%=360;}

 hsv_to_rgb(hue, _s, _v, &max_r, &max_g, &max_b);
 create_palette();
 set_palette(local_palette);
}
//----------------------------------------------------------------------------
void create_palette()
{
 int i;

 for(i=0;i<256;i++)
	{
     local_palette[i].r = (float)(max_r*(i >> 2))/256;
     local_palette[i].g = (float)(max_g*(i >> 2))/256;;
     local_palette[i].b = (float)(max_b*(i >> 2))/256;;
    }
}
//----------------------------------------------------------------------------
BITMAP *create_image(BITMAP *source)
{
 BITMAP *temp;

 if (!source) exit(56);

 temp=create_bitmap_ex(8, 256, 512);
 if (!temp) exit(32);

 stretch_blit(source, temp, 0, 0, source->w, source->h, 0, 0, 256, 256);
 stretch_blit(source, temp, 0, 0, source->w, source->h, 0, 256, 256, 256);

 return temp;
}
//----------------------------------------------------------------------------
void init()
{
 BITMAP *temp;
 int i;

 set_color_depth(8);
 if (set_gfx_mode(GFX_AUTODETECT, w, h, 0, 0)) exit(30);
 screen_bk=screen;

 set_palette(desktop_palette);
 textprintf_centre(screen, font, w/2, h/2-8, 1, "%s, CataSoft 2000", FX_STR);
 textout_centre(screen, font, "Rendering the Universe", w/2, h/2+8, 1);
 textout_centre(screen, font, "Please wait...", w/2, h/2+24, 1);

 init_fire(&my_fire, w, h);
 init_plas (&my_plas, w, h, 4);
 init_two_worms(&my_wor1, &my_wor2, w, h, depth, quality);
 init_texture(&my_text, w, h);

 buffer = create_bitmap(w, h);
 if (!buffer) exit(31);
 clear(buffer);

 temp=still_plasma(256, 256, STILL_SEAMLESS);
 if (!temp) exit(55);
 local_image=create_image(temp);
 destroy_bitmap(temp);

 temp=load_bitmap(loaded_image_path, loaded_palette);
 if (temp) loaded_image=create_image(temp);
 else if (use_image==1) use_image=2;
 destroy_bitmap(temp);

 if (use_image==0 || use_image==2) image=local_image;
 else image=loaded_image;

 i=palette; palette=0; animate_palette(); palette=i;
 if (palette==0) set_palette(local_palette);
 else set_palette(loaded_palette);

 dplayer=init_dialog(MDK30_Dialog, -1);
 _dialogp=MDK30_Dialog;

 gui_mouse_x=__mouse_x;
 gui_mouse_y=__mouse_y;
 gui_mouse_b=__mouse_b;

 frame_count=1; game_time=1;
}
//----------------------------------------------------------------------------
void uninit()
{
 screen=screen_bk;

 free(my_plas.table1);
 free(my_plas.table2);

 free(my_wor1.table1);
 free(my_wor1.table2);
 free(my_wor2.table1);
 free(my_wor2.table2);

 free(my_text.table1);
 free(my_text.table2);

 destroy_bitmap(my_fire.buf);

 if (buffer) destroy_bitmap(buffer);
 if (loaded_image) destroy_bitmap(loaded_image);
 if (local_image) destroy_bitmap(local_image);

 shutdown_dialog(dplayer);
}
//----------------------------------------------------------------------------
void save_defaults()
{
// push_config_state();
 set_config_file("fx.ini");

 set_config_int("SCREEN", "Width", w);
 set_config_int("SCREEN", "Height", h);
 set_config_int("SCREEN", "Vsync", use_vsync);
 set_config_int("FX", "Fx", fx);
 set_config_int("FX", "Quality", quality);
 set_config_int("FX", "Depth", depth);
 set_config_string("FX", "Texture", loaded_image_path);
 set_config_int("FX", "Texture_type", use_image?(image==local_image?2:1):0);
 set_config_int("FX", "Rot_speed", rot_speed);
 set_config_int("FX", "Speed", speed);
 set_config_int("FX", "Fx_speed", fx_speed);
 set_config_int("PALETTE", "Palette", palette);
 set_config_int("PALETTE", "Hue", hue);
 set_config_int("PALETTE", "Saturation", saturation);
 set_config_int("PALETTE", "Value", value);
 set_config_int("PALETTE", "Anim_hue", anim_hue);
 set_config_int("PALETTE", "Anim_saturation", anim_saturation);
 set_config_int("PALETTE", "Anim_value", anim_value);
}
//----------------------------------------------------------------------------
void load_defaults()
{
// push_config_state();
 set_config_file("fx.ini");

 w=					get_config_int("SCREEN", "Width", 640);
 h=					get_config_int("SCREEN", "Height", 480);
 use_vsync=			get_config_int("SCREEN", "Vsync", 0);
 fx=				get_config_int("FX", "Fx", 0);
 quality=			get_config_int("FX", "Quality", 450);
 depth=				get_config_int("FX", "Depth", 1000);
 strcpy(loaded_image_path, get_config_string("FX", "Texture", "None"));
 use_image=			get_config_int("FX", "Texture_type", 2);
 rot_speed=			get_config_int("FX", "Rot_speed", 276);
 speed=				get_config_int("FX", "Speed", 276);
 fx_speed=			get_config_int("FX", "Fx_speed", 128);
 palette=			get_config_int("PALETTE", "Palette", 0);
 hue=				get_config_int("PALETTE", "Hue", 0);
 saturation=		get_config_int("PALETTE", "Saturation", 360);
 value=				get_config_int("PALETTE", "Value", 360);
 anim_hue=			get_config_int("PALETTE", "Anim_hue", 0);
 anim_saturation=	get_config_int("PALETTE", "Anim_saturation", 0);
 anim_value=		get_config_int("PALETTE", "Anim_value", 0);
}
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
 static int x_off, y_off;
 int obj, i, j, done;
 unsigned char *p;

 srandom(time(0));

 allegro_init();
 install_keyboard();
 install_timer();
 if (install_mouse()<1) exit(2);

 LOCK_VARIABLE(game_time); LOCK_FUNCTION(my_timer);  // lock interrupt vars
 install_int(my_timer, 100);

 strcpy(loaded_image_path, "None");

 load_defaults();
 save_defaults();
 new_w=w; new_h=h;
 new_quality=quality; new_depth=depth;

 init();

 done=0;
 while(!done)
   {
	show_mouse(NULL);
	while (keypressed()) readkey();//so that the keyboard wont scream

	if (key[KEY_ESC]) done=1;

	if (key[KEY_S])
	  	{
		 save_bitmap("screen.pcx", local_image, local_palette);
		}

	if (set_res || set_qd)//in case we changed the display mode, quality of depth
	  	{
		 uninit();
		 if (set_res) {w=new_w; h=new_h;}
		 if (set_qd) {quality=new_quality; depth=new_depth;}
		 init();
		 set_res=0; set_qd=0;
		}

	if (mouse_b==2)//if moving the dialog
   		{
		 if (x_off==-999) {x_off=_dialogp[0].x-mouse_x; y_off=_dialogp[0].y-mouse_y;}
     	 dialog_at(_dialogp, mouse_x+x_off, mouse_y+y_off);
		}
 	else x_off=-999;

	if (anim_hue || anim_saturation || anim_value) animate_palette();//palette animation

    fps = frame_count * 10.0 / game_time;
	fps=(fps*(512-fx_speed))/256+1;
    y_pos += (rot_speed-256) / fps; x_pos += (speed-256) / fps;
	frame_count++;

    if (fx==0)
   		{
     	 plasma  (&my_plas, buffer, image, use_image, fps);

     	 for(j=0;j<h;j++)
         	{
       		 p = buffer->line[j];
      	     for(i=0;i<w/4;i++)
               	{
           	     if(*p & 128) *p=~*p; *p = *p++ << 1;
                 if(*p & 128) *p=~*p; *p = *p++ << 1;
                 if(*p & 128) *p=~*p; *p = *p++ << 1;
                 if(*p & 128) *p=~*p; *p = *p++ << 1;
         		}
      		}
        }
    if (fx==1) wormhole(&my_wor1, buffer, image, (int) y_pos, (int) x_pos);
    if (fx==2) wormhole(&my_wor2, buffer, image, (int) y_pos, (int) x_pos);
    if (fx==3) texture(&my_text, buffer, image, fps);
	if (fx==4) do_fire(&my_fire, buffer, image, use_image, fps);

    if (key[KEY_F]) textprintf(buffer, font, 0, 0, 255, "fps: %f", fps);
	if (key[KEY_ENTER] && !dialog) dialog=1;

	if (key[KEY_1]) fx1_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_2])	fx2_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_3])	fx3_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_4])	fx4_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_5])	fx5_proc(MSG_CLICK, &dummy, 0);

	if (key[KEY_V])	vsync_proc(MSG_CLICK, &dummy, 0);

	if (key[KEY_T])	local_texture_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_Y]) loaded_texture_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_U])	no_texture_proc(MSG_CLICK, &dummy, 0);

	if (key[KEY_P])	local_palette_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_OPENBRACE])	loaded_palette_proc(MSG_CLICK, &dummy, 0);

	if (key[KEY_J])	anim_hue_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_K]) anim_saturation_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_L])	anim_value_proc(MSG_CLICK, &dummy, 0);

	if (key[KEY_F1]) res1_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F2]) res2_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F3]) res3_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F4]) res4_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F5]) res5_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F6]) res6_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F7]) res7_proc(MSG_CLICK, &dummy, 0);
	if (key[KEY_F12]) set_res_proc(MSG_CLICK, &dummy, 0);

    if (dialog)
		{
		 screen_bk=screen;
		 screen=buffer;
		 dialog_message(MDK30_Dialog, MSG_DRAW, 0, &obj);
		 update_dialog(dplayer);
		 screen=screen_bk;

		 show_mouse(buffer);
		}

    if (use_vsync) vsync();
	blit(buffer, screen, 1, 0, 0, 0, w, h);
   }

 uninit();
 return 0;
}
