#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"

#include "fire.h"


int init_fire(fire *f, int w, int h)
{
 int c;

 f->w=w;
 f->h=h;

 f->buf=create_bitmap(w, h);
 clear(f->buf);

 for (c=0; c<FIRE_HOTSPOTS; c++)
      f->hotspot[c] = random() % w;

 return 0;
}
//---------------------------------------------------------------------------
void draw_bottom_line_of_fire(fire *f)
{
   int c, c2;
   unsigned char temp[1280];
   unsigned char *p;
   int w, h;

   w=f->w;
   h=f->h;
   /* zero the buffer */
   for (c=0; c<w; c++)
      temp[c] = 0;

   for (c=0; c<FIRE_HOTSPOTS; c++) { 
      /* display the hotspots */
      for (c2=f->hotspot[c]-36; c2<f->hotspot[c]+36; c2++)
	 if ((c2 >= 0) && (c2 < w))
	    temp[c2] = MIN(temp[c2] + 36-ABS(f->hotspot[c]-c2), 192);

      /* move the hotspots */
      f->hotspot[c] += (random() & 7) - 3;
      if (f->hotspot[c] < 0)
	 f->hotspot[c] += w;
      else
	 if (f->hotspot[c] >= w)
	    f->hotspot[c] -= w;
   }

   p=f->buf->line[h-1];
   /* display the buffer */
   for (c=0; c<w; c++) p[c]=temp[c];
}
//----------------------------------------------------------------------------
void do_fire(fire *f, BITMAP *buf, BITMAP *backpic, int backon, double fps)
{
   int x, y, w, h, top;
   unsigned char *p, *e, *q, *q1, *b;
   static float step;

   w=f->w; h=f->h;
   top=MAX(h-256, 0);
   step+=fps/40.0;
   if (step<1) return;
   step=0;

   draw_bottom_line_of_fire(f);

   rectfill(buf, 0, 0, w, top, 0);

   for (y=top; y<h; y++)
  	{
	 p=(unsigned char *)buf->line[y];
	 e=p+w;
	 q=(unsigned char *)f->buf->line[y-1];
	 q1=(unsigned char *)f->buf->line[y];

	 if (!backon)
	   	{
		 for (;p<e;p++, q++, q1++)
	   		{
    		 if (*q1>0) *q=*q1-1;
//    		 else *q=0;
    
    		 *p=*q;
    		}
        }
     else
	   	{
		 b=(unsigned char *)backpic->line[y];
		 for (;p<e;p++, q++, q1++, b++)
		   	{
			 if (*q1>0) *q=*q1-1;
//			 else *q=0;

			 *p= (*q)*(*b)>>8;
			}
        }
    }
}
