/* WORM.C - generates a real-time wormhole

   This is the header file and must be included in any file using worm.c
   ie #include "worm.h"

   You must also of course include the file worm.c (or worm.o) in your
   compilation command line.
   ie gcc -o myprog.exe myprog.c worm.o -lalleg -s -O3 -ffast-math etc

   There are two types of wormholes featured with this - a spiral one and
   a normal one. Call the function init_worm to initialize a single one,
   defined as -
      void init_worm(worm *the_worm, int w, int h, float cone_z, int m,
                     int type);
   The parameters should be a worm structure, the width and height you will
   be using (width as mutiple of 16), 1000.0 for cone_z (play around with it
   later), 500 for m (again, play around with this later - if it is too high
   the initialization will be needlessly slow, if too low it will miss pixels
   and this will be obvious when running the program). The type should be
   either WORM_NORMAL or WORM_SPIRAL.
   If you wish to use both a normal type and a spiral type in your program,
   call init_two_worms with two worm structures and no type.

   Then for each frame call wormhole with the worm structure you have just
   initialized, the output bitmap of size w * h, a background picture of
   dimensions 256 x 512, with the second 256 rows a copy of the first, and
   the y & x positions. Change the y & x positions to generate movement with
   the wormhole. To create a background picture, use my stilplas module to
   create a still cloud type plasma (use the seamless option) of size 256 x
   256, and then create a 256 x 512 bitmap and blit the plasma onto it at
   positions (0, 0) and (0, 256).

   The wormhole_lines function is the same as wormhole except it expects a
   256 x 2 back, with the second row an identical copy of the first. Try
   using this with the row being a row chosen at random out of the plasma.

   Why do I make things complicated by requiring the background to be
   256 x 512 size with the bottom half being a copy of the top half?
   The answer is speed... for the same reason that the width must be a
   mutiple of 16.

   Requires - DJGPP, Allegro.
   Created by Michael Bevin, 1998.
   Please use but give credit.
*/

#define WORM_NORMAL 0
#define WORM_SPIRAL 1

typedef struct worm {
   int width, height;
   unsigned char *table1, *table2;
} worm;

void wormhole(worm *the_worm, BITMAP *buff, BITMAP *back, int y_pos, int x_pos);
void wormhole_lines(worm *the_worm, BITMAP *buff, BITMAP *back, int y_pos, int x_pos);

void init_worm(worm *the_worm, int w, int h, float cone_z, int m, int type);
void init_two_worms(worm *the_worm1, worm *the_worm2, int w, int h, float cone_z, int m);

