#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <float.h>
#include <math.h>

#include "worm.h"

// assumes back is 256 x 512, with second 256 x 256 copy of 1st

void wormhole(worm *the_worm, BITMAP *buff, BITMAP *back, int y_pos, int x_pos)
{
   unsigned short *p, *p1, y;
   unsigned char *q, *r, x, a, b, wi;

   p = (unsigned short *) the_worm->table1;
   a = y_pos; b = x_pos;
   q = &back->line[a][b];
   wi = the_worm->width / 16;

   for(y=0;y<the_worm->height;y++) {
      r = &buff->line[y][0];
      p1 = &p[y*the_worm->width];
      for(x=0;x<wi;x++) {
         *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++); *r++ = *(q + *p1++);
      }
   }
}


// assumes back is 256 x 2, with second row a copy of first

void wormhole_lines(worm *the_worm, BITMAP *buff, BITMAP *back, int y_pos, int x_pos)
{
   unsigned short y;
   unsigned char *q, *r, *p1, x, b, wo16;

   b = x_pos;
   q = &back->line[0][0] + b;
   wo16 = the_worm->width / 16;

   p1 = the_worm->table2;

   for(y=0;y<the_worm->height;y++) {
      r = &buff->line[y][0];
      for(x=0;x<wo16;x++) {
         *r++ = *(q + *p1++); *r++ = *(q + *p1++);  *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++);  *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++);  *r++ = *(q + *p1++); *r++ = *(q + *p1++);
         *r++ = *(q + *p1++); *r++ = *(q + *p1++);  *r++ = *(q + *p1++); *r++ = *(q + *p1++);
      }
   }
}

// a routine i ripped from somewhere, hacked heaps, increasing its speed quite
// significantly, my favourite speed increase being a method of halving the
// time using a form of symmetry

void init_worm(worm *the_worm, int w, int h, float cone_z, int m, int type)
{
   unsigned short *p, ty256;
   float step, x, y, theta, phi, t1, cxt1, cyt1, cone_y, cone_x;
   unsigned char tx, ty, spirdeg;
   short sx, sy, w1, h1, tsy, tsx;
   const float t360 = 360 * 0.01745329 / 100.0;
   int syw;

   the_worm->width  = w;
   the_worm->height = h;
   the_worm->table1 = malloc(w * h * 4);

   cone_x = (215.0 * w) / 320;
   cone_y = (150.0 * h) / 200;
   spirdeg = 1;

   p = (unsigned short *) the_worm->table1;
   w1 = w/2; h1 = h/2;

   for(y=1200.0; y>0; y-=step) {
      phi=y/100.0;
      step=0.065 *(200.0/m) +(0.4*phi *(200.0/m) );

      ty      = phi * 256.0;
      ty256   = ty * 256;
      if(type == WORM_SPIRAL) ty256 = ty256 - ty * spirdeg;

      t1 = 150/(cone_z*phi+150);
      cxt1 = t1 * cone_x;
      cyt1 = t1 * cone_y;

      for(x=100.0; x>75.0; x-=step) {
         theta  = x * t360;

         tsy=cyt1*sin(theta);
         sy = h1 + tsy;

         if(sy < h && sy >= 0) {
            tsx=cxt1*cos(theta);
            sx = w1 + tsx;
            if(sx < w && sx >= 0) {
               syw = sy * w;

               // 1st quadrant
               tx = x * 256.0 / 100.0;
               p[syw+sx] = ty256+tx;

               // 2nd quadrant
               tx = (150.0 - x) * 256.0 / 100.0;
               sx = w1 - tsx;
               p[syw+sx] = ty256+tx;

               // 3rd quadrant
               tx = (x - 50.0) * 256.0 / 100.0;
               syw = (h1 - tsy)*w;
               p[syw+sx] = ty256+tx;

               // 4th quadrant
               tx = (100.0 - x) * 256.0 / 100.0;
               sx = w1 + tsx;
               p[syw+sx] = ty256+tx;
            }
         }
      }
   }
}

void init_two_worms(worm *the_worm1, worm *the_worm2, int w, int h, float cone_z, int m)
{
   unsigned short *p, *q, ty256, tz256;
   float step, x, y, theta, phi, t1, cxt1, cyt1, cone_y, cone_x;
   unsigned char tx, ty, spirdeg;
   short sx, sy, w1, h1, tsy, tsx;
   const float t360 = 360 * 0.01745329 / 100.0;
   int syw;

   the_worm1->width  = w;
   the_worm1->height = h;
   the_worm1->table1 = malloc(w * h * 4);
   the_worm2->width  = w;
   the_worm2->height = h;
   the_worm2->table1 = malloc(w * h * 4);

   cone_x = (215.0 * w) / 320;
   cone_y = (150.0 * h) / 200;
   spirdeg = 1;

   p = (unsigned short *) the_worm1->table1;
   q = (unsigned short *) the_worm2->table1;
   w1 = w/2; h1 = h/2;

   for(y=1200.0; y>0; y-=step) {
      phi=y/100.0;
      step=0.065 *(200.0/m) +(0.4*phi *(200.0/m) );

      ty     = phi * 256.0;
      ty256  = ty * 256;
      tz256  = ty256 - ty * spirdeg;

      t1 = 150/(cone_z*phi+150);
      cxt1 = t1 * cone_x;
      cyt1 = t1 * cone_y;

      for(x=100.0; x>75.0; x-=step) {
         theta  = x * t360;

         tsy=cyt1*sin(theta);
         sy = h1 + tsy;

         if(sy < h && sy >= 0) {
            tsx=cxt1*cos(theta);
            sx = w1 + tsx;
            if(sx < w && sx >= 0) {
               syw = sy * w;

               // 1st quadrant
               tx = x * 256.0 / 100.0;
               p[syw+sx] = ty256+tx; q[syw+sx] = tz256+tx;

               // 2nd quadrant
               tx = (150.0 - x) * 256.0 / 100.0;
               sx = w1 - tsx;
               p[syw+sx] = ty256+tx; q[syw+sx] = tz256+tx;

               // 3rd quadrant
               tx = (x - 50.0) * 256.0 / 100.0;
               syw = (h1 - tsy)*w;
               p[syw+sx] = ty256+tx; q[syw+sx] = tz256+tx;

               // 4th quadrant
               tx = (100.0 - x) * 256.0 / 100.0;
               sx = w1 + tsx;
               p[syw+sx] = ty256+tx; q[syw+sx] = tz256+tx;
            }
         }
      }
   }
}

