/* MOVEPLAS.C - generates a real-time moving plasma

   This is the header file and must be included in any file using moveplas.c
   ie #include "moveplas.h"

   You must also of course include the file moveplas.c (or moveplas.o) in
   your compilation command line.
   ie gcc -o myprog.exe myprog.c moveplas.o -lalleg -s -O3 -ffast-math etc

   Call function init_plas(plas *the_plas, int width, int height, int range)
   with a plas structure, the width and height, and the range (set to 4 and
   play around with later, it defines how varied the output colour is). The
   width must be a multiple of 16 (this allows it to run real fast, and all
   normal screen modes ie width 320, 400, 640, 800, 1024 divide into it).

   Then for each frame call function plasma, defined as -
      void plasma (plas *the_plas, BITMAP *buffer, BITMAP *backpic,
                   int backon, double fps);
   The plas structure should be the one you used with init_plas, as init_plas
   will have set it up appropriately. Buffer is the output bitmap and backpic
   is an optional background picture, and is only used if backon is set (both
   bitmaps should be of dimensions width * height). Fps should be the current
   frames rate your program is running at - to be used so that the plasma can
   move the appropriate amount per frame.

   Requires - DJGPP, Allegro.
   Created by Michael Bevin, 1998.
   Please use but give credit.
*/


typedef struct plas {
   unsigned char *table1, *table2;
   int width, height, type;
   float circle1,circle2,circle3,circle4,circle5,circle6,circle7,circle8, roll;
} plas;

void init_plas (plas *the_plas, int width, int height, int range);
void plasma (plas *the_plas, BITMAP *buffer, BITMAP *backpic, int backon, double fps);
