#include <stdio.h>
#include "error.h"
#include "inicreat.h"


// ==========================================================================
// create a new ds1edit.ini
void ini_create(char * ininame)
{
   FILE * out;
   char tmp[80];

   printf("can't open %s, creating it\n", ininame);
   out = fopen(ininame, "wt");
   if (out == NULL)
   {
      sprintf(tmp, "can't create %s", ininame);
      ds1edit_error(tmp);
   }
   fputs(
      "; Paths to the mpqs. When the editor need to read a file from a mpq\n"
      "; it scan first in mod_dir. If not found, in patch_d2. If not found,\n"
      "; in d2exp. If again not found, in d2data (just like the game)\n"
      "; =================================================================\n"
      "d2char   = c:\\program files\\diablo II\\d2char.mpq\n"
      "d2data   = c:\\program files\\diablo II\\d2data.mpq\n"
      "d2exp    = c:\\program files\\diablo II\\d2exp.mpq\n"
      "patch_d2 = c:\\program files\\diablo II\\patch_d2.mpq\n"
      "mod_dir  =\n"
      "\n"
      "; if you don't have a mpq, put a blank, like :\n"
      "; d2exp =\n"
      "\n"
      "; mod_dir is an optional Mod Directory, like :\n"
      "; mod_dir = c:\\program files\\diablo II\\mods\\my_mod\n"
      "\n"
      "\n"
      "; screen configuration\n"
      "; screen_depth can be either 8, 15, 16, 24 or 32 bits per pixel\n"
      ";    (if your video card support it)\n"
      "; if full_screen is not set to YES, it'll be a windowed screen\n"
      ";    (will always fail under MS-DOS)\n"
      "; =============================================================\n"
      "full_screen   = YES\n"
      "screen_width  = 800\n"
      "screen_height = 600\n"
      "screen_depth  = 8\n"
      "\n"
      "\n"
      "; Try to use this refresh rate, if possible. Not all drivers are able to\n"
      "; control this at all, and even when they can, not all rates will be\n"
      "; possible on all hardware, so the actual settings may differ from what\n"
      "; you requested. Some non-exhaustive values : 60, 70, 72, 75, 85, 100, 120\n"
      "; ========================================================================\n"
      "refresh_rate = 60\n"
      "\n"
      "\n"
      "; speed of scrolls, in pixels\n"
      "; ===========================\n"
      "keyb_scroll_x  = 40\n"
      "keyb_scroll_y  = 20\n"
      "mouse_scroll_x = 20\n"
      "mouse_scroll_y = 10\n"
      "edit_scroll_x  = 20\n"
      "edit_scroll_y  = 20\n"
      "\n"
      "\n"
      "; speed of scroll in the Object Editing window, in rows\n"
      "; =====================================================\n"
      "obj_edit_scroll = 2\n"
      "\n"
      "\n"
      "; speed of mouse, larger values slow the mouse, defaut 2\n"
      "; (don't seem to work under Windows XP)\n"
      "; ======================================================\n"
      "mouse_speed_x = 2\n"
      "mouse_speed_y = 2\n"
      "\n"
      "\n"
      "\n"
      "; misc options\n"
      "; ============\n"
      "\n"
      "\n"
      "; default gamma correction\n"
      "; valid value : 0.60, 0.62, [...] 0.98, 1.00, 1.10, 1.20, [...], 3.00\n"
      "; -------------------------------------------------------------------\n"
      "gamma_correction = 1.30\n"
      "\n"
      "\n"
      "; does the editor allow you to use Type 2 objects of higher act ?\n"
      "; if this line is NOT set to YES, the editor will allow it\n"
      "; ---------------------------------------------------------------\n"
      "only_normal_type2 = YES\n"
      "\n"
      "\n"
      "; does the editor always modified the ds1 to have 2 floors layers and\n"
      "; 4 walls layers ?\n"
      "; if this line is NOT set to YES, the editor won't make any change\n"
      "; -------------------------------------------------------------------\n"
      "always_max_layers = YES\n"
      "\n"
      "\n"
      "; resize the sprites when zooming\n"
      "; -------------------------------\n"
      "stretch_sprite = YES\n"
      "\n"
      "\n"
      "; when editing an object, posibility to scroll the main tile editing window\n"
      "; with the arrow keys\n"
      "; -------------------------------------------------------------------------\n"
      "winobj_can_scroll_keyb = YES\n"
      "\n"
      "\n"
      "; when editing an object, posibility to scroll the main tile editing window\n"
      "; with the mouse on the border of the screen\n"
      "; -------------------------------------------------------------------------\n"
      "winobj_can_scroll_mouse = NO\n"
      "\n"
      "\n"
      "; after a Centering (with the 'C' key), wich zoom ?\n"
      "; possible values : NO_CHANGE, 1:1, 1:2, 1:4, 1:8, 1:16\n"
      "; -----------------------------------------------------\n"
      "center_zoom = 1:1\n"
      "\n"
      "\n"
      "; What are the sizes of object tables in DLL for type 1 and 2 ?\n"
      "; normal values are :\n"
      ";    *  60 entries per act for type 1 objects\n"
      ";    * 150 entries per act for type 2 objects\n"
      "; You shouldn't change these values unless you have a modified DLL\n"
      "; ----------------------------------------------------------------\n"
      "nb_type1_per_act = 60\n"
      "nb_type2_per_act = 150\n"
      "\n"
      "\n"
      "; minimize file size of saved ds1 ?\n"
      "; ---------------------------------\n"
      "ds1_saved_minimize = YES\n"
      "\n"
      "\n"
      "; reduce scrolling speed when zooming out ?\n"
      "; -----------------------------------------\n"
      "lower_speed_zoom_out = NO\n"
      "\n"
      "\n"
      "; enable the workspace feature ?\n"
      "; ------------------------------\n"
      "workspace_enable = YES\n"
      , out
   );

   fclose(out);
   printf("new ds1edit.ini was created\n");
   fprintf(stderr, "new ds1edit.ini was created\n");
}
