/*
   TODO list
   =========


   DONE list since last version :
   ==============================
   * MOVE tiles (cut / paste)
        - CTRL + X no longer delete tiles : now it's DEL and DEL of KEYPAD keys
        - now CTRL + X 'cut' and paste tiles

   * to be consistent, CTRL+X is replace by DEL in Object mode too

*/

#include "structs.h"
#include "error.h"
#include "mpq/mpqview.h"
#include "dt1misc.h"
#include "ds1misc.h"
#include "anim.h"
#include "wEdit.h"
#include "undo.h"
#include "txtread.h"
#include "misc.h"
#include "inicreat.h"
#include "iniread.h"
#include "animdata.h"
#include "interfac.h"

// for mkdir()
#ifdef DJGPP
#include <sys/stat.h>
#endif

#define DS1EDIT_BUILD    "2006/03/05"
#define DS1EDIT_GOOD_DLL "Allegro 4.0.3, MSVC"
#define DS1EDIT_DLL_LINK "http://paul.siramy.free.fr/_divers/ds1/alleg403.zip"


WRKSPC_DATAS_S wrkspc_datas[WRKSPC_MAX] = // workspace datas saved in .ds1
{
   {{"DS1EDIT_WRKSPC_TILE_X"}},
   {{"DS1EDIT_WRKSPC_TILE_Y"}},
   {{"DS1EDIT_WRKSPC_ZOOM"}},
   {{"DS1EDIT_VERSION"}},
   {{"DS1EDIT_SAVE_COUNT"}}
};

GAMMA_S gamma_str[GC_MAX] = // gamma correction string table
{
   {"0.60", GC_060}, {"0.62", GC_062}, {"0.64", GC_064},
   {"0.66", GC_066}, {"0.68", GC_068}, {"0.70", GC_070},
   {"0.72", GC_072}, {"0.74", GC_074}, {"0.76", GC_076},
   {"0.78", GC_078}, {"0.80", GC_080}, {"0.82", GC_082},
   {"0.84", GC_084}, {"0.86", GC_086}, {"0.88", GC_088},
   {"0.90", GC_090}, {"0.92", GC_092}, {"0.94", GC_094},
   {"0.96", GC_096}, {"0.98", GC_098}, {"1.00", GC_100},
   {"1.10", GC_110}, {"1.20", GC_120}, {"1.30", GC_130},
   {"1.40", GC_140}, {"1.50", GC_150}, {"1.60", GC_160},
   {"1.70", GC_170}, {"1.80", GC_180}, {"1.90", GC_190},
   {"2.00", GC_200}, {"2.10", GC_210}, {"2.20", GC_220},
   {"2.30", GC_230}, {"2.40", GC_240}, {"2.50", GC_250},
   {"2.60", GC_260}, {"2.70", GC_270}, {"2.80", GC_280},
   {"2.90", GC_290}, {"3.00", GC_300}
};

char * txt_def_lvltype_req[] = 
{
   {"Id"},      {"Act"},
   {"File 1"},  {"File 2"},  {"File 3"},  {"File 4"},  {"File 5"},
   {"File 6"},  {"File 7"},  {"File 8"},  {"File 9"},  {"File 10"},
   {"File 11"}, {"File 12"}, {"File 13"}, {"File 14"}, {"File 15"},
   {"File 16"}, {"File 17"}, {"File 18"}, {"File 19"}, {"File 20"},
   {"File 21"}, {"File 22"}, {"File 23"}, {"File 24"}, {"File 25"},
   {"File 26"}, {"File 27"}, {"File 28"}, {"File 29"}, {"File 30"},
   {"File 31"}, {"File 32"},
   NULL // DO NOT REMOVE !
};

char * txt_def_lvlprest_req[] =
{
   {"Def"},   {"Dt1Mask"},
   {"File1"}, {"File2"}, {"File3"}, {"File4"}, {"File5"}, {"File6"},
   NULL // DO NOT REMOVE !
};
        
char * txt_def_obj_req[] =
{
   // number
   {"Act"},
   {"Type"},
   {"Id"},
   {"Direction"},
   {"Index"},
   {"Objects.txt_ID"},
   {"Monstats.txt_ID"},

   // text
   {"Base"},
   {"Token"},
   {"Mode"},
   {"Class"},
   {"HD"}, {"TR"}, {"LG"}, {"RA"}, {"LA"}, {"RH"}, {"LH"}, {"SH"},
   {"S1"}, {"S2"}, {"S3"}, {"S4"}, {"S5"}, {"S6"}, {"S7"}, {"S8"},
   {"Colormap"},
   {"Description"},

   NULL // DO NOT REMOVE !
};

char * txt_def_objects_req[] =
{
   // number
   {"Id"},
   {"SizeX"},
   {"SizeY"},
   {"FrameCnt0"},
   {"FrameCnt1"},
   {"FrameCnt2"},
   {"FrameCnt3"},
   {"FrameCnt4"},
   {"FrameCnt5"},
   {"FrameCnt6"},
   {"FrameCnt7"},
   {"FrameDelta0"},
   {"FrameDelta1"},
   {"FrameDelta2"},
   {"FrameDelta3"},
   {"FrameDelta4"},
   {"FrameDelta5"},
   {"FrameDelta6"},
   {"FrameDelta7"},
   {"CycleAnim0"},
   {"CycleAnim1"},
   {"CycleAnim2"},
   {"CycleAnim3"},
   {"CycleAnim4"},
   {"CycleAnim5"},
   {"CycleAnim6"},
   {"CycleAnim7"},
   {"Lit0"},
   {"Lit1"},
   {"Lit2"},
   {"Lit3"},
   {"Lit4"},
   {"Lit5"},
   {"Lit6"},
   {"Lit7"},
   {"BlocksLight0"},
   {"BlocksLight1"},
   {"BlocksLight2"},
   {"BlocksLight3"},
   {"BlocksLight4"},
   {"BlocksLight5"},
   {"BlocksLight6"},
   {"BlocksLight7"},
   {"Start0"},
   {"Start1"},
   {"Start2"},
   {"Start3"},
   {"Start4"},
   {"Start5"},
   {"Start6"},
   {"Start7"},
   {"BlocksVis"},
   {"Trans"},
   {"OrderFlag0"},
   {"OrderFlag1"},
   {"OrderFlag2"},
   {"OrderFlag3"},
   {"OrderFlag4"},
   {"OrderFlag5"},
   {"OrderFlag6"},
   {"OrderFlag7"},
   {"Mode0"},
   {"Mode1"},
   {"Mode2"},
   {"Mode3"},
   {"Mode4"},
   {"Mode5"},
   {"Mode6"},
   {"Mode7"},
   {"Yoffset"},
   {"Xoffset"},
   {"Draw"},
   {"Red"},
   {"Green"},
   {"Blue"},
   {"TotalPieces"},
   {"SubClass"},
   {"Xspace"},
   {"YSpace"},
   {"OperateRange"},
   {"Act"},
   {"Sync"},
   {"Flicker"},
   {"Overlay"},
   {"CollisionSubst"},
   {"Left"},
   {"Top"},
   {"Width"},
   {"Height"},
   {"BlockMissile"},
   {"DrawUnder"},
   {"HD"}, {"TR"}, {"LG"}, {"RA"}, {"LA"}, {"RH"}, {"LH"}, {"SH"},
   {"S1"}, {"S2"}, {"S3"}, {"S4"}, {"S5"}, {"S6"}, {"S7"}, {"S8"},

   // text
   {"Token"},

   NULL // DO NOT REMOVE !
};

char ** txt_req_ptr[RQ_MAX] = {NULL, NULL, NULL, NULL};
       
CONFIG_S      config;                       // global configuration datas
GLB_DS1EDIT_S glb_ds1edit;                  // global datas of the editor
GLB_MPQ_S     glb_mpq_struct[MAX_MPQ_FILE]; // global data of 1 mpq
DS1_S         * ds1;                        // ds1 datas
DT1_S         * dt1;                        // dt1 datas
char          tiles_path[30]       = "Data\\Global\\Tiles\\";
char          ds1edit_data_dir[80] = "Data\\";
char          ds1edit_tmp_dir[80]  = "Tmp\\";


// ==========================================================================
// near the start of the prog
void ds1edit_init(void)
{
   FILE * out;
   static struct
   {
      char   name[40];
      MODE_E idx;
   } cursor[MOD_MAX] = {
        {"pcx\\cursor_t.pcx", MOD_T}, // tiles
        {"pcx\\cursor_o.pcx", MOD_O}, // objects
        {"pcx\\cursor_p.pcx", MOD_P}, // paths
        {"pcx\\cursor_l.pcx", MOD_L}  // lights
     };
   int  i, o;
   static int
        dir4[4]   = { 0,  1,  2,  3},
        dir8[8]   = { 4,  0,  5,  1,  6,  2,  7,  3},

        dir16[16] = { 4,  8,  0,  9,  5, 10,  1, 11,
                      6, 12,  2, 13,  7, 14,  3, 15},

        dir32[32] = { 4, 16,  8, 17,  0, 18,  9, 19,
                      5, 20, 10, 21,  1, 22, 11, 23,
                      6, 24, 12, 25,  2, 26, 13, 27,
                      7, 28, 14, 29,  3, 30, 15, 31},

        obj_sub_tile[5][5] = {
           { 0,  2,  5,  9, 14},
           { 1,  4,  8, 13, 18},
           { 3,  7, 12, 17, 21},
           { 6, 11, 16, 20, 23},
           {10, 15, 19, 22, 24}
        };
   char tmp[80];


   // zero mem
   printf("ds1edit_init()\n");
   memset(&config,      0, sizeof(config));
   memset(&glb_ds1edit, 0, sizeof(glb_ds1edit));

   // allocate mem for DT1 & DS1
   i = sizeof(DS1_S) * DS1_MAX;
   printf("\nallocate %i bytes for ds1[%i]\n", i, DS1_MAX);
   ds1 = (DS1_S *) malloc(i);
   if (ds1 == NULL)
   {
      sprintf(tmp, "ds1edit_init() can't allocate %i bytes for ds1[%i]", i, DS1_MAX);
      ds1edit_error(tmp);
   }
   memset(ds1, 0, i);

   i = sizeof(DT1_S) * DT1_MAX;
   printf("allocate %i bytes for dt1[%i]\n\n", i, DT1_MAX);
   dt1 = (DT1_S *) malloc(i);
   if (dt1 == NULL)
   {
      sprintf(tmp, "ds1edit_init() can't allocate %i bytes for dt1[%i]", i, DT1_MAX);
      ds1edit_error(tmp);
   }
   memset(dt1, 0, i);

   // set the version
   glb_ds1edit.version_build = DS1EDIT_BUILD;
   glb_ds1edit.version_dll = DS1EDIT_GOOD_DLL;
   strcpy(glb_ds1edit.version, DS1EDIT_BUILD);
   printf(".exe version : ");
#ifdef DJGPP
   printf("DJGPP");
#else
   printf("VC6");
#endif
   printf(", date YYYY/MM/DD = %s\n", glb_ds1edit.version);

   // update the version info on disk
   sprintf(tmp, "%sversion", ds1edit_data_dir);
   out = fopen(tmp, "wb");
   if (out != NULL)
   {
      sprintf(tmp, "YYYY/MM/DD = %s", glb_ds1edit.version);
      fwrite(tmp, strlen(tmp), 1, out);
      fclose(out);
   }

   for (i=0; i<MAX_MPQ_FILE; i++)
   {
      memset( & glb_mpq_struct[i], 0, sizeof(GLB_MPQ_S));
      glb_mpq_struct[i].is_open = FALSE;
   }

   // mouse cursors
   glb_ds1edit.mouse_cursor_width  = -1;
   glb_ds1edit.mouse_cursor_height = -1;
   for (i=0; i<MOD_MAX; i++)
   {
      glb_ds1edit.mouse_cursor[i] =
         load_pcx(cursor[i].name, glb_ds1edit.dummy_pal);
      if (glb_ds1edit.mouse_cursor[i] == NULL)
      {
         sprintf(tmp, "ds1edit_init() can't open %s", cursor[i].name);
         ds1edit_error(tmp);
      }
      else
      {
         // max width
         if (glb_ds1edit.mouse_cursor[i]->w > glb_ds1edit.mouse_cursor_width)
            glb_ds1edit.mouse_cursor_width = glb_ds1edit.mouse_cursor[i]->w;

         // max height
         if (glb_ds1edit.mouse_cursor[i]->h > glb_ds1edit.mouse_cursor_height)
            glb_ds1edit.mouse_cursor_height = glb_ds1edit.mouse_cursor[i]->h;
      }
   }
   glb_ds1edit.mouse_cursor_background =
      create_bitmap(glb_ds1edit.mouse_cursor_width, glb_ds1edit.mouse_cursor_height);
   if (glb_ds1edit.mouse_cursor_background == NULL)
   {
      sprintf(tmp, "ds1edit_init() can't make mouse_cursor_background (%i * %i)",
         glb_ds1edit.mouse_cursor_width, glb_ds1edit.mouse_cursor_height);
      ds1edit_error(tmp);
   }
   clear(glb_ds1edit.mouse_cursor_background);

   // txt
   txt_req_ptr[RQ_LVLTYPE]  = txt_def_lvltype_req;
   txt_req_ptr[RQ_LVLPREST] = txt_def_lvlprest_req;
   txt_req_ptr[RQ_OBJ]      = txt_def_obj_req;
   txt_req_ptr[RQ_OBJECTS]  = txt_def_objects_req;
   remove("lvltypes.mem");
   remove("lvltypes.def");
   remove("lvlprest.mem");
   remove("lvlprest.def");
   remove("obj.mem");
   remove("obj.def");
   remove("objects.mem");
   remove("objects.def");

   // tables
   glb_ds1edit.new_dir1[0] = 0;

   for (i=0; i < 4; i++)
      glb_ds1edit.new_dir4[i] = dir4[i];

   for (i=0; i < 8; i++)
      glb_ds1edit.new_dir8[i] = dir8[i];
   
   for (i=0; i < 16; i++)
      glb_ds1edit.new_dir16[i] = dir16[i];

   for (i=0; i < 32; i++)
      glb_ds1edit.new_dir32[i] = dir32[i];

   // for re-ordering sub-tile objects, from back to front
   for (i=0; i < 5; i++)
      for (o=0; o < 5; o++)
         glb_ds1edit.obj_sub_tile_order[i][o] = obj_sub_tile[i][o];

   // init the default values of the command line
   glb_ds1edit.cmd_line.ds1_filename  = NULL;
   glb_ds1edit.cmd_line.ini_filename  = NULL;
   glb_ds1edit.cmd_line.lvltype_id    = -1;
   glb_ds1edit.cmd_line.lvlprest_def  = -1;
   glb_ds1edit.cmd_line.resize_width  = -1;
   glb_ds1edit.cmd_line.resize_height = -1;
   glb_ds1edit.cmd_line.force_pal_num = -1;
   glb_ds1edit.cmd_line.no_check_act  = FALSE;
   glb_ds1edit.cmd_line.dt1_list_num  = -1;
   for (i=0; i < DT1_IN_DS1_MAX; i++)
      glb_ds1edit.cmd_line.dt1_list_filename[i] = NULL;

   // 2nd row of infos
   glb_ds1edit.show_2nd_row = FALSE;
}


// ==========================================================================
// automatically called at the end, with the help of atexit()
void ds1edit_exit(void)
{
   int i, z, b, total=0;
   

   printf("\nds1edit_exit()\n");

   // close all mpq
   for (i=0; i<MAX_MPQ_FILE; i++)
   {
      if (glb_mpq_struct[i].is_open != FALSE)
      {
         fprintf(stderr, "closing %s\n", glb_mpq_struct[i].file_name);
         fflush(stderr);

         glb_mpq = & glb_mpq_struct[i];
         mpq_batch_close();
         
         memset( & glb_mpq_struct[i], 0, sizeof(GLB_MPQ_S));
         glb_mpq_struct[i].is_open = FALSE;
      }
   }
   
   // free all mem
   fprintf(stderr, "exit, memory free :\n");
   fflush(stderr);

   // mouse cursor
   fprintf(stderr, "   * mouse cursor...\n");
   fflush(stderr);
   show_mouse(NULL);
   set_mouse_sprite(NULL);
   for (i=0; i<MOD_MAX; i++)
   {
      if (glb_ds1edit.mouse_cursor[i] != NULL)
      {
         destroy_bitmap(glb_ds1edit.mouse_cursor[i]);
         glb_ds1edit.mouse_cursor[i] = NULL;
      }
   }
   if (glb_ds1edit.mouse_cursor_background != NULL)
      destroy_bitmap(glb_ds1edit.mouse_cursor_background);
      
   // screen buffer
   fprintf(stderr, "   * screen buffer...\n");
   fflush(stderr);
   if (glb_ds1edit.screen_buff != NULL)
      destroy_bitmap(glb_ds1edit.screen_buff);

   if (glb_ds1edit.big_screen_buff != NULL)
      destroy_bitmap(glb_ds1edit.big_screen_buff);
   
   // config, mpq name
   fprintf(stderr, "   * config, mpq names...\n");
   fflush(stderr);
   for (i=0; i<MAX_MPQ_FILE; i++)
   {
      if(config.mpq_file[i] != NULL)
      {
         total += strlen(config.mpq_file[i]);
         free(config.mpq_file[i]);
      }
   }

   // config, mod directory
   fprintf(stderr, "   * config, mod directory name...\n");
   fflush(stderr);
   for (i=0; i<MAX_MOD_DIR; i++)
   {
      if(config.mod_dir[i] != NULL)
      {
         total += strlen(config.mod_dir[i]);
         free(config.mod_dir[i]);
      }
   }

   // palettes
   fprintf(stderr, "   * palettes...\n");
   fflush(stderr);
   for (i=0; i<ACT_MAX; i++)
   {
      if(glb_ds1edit.d2_pal[i] != NULL)
      {
         free(glb_ds1edit.d2_pal[i]);
         total += glb_ds1edit.pal_size[i];
         glb_ds1edit.d2_pal[i] = NULL;
         glb_ds1edit.pal_size[i] = 0;
      }
   }

   // dt1
   fprintf(stderr, "   * DT1 files...\n");
   fflush(stderr);
   for (i=0; i<DT1_MAX; i++)
      total += dt1_free(i);

   // ds1
   fprintf(stderr, "   * DS1 files...\n");
   fflush(stderr);
   for (i=0; i<DS1_MAX; i++)
      total += ds1_free(i);

   // objects descriptions
   fprintf(stderr, "   * objects descriptions...\n");
   fflush(stderr);
   if (glb_ds1edit.obj_desc != NULL)
   {
      total += anim_exit();
      free(glb_ds1edit.obj_desc);
      total += sizeof(OBJ_DESC_S) * glb_ds1edit.obj_desc_num;
      glb_ds1edit.obj_desc = NULL;
      glb_ds1edit.obj_desc_num = 0;
   }

   // buttons & tab
   fprintf(stderr, "   * buttons & tab...\n");
   fflush(stderr);
   wedit_free();

   // undo buffers
   fprintf(stderr, "   * undo buffers...\n");
   fflush(stderr);
   undo_exit();

   // walkable infos tiles
   fprintf(stderr, "   * walkable info tiles...\n");
   fflush(stderr);
   for (b=0; b<9; b++)
   {
      for (z=0; z<ZM_MAX; z++)
      {
         for (i=0; i<25; i++)
         {
            if (glb_ds1edit.subtile_flag[b][z][i] != NULL)
            {
               destroy_rle_sprite(glb_ds1edit.subtile_flag[b][z][i]);
               glb_ds1edit.subtile_flag[b][z][i] = NULL;
            }
         }
      }
      if (b == 0)
      {
         for (z=0; z<ZM_MAX; z++)
         {
            for (i=0; i<25; i++)
            {
               if (glb_ds1edit.subtile_nowalk[z][i] != NULL)
               {
                  destroy_rle_sprite(glb_ds1edit.subtile_nowalk[z][i]);
                  glb_ds1edit.subtile_nowalk[z][i] = NULL;
               }
            }
         }
         for (z=0; z<ZM_MAX; z++)
         {
            for (i=0; i<25; i++)
            {
               if (glb_ds1edit.subtile_nojump[z][i] != NULL)
               {
                  destroy_rle_sprite(glb_ds1edit.subtile_nojump[z][i]);
                  glb_ds1edit.subtile_nojump[z][i] = NULL;
               }
            }
         }
      }
   }
   if (glb_ds1edit.subtile_help != NULL)
   {
      destroy_bitmap(glb_ds1edit.subtile_help);
      glb_ds1edit.subtile_help = NULL;
   }

   // .txt buffers
   fprintf(stderr, "   * .txt buffers ...\n");
   fflush(stderr);
   if (glb_ds1edit.lvltypes_buff != NULL)
   {
      total += glb_ds1edit.lvltypes_buff->line_num *
               glb_ds1edit.lvltypes_buff->line_size;
      glb_ds1edit.lvltypes_buff = txt_destroy(glb_ds1edit.lvltypes_buff);
   }
   if (glb_ds1edit.lvlprest_buff != NULL)
   {
      total += glb_ds1edit.lvlprest_buff->line_num *
               glb_ds1edit.lvlprest_buff->line_size;
      glb_ds1edit.lvlprest_buff = txt_destroy(glb_ds1edit.lvlprest_buff);
   }
   if (glb_ds1edit.obj_buff != NULL)
   {
      total += glb_ds1edit.obj_buff->line_num *
               glb_ds1edit.obj_buff->line_size;
      glb_ds1edit.obj_buff = txt_destroy(glb_ds1edit.obj_buff);
   }

   // animdata.d2
   fprintf(stderr, "   * animdata.d2 buffer ...\n");
   fflush(stderr);
   total += glb_ds1edit.anim_data.buffer_size;
   if (glb_ds1edit.anim_data.buffer)
      free(glb_ds1edit.anim_data.buffer);

   // obj in ds1
   fprintf(stderr, "   * ds1[] & dt1[] & ds1[].obj & ds1[].obj_undo ...\n");
   fflush(stderr);

   // ds1 & dt1
   if (ds1 != NULL)
   {
      for (i=0; i < DS1_MAX; i++)
      {
         if (ds1[i].obj != NULL)
         {
            total += sizeof(OBJ_S) * OBJ_MAX;
            free(ds1[i].obj);
         }
         if (ds1[i].obj_undo != NULL)
         {
            total += sizeof(OBJ_S) * OBJ_MAX;
            free(ds1[i].obj_undo);
         }
      }
      total += sizeof(DS1_S) * DS1_MAX;
      free(ds1);
   }
   if (dt1 != NULL)
   {
      total += sizeof(DT1_S) * DT1_MAX;
      free(dt1);
   }
   
   // total
   printf("total bytes freed : %i\n", total);
   fprintf(stderr, "total bytes freed : %i\n", total);
   fflush(stderr);

   // txt debug
#ifdef _DS1EDIT_DEBUG_
   if (glb_ds1edit.txt_debug != NULL)
      fclose(glb_ds1edit.txt_debug);
#endif

}


// ==========================================================================
// just for debug purpose
void ds1edit_debug(void)
{
   printf("\n");
   printf("d2char                  = %s\n", config.mpq_file[3]);
   printf("d2data                  = %s\n", config.mpq_file[2]);
   printf("d2exp                   = %s\n", config.mpq_file[1]);
   printf("patch_d2                = %s\n", config.mpq_file[0]);
   printf("mod_dir                 = %s\n", config.mod_dir[0]);
   printf("fullscreen              = %s\n", config.fullscreen ? "YES" : "NO");
   printf("screen_width            = %i\n", config.screen.width);
   printf("screen_height           = %i\n", config.screen.height);
   printf("screen_depth            = %i\n", config.screen.depth);
   printf("refresh_rate            = %i\n", config.screen.refresh);
   printf("keyb_scroll_x           = %i\n", config.scroll.keyb.x);
   printf("keyb_scroll_y           = %i\n", config.scroll.keyb.y);
   printf("mouse_scroll_x          = %i\n", config.scroll.mouse.x);
   printf("mouse_scroll_y          = %i\n", config.scroll.mouse.y);
   printf("edit_scroll_x           = %i\n", config.scroll.edit.x);
   printf("edit_scroll_y           = %i\n", config.scroll.edit.y);   
   printf("obj_edit_scroll         = %i\n", config.scroll.obj_edit);
   printf("mouse_speed_x           = %i\n", config.mouse_speed.x);
   printf("mouse_speed_y           = %i\n", config.mouse_speed.y);
   printf("gamma_correction        = %s\n", gamma_str[config.gamma].str);
   printf("only_normal_type2       = %s\n", config.normal_type2        ? "YES" : "NO");
   printf("always_max_layers       = %s\n", config.always_max_layers   ? "YES" : "NO");
   printf("stretch_sprites         = %s\n", config.stretch_sprites     ? "YES" : "NO");
   printf("winobj_can_scroll_keyb  = %s\n", config.winobj_scroll_keyb  ? "YES" : "NO");
   printf("winobj_can_scroll_mouse = %s\n", config.winobj_scroll_mouse ? "YES" : "NO");

   printf("center_zoom             = ");
   switch(config.center_zoom)
   {
      case -1    : printf("NO_CHANGE\n"); break;
      case ZM_11 : printf("1:1\n"); break;
      case ZM_12 : printf("1:2\n"); break;
      case ZM_14 : printf("1:4\n"); break;
      case ZM_18 : printf("1:8\n"); break;
      case ZM_116: printf("1:16\n"); break;
      default : printf("?\n"); break;
   }

   printf("nb_type1_per_act        = %i\n", config.nb_type1_per_act);
   printf("nb_type2_per_act        = %i\n", config.nb_type2_per_act);
   printf("ds1_saved_minimize      = %s\n", config.minimize_ds1         ? "YES" : "NO");
   printf("lower_speed_zoom_out    = %s\n", config.lower_speed_zoom_out ? "YES" : "NO");
   printf("workspace_enable        = %s\n", config.workspace_enable     ? "YES" : "NO");
   printf("\n");
}


// ==========================================================================
// 1 tick each 1/25 of a second
void ds1edit_counter_tick(void)
{
   glb_ds1edit.ticks_elapsed++;
}
END_OF_FUNCTION(ds1edit_counter_tick);


// ==========================================================================
// 1 tick each second
void ds1edit_counter_fps(void)
{
   glb_ds1edit.old_fps = glb_ds1edit.fps;
   glb_ds1edit.fps = 0;
}
END_OF_FUNCTION(ds1edit_counter_fps);


// ==========================================================================
// open all mpq
void ds1edit_open_all_mpq(void)
{
   int  i;

   printf("ds1edit_open_all_mpq()\n");
   for (i=0; i<MAX_MPQ_FILE; i++)
   {
      if (config.mpq_file[i] != NULL)
      {
         fprintf(stdout, "opening mpq %i : %s\n", i, config.mpq_file[i]);
         fprintf(stderr, "opening %s\n", config.mpq_file[i]);
         fflush(stdout);
         fflush(stderr);
         glb_mpq = & glb_mpq_struct[i];
         mpq_batch_open(config.mpq_file[i]);
      }
   }
}


// ==========================================================================
// load palettes of the 5 acts from disk, else from mpq
void ds1edit_load_palettes(void)
{
   int  i, entry;
   char palname[80], tmp[150];
   
   fprintf(stderr, "loading palettes");
   fprintf(stdout, "\nloading palettes\n");
   fflush(stderr);
   fflush(stdout);
   
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : START\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   for (i=0; i<ACT_MAX; i++)
   {
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "\nds1edit_load_palettes() : palette of act %i\n", i+1);
   fflush(glb_ds1edit.txt_debug);
#endif
      glb_ds1edit.pal_loaded[i] = TRUE;
      // first checking on disk
      if (misc_load_pal_from_disk(i) == FALSE)
      {
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : wasn't on disk already\n");
   fflush(glb_ds1edit.txt_debug);
#endif
         // not already on disk
         glb_ds1edit.pal_loaded[i] = FALSE;
         
         // make full path
         sprintf(palname, "Data\\Global\\Palette\\Act%i\\Pal.pl2", i+1);
         
         // load the palette
         printf("want to read a palette from mpq : %s\n", palname);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : about to load '%s' from mpq\n", palname);
   fflush(glb_ds1edit.txt_debug);
#endif
         entry = misc_load_mpq_file(
                    palname,
                    & glb_ds1edit.d2_pal[i],
                    & glb_ds1edit.pal_size[i],
                    TRUE
                 );
         if (entry == -1)
         {
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : wasn't extracted from mpq\n");
   fflush(glb_ds1edit.txt_debug);
#endif
            sprintf(tmp, "ds1edit_load_palettes() : file %s not found",
               palname);
            if (i < 4)
               ds1edit_error(tmp);
            else
               printf("warning :\n%s\n", tmp);
         }

         // save it for the next time
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : save on disk for later use\n");
   fflush(glb_ds1edit.txt_debug);
#endif
         misc_save_pal_on_disk(i, glb_ds1edit.d2_pal[i]);
      }

      // palette loaded, either from disk of from mpq, reorder it
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : rearrange palette\n");
   fflush(glb_ds1edit.txt_debug);
#endif
      misc_pl2_correct(i);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : pal D2 to vga\n");
   fflush(glb_ds1edit.txt_debug);
#endif
      misc_pal_d2_2_vga(i);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "ds1edit_load_palettes() : palette done\n");
   fflush(glb_ds1edit.txt_debug);
#endif
      fprintf(stderr, ".");
      fflush(stderr);
   }
   fprintf(stderr, "\n");
   fflush(stderr);
   printf("\n");
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "\nds1edit_load_palettes() : END\n");
   fflush(glb_ds1edit.txt_debug);
#endif
}


// ==========================================================================
// as expected, the start of the prog
int main(int argc, char * argv[])
{
   int  i, mpq_num=0, mod_num=1, ds1_idx=0;
   char ininame[] = "ds1edit.ini", tmp[512];
#ifdef _DS1EDIT_DEBUG_
   char * txt_debug_name = "win_ds1edit_debug.txt";
   FILE * debug;


   debug = fopen(txt_debug_name, "wt");
   if (debug == NULL)
   {
      printf("can't create %s\n", txt_debug_name);
      return -1;
   }
   fprintf(debug, "main() : START\n");
   fflush(debug);
#endif

   // init
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : srand()\n");
   fflush(debug);
#endif
   srand(time(NULL));
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : allegro_init()\n");
   fflush(debug);
#endif
   allegro_init();

#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : set_gfx_mode(GFX_TEXT)\n");
   fflush(debug);
#endif
   set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
   
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : install_keyboard()\n");
   fflush(debug);
#endif
   install_keyboard();
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : install_timer()\n");
   fflush(debug);
#endif
   install_timer();
   set_color_depth(8);
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : atexit()\n");
   fflush(debug);
#endif
   atexit(ds1edit_exit);
#ifdef _DS1EDIT_DEBUG_
   fprintf(debug, "main() : ds1edit_init\n");
   fflush(debug);
#endif
   ds1edit_init();

   // some allegro infos
#ifdef _DS1EDIT_DEBUG_
   glb_ds1edit.txt_debug = debug;
   fprintf(glb_ds1edit.txt_debug, "main() : some allegro infos\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   printf("\n[allegro var]\n");
   printf("allegro_id       = \"%s\"\n", allegro_id);
   printf("os_type          = ");
   switch(os_type)
   {
       case OSTYPE_UNKNOWN : printf("unknown, or regular MSDOS\n"); break;
       case OSTYPE_WIN3    : printf("Windows 3.1 or earlier\n");    break;
       case OSTYPE_WIN95   : printf("Windows 95\n");                break;
       case OSTYPE_WIN98   : printf("Windows 98\n");                break;
       case OSTYPE_WINME   : printf("Windows ME\n");                break;
       case OSTYPE_WINNT   : printf("Windows NT\n");                break;
       case OSTYPE_WIN2000 : printf("Windows 2000\n");              break;
       case OSTYPE_WINXP   : printf("Windows XP\n");                break;
       case OSTYPE_OS2     : printf("OS/2\n");                      break;
       case OSTYPE_WARP    : printf("OS/2 Warp 3\n");               break;
       case OSTYPE_DOSEMU  : printf("Linux DOSEMU\n");              break;
       case OSTYPE_OPENDOS : printf("Caldera OpenDOS\n");           break;
       case OSTYPE_LINUX   : printf("Linux\n");                     break;
       case OSTYPE_SUNOS   : printf("SunOS/Solaris\n");             break;
       case OSTYPE_FREEBSD : printf("FreeBSD\n");                   break;
       case OSTYPE_NETBSD  : printf("NetBSD\n");                    break;
       case OSTYPE_IRIX    : printf("IRIX\n");                      break;
       case OSTYPE_QNX     : printf("QNX\n");                       break;
       case OSTYPE_UNIX    : printf("Unknown Unix variant\n");      break;
       case OSTYPE_BEOS    : printf("BeOS\n");                      break;
       case OSTYPE_MACOS   : printf("MacOS\n");                     break;
       default : printf("?\n"); break;
   }
   printf("os_version       = %i\n", os_version);
   printf("os_revision      = %i\n", os_revision);
   printf("os_multitasking  = %s\n", os_multitasking ? "TRUE" : "FALSE");
   printf("cpu_vendor       = %s\n", cpu_vendor);
   printf("cpu_family       = %i\n", cpu_family);
   printf("cpu_model        = %i\n", cpu_model);
   printf("cpu_capabilities = 0x%08X\n", cpu_capabilities);
   printf("\n");

   sprintf(tmp, "DS1 Editor, Build %s, %s", glb_ds1edit.version, allegro_id);
   set_window_title(tmp);

   // allegro dll safety check
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : allegro dll safety check\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   if (strcmp(allegro_id, DS1EDIT_GOOD_DLL) != 0)
   {
      sprintf(tmp,
         "\n\n"
         "I have detected that the current Allegro DLL that you're using is\n\n"
         "   \"%s\"\n\n"
         "It should be\n\n"
         "   \"%s\"\n\n"
         "Download the good Allegro DLL from\n\n"
         "   %s\n\n"
         "Then extract the DLL into this directory and restart the program\n",
         allegro_id,
         DS1EDIT_GOOD_DLL,
         DS1EDIT_DLL_LINK
      );
      ds1edit_error(tmp);
   }

   // check data\tmp directory
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : check data\\tmp directory\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   sprintf(tmp, "%s%s\\.", ds1edit_data_dir, ds1edit_tmp_dir);
   if (file_exists(tmp, -1, NULL) == 0)
   {
      // create tmp directory
      sprintf(tmp, "%s%s", ds1edit_data_dir, ds1edit_tmp_dir);
      if (strlen(tmp))
         tmp[strlen(tmp) - 1] = 0;
#ifdef DJGPP
      if (mkdir(tmp, S_IWUSR))
#else
      if (mkdir(tmp))
#endif
      {
         // re-use the tmp var for a different string
         sprintf(tmp, "main() : can't create directory %s%s",
            ds1edit_data_dir, ds1edit_tmp_dir);
         tmp[strlen(tmp) - 1] = 0;
         ds1edit_error(tmp);
      }
   }
   
   // check if ds1edit.ini exists
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : does ds1edit.ini exists ?\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   sprintf(tmp, "ds1edit.ini");
   if (file_exists(tmp, -1, NULL) == 0)
   {
      ini_create(tmp);
      exit(DS1ERR_INICREATE);
   }

   // init (config)
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : init (config)\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   ini_read(ininame);
   ds1edit_debug();
   sprintf(tmp, "%s\\.", config.mod_dir[0]);

   // check mod directory
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : check mod directory\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   errno=0; // just for safety
   file_exists(tmp, -1, NULL);
   if (errno)
   {
      if (strlen(tmp))
         printf("main(), warning, can't find mod dir :\n   %s", tmp);
      mod_num=0;
   }
   for (i=0; i<MAX_MPQ_FILE; i++)
   {
      if (config.mpq_file[i] != NULL)
      {
         if (file_exists(config.mpq_file[i], -1, NULL) == 0)
         {
            printf("main(), warning : can't find mpq : %s\n",
               config.mpq_file[i]);
         }
         else
            mpq_num++;
      }
   }
   if ((mod_num == 0) && (mpq_num == 0))
   {
      sprintf(tmp, "main() : no mod_dir path & no mpq paths, it can't work");
      ds1edit_error(tmp);
   }
   else if (mpq_num < 4)
      printf("warning : not all the 4 mpq have been found\n");

   // gamma correction
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : gamma correction\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   glb_ds1edit.cur_gamma = config.gamma;
   misc_read_gamma();

   // preview window update
   glb_ds1edit.win_preview.x0 = 0;
   glb_ds1edit.win_preview.y0 = 0;
   glb_ds1edit.win_preview.w  = config.screen.width;
   glb_ds1edit.win_preview.h  = config.screen.height;

   // edit window
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : edit window\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   wedit_read_pcx();
   wedit_make_2nd_buttons();
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : walkable tiles\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   misc_walkable_tile_info_pcx();

   // screen buffer (we're still in 8bpp color depth !)
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : screen buffer\n");
   fflush(glb_ds1edit.txt_debug);
#endif

   // we're making a big buffer, with 300 pixels on each 4 borders,
   // and then we'll make the true screen buffer be a sub-bitmap of this buffer
   // this is to avoid potential problems with clipings, especially when using
   // the functions from gfx_custom.c
   // yes, I'm hidding the problem under the carpet

   config.screen.width  += 600;
   config.screen.height += 600;
   glb_ds1edit.big_screen_buff = create_bitmap(
      config.screen.width,
      config.screen.height
   );
   if (glb_ds1edit.big_screen_buff == NULL)
   {
      sprintf(tmp, "can't create big_screen_buff %i * %i",
         config.screen.width,
         config.screen.height
      );
      ds1edit_error(tmp);
   }
   config.screen.width  -= 600;
   config.screen.height -= 600;

   glb_ds1edit.screen_buff = create_sub_bitmap(
      glb_ds1edit.big_screen_buff,
      300,
      300,
      config.screen.width,
      config.screen.height
   );
   if (glb_ds1edit.screen_buff == NULL)
   {
      sprintf(tmp, "can't create sub-bitmap screen_buff %i * %i",
         config.screen.width,
         config.screen.height
      );
      ds1edit_error(tmp);
   }

   // open all mpq
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : open all mpq\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   ds1edit_open_all_mpq();
   
   // load palettes from disk, else from mpq
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : load palettes\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   ds1edit_load_palettes();
   
   // syntaxe of the command line
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : syntax of command line\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   printf("============================================================\n");
   if (argc >= 4) // at least 3 arguments (ds1 name + ID + DEF + options)
   {
      if (misc_cmd_line_parse (argc, argv))
         exit(DS1ERR_CMDLINE);

      // objects.txt
      fprintf(stderr, "reading objects.txt...");
      read_objects_txt();
      fprintf(stderr, "done\n");

      // obj.txt
      fprintf(stderr, "reading Obj.txt...");
      read_obj_txt();
      fprintf(stderr, "done\n");

      // read the ds1
      if (glb_ds1edit.cmd_line.dt1_list_num != -1)
      {
         // force dt1
         misc_open_1_ds1_force_dt1(ds1_idx);
      }
      else
      {
         // find dt1 list from .txt
         misc_open_1_ds1(
            ds1_idx,
            glb_ds1edit.cmd_line.ds1_filename,
            glb_ds1edit.cmd_line.lvltype_id,
            glb_ds1edit.cmd_line.lvlprest_def,
            glb_ds1edit.cmd_line.resize_width,
            glb_ds1edit.cmd_line.resize_height
         );
      }
   }
   else if (argc == 2) // 1 argument (assume it's a .ini file)
   {
      // 2nd row of infos
      glb_ds1edit.show_2nd_row = TRUE;

      // objects.txt
      fprintf(stderr, "reading objects.txt...");
      read_objects_txt();
      fprintf(stderr, "done\n");

      // obj.txt
      fprintf(stderr, "reading Obj.txt...");
      read_obj_txt();
      fprintf(stderr, "done\n");

      // list of ds1 to open
      misc_open_several_ds1(argv[1]);
   }
   else // syntax error
   {
      printf("syntaxe1 : ds1edit <file.ds1> <lvlTypes.txt Id> <lvlPrest.txt Def> [options]\n");
      printf("syntaxe2 : ds1edit <file.ini>\n"
             "   file.ini in syntaxe2 is a text file, each line for 1 ds1 to load,\n"
             "   3 elements : <lvlTypes.txt Id> <lvlPrest.txt Def> <file.ds1>\n");
      exit(DS1ERR_CMDLINE);
   }
   printf("============================================================\n");


   // animdata.d2
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : animdata.d2\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   printf("\nanimdata_load()\n");
   fflush(stdout);
   fflush(stderr);
   animdata_load();

   // load necessary objects animation
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : load necessary objects animations\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   printf("loading ds1 objects animations :\n");
   fprintf(stderr, "loading ds1 objects animations : ");
   fflush(stdout);
   fflush(stderr);

   anim_update_gfx(TRUE); // TRUE is for "show dot progression"

   printf("\n");
   fprintf(stderr, "\n");
   fflush(stdout);
   fflush(stderr);
   
   // colormaps
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : colormaps\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   printf("\ncolor maps...");
   fprintf(stderr, "color maps");
   misc_make_cmaps();
   printf("done\n");
   fprintf(stderr, "done\n");

   // start
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : fflush(sdtout & stderr)\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   fflush(stdout);
   fflush(stderr);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : set_color_depth(%i)\n", config.screen.depth);
   fflush(glb_ds1edit.txt_debug);
#endif
   set_color_depth(config.screen.depth);

#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : request_refresh_rate()\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   request_refresh_rate(config.screen.refresh);
   if (config.fullscreen == TRUE)
   {
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, config.screen.width,
             config.screen.height, 0, 0))
      {
         ds1edit_error(allegro_error);
      }
   }
   else
   {
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, config.screen.width,
             config.screen.height, 0, 0))
      {
         ds1edit_error(allegro_error);
      }
   }
   glb_ds1edit.current_refresh_rate = get_refresh_rate();

   // get back to a 8bpp color depth, for futur BITMAP creation
   set_color_depth(8);

   text_mode(-1); // draw text as sprite, no background color
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : lock some variables\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   LOCK_VARIABLE(glb_ds1edit.old_fps);
   LOCK_VARIABLE(glb_ds1edit.fps);
   LOCK_VARIABLE(glb_ds1edit.ticks_elapsed);
   LOCK_FUNCTION(ds1edit_counter_tick);
   LOCK_FUNCTION(ds1edit_counter_fps);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : install ds1edit ticks & fps timer\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   install_int(ds1edit_counter_tick, 1000 / 25);
   install_int(ds1edit_counter_fps, 1000);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : install mouse\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   install_mouse();
   set_mouse_speed(config.mouse_speed.x, config.mouse_speed.y);
   set_mouse_sprite(glb_ds1edit.mouse_cursor[glb_ds1edit.mode]);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : show mouse\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   show_mouse(screen);

   glb_ds1edit.win_preview.x0 = ds1[ds1_idx].own_wpreview.x0;
   glb_ds1edit.win_preview.y0 = ds1[ds1_idx].own_wpreview.y0;
   glb_ds1edit.win_preview.w  = ds1[ds1_idx].own_wpreview.w ;
   glb_ds1edit.win_preview.h  = ds1[ds1_idx].own_wpreview.h ;


   // main loop
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : main loop !\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   freopen("stderr.txt", "wt", stderr);
   interfac_user_handler(ds1_idx);

   // end
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : END\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
   // fclose(stdout);
   fflush(stdout);
   fflush(stderr);
#ifdef _DS1EDIT_DEBUG_
   fprintf(glb_ds1edit.txt_debug, "main() : return from main, DS1ERR_OK\n");
   fflush(glb_ds1edit.txt_debug);
#endif
   return DS1ERR_OK;
}
END_OF_MAIN();
