// TStatic.cpp: implementation of the TStatic class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TStatic.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB214470198
TStatic::TStatic(const int x, const int y, const int w, const int h, const string& text)
:TObject(x, y, w, h)
{
	this->text = text;
}

//##ModelId=3FB2144701A4
TStatic::~TStatic()
{

}

//##ModelId=3FB2144701A6
void TStatic::Init()
{
	background = create_bitmap(w, h);
	TObject::Init();
}

//##ModelId=3FB2144701AB
void TStatic::Close()
{
	destroy_bitmap(background);
}

//##ModelId=3FB2144701AC
void TStatic::FirstDraw(BITMAP *dest)
{
//	clear_to_color(background, makecol(128, 64, 64));
//	release_screen();
	show_mouse(NULL);
	acquire_bitmap(background);
	blit (GetParent()->GetDestinationBitmap(), background, x, y, 0, 0, w, h);
	release_bitmap(background);
//	acquire_screen();
	Draw(dest);
}

//##ModelId=3FB2144701AE
void TStatic::Draw(BITMAP *dest)
{
	int y=0;
	int pos = 0, end_pos;
	bool final = false;
	string word;
	string line;
	int len;

//	skin->draw_panel(dest, 0, 0, w, h, 0, 0, false);

	blit (background, dest, 0, 0, 0, 0, w, h);

	end_pos = text.find_first_of(" ", pos);
	if (end_pos == signed(string::npos))
	{
		word = text.substr(pos);
	}
	else
	{
		word = text.substr(pos, end_pos-pos+1);
	}
	pos = end_pos+1;

	do
	{
		do
		{
			if (end_pos == signed(string::npos)) final = true;
			line += word;
			end_pos = text.find_first_of(" ", pos);
			if (end_pos == signed(string::npos))
			{
				word = text.substr(pos);
				len = text_length(skin->get_normal_font(), (string(line + word)).c_str());
			}
			else
			{
				word = text.substr(pos, end_pos-pos);
				len = text_length(skin->get_normal_font(), (string(line + word)).c_str());
				word += " ";
			}
			pos = end_pos+1;
		} while (!final && len < w);
//		textout (dest, font, line.c_str(), 0, y, 0);
		skin->print(TSkin::pbackground, dest, 0, y, w, text_height(skin->get_normal_font()), line.c_str(), TSkin::aleft, TSkin::tstandard, TSkin::cplain);
		y+=text_height(skin->get_normal_font());
		line = "";
	} while (!final);

}
