// TSpin.cpp: implementation of the TSpin class.
//
//////////////////////////////////////////////////////////////////////

#include <list>
#include <string>
#include <allegro.h>

using namespace std;

#include "TSpin.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB214470210
TSpin::TSpin(const int x, const int y, const int w, const int h)
:TObject(x, y, w, h)
{
	selected = 0;
	mouse_over = false;
	OnChange = NULL;
	variable=NULL;
	background = create_bitmap(w, h);
}

//##ModelId=3FB21447021A
TSpin::~TSpin()
{
	destroy_bitmap(background);
}

//##ModelId=3FB21447021C
void TSpin::MouseExit()
{
	mouse_over = false;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB21447021D
void TSpin::MouseEnter()
{
	mouse_over = true;;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB214470223
void TSpin::MouseDown(int button, int x, int y)
{
	if (x < h)
	{
		if (selected > 0)
		{
			sel_object--;
			selected--;
			GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
			if (OnChange)
			{
				OnChange(this);
			}
		}
	}
	if (x > w-h-1)
	{
		if (selected < signed(objects.size())-1)
		{
			sel_object++;
			selected++;
			GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
			if (OnChange)
			{
				OnChange(this);
			}
		}
	}
}

//##ModelId=3FB214470227
void TSpin::FirstDraw(BITMAP *dest)
{
	show_mouse(NULL);
	acquire_bitmap(background);
	blit (GetParent()->GetDestinationBitmap(), background, x, y, 0, 0, w, h);
	release_bitmap(background);

	Draw(dest);
}

//##ModelId=3FB21447022E
void TSpin::Draw(BITMAP *dest)
{
	blit (background, dest, 0, 0, 0, 0, w, h);

	skin->draw_panel(TSkin::pforeground, dest, h, 0, w-2*h, h, -1, 0, false, false);
//	skin->draw_panel(TSkin::pbutton, dest, 0, 0, h, h, 1, 0, false, mouse_over);
	if (selected > 0) skin->draw_arrow(dest, 1, 2, h-4, h-4, TSkin::left, false, mouse_over);
//	skin->draw_panel(TSkin::pbutton, dest, w-h, 0, h, h, 1, 0, false, mouse_over);
	if (selected < signed(objects.size())-1) skin->draw_arrow(dest, w-h+2, 2, h-4, h-4, TSkin::right, false, mouse_over);
	skin->print(TSkin::pforeground, dest, 0, 0, w, h, sel_object->c_str(), TSkin::acentre, TSkin::tstandard, mouse_over?TSkin::chover:TSkin::cplain);
}

//##ModelId=3FB214470230
void TSpin::SetMsgChange(void (*OnChange) (TSpin *))
{
	this->OnChange = OnChange;
}

//##ModelId=3FB214470237
void TSpin::AddItem(const string &str)
{
	objects.push_back(str);
	sel_object = objects.begin();
}

//##ModelId=3FB214470239
void TSpin::InsertItem(string &str, int pos)
{
}

//##ModelId=3FB214470241
void TSpin::DeleteItem(string &str)
{
}

//##ModelId=3FB214470243
void TSpin::DeleteItem(int pos)
{
}

//##ModelId=3FB214470245
int TSpin::GetSel(void)
{
	return selected;
}

//##ModelId=3FB21447024C
void TSpin::SetSel(int p)
{
	selected = p;

	sel_object = objects.begin();

	while (p>0)
	{
		sel_object++;
		p--;
	}

	if (initialized) GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB214470256
void TSpin::UpdateData(bool retrieve)
{
	if (variable)
	{
		if (retrieve)
		{
			*variable = selected;
		}
		else
		{
			selected = *variable;
			if (initialized)
			{
				this->GetParent()->SendMessage(TMSG_DRAW, 0, 0);
			}
		}
	}
}
