// TSkin.cpp: implementation of the TSkin class.
//
//////////////////////////////////////////////////////////////////////

#include <allegro.h>

#include "TSkin.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB21447033C
TSkin::TSkin()
{
	check_checked_focused = NULL;
	check_checked = NULL;
	check_focused = NULL;
	check = NULL;
	radio_checked_focused = NULL;
	radio_checked = NULL;
	radio_focused = NULL;
	radio = NULL;

	background_skin.fill_color = makecol(154, 154, 154);
	foreground_skin.fill_color = makecol(224, 224, 224);
	selection_skin.fill_color = makecol(64, 64, 128);
	selection_skin.text_color = makecol(224, 224, 255);
	selection_skin.hover_text_color = makecol(192, 192, 255);
	scrollbar_skin.fill_color = makecol(180, 180, 180);
	foreground_skin.hover_light_border_color = makecol(208, 208, 208);
	foreground_skin.hover_dark_border_color = makecol(96, 96, 96);
}

//##ModelId=3FB21447033D
TSkin::~TSkin()
{

}

//##ModelId=3FB2144801AC
TSkin::t_panel::t_panel()
{
	light_border_color = makecol(208, 208, 208);
	dark_border_color = makecol(96, 96, 96);
	fill_color = makecol(164, 164, 164);
	fill_texture = NULL;
	text_color = makecol(0, 0, 0);
	hover_light_border_color = makecol(255, 255, 255);
	hover_dark_border_color = makecol(128, 128, 128);
	hover_fill_color = makecol(192, 192, 192);
	hover_fill_texture = NULL;
	hover_text_color = makecol(0, 64, 224);
	selected_text_color = makecol(0, 64, 160);
	grayed_text_color = makecol(92, 92, 92);
	draw_color = makecol(92, 92, 92);
	draw_grayed_color = makecol(128, 128, 128);
	draw_hover_color = makecol(192, 192, 192);
	draw_selected_color = makecol(192, 192, 192);
}

void TSkin::set_panel_props(enum TSkin::panel p, TSkin::t_panel &props)
{
	t_panel &dest = get_panel_props(p);

	dest.light_border_color = props.light_border_color;
	dest.dark_border_color = props.dark_border_color;
	dest.fill_color = props.fill_color;
	dest.fill_texture = props.fill_texture;
	dest.text_color = props.text_color;
	dest.hover_light_border_color = props.hover_light_border_color;
	dest.hover_dark_border_color = props.hover_dark_border_color;
	dest.hover_fill_color = props.hover_fill_color;
	dest.hover_fill_texture = props.hover_fill_texture;
	dest.hover_text_color = props.hover_text_color;
	dest.draw_color = props.draw_color;
	dest.draw_grayed_color = props.draw_grayed_color;
	dest.draw_hover_color = props.draw_hover_color;
	dest.draw_selected_color = props.draw_selected_color;
}

TSkin::t_panel& TSkin::get_panel_props(enum TSkin::panel p)
{
	t_panel *dest = NULL;

	switch (p)
	{
	case pbackground:
		dest = &background_skin;
		break;
	case pbutton:
		dest = &button_skin;
		break;
	case pforeground:
		dest = &foreground_skin;
		break;
	case pselection:
		dest = &selection_skin;
		break;
	case pscrollbar:
		dest = &scrollbar_skin;
		break;
	}

	return *dest;
}

//##ModelId=3FB214470346
void TSkin::draw_checkbox (BITMAP *dest, int x, int y, bool checked, bool focused)
{
	if (checked)
	{
		if (focused)
		{
			if (check_checked_focused)
			{
				draw_sprite(dest, check_checked_focused, x, y-check_checked_focused->h/2);
			}
			else
			{
				draw_panel(pforeground, dest, x, y-6, 12, 12, -1, 0, false, true);
				line(dest, x+2, y-4, x+9, y+3, button_skin.text_color);
				line(dest, x+9, y-4, x+2, y+3, button_skin.text_color);
			}
		}
		else
		{
			if (check_checked)
			{
				draw_sprite(dest, check_checked, x, y-check_checked->h/2);
			}
			else
			{
				draw_panel(pforeground, dest, x, y-6, 12, 12, -1, 0, false, false);
				line(dest, x+2, y-4, x+9, y+3, button_skin.text_color);
				line(dest, x+9, y-4, x+2, y+3, button_skin.text_color);
			}
		}
	}
	else
	{
		if (focused)
		{
			if (check_focused)
			{
				draw_sprite(dest, check_focused, x, y-check_focused->h/2);
			}
			else
			{
				draw_panel(pforeground, dest, x, y-6, 12, 12, -1, 0, false, true);
			}
		}
		else
		{
			if (check)
			{
				draw_sprite(dest, check, x, y-check->h/2);
			}
			else
			{
				draw_panel(pforeground, dest, x, y-6, 12, 12, -1, 0, false, false);
			}
		}
	}
}

//##ModelId=3FB214470351
void TSkin::draw_radio (BITMAP *dest, int x, int y, bool checked, bool focused)
{
	if (checked)
	{
		if (focused)
		{
			if (radio_checked_focused)
			{
				draw_sprite(dest, radio_checked_focused, x, y-radio_checked_focused->h/2);
			}
		}
		else
		{
			if (radio_checked)
			{
				draw_sprite(dest, radio_checked, x, y-radio_checked->h/2);
			}
		}
	}
	else
	{
		if (focused)
		{
			if (radio_focused)
			{
				draw_sprite(dest, radio_focused, x, y-radio_focused->h/2);
			}
		}
		else
		{
			if (radio)
			draw_sprite(dest, radio, x, y-radio->h/2);
		}
	}
}

//##ModelId=3FB214470369
void TSkin::draw_texture (BITMAP *tex, BITMAP *dest, int x, int y, int w, int h)
{
	int tw = tex->w;
	int th = tex->h;
	int px=0;
	int py=0;
	int bh, bw;

	while (py < h)
	{
		if (h-py < th) bh = h-py;
		else bh = th;
		px=0;
		while (px < w)
		{
			if (w-px < tw) bw = w-px;
			else bw = tw;
			blit (tex, dest, 0, 0, x+px, y+py, bw, bh);
			px+=tw;
		}
		py+=th;
	}
}

//##ModelId=3FB21447035B
void TSkin::draw_texture (TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, bool focused, bool hover)
{
	t_panel &pp = get_panel_props(p);
	
	if (focused || hover)
	{
		if (pp.hover_fill_texture)
		{
			draw_texture(pp.hover_fill_texture, dest, x, y, w, h);
		}
		else
		{
			rectfill(dest, x, y, x+w-1, y+h-1, pp.hover_fill_color);
		}
	}
	else
	{
		if (pp.fill_texture)
		{
			draw_texture(pp.fill_texture, dest, x, y, w, h);
		}
		else
		{
			rectfill(dest, x, y, x+w-1, y+h-1, pp.fill_color);
		}
	}
}

//##ModelId=3FB214470377
void TSkin::draw_panel (TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, int alt, int move, bool focused, bool hover)
{
	draw_texture(p, dest, x+move, y+move, w, h, focused, hover);
	draw_border(p, dest, x, y, w, h, alt, move, focused, hover);
}

void TSkin::draw_arrow(BITMAP *dest, int x, int y, int w, int h, TSkin::direction dir, bool focused, bool hover)
{
	int color;

	color = focused||hover ? scrollbar_skin.draw_hover_color : scrollbar_skin.draw_color;

	switch(dir)
	{
	case up:
		triangle(dest, x, y+h, x+w, y+h, x+w/2, y, color);
		break;
	case down:
		triangle(dest, x, y, x+w, y, x+w/2, y+h, color);
		break;
	case left:
		triangle(dest, x, y+h/2, x+w, y, x+w, y+h, color);
		break;
	case right:
		triangle(dest, x+w, y+h/2, x, y, x, y+h, color);
		break;
	}
}

//##ModelId=3FB214470387
void TSkin::draw_border(TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, int alt, int move, bool focused, bool hover)
{
	t_panel &pp = get_panel_props(p);
	int i, j;
	int c1 = focused || hover ? pp.hover_light_border_color : pp.light_border_color;
	int c2 = focused || hover ? pp.hover_dark_border_color : pp.dark_border_color;
	int col1, col2;

	if (alt >= 0)
	{
		col1 = c1;
		col2 = c2;
	}
	else
	{
		col1 = c2;
		col2 = c1;
		alt = -alt;
	}

	for (i=0, j=0; j<alt; i++, j++)
	{
		hline (dest, x+i, y+h-j-1, x+w-i-1, col2);
		vline (dest, x+w-i-1, y+j, y+h-j-1, col2);
	}

	for (i=0, j=0; j<alt+move; i++, j++)
	{
		hline (dest, x+i, y+j, x+w-i-1, col1);
		vline (dest, x+i, y+j, y+h-j-1, col1);
	}
}

//##ModelId=3FB21447039A
void TSkin::print(TSkin::panel p, BITMAP *dest, const int x, const int y, const int w, const int h, const char *txt, const font_align align, const font_type type, const font_color color)
{
	t_panel &pp = get_panel_props(p);
	FONT *f = NULL;
	int c = 0;
	int th;

	switch (type)
	{
	case tstandard:
		f = normal_font;
		break;
	case tmonospaced:
		f = mono_font;
		break;
	}

	switch (color)
	{
	case cplain:
		c = pp.text_color;
		break;
	case cselected:
		c = pp.selected_text_color;
		break;
	case chover:
		c = pp.hover_text_color;
		break;
	case cgrayed:
		c = pp.grayed_text_color;
		break;
	}

	th = text_height(f);

	switch (align)
	{
	case aleft:
		textout(dest, f, txt, x, y+(h-th)/2, c);
		break;
	case aright:
		textout_right(dest, f, txt, x+w, y+(h-th)/2, c);
		break;
	case acentre:
		textout_centre(dest, f, txt, x+w/2, y+(h-th)/2, c);
		break;
	case ajustify:
		textout_justify(dest, f, txt, x, x+w, y+(h-th)/2, w, c);
		break;
	}
}
