// TRadio.cpp: implementation of the TRadio class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TRadio.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB21448021B
TRadio::TRadio(const int x, const int y, const int w, const int h, const string& text, const int group)
:TCheck(x, y, w, h, text)
{
	this->group = group;
}

//##ModelId=3FB214480226
TRadio::~TRadio()
{

}

//##ModelId=3FB21448022E
void TRadio::MouseClick(int button, int x, int y)
{
	value = true;
	TButton::MouseClick(button, x, y);
	GetParent()->SendMessage(TMSG_RADIO, group, ID);
}

//##ModelId=3FB214480232
void TRadio::GetCustomMsg(int msg, int param1, int param2)
{
	if (msg == TMSG_RADIO)
	{
		if (param1 == group && param2 != ID)
		{
			value = false;
			GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
		}
	}
}

//##ModelId=3FB214480228
void TRadio::Draw(BITMAP *dest)
{
	int marca;

	blit(background, dest, 0, 0, 0, 0, w, h);
	marca = pushed&&mouse_over&&!value ? !value : value;

	skin->draw_radio(dest, 0, h/2, marca?true:false, mouse_over||pushed);
	skin->print(TSkin::pbackground, dest, 20, 0, w-20, h, text.c_str(), TSkin::aleft, TSkin::tstandard, mouse_over||pushed?TSkin::chover:TSkin::cplain);
}

//##ModelId=3FB21448023B
void TRadio::SetCheck(bool check)
{
	this->value = check;
	if (initialized)
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
		if (check)
		{
			GetParent()->SendMessage(TMSG_RADIO, group, ID);
		}
	}
}
