// TObject.cpp: implementation of the TObject class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TObject.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB214490082
TSkin* TObject::skin = NULL;

//##ModelId=3FB21449005B
TObject::TObject(const int x, const int y, const int w, const int h)
{
	this->x = x;
	this->y = y;
	this->w = w;
	this->h = h;
	this->text = "";
	this->help_object = NULL;
	this->help_text = "";
	ID = -2;
	group = 0;
	parent = NULL;
	initialized = false;;
}

//##ModelId=3FB214490064
TObject::~TObject()
{

}

//##ModelId=3FB214490015
bool TObject::Initialized() const
{
	return initialized;
}

//##ModelId=3FB2144803D7
void TObject::Init()
{
	initialized = true;
}

//##ModelId=3FB2144803E8
void TObject::Move(const int x, const int y)
{
	this->x = x;
	this->y = y;

	parent->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB214490050
string& TObject::GetText()
{
	return text;
}

//##ModelId=3FB214490031
void TObject::SetGroup(int g)
{
	group = g;
}

//##ModelId=3FB214490033
int TObject::GetGroup() const
{
	return group;
}

//##ModelId=3FB214490048
void TObject::SetText(const string &str)
{
	text = str;
}

//##ModelId=3FB21449003F
void TObject::SetHelpText(const string &str)
{
	help_text = str;
}

//##ModelId=3FB214490047
string& TObject::GetHelpText()
{
	return help_text;
}

//##ModelId=3FB21449003D
TDialog* TObject::GetParent() const
{
	return parent;
}

//##ModelId=3FB21449002A
int TObject::GetID() const
{
	return ID;
}

//##ModelId=3FB214490028
void TObject::SetID(int ID)
{
	this->ID = ID;
}

//##ModelId=3FB214490022
int TObject::GetPosX() const
{
	return x;
}

//##ModelId=3FB214490020
int TObject::GetPosY() const
{
	return y;
}

//##ModelId=3FB21449001E
int TObject::GetWidth() const
{
	return w;
}

//##ModelId=3FB214490017
int TObject::GetHeight() const
{
	return h;
}

//##ModelId=3FB214490051
void TObject::SetSkin(TSkin* s)
{
	skin = s;
}

//##ModelId=3FB214490059
TSkin* TObject::GetSkin()
{
	return skin;
}

//##ModelId=3FB2144803DD
void TObject::FirstDraw(BITMAP *dest)
{
	Draw(dest);
}

//##ModelId=3FB2144803D4
void TObject::KeyDown(int key)
{

}

//##ModelId=3FB2144803CC
void TObject::KeyUp(int key)
{

}

//##ModelId=3FB2144803C9
bool TObject::KeyPress(int key)
{
	return false;
}

//##ModelId=3FB2144803C0
void TObject::MouseDown(int button, int x, int y)
{

}

//##ModelId=3FB2144803B7
void TObject::MouseUp(int button, int x, int y)
{

}

//##ModelId=3FB2144803B0
void TObject::MouseWheel(int d)
{

}

//##ModelId=3FB2144803AC
void TObject::MouseMove(int x, int y)
{

}

//##ModelId=3FB2144803A5
void TObject::MouseEnter()
{

}

//##ModelId=3FB2144803A3
void TObject::MouseExit()
{

}

//##ModelId=3FB21448039A
void TObject::MouseClick(int button, int x, int y)
{

}

//##ModelId=3FB21448038F
void TObject::MouseDblClick(int button, int x, int y)
{

}

//##ModelId=3FB21448038D
bool TObject::GotFocus()
{
	return true;
}

//##ModelId=3FB214480387
bool TObject::LostFocus()
{
	return true;
}

//##ModelId=3FB214480384
void TObject::Timer(int t)
{

}

//##ModelId=3FB21449003B
void TObject::SetParent(TDialog *p)
{
	parent = p;
}

//##ModelId=3FB21448037A
void TObject::Idle()
{

}

//##ModelId=3FB214490009
void TObject::GetCustomMsg(int msg, int param1, int param2)
{

}
