// TList.cpp: implementation of the TList class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <list>
#include <allegro.h>

using namespace std;

#include "TList.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144901C4
TList::TList(const int x, const int y, const int w, const int h, const string& text)
:TObject(x, y, w, h)
{
	pos = 0;
	selected = -1;
	hotitem = -1;
	clicked = NONE;
	mouse_over = NONE;
	num_items = (h-2)/text_height(skin->get_normal_font());
	scroll_size = h-30;
	scroll_pos = 0;
	scroll_visible = false;
	variable = NULL;
	OnSelChange = NULL;
	redraw_on_insert = true;
}

//##ModelId=3FB2144901D0
TList::~TList()
{

}

//##ModelId=3FB2144901D6
void TList::Draw(BITMAP *dest)
{
	int j=1;
	int p=0;
	int fh;

	fh = text_height(skin->get_normal_font());

	skin->draw_panel(TSkin::pforeground, dest, 0, 0, scroll_visible?w-16:w, h, -1, 0, false, false);

	if (!objects.empty())
	{
		list<list_node>::iterator it = objects.begin();

		while (p<pos) it++,p++;

		do
		{
			if(p==selected)
			{
				skin->draw_panel(TSkin::pselection, dest, 1, j, scroll_visible?w-18:w-2, text_height(skin->get_normal_font()), 0, 0, false, false);
			}
			if (it->enabled)
			{
				skin->print(selected==p?TSkin::pselection:TSkin::pforeground, dest, 2, j, scroll_visible?w-18:w-2, fh, it->str.c_str(), TSkin::aleft, TSkin::tstandard, hotitem==p?TSkin::chover:TSkin::cplain);
			}
			else
			{
				skin->print(TSkin::pforeground, dest, 2, j, scroll_visible?w-18:w-2, fh, it->str.c_str(), TSkin::aleft, TSkin::tstandard, TSkin::cgrayed);
			}
			it++;
			j+=fh;
			p++;
		} while (it != objects.end() && p<pos+num_items);
	}
	if (scroll_visible)
	{
		skin->draw_panel(TSkin::pscrollbar, dest, w-16, 0, 16, h, -1, 0, false, false);
		skin->draw_panel(TSkin::pbutton, dest, w-15, 1, 14, 14, mouse_over==UP && clicked==UP?-1:1, 0, clicked==UP, mouse_over==UP);
		if (mouse_over==UP && clicked==UP)
			skin->draw_arrow(dest, w-12+1, 4+1, 8, 8, TSkin::up, clicked==UP, mouse_over==UP);
		else
			skin->draw_arrow(dest, w-12, 4, 8, 8, TSkin::up, clicked==UP, mouse_over==UP);
		skin->draw_panel(TSkin::pbutton, dest, w-15, h-15, 14, 14, mouse_over==DOWN && clicked==DOWN?-1:1, 0, clicked==DOWN, mouse_over==DOWN);
		if (mouse_over==DOWN && clicked==DOWN)
			skin->draw_arrow(dest, w-12+1, h-12+1, 8, 8, TSkin::down, clicked==DOWN, mouse_over==DOWN);
		else
			skin->draw_arrow(dest, w-12, h-12, 8, 8, TSkin::down, clicked==DOWN, mouse_over==DOWN);
		skin->draw_panel(TSkin::pbutton, dest, w-15, scroll_pos+15, 14, scroll_size, clicked==SCROLL?-1:1, 0, clicked==SCROLL, mouse_over==SCROLL);
	}
}

//##ModelId=3FB2144901D8
void TList::MouseExit()
{
	int old_hotitem = hotitem;
	bool redraw = false;

	hotitem = -1;

	if (mouse_over != NONE)
	{
		redraw = true;
	}
	else if ((clicked == UP && mouse_over == UP) ||
		(clicked == DOWN && mouse_over == DOWN) ||
		(clicked == SCROLL && mouse_over == SCROLL))
	{
		redraw = true;
	}

	mouse_over = NONE;

	if (old_hotitem != hotitem)
	{
		redraw = true;
	}

	if (redraw)	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144901D9
void TList::MouseMove(int x, int y)
{
	int old_hotitem = hotitem;
	int old_selected = selected;
	int old_mouse_over = mouse_over;
	bool redraw = false;

	if (clicked == SCROLL)
	{
		int old_pos = scroll_pos;
		scroll_pos = y-scroll_mouse_pos;
		if (scroll_pos < 0) scroll_pos = 0;
		if (scroll_pos > h-30-scroll_size) scroll_pos = h-30-scroll_size;

		pos = int(0.5+(scroll_pos*double(objects.size()-num_items))/(double(h-30-scroll_size)));

		if (old_pos != scroll_pos)
		{
			redraw = true;
		}
	}

	if (x>0 && y>0 && y<h-1 &&
		((scroll_visible && x<w-17) ||
		(!scroll_visible && x<w-1)))
	{
		if ((clicked == UP && mouse_over == UP) ||
			(clicked == DOWN && mouse_over == DOWN) ||
			(clicked == SCROLL && mouse_over == SCROLL))
		{
			redraw = true;
		}
		mouse_over = LIST;
	}
	else if (scroll_visible && x>w-16 && x<w-1 && y>0 && y<15)
	{
		if ((clicked == UP && mouse_over != UP) ||
			(clicked == SCROLL && mouse_over == SCROLL))
		{
			redraw = true;
		}
		mouse_over = UP;
	}
	else if (scroll_visible && x>w-16 && x<w-1 && y>h-16 && y<h-1)
	{
		if ((clicked == DOWN && mouse_over != DOWN) ||
			(clicked == SCROLL && mouse_over == SCROLL))
		{
			redraw = true;
		}
		mouse_over = DOWN;
	}
	else if (scroll_visible && x>w-16 && x<w-1 && y>14+scroll_pos && y<15+scroll_pos+scroll_size)
	{
		if ((clicked == SCROLL && mouse_over != SCROLL) ||
			(clicked == UP && mouse_over == UP) ||
			(clicked == DOWN && mouse_over == DOWN))
		{
			redraw = true;
		}
		mouse_over = SCROLL;
	}
	else if (scroll_visible && x>w-16 && x<w-1 && y>14 && y<15+scroll_pos)
	{
		if ((clicked == UP && mouse_over == UP) ||
			(clicked == DOWN && mouse_over == DOWN))
		{
			redraw = true;
		}
		mouse_over = PUP;
	}
	else if (scroll_visible && x>w-16 && x<w-1 && y>14+scroll_pos+scroll_size && y<h-14)
	{
		if ((clicked == UP && mouse_over == UP) ||
			(clicked == DOWN && mouse_over == DOWN))
		{
			redraw = true;
		}
		mouse_over = PDOWN;
	}
	else
	{
		if ((clicked == UP && mouse_over == UP) ||
			(clicked == DOWN && mouse_over == DOWN) ||
			(clicked == SCROLL && mouse_over == SCROLL))
		{
			redraw = true;
		}
		mouse_over = NONE;
	}

//	if (clicked == NONE || clicked == LIST)
	if (mouse_over == LIST)
	{
		hotitem = GetHotItem(y);
	}
	else
	{
		hotitem = -1;
	}

	if (clicked == LIST && hotitem != -1)
	{
		if (ItemEnabled(hotitem))
		{
			selected = hotitem;
		}
	}
	
	if (clicked != NONE && clicked != mouse_over)
	{
		mouse_over = NONE;
		hotitem = -1;
		redraw = true;
	}


	if (old_hotitem != hotitem || old_selected != selected || old_mouse_over != mouse_over)
	{
		redraw = true;
	}

	if (old_selected != selected)
	{
		if (OnSelChange)  OnSelChange(this);
	}

	if (redraw)	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144901E2
void TList::MouseUp(int button, int x, int y)
{
	bool redraw = false;

	if (clicked == SCROLL)
	{
		scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
		redraw = true;
	}
	if ((mouse_over == UP || clicked == UP) ||
		(mouse_over == DOWN || clicked == DOWN))
	{
		redraw = true;
	}
	clicked = NONE;

	if (redraw)	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144901EB
void TList::MouseDown(int button, int x, int y)
{
	int ant_sel = selected;
	bool redraw = false;
	bool call_sel_change = false;

	if (mouse_over == LIST)
	{
		clicked = LIST;
		if (hotitem != -1)
		{
			if (ItemEnabled(hotitem))
			{
				selected = hotitem;
				if (ant_sel != selected)
				{
					redraw = true;
					call_sel_change = true;
				}
			}
		}
	}
	if (mouse_over == UP)
	{
		clicked = UP;
		if (pos > 0) pos--;
		scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
		redraw = true;
	}
	if (mouse_over == DOWN)
	{
		clicked = DOWN;
		if (unsigned(num_items) < objects.size()-pos) pos++;
		scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
		redraw = true;
	}
	if (mouse_over == SCROLL)
	{
		clicked = SCROLL;
		scroll_mouse_pos = y-scroll_pos;
		redraw = true;
	}
	if (mouse_over == PUP)
	{
		clicked = PUP;
		pos -= num_items-1;
		if (pos < 0) pos = 0;
		scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
		redraw = true;
	}
	if (mouse_over == PDOWN)
	{
		clicked = PDOWN;
		pos += num_items-1;
		if (pos > signed(objects.size())-num_items) pos = objects.size()-num_items;
		scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
		redraw = true;
	}

	if (redraw)	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	if (call_sel_change && OnSelChange)  OnSelChange(this);
}

//##ModelId=3FB2144901EF
void TList::SetMsgSelChange(void (*OnSelChange)(TList *))
{
	this->OnSelChange = OnSelChange;
}

//##ModelId=3FB2144901F7
void TList::EndMultipleItemInsertion(void)
{
	redraw_on_insert = true;

	if (Initialized())
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB2144901FF
void TList::AddItem(const string &str, const bool enabled, void *data)
{
	list_node node;
	node.str = str;
	node.data = data;
	node.enabled = enabled;
	objects.push_back(node);
	if (objects.size() > unsigned(num_items))
	{
		scroll_size = (num_items*(h-30))/objects.size();
		if (scroll_size < 7) scroll_size = 7;
		scroll_visible = true;
	}
	else
	{
		scroll_size = h-30;
		scroll_visible = false;
	}
	if (Initialized() && redraw_on_insert)
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB214490208
void TList::InsertItem(string &str, int pos, const bool enabled, void *data)
{
}

//##ModelId=3FB21449020D
void TList::DeleteItem(string &str)
{
}

//##ModelId=3FB214490213
void TList::DeleteItem(int pos)
{
}

//##ModelId=3FB214490215
void TList::Vaciar()
{
	selected = -1;
	hotitem = -1;
	pos = 0;
	scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));
	scroll_visible = false;
	objects.clear();
	if (Initialized())
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB21449021F
void TList::SetSel(int p)
{
	selected=p;
	if (Initialized())
	{
		EnsureItemVisible(p);
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB21449021D
int TList::GetSel(void)
{
	return selected;
}

//##ModelId=3FB214490226
string& TList::GetItemText(int index)
{
	int i=0;
	list<list_node>::iterator it;

	it = objects.begin();
	while (i<index) it++, i++;
	return it->str;
}

//##ModelId=3FB214490228
string& TList::GetSelText(void)
{
	int i=0;
	list<list_node>::iterator it;

	it = objects.begin();
	while (i<selected) it++, i++;
	return it->str;
}

//##ModelId=3FB21449022A
void* TList::GetSelData(void)
{
	int i=0;
	list<list_node>::const_iterator it;

	it = objects.begin();
	if (selected >= 0)
	{
		while (i<selected) it++, i++;
		return it->data;
	}

	return NULL;
}

//##ModelId=3FB214490231
void TList::SetSelData(void *data)
{
	int i=0;
	list<list_node>::iterator it;

	it = objects.begin();
	if (selected >= 0)
	{
		while (i<selected) it++, i++;
		it->data = data;
	}
}

//##ModelId=3FB214490258
int TList::GetHotItem(int y)
{
	int hot = -1;

	hot = pos+(y-1)/text_height(skin->get_normal_font());
	if (hot >= signed(objects.size())) hot = -1;

	return hot;
}

//##ModelId=3FB21449023A
void TList::EnableItem(int index)
{
	int i=0;
	list<list_node>::iterator it;

	it = objects.begin();
	if (index >= 0)
	{
		while (i<index && i<=num_items) it++, i++;
		if (i<num_items)
		{
			it->enabled = true;
		}
		if (Initialized())
		{
			GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
		}
	}
}

//##ModelId=3FB21449023C
void TList::EnableItem(char *text)
{
}

//##ModelId=3FB21449023E
void TList::DisableItem(int index)
{
	int i=0;
	list<list_node>::iterator it;

	it = objects.begin();
	if (index >= 0)
	{
		while (i<index && i<=num_items) it++, i++;
		if (i<num_items)
		{
			it->enabled = false;
			if (i==selected) selected = -1;
		}
		if (Initialized())
		{
			GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
		}
	}
}

//##ModelId=3FB214490245
void TList::DisableItem(char *text)
{
}

//##ModelId=3FB21449024F
void TList::Scroll(int p)
{
	if (p>int(objects.size())-num_items) p = int(objects.size())-num_items;
	if (p<0) p=0;

	pos = p;
	scroll_pos = int(0.5+(pos*double(h-30-scroll_size))/(double(objects.size()-num_items)));

	if (Initialized())
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB214490247
void TList::EnsureItemVisible(int index)
{
	if (index >= 0)
	{
		if (index < pos)
		{
			Scroll(index);
		}
		if (index >= pos+num_items)
		{
			Scroll(index-num_items+1);
		}
	}
}

//##ModelId=3FB214490251
bool TList::ItemEnabled(int index)
{
	int i;
	list<list_node>::const_iterator it;

	it = objects.begin();
	i = 0;
	while (i < index)
	{
		it++;
		i++;
	}

	if (i==index && it->enabled)
		return true;
	else
		return false;
}

//##ModelId=3FB214490262
void TList::UpdateData(bool retrieve)
{
	if (variable)
	{
		if (retrieve)
		{
			*variable = selected;
		}
		else
		{
			selected = *variable;
			EnsureItemVisible(selected);
		}
	}
}
