// TDialog.cpp: implementation of the TDialog class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144903D7
TDialog::TDialog(const int x, const int y, const int w, const int h)
:TObject(x, y, w, h), MessageList(10)
{
	ID=-1;
	ObjectCount = 0;
	buffer = NULL;
	ant_mouse_pos = -2;
	ant_mouse_down = -2;
	dest_bitmap = screen;
}

//##ModelId=3FB2144903DF
TDialog::~TDialog()
{

}

//##ModelId=3FB2144903E1
void TDialog::SetBuffer(BITMAP *b)
{
	buffer = b;
}

//##ModelId=3FB2144903C4
void TDialog::Draw(BITMAP *dest)
{
//	int i;
//	for(i=0; i<this->ObjectCount; i++)
//	{
//		SendMessage(i, TMSG_DRAW, 0, 0);
//	}
}

//##ModelId=3FB2144903B9
void TDialog::SendMessage(int ID, int msg, int param1, int param2)
{
	TMessage t;

	t.message = msg;
	t.object_ID = ID;
	t.param1 = param1;
	t.param2 = param2;

	switch(msg)
	{
	case TMSG_INIT:
		MessageList.Push(t, 5);
		break;
	case TMSG_FIRST_DRAW:
		MessageList.Push(t, 8);
		break;
	case TMSG_KEY_DOWN:
		break;
	case TMSG_KEY_UP:
		break;
	case TMSG_KEYPRESS:
		break;
	case TMSG_MOUSEENTER:
	case TMSG_MOUSEEXIT:
	case TMSG_MOUSEMOVE:
	case TMSG_RMOUSEDOWN:
	case TMSG_LMOUSEDOWN:
	case TMSG_MMOUSEDOWN:
	case TMSG_RMOUSEUP:
	case TMSG_LMOUSEUP:
	case TMSG_MMOUSEUP:
	case TMSG_MOUSEWHEEL:
	case TMSG_RMOUSECLICK:
	case TMSG_RMOUSEDBLCLICK:
	case TMSG_LMOUSECLICK:
	case TMSG_LMOUSEDBLCLICK:
	case TMSG_MMOUSECLICK:
	case TMSG_MMOUSEDBLCLICK:
		MessageList.Push(t, 5);
		break;
	case TMSG_GOTFOCUS:
		break;
	case TMSG_LOSTFOCUS:
		break;
	case TMSG_TIMER:
		break;
	case TMSG_DRAW:
		MessageList.Push(t, 8);
		break;
	case TMSG_CLOSE:
		MessageList.Push(t, 5);
		break;
	}

	if (msg >= TMSG_USER)
	{
		MessageList.Push(t, 5);
	}
}

//##ModelId=3FB2144903B0
void TDialog::SendMessage(int msg, int param1, int param2)
{
	TMessage t;
	int i;
	int m_pos;
	TObject *obj;

	t.message = msg;
	t.param1 = param1;
	t.param2 = param2;
	t.object_ID = -1;

	switch(msg)
	{
	case TMSG_INIT:
		MessageList.Push(t, 5);
		UpdateData(false);
		for(i=0; i<ObjectCount; i++)
		{
			SendMessage(i, msg, param1, param2);
		}
		break;
	case TMSG_FIRST_DRAW:
		MessageList.Push(t, 8);
		for(i=0; i<ObjectCount; i++)
		{
			SendMessage(i, msg, param1, param2);
		}
		break;
	case TMSG_KEY_DOWN:
		break;
	case TMSG_KEY_UP:
		break;
	case TMSG_KEYPRESS:
		break;
	case TMSG_MOUSEENTER:
		obj = FindObject(param1, param2);
		if (obj)
		{
			m_pos = obj->GetID();
			if (ant_mouse_down < -1 || m_pos == ant_mouse_down)
			{
				SendMessage(m_pos, TMSG_MOUSEENTER, 0, 0);
			}
		}
		break;
	case TMSG_MOUSEEXIT:
		if (ant_mouse_pos >= 0)
		{
			SendMessage(ant_mouse_pos, TMSG_MOUSEEXIT, 0, 0);
		}
		break;
	case TMSG_MOUSEMOVE:
		obj = FindObject(param1, param2);
		if (obj)
		{
			m_pos = obj->GetID();
//**			textprintf(screen, font, 0, 24, makecol(255,255,255), "pos = %4d, ant_pos = %4d", m_pos, ant_mouse_pos);
			if (m_pos != ant_mouse_pos)
			{
				SendMessage(ant_mouse_pos, TMSG_MOUSEEXIT, 0, 0);
				if (ant_mouse_down < -1 || m_pos == ant_mouse_down)
				{
					SendMessage(m_pos, TMSG_MOUSEENTER, param1-obj->GetPosX(), param2-obj->GetPosY());
				}
			}
			if (ant_mouse_down < -1)
			{
				SendMessage(m_pos, TMSG_MOUSEMOVE, param1-obj->GetPosX(), param2-obj->GetPosY());
			}
			else
			{
				SendMessage(ant_mouse_down, TMSG_MOUSEMOVE, param1-GetObject(ant_mouse_down)->GetPosX(), param2-GetObject(ant_mouse_down)->GetPosY());
			}
			ant_mouse_pos = m_pos;
		}
		MessageList.Push(t, 5);
		break;
	case TMSG_RMOUSEDOWN:
	case TMSG_LMOUSEDOWN:
	case TMSG_MMOUSEDOWN:
		obj = FindObject(param1, param2);
		if (obj)
		{
			SendMessage(obj->GetID(), msg, param1-obj->GetPosX(), param2-obj->GetPosY());
			ant_mouse_down = obj->GetID();
		}
		MessageList.Push(t, 5);
		break;
	case TMSG_RMOUSEUP:
	case TMSG_LMOUSEUP:
	case TMSG_MMOUSEUP:
		MessageList.Push(t, 5);
		if (ant_mouse_down >= 0)
		{
			SendMessage(ant_mouse_down, msg, param1-GetObject(ant_mouse_down)->GetPosX(), param2-GetObject(ant_mouse_down)->GetPosY());
		}
		obj = FindObject(param1, param2);
//		if (obj && ant_mouse_down == obj->GetID())
		if (obj)
		{
			m_pos = obj->GetID();
//			if (m_pos != ant_mouse_pos)
			{
				SendMessage(m_pos, TMSG_MOUSEENTER, param1-obj->GetPosX(), param2-obj->GetPosY());
				SendMessage(m_pos, TMSG_MOUSEMOVE, param1-obj->GetPosX(), param2-obj->GetPosY());
			}
			ant_mouse_pos = m_pos;
		}
		break;
	case TMSG_MOUSEWHEEL:
		MessageList.Push(t, 5);
		obj = FindObject(param1, param2);
		if (obj)
			SendMessage(obj->GetID(), msg, param1-obj->GetPosX(), param2-obj->GetPosY());
		break;
	case TMSG_RMOUSECLICK:
	case TMSG_RMOUSEDBLCLICK:
	case TMSG_LMOUSECLICK:
	case TMSG_LMOUSEDBLCLICK:
	case TMSG_MMOUSECLICK:
	case TMSG_MMOUSEDBLCLICK:
		MessageList.Push(t, 5);
		obj = FindObject(param1, param2);
		if (obj && ant_mouse_down == obj->GetID())
			SendMessage(obj->GetID(), msg, param1-obj->GetPosX(), param2-obj->GetPosY());
		ant_mouse_down = -2;
		break;
	case TMSG_GOTFOCUS:
		break;
	case TMSG_LOSTFOCUS:
		break;
	case TMSG_TIMER:
		break;
	case TMSG_DRAW:
		MessageList.Push(t, 8);
		for(i=0; i<ObjectCount; i++)
		{
			SendMessage(i, msg, param1, param2);
		}
		break;
	case TMSG_CLOSE:
		MessageList.Push(t, 5);
	}

	if (msg >= TMSG_USER)
	{
		MessageList.Push(t, 5);
		for(i=0; i<ObjectCount; i++)
		{
			SendMessage(i, msg, param1, param2);
		}
	}
}

//##ModelId=3FB2144903AD
TObject* TDialog::GetObject(int ID) const
{
	if (ID == -1) return (TObject*)this;
	return Object[ID];
}

//##ModelId=3FB2144903A4
TObject* TDialog::FindObject(int x, int y)
{
	int i;
	TObject *obj = NULL;

	if (this->x<=x && this->y<=y &&
		this->x+this->w-1>= x &&
		this->y+this->h-1>= y)
	{
		obj = this;
	}
	for(i=0; i<ObjectCount; i++)
	{
		if (Object[i]->GetPosX()<=x && Object[i]->GetPosY()<=y &&
			Object[i]->GetPosX()+Object[i]->GetWidth()-1>=x &&
			Object[i]->GetPosY()+Object[i]->GetHeight()-1>=y)
		{
			obj = Object[i];
		}
	}

	return obj;
}

//##ModelId=3FB2144903A3
void TDialog::Do()
{
	do
	{
		DoMessage();
	} 	while (!MessageList.Empty());
}

//##ModelId=3FB2144903A2
bool TDialog::DoMessage()
{
	TMessage *t;
	TObject *obj;
	bool ret = true;
	
	if (MessageList.Empty())
	{
		this->Idle();
		for (int i=0; i<ObjectCount; i++)
		{
			Object[i]->Idle();
		}
		return ret;
	}

	t = MessageList.Top();

	if (t->object_ID == -1)
	{
		obj = this;
	}
	else if (t->object_ID >= 0)
	{
		obj = Object[t->object_ID];
	}
	else obj = NULL;


	if (obj!=NULL)
	{
//**		textprintf(screen, font, 0, 8, makecol(255,255,255), "Enviando mensaje: %4d %3d", obj->GetID(), t->message);
//		if (t->message == TMSG_DRAW || t->message == TMSG_FIRST_DRAW)
//		{
//**			textprintf(screen, font, 0, 16, makecol(255,255,255), "Drawing: %3d", t->message);
//		}
		switch(t->message)
		{
		case TMSG_INIT:
			obj->Init();
			break;
		case TMSG_KEY_DOWN:
			obj->KeyDown(t->param1);
			break;
		case TMSG_KEY_UP:
			obj->KeyUp(t->param1);
			break;
		case TMSG_KEYPRESS:
			obj->KeyPress(t->param1);
			break;
		case TMSG_MOUSEENTER:
			obj->MouseEnter();
			break;
		case TMSG_MOUSEEXIT:
			obj->MouseExit();
			break;
		case TMSG_MOUSEMOVE:
			obj->MouseMove(t->param1, t->param2);
			break;
		case TMSG_RMOUSEDOWN:
			obj->MouseDown(2, t->param1, t->param2);
			break;
		case TMSG_LMOUSEDOWN:
			obj->MouseDown(1, t->param1, t->param2);
			break;
		case TMSG_MMOUSEDOWN:
			obj->MouseDown(3, t->param1, t->param2);
			break;
		case TMSG_RMOUSEUP:
			obj->MouseUp(2, t->param1, t->param2);
			break;
		case TMSG_LMOUSEUP:
			obj->MouseUp(1, t->param1, t->param2);
			break;
		case TMSG_MMOUSEUP:
			obj->MouseUp(3, t->param1, t->param2);
			break;
		case TMSG_MOUSEWHEEL:
			obj->MouseWheel(t->param1);
			break;
		case TMSG_RMOUSECLICK:
			obj->MouseClick(2, t->param1, t->param2);
			break;
		case TMSG_RMOUSEDBLCLICK:
			obj->MouseDblClick(2, t->param1, t->param2);
			break;
		case TMSG_LMOUSECLICK:
			obj->MouseClick(1, t->param1, t->param2);
			break;
		case TMSG_LMOUSEDBLCLICK:
			obj->MouseDblClick(1, t->param1, t->param2);
			break;
		case TMSG_MMOUSECLICK:
			obj->MouseClick(3, t->param1, t->param2);
			break;
		case TMSG_MMOUSEDBLCLICK:
			obj->MouseDblClick(3, t->param1, t->param2);
			break;
		case TMSG_GOTFOCUS:
			obj->GotFocus();
			break;
		case TMSG_LOSTFOCUS:
			obj->LostFocus();
			break;
		case TMSG_TIMER:
			obj->Timer(t->param1);
			break;
		case TMSG_FIRST_DRAW:
			if (buffer)
			{
				acquire_bitmap(buffer);
				obj->FirstDraw(buffer);
				release_bitmap(buffer);
				show_mouse(NULL);
				acquire_bitmap(dest_bitmap);
				blit (buffer, dest_bitmap, 0, 0, obj->GetPosX(), obj->GetPosY(), obj->GetWidth(), obj->GetHeight());
				release_bitmap(dest_bitmap);
				show_mouse(dest_bitmap);
			}
			else
			{
				BITMAP *dest = create_sub_bitmap(dest_bitmap, obj->GetPosX(), obj->GetPosY(), obj->GetWidth(), obj->GetHeight());
				show_mouse(NULL);
				obj->FirstDraw(dest);
				show_mouse(dest_bitmap);
				destroy_bitmap(dest);
			}
			break;
		case TMSG_DRAW:
			if (buffer)
			{
				acquire_bitmap(buffer);
				obj->Draw(buffer);
				release_bitmap(buffer);
				show_mouse(NULL);
				acquire_bitmap(dest_bitmap);
				blit (buffer, dest_bitmap, 0, 0, obj->GetPosX(), obj->GetPosY(), obj->GetWidth(), obj->GetHeight());
				release_bitmap(dest_bitmap);
				show_mouse(dest_bitmap);
			}
			else
			{
				BITMAP *dest = create_sub_bitmap(dest_bitmap, obj->GetPosX(), obj->GetPosY(), obj->GetWidth(), obj->GetHeight());
				show_mouse(NULL);
				obj->Draw(dest);
				show_mouse(dest_bitmap);
				destroy_bitmap(dest);
			}
			break;
		case TMSG_CLOSE:
			ret = false;
			break;
		}
	}

	if (t->message >= TMSG_USER)
	{
		obj->GetCustomMsg(t->message, t->param1, t->param2);
	}
	
	MessageList.Pop();

	return ret;
}

//##ModelId=3FB214490399
int TDialog::AddObject(TObject *obj)
{
	if (ObjectCount >= 2000) return -2;

	Object[ObjectCount] = obj;
	obj->SetID(ObjectCount);
	ObjectCount++;

	obj->SetParent(this);

	return obj->GetID();
}

//##ModelId=3FB214490398
void TDialog::Idle()
{
	if (!MessageList.Empty())
	{
		if (!DoMessage())
		{
			if (parent)
			{
				parent->SendMessage(TMSG_CLOSE, 0, 0);
			}
		}
	}
}

//##ModelId=3FB2144903CA
void TDialog::UpdateData(bool retrieve)
{
	int i;

	for(i=0; i<ObjectCount; i++)
	{
		GetObject(i)->UpdateData(retrieve);
	}
}
