// TCheck.cpp: implementation of the TCheck class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TCheck.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144A008D
TCheck::TCheck(const int x, const int y, const int w, const int h, const string& text)
:TButton(x, y, w, h, text)
{
	value = false;
	variable = NULL;
}

//##ModelId=3FB2144A0098
TCheck::~TCheck()
{
}

//##ModelId=3FB2144A009A
void TCheck::Init()
{
	background = create_bitmap(w, h);
	TObject::Init();
}

//##ModelId=3FB2144A009B
void TCheck::Close()
{
	destroy_bitmap(background);
}

//##ModelId=3FB2144A00AC
void TCheck::MouseClick(int button, int x, int y)
{
	value = !value;
	TButton::MouseClick(button, x, y);
}

//##ModelId=3FB2144A00A1
void TCheck::FirstDraw(BITMAP *dest)
{
	show_mouse(NULL);
	blit (GetParent()->GetDestinationBitmap(), background, x, y, 0, 0, w, h);
	Draw(dest);
}

//##ModelId=3FB2144A00A3
void TCheck::Draw(BITMAP *dest)
{
	int marca;
//	skin->draw_texture(dest, 0, 0, w, h, false);
	blit(background, dest, 0, 0, 0, 0, w, h);
//	rect(dest, 0, (h-10)/2, 10, (h-10)/2+10, 0);
	marca = pushed&&mouse_over ? !value : value;
//	if (marca)
//	{
//		line (dest, 0, (h-10)/2, 10, (h-10)/2+10, 0);
//		line (dest, 10, (h-10)/2, 0, (h-10)/2+10, 0);
//	}
	skin->draw_checkbox(dest, 0, h/2, marca?true:false, mouse_over||pushed);
	skin->print(TSkin::pbackground, dest, 20, 0, w-20, h, text.c_str(), TSkin::aleft, TSkin::tstandard, mouse_over||pushed?TSkin::chover:TSkin::cplain);
}

//##ModelId=3FB2144A00B6
void TCheck::SetCheck(bool check)
{
	value = check;
	if (initialized)
	{
		GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
	}
}

//##ModelId=3FB2144A00B9
bool TCheck::GetCheck() const
{
	return value;
}

//##ModelId=3FB2144A00C2
void TCheck::UpdateData(bool retrieve)
{
	if (variable)
	{
		if (retrieve)
		{
			*variable = value;
		}
		else
		{
			value = *variable;
			if (initialized)
			{
				this->GetParent()->SendMessage(TMSG_DRAW, 0, 0);
			}
		}
	}
}
