// TButton.cpp: implementation of the TButton class.
//
//////////////////////////////////////////////////////////////////////

#include <string>
#include <allegro.h>

using namespace std;

#include "TButton.h"
#include "TDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//##ModelId=3FB2144A0112
TButton::TButton(const int x, const int y, const int w, const int h, const string& text)
:TObject(x, y, w, h)
{
	this->text = text;
	pushed = false;
	mouse_over=false;
	OnButtonClick = NULL;
}

//##ModelId=3FB2144A011C
TButton::~TButton()
{

}

//##ModelId=3FB2144A00FE
void TButton::Draw(BITMAP *dest)
{
	skin->draw_panel(TSkin::pbutton, dest, 0, 0, w, h, mouse_over&&pushed?-1:1, mouse_over&&pushed?1:0, pushed, mouse_over);
	skin->print(TSkin::pbutton, dest, (pushed&&mouse_over?1:0), (pushed&&mouse_over?1:0), w, h, text.c_str(), TSkin::acentre, TSkin::tstandard, mouse_over||pushed?TSkin::chover:TSkin::cplain);
}

//##ModelId=3FB2144A00FD
void TButton::MouseEnter()
{
	mouse_over = true;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144A00FC
void TButton::MouseExit()
{
	mouse_over = false;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144A00F5
void TButton::SetMsgBtnClick(void (*OnButtonClick)(TButton *))
{
	this->OnButtonClick = OnButtonClick;
}

//##ModelId=3FB2144A00F1
void TButton::MouseClick(int button, int x, int y)
{
	if (button == 1 && OnButtonClick != NULL)
	{
		OnButtonClick(this);
	}
}

//##ModelId=3FB2144A0106
void TButton::MouseUp(int button, int x, int y)
{
	pushed = false;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}

//##ModelId=3FB2144A010A
void TButton::MouseDown(int button, int x, int y)
{
	pushed = true;
	GetParent()->SendMessage(ID, TMSG_DRAW, 0, 0);
}
