// TSkin.h: interface for the TSkin class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TSKIN_H__61F54CBC_3606_4725_B4B7_D1B7A163FA23__INCLUDED_)
#define AFX_TSKIN_H__61F54CBC_3606_4725_B4B7_D1B7A163FA23__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//##ModelId=3FB21447033B
class TSkin  
{
public:

	//##ModelId=3FB214480116
	enum font_align {aleft, aright, acentre, ajustify};
	//##ModelId=3FB21448012A
	enum font_type {tstandard, tmonospaced}; 
	//##ModelId=3FB214480148
	enum font_color {cplain, cselected, chover, cgrayed};
	//##ModelId=3FB214480166
	enum panel {pbackground, pbutton, pforeground, pselection, pscrollbar};
	//##ModelId=3FB214480184
	enum direction {up, down, right, left};

	//##ModelId=3FB2144801A2
	struct t_panel
	{
		//##ModelId=3FB2144801AC
		t_panel();

		//##ModelId=3FB2144801AD
		int light_border_color;
		//##ModelId=3FB2144801AE
		int dark_border_color;
		//##ModelId=3FB2144801B6
		int fill_color;
		//##ModelId=3FB2144801C1
		BITMAP *fill_texture;
		//##ModelId=3FB2144801C5
		int text_color;
		//##ModelId=3FB2144801CA
		int hover_light_border_color;
		//##ModelId=3FB2144801CB
		int hover_dark_border_color;
		//##ModelId=3FB2144801CC
		int hover_fill_color;
		//##ModelId=3FB2144801D5
		BITMAP *hover_fill_texture;
		//##ModelId=3FB2144801DE
		int hover_text_color;
		//##ModelId=3FB2144801DF
		int selected_text_color;
		//##ModelId=3FB2144801E8
		int grayed_text_color;
		//##ModelId=3FB2144801F2
		int draw_color;
		//##ModelId=3FB2144801F3
		int draw_hover_color;
		//##ModelId=3FB2144801FC
		int draw_selected_color;
		//##ModelId=3FB2144801FD
		int draw_grayed_color;
	};

	//##ModelId=3FB21447033C
	TSkin();
	//##ModelId=3FB21447033D
	virtual ~TSkin();

	//##ModelId=3FB214470346
	virtual void draw_checkbox (BITMAP *dest, int x, int y, bool checked, bool focused);
	//##ModelId=3FB214470351
	virtual void draw_radio (BITMAP *dest, int x, int y, bool checked, bool focused);

	//##ModelId=3FB21447035B
	virtual void draw_texture (TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, bool focused, bool hover);
	//##ModelId=3FB214470369
	virtual void draw_texture (BITMAP *tex, BITMAP *dest, int x, int y, int w, int h);

	//##ModelId=3FB214470377
	virtual void draw_panel (TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, int alt, int move, bool focused, bool hover);
	//##ModelId=3FB214470387
	virtual void draw_border (TSkin::panel p, BITMAP *dest, int x, int y, int w, int h, int alt, int move, bool focused, bool hover);

	//##ModelId=3FB21447039A
	virtual void TSkin::print(TSkin::panel p, BITMAP *dest, const int x, const int y, const int w, const int h, const char *txt, const font_align align, const font_type type, const font_color color);

	//##ModelId=3FB2144703AD
	virtual void TSkin::draw_arrow(BITMAP *dest, int x, int y, int w, int h, direction dir, bool focused, bool hover);

	//##ModelId=3FB2144703BE
	BITMAP* get_check(void) const {return check;}
	//##ModelId=3FB2144703C1
	BITMAP* get_check_checked(void) const {return check_checked;}
	//##ModelId=3FB2144703C4
	BITMAP* get_check_focused(void) const {return check_focused;}
	//##ModelId=3FB2144703CA
	BITMAP* get_check_checked_focused(void) const {return check_checked_focused;}

	//##ModelId=3FB2144703CD
	BITMAP* get_radio(void) const {return radio;}
	//##ModelId=3FB2144703D4
	BITMAP* get_radio_checked(void) const {return radio_checked;}
	//##ModelId=3FB2144703D7
	BITMAP* get_radio_focused(void) const {return radio_focused;}
	//##ModelId=3FB2144703DE
	BITMAP* get_radio_checked_focused(void) const {return radio_checked_focused;}

	//##ModelId=3FB2144703E1
	FONT* get_normal_font(void) const {return normal_font;}
	//##ModelId=3FB2144703E8
	FONT* get_monospaced_font(void) const {return mono_font;}

	//##ModelId=3FB2144703EB
	void set_check(BITMAP *bmp) {check = bmp;}
	//##ModelId=3FB214480009
	void set_check_checked(BITMAP *bmp) {check_checked = bmp;}
	//##ModelId=3FB21448000B
	void set_check_focused(BITMAP *bmp) {check_focused = bmp;}
	//##ModelId=3FB214480012
	void set_check_checked_focused(BITMAP *bmp) {check_checked_focused = bmp;}

	//##ModelId=3FB214480014
	void set_radio(BITMAP *bmp) {radio = bmp;}
	//##ModelId=3FB21448001C
	void set_radio_checked(BITMAP *bmp) {radio_checked = bmp;}
	//##ModelId=3FB21448001E
	void set_radio_focused(BITMAP *bmp) {radio_focused = bmp;}
	//##ModelId=3FB214480020
	void set_radio_checked_focused(BITMAP *bmp) {radio_checked_focused = bmp;}

	//##ModelId=3FB214480027
	void set_panel_props(enum panel p, t_panel &props);
	//##ModelId=3FB21448002A
	virtual t_panel& get_panel_props(enum panel p);

	//##ModelId=3FB214480032
	void set_normal_font(FONT *f) {normal_font = f;}
	//##ModelId=3FB214480034
	void set_monospaced_font(FONT *f) {mono_font = f;}

protected:
	//##ModelId=3FB21448003C
	BITMAP *check;
	//##ModelId=3FB214480045
	BITMAP *check_checked;
	//##ModelId=3FB21448004F
	BITMAP *check_focused;
	//##ModelId=3FB214480063
	BITMAP *check_checked_focused;

	//##ModelId=3FB21448006D
	BITMAP *radio;
	//##ModelId=3FB214480077
	BITMAP *radio_checked;
	//##ModelId=3FB214480081
	BITMAP *radio_focused;
	//##ModelId=3FB214480095
	BITMAP *radio_checked_focused;

	//##ModelId=3FB21448009F
	FONT* normal_font;
	//##ModelId=3FB2144800A9
	FONT* mono_font;

	//##ModelId=3FB2144800BD
	t_panel background_skin;
	//##ModelId=3FB2144800C7
	t_panel foreground_skin;
	//##ModelId=3FB2144800DB
	t_panel button_skin;
	//##ModelId=3FB2144800E5
	t_panel selection_skin;
	//##ModelId=3FB2144800F9
	t_panel scrollbar_skin;
};

#endif // !defined(AFX_TSKIN_H__61F54CBC_3606_4725_B4B7_D1B7A163FA23__INCLUDED_)
