// TObject.h: interface for the TObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TOBJECT_H__2F5D2C04_4130_4EB7_AB6F_5BCB7F7724A7__INCLUDED_)
#define AFX_TOBJECT_H__2F5D2C04_4130_4EB7_AB6F_5BCB7F7724A7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MsgQueue.h"
#include "TMessage.h"
#include "TSkin.h"

class TDialog;

/** Pure virtual class that defines an object. You may derive a class
from this one to create custom dialog objects.
*/
//##ModelId=3FB214480379
class TObject  
{
public:
	/// Called when TGUI has nothing better to do
	//##ModelId=3FB21448037A
	virtual void Idle();
	/// Called when a time event ocurs on the object
	/**
	\param t
	elapsed time, in miliseconds
	*/
	//##ModelId=3FB214480384
	virtual void Timer(int t);
	/// Called when the object should lose the focus
	/**
	\return
	If the function retuns true, the object will lose the focus.
	TGUI will send a TMSG_DRAW message automatically after the
	focus has changed.
	If it returns false, the object will maintain the focus.
	*/
	//##ModelId=3FB214480387
	virtual bool LostFocus();
	/// Called when the object should get the focus
	/**
	\return
	If the functions returns true, the object accepts the focus.
	TGUI will send a TMSG_DRAW message automatically after the
	focus has changed.
	If it returns false, the object refuses the focus.
	*/
	//##ModelId=3FB21448038D
	virtual bool GotFocus();
	/// Called when a mouse double click event occurs.
	/**
	\param button
	Mouse button: 1 (left), 2 (left) or 3 (middle).
	\param x
	horizontal coordinate, in pixels, of the mouse position at the moment of the
	event (keep in mind that the mouse may have moved since the event
	really take effect until this function is really called).
	\param y
	vertical coordinate, in pixels, od the mouse position.
	*/
	//##ModelId=3FB21448038F
	virtual void MouseDblClick(int button, int x, int y);
	/// Called when a mouse click event occurs.
	/**
	\param button
	Mouse button: 1 (left), 2 (left) or 4 (middle).
	\param x
	horizontal coordinate, in pixels, of the mouse position at the moment of the
	event (keep in mind that the mouse may have moved since the event
	really take effect until this function is really called).
	\param y
	vertical coordinate, in pixels, od the mouse position.
	*/
	//##ModelId=3FB21448039A
	virtual void MouseClick(int button, int x, int y);
	/// Called when the mouse leaves the client area of the object.
	//##ModelId=3FB2144803A3
	virtual void MouseExit();
	/// Called when the mouse enters the client area of the object.
	/**
	Inmediatelly after this, a TMSG_MOUSEMOVE event occurs, so
	MouseMove() is called.
	*/
	//##ModelId=3FB2144803A5
	virtual void MouseEnter();
	/// Called when the mouse moves inside the object client area.
	/**
	\param x
	horizontal coordinate, in pixels, of the mouse position at the moment of the
	event (keep in mind that the mouse may have moved since the event
	really take effect until this function is really called).
	\param y
	vertical coordinate, in pixels, od the mouse position.
	*/
	//##ModelId=3FB2144803AC
	virtual void MouseMove(int x, int y);
	/// Called when the well is moved while the mouse is inside the object client area.
	/**
	\param d
	whell position.
	*/
	//##ModelId=3FB2144803B0
	virtual void MouseWheel(int d);
	/// Called when a mouse button is depressed.
	/**
	\param button
	Mouse button: 1 (left), 2 (left) or 3 (middle).
	\param x
	horizontal coordinate, in pixels, of the mouse position at the moment of the
	event (keep in mind that the mouse may have moved since the event
	really take effect until this function is really called).
	\param y
	vertical coordinate, in pixels, od the mouse position.
	*/
	//##ModelId=3FB2144803B7
	virtual void MouseUp(int button, int x, int y);
	/// Called when a mouse button is pressed
	/**
	\param button
	Mouse button: 1 (left), 2 (left) or 3 (middle).
	\param x
	horizontal coordinate, in pixels, of the mouse position at the moment of the
	event (keep in mind that the mouse may have moved since the event
	really take effect until this function is really called).
	\param y
	vertical coordinate, in pixels, od the mouse position.
	*/
	//##ModelId=3FB2144803C0
	virtual void MouseDown(int button, int x, int y);
	/// Called when a key is pressed
	/**
	\param key
	key in the allegro format
	*/
	//##ModelId=3FB2144803C9
	virtual bool KeyPress(int key);
	/// Called when a key is released
	/**
	\param key
	key in the allegro format
	*/
	//##ModelId=3FB2144803CC
	virtual void KeyUp(int key);
	/// Called when a key is pressed down
	/**
	\param key
	key in the allegro format
	*/
	//##ModelId=3FB2144803D4
	virtual void KeyDown(int key);
	/// Called once at dialog startup.
	/**
	This function is called before any other event handling function
	*/
	//##ModelId=3FB2144803D7
	virtual void Init();
	/// Called once at dialog startup.
	/**
	This function is called after Init() but before any other drawing function
	*/
	//##ModelId=3FB2144803DD
	virtual void FirstDraw(BITMAP *dest);
	/// Called when the object should draw itself.
	/**
	\param dest
	destination bitmap. You should draw entirelly this bitmap.
	*/
	//##ModelId=3FB2144803E0
	virtual void Draw(BITMAP *dest) = 0;
	/// Called when an object should be moved.
	/**
	\param x
	new x coordinate of the object position
	\param y
	new y coordinate of the object position
	*/
	//##ModelId=3FB2144803E8
	virtual void Move(const int x, const int y);
	/// Called when a custom message should be handled.
	/**
	\param msg
	message ID
	\param param1
	first paramteter of the message.
	\param param2
	second parameter of the message.
	*/
	//##ModelId=3FB214490009
	virtual void GetCustomMsg(int msg, int param1, int param2);
	/// Updates the associated variable
	/**
	\param retrieve
	true to update the variable value from the object, false to
	update the object from the variable value.
	*/
	//##ModelId=3FB21449000E
	virtual void UpdateData (bool retrieve) = 0;

	/// Tells if the objects is initialized.
	/**
	\returns
	true if the object is already in an existent dialog, false otherwise.
	*/
	//##ModelId=3FB214490015
	bool Initialized() const;
	//##ModelId=3FB214490017
	int GetHeight() const;
	//##ModelId=3FB21449001E
	int GetWidth() const;
	//##ModelId=3FB214490020
	int GetPosY() const;
	//##ModelId=3FB214490022
	int GetPosX() const;
	//##ModelId=3FB214490028
	void SetID(int ID);
	//##ModelId=3FB21449002A
	int GetID() const;
	//##ModelId=3FB214490031
	void SetGroup(int g);
	//##ModelId=3FB214490033
	int GetGroup() const;
	//##ModelId=3FB21449003B
	void SetParent(TDialog* p);
	//##ModelId=3FB21449003D
	TDialog* GetParent() const;
	//##ModelId=3FB21449003F
	virtual void SetHelpText(const string& str);
	//##ModelId=3FB214490047
	string& GetHelpText();
	//##ModelId=3FB214490048
	virtual void SetText(const string& str);
	//##ModelId=3FB214490050
	string& GetText();
	//##ModelId=3FB214490051
	static void SetSkin(TSkin* s);
	//##ModelId=3FB214490059
	static TSkin* GetSkin();

	//##ModelId=3FB21449005B
	TObject(const int x, const int y, const int w, const int h);
	//##ModelId=3FB214490064
	virtual ~TObject();

	//##ModelId=3FB2144900E6
	friend void TShowDialog(TDialog& d);

protected:
	//##ModelId=3FB214490067
	TDialog* parent;
	//##ModelId=3FB21449007A
	TObject* help_object;
	//##ModelId=3FB214490082
	static TSkin* skin;
	//##ModelId=3FB214490096
	string help_text;
	//##ModelId=3FB2144900A0
	string text;
	//##ModelId=3FB2144900A9
	int h;
	//##ModelId=3FB2144900B3
	int w;
	//##ModelId=3FB2144900BD
	int y;
	//##ModelId=3FB2144900C7
	int x;
	//##ModelId=3FB2144900D1
	int ID;
	//##ModelId=3FB2144900D2
	int group;
	//##ModelId=3FB2144900E5
	bool initialized;
};

#endif // !defined(AFX_TOBJECT_H__2F5D2C04_4130_4EB7_AB6F_5BCB7F7724A7__INCLUDED_)
