// TList.h: interface for the TList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLIST_H__C7E0D81F_7D68_481D_BD98_C006F74F6E95__INCLUDED_)
#define AFX_TLIST_H__C7E0D81F_7D68_481D_BD98_C006F74F6E95__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TObject.h"

//##ModelId=3FB2144901C2
class TList : public TObject  
{
public:
	//##ModelId=3FB2144901C4
	TList(const int x, const int y, const int w, const int h, const string& text);
	//##ModelId=3FB2144901D0
	virtual ~TList();

	//##ModelId=3FB2144901D6
	void Draw(BITMAP *dest);
	//##ModelId=3FB2144901D8
	void MouseExit();
	//##ModelId=3FB2144901D9
	void MouseMove(int x, int y);
	//##ModelId=3FB2144901E2
	void MouseUp(int button, int x, int y);
	//##ModelId=3FB2144901EB
	void MouseDown(int button, int x, int y);

	//##ModelId=3FB2144901EF
	void SetMsgSelChange(void (*OnSelChange)(TList*));

	//##ModelId=3FB2144901F5
	void BeginMultipleItemInsertion(void) {redraw_on_insert = false;}
	//##ModelId=3FB2144901F7
	void EndMultipleItemInsertion(void);
	//##ModelId=3FB2144901FF
	void AddItem(const string &str, const bool enabled = true, void *data = NULL);
	//##ModelId=3FB214490208
	void InsertItem(string &str, int pos, const bool enabled = true, void *data = NULL);
	//##ModelId=3FB21449020D
	void DeleteItem(string &str);
	//##ModelId=3FB214490213
	void DeleteItem(int pos);
	//##ModelId=3FB214490215
	void Vaciar(void);
	//##ModelId=3FB21449021D
	int GetSel(void);
	//##ModelId=3FB21449021F
	void SetSel(int p);
	//##ModelId=3FB214490226
	string& GetItemText(int index);
	//##ModelId=3FB214490228
	string& GetSelText(void);
	//##ModelId=3FB21449022A
	void* GetSelData(void);
	//##ModelId=3FB214490231
	void SetSelData(void *data);

	//##ModelId=3FB21449023A
	void EnableItem(int index);
	//##ModelId=3FB21449023C
	void EnableItem(char *text);
	//##ModelId=3FB21449023E
	void DisableItem(int index);
	//##ModelId=3FB214490245
	void DisableItem(char *text);
	//##ModelId=3FB214490247
	void EnsureItemVisible(int index);
	//##ModelId=3FB21449024F
	void Scroll(int p);

	//##ModelId=3FB214490251
	bool ItemEnabled(int index);

	//##ModelId=3FB214490258
	int GetHotItem(int y);

	//##ModelId=3FB21449025A
	void SetDataVar (int *var) {variable = var;};
	//##ModelId=3FB214490262
	void UpdateData(bool retrieve);

protected:
	//##ModelId=3FB214490264
	void (*OnSelChange)(TList*);

	//##ModelId=3FB2144902DA
	struct list_node {string str; void* data; bool enabled;};
	//##ModelId=3FB214490278
	list<list_node> objects;
	//##ModelId=3FB214490280
	int selected;
	//##ModelId=3FB21449028A
	int hotitem;
	//##ModelId=3FB21449028B
	int pos;
	//##ModelId=3FB214490294
	int num_items;
	//##ModelId=3FB214490295
	int scroll_size;
	//##ModelId=3FB214490296
	int scroll_pos;
	//##ModelId=3FB21449029E
	int scroll_mouse_pos;
	//##ModelId=3FB21449029F
	bool scroll_visible;
	//##ModelId=3FB2144902A8
	int *variable;
	//##ModelId=3FB2144902A9
	bool redraw_on_insert;

	//##ModelId=3FB214490302
	enum click_pos {NONE, LIST, UP, DOWN, PUP, PDOWN, SCROLL};
	//##ModelId=3FB2144902B3
	click_pos clicked;
	//##ModelId=3FB2144902C7
	click_pos mouse_over;
};

#endif // !defined(AFX_TLIST_H__C7E0D81F_7D68_481D_BD98_C006F74F6E95__INCLUDED_)
