// MsgCue.h: interface for the MsgCue class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MSGCUE_H__D768D46C_6CA3_4A20_A4A8_CE079FB5711F__INCLUDED_)
#define AFX_MSGCUE_H__D768D46C_6CA3_4A20_A4A8_CE079FB5711F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//##ModelId=3FB2144A0141
template <class T>
class MsgQueue
{
public:
	//##ModelId=3FB2144A014C
	MsgQueue(int p);
	//##ModelId=3FB2144A0155
	~MsgQueue();
	//##ModelId=3FB2144A0156
	void Push(T v, int p);
	//##ModelId=3FB2144A0159
	T *Top();
	//##ModelId=3FB2144A015F
	bool Empty();
	//##ModelId=3FB2144A0160
	void Pop();

private:
	//##ModelId=3FB2144A017D
	struct Queue
	{
		//##ModelId=3FB2144A0192
		T val;
		//##ModelId=3FB2144A019E
		Queue *next;
	};

	//##ModelId=3FB2144A016A
	Queue **first;
	//##ModelId=3FB2144A0174
	Queue **last;
	//##ModelId=3FB2144A0178
	int MaxPriorities;
};

//##ModelId=3FB2144A014C
template <class T>
MsgQueue<T>::MsgQueue(int p)
{
	MaxPriorities = p;
	if (p<=0) return;

	first = new Queue *[p];
	last = new Queue *[p];

	for(int i=0; i<p; i++)
	{
		first[i] = NULL;
		last[i] = NULL;
	}
}

//##ModelId=3FB2144A0155
template <class T> MsgQueue<T>::~MsgQueue()
{
	if (MaxPriorities<=0) return;

	Queue *q;

	for(int i=0; i<MaxPriorities; i++)
	{
		while (first[i])
		{
			q = first[i]->next;
			delete first[i];
			first[i] = q;
		}
		i++;
	}

	delete [] first;
	delete [] last;
}

//##ModelId=3FB2144A0156
template <class T> void MsgQueue<T>::Push(T v, int p)
{
	if (MaxPriorities<=0) return;

	MsgQueue::Queue *q = new MsgQueue::Queue;

	q->val = v;
	q->next = NULL;
	if (!first[p])
	{
		first[p] = q;
		last[p] = q;
	}
	else
	{
		last[p]->next = q;
		last[p] = q;
	}
}

//##ModelId=3FB2144A0159
template <class T> T *MsgQueue<T>::Top()
{
	int i=0;
	T *ret = NULL;
	bool found = false;

	while (i<MaxPriorities && !found)
	{
		if (first[i] != NULL)
		{
			ret = &first[i]->val;
			found = true;
		}
		i++;
	}

	return ret;
}

//##ModelId=3FB2144A015F
template <class T> bool MsgQueue<T>::Empty()
{
	bool b = true;
	int i=0;

	while (i<MaxPriorities && b)
	{
		if (first[i] != NULL) b = false;
		i++;
	}

	return b;
}

//##ModelId=3FB2144A0160
template <class T> void MsgQueue<T>::Pop()
{
	int i=0;
	bool popped = false;
	Queue *q;

	while (i<MaxPriorities && !popped)
	{
		if (first[i] != NULL)
		{
			q = first[i];
			first[i] = q->next;
			delete q;
			popped = true;
		}
		i++;
	}
}

#endif // !defined(AFX_MSGCUE_H__D768D46C_6CA3_4A20_A4A8_CE079FB5711F__INCLUDED_)
