//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "menu.h"
#include "gfx.h"
#include "jugador.h"
#include "gui.h"
#include "main.h"
#include "config.h"
#include "editor.h"
#include "juego_config.h"
#include "consola.h"
#include "sis_part.h"
#include "musica.h"
#include "tetris.h"
#include "fuentes.h"
#include "globals.h"


BITMAP *fondo_opciones;

void menu_nuevo(BITMAP *fondo)
{
	int fin = 0;
	struct OPC_MENU newgame;

	newgame.fondo = fondo;
	newgame.fuente = menu;
	newgame.num = 7;
	newgame.esc_item = 6;
	newgame.posy[0] = 180;
	newgame.posy[1] = 220;
	newgame.posy[2] = 260;
	newgame.posy[3] = 300;
	newgame.posy[4] = 340;
	newgame.posy[5] = 380;
	newgame.posy[6] = 420;

	do
	{
		sprintf (newgame.menu[0], "%s (1-2)", TEXT_arcade());
		sprintf (newgame.menu[1], "%s (1-4)", TEXT_normal());
		sprintf (newgame.menu[2], "%s (2-4)", TEXT_cooperativo());
		sprintf (newgame.menu[3], "%s (2-4)", TEXT_competitivo());
		sprintf (newgame.menu[4], "%s (2-4)", TEXT_survival());
		sprintf (newgame.menu[5], "%s (2, 4, 8, 16)", TEXT_campeonato());
		sprintf (newgame.menu[6], TEXT_volver());
		newgame.enabled[0] = true;
		newgame.enabled[1] = true;
		newgame.enabled[2] = true;
		newgame.enabled[3] = true;
		newgame.enabled[4] = true;
		newgame.enabled[5] = true;
		newgame.enabled[6] = true;

		switch(mostrar_menu(&newgame))
		{
		case 0:
			no_disponible(fondo);
			break;
		case 1:
			juego_normal(fondo, book);
			break;
		case 2:
			juego_cooperativo(fondo, book);
			break;
		case 3:
			juego_competitivo(fondo, book);
			break;
		case 4:
			no_disponible(fondo);
			break;
		case 5:
			no_disponible(fondo);
			break;
		case 6:
			fin=1;
			break;
		}
	} while (!fin);
}

void menu_jugadores(BITMAP *fondo)
{
	int fin = 0;
	struct OPC_MENU jugadores;

	jugadores.fondo = fondo;
	jugadores.fuente = menu;
	jugadores.num = 6;
	jugadores.esc_item = 5;
	jugadores.posy[0] = 220;
	jugadores.posy[1] = 260;
	jugadores.posy[2] = 300;
	jugadores.posy[3] = 340;
	jugadores.posy[4] = 380;
	jugadores.posy[5] = 420;

	do
	{
		strcpy (jugadores.menu[0], TEXT_nuevo_jug());
		strcpy (jugadores.menu[1], TEXT_info_jug());
		strcpy (jugadores.menu[2], TEXT_eliminar_jug());
		strcpy (jugadores.menu[3], TEXT_importar_jug());
		strcpy (jugadores.menu[4], TEXT_exportar_jug());
		strcpy (jugadores.menu[5], TEXT_volver());
		jugadores.enabled[0] = true;
		jugadores.enabled[1] = num_jug > 0 ? true : false;
		jugadores.enabled[2] = num_jug > 0 ? true : false;
		jugadores.enabled[3] = true;
		jugadores.enabled[4] = num_jug > 0 ? true : false;
		jugadores.enabled[5] = true;

		switch(mostrar_menu(&jugadores))
		{
		case 0:
			if (num_jug < MAX_JUGADORES)
			{
				if (!add_jugador(num_jug, fondo, roman))
				{
					num_jug++;
					guardar_jugadores();
				}
			}
			else
			{
				string ok = TEXT_aceptar();
				pregunta(fondo, roman, 250, 2, "No se pueden aadir ms jugadores.", "Se ha alcanzado el nmero mximo", NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
			break;
		case 1:
			if (num_jug > 0)
			{
				ver_info(fondo, amelia, roman12);
			}
			else
			{
				string ok = TEXT_aceptar();
				string msg = TEXT_q_no_hay_ningun_jug();
				pregunta (fondo, roman, 275, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
			break;
		case 2:
			if (num_jug > 0)
			{
				eliminar_jugador(fondo, roman, book);
				guardar_jugadores();
			}
			else
			{
				string ok = TEXT_aceptar();
				string msg = TEXT_q_no_hay_ningun_jug();
				pregunta (fondo, roman, 275, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
			break;
		case 3:
			if (num_jug < MAX_JUGADORES)
			{
				int ret;
				ret = importar_jugador(num_jug, fondo, roman, book);
				if (!ret)
				{
					num_jug++;
					guardar_jugadores();
				}
			}
			else
			{
				string ok = TEXT_aceptar();
				pregunta(fondo, roman, 250, 2, "No se pueden aadir ms jugadores.", "Se ha alcanzado el nmero mximo", NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
			break;
		case 4:
			if (num_jug > 0)
				exportar_jugador(fondo, roman, book);
			else
			{
				string msg = TEXT_q_no_hay_ningun_jug();
				string ok = TEXT_aceptar();
				pregunta (fondo, roman, 275, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
			break;
		case 5:
			fin=1;
			break;
		}
	} while (!fin);
}

int music_elem, music_num;

volatile int var1=0, var2=0, var3=0;
volatile int event, b1, b2, t1, l1;
volatile int canal[16];
volatile int nota[16];
volatile int volum[16];
int barras[16];
int espectro[32];
int espectro_grande[88];
int peaks[32];
int peaks_grandes[88];
int peak_time[32];
int peak_time_grande[88];

void midi_msg(int msg, int byte1, int byte2)
{
	if ((msg>>4) == 0x09)
	{
/*		if (barras[msg&0x0f]<byte2)
		{
			barras[msg&0x0f]+=15;
			if (barras[msg&0x0f]>byte2) barras[msg&0x0f]=byte2;
		}
*/
		if (byte2>barras[msg&0x0f]) barras[msg&0x0f] = byte2;
		canal[msg&0x0f] = byte2;
		nota[msg&0x0f] = byte1;
//		volum[msg&0x0f] = byte2;
		event = msg;
		b1 = byte1;
		b2 = byte2;
		var1=1;
	}
	if ((msg>>4) == 0x08)
	{
		canal[msg&0x0f] = 0;
		event = msg;
		var1=1;
	}
}
END_OF_FUNCTION(midi_msg);

void midi_meta(int type, const unsigned char *data, int length)
{
	t1 = type;
	l1 = length;
	var2=1;
}
END_OF_FUNCTION(midi_meta);

void midi_sysex(const unsigned char *data, int length)
{
	var3=1;
}
END_OF_FUNCTION(midi_sysex);

int music_change = 1;
volatile float *spectrum;
BITMAP *barra_act;
BITMAP *barra_deact;

BITMAP *barra_grande_act;
BITMAP *barra_grande_deact;

int music_info(int msg)
{
	static int min_modo = 0;
	static int max_modo = 2;
	static int modo = 0;
	static int ant_elem=-1, ant_num=-1;
	static int in1=0, in2=0, in3=0;
	static int intensidad = 0;
	int it = 5;
	int it1 = 5;
	int it2 = 20;
	int it3 = 2;
	int it4 = 5;
	int peak_down_vel = 2;
	static int ant_midi_pos = 0;
	int i;
	static int state = 1;
	float val;
	int song_time;

	switch (cur_music_type)
	{
	case 0:
		min_modo = 0;
		max_modo = 1;
		if (modo > 1) modo = 0;
		break;
	case 1:
		min_modo = 2;
		max_modo = 3;
		if (modo < 2) modo = 2;
		break;
	case 2:
		min_modo = 2;
		max_modo = 3;
		if (modo < 2) modo = 2;
		break;
	}

//	if (music_elem < 0) return 0;

	BITMAP *dst = video.ObtenerPantalla();

	switch (msg)
	{
	case 0:
		switch (cur_music_type)
		{
		case 0:
			if (musica_finalizada()) state = 1;
			if (music_change)
			{
				music_change = 0;
				state=1;
				ant_elem = music_elem;
				ant_num = music_num;
				for (i=0; i<16; i++)
				{
					canal[i] = 0;
					nota[i] = 0;
					volum[i] = 0;
				}
			}

			if (midi_pos != ant_midi_pos) intensidad = 255;
			else if (intensidad > 0) intensidad-=it;
			if (intensidad<0) intensidad=0;

			if (var1)
			{
				var1=0, in1=255;
			}


			for(i=0; i<16; i++)
			{
				if (volum[i]>canal[i])
				{
					volum[i]-=it1;
					if (volum[i]<canal[i]) volum[i]=canal[i];
				}
				if (volum[i]<canal[i])
				{
					volum[i]+=it2;
					if (volum[i]>canal[i]) volum[i]=canal[i];
				}
				if (barras[i]>0)
				{
					barras[i]-=it3;
					if (barras[i]<0) barras[i]=0;
				}
			}

			if (var2) var2=0, in2=255;
			else if (in2 > 0) in2-=it2;
			if (in2 < 0) in2 = 0;

			if (var3) var3=0, in3=255;
			else if (in3 > 0) in3-=it3;
			if (in3 < 0) in3 = 0;

			ant_midi_pos = midi_pos;
			break;
		case 1:
		case 2:
			for(i=0; i<88; i++)
			{
				if (i<32)
				{
					if (espectro[i]>0)
					{
						espectro[i]-=it4;
						if (espectro[i]<0) espectro[i]=0;
					}

 					val = (spectrum[i*2]
						+ spectrum[i*2+1]);
						//+ spectrum[i*3+2]);
						//+ spectrum[i*4+3]);
					val *= 170.0;
					val = MIN(val, 256);
					if (val > espectro[i]) espectro[i] = int(val);
					if (espectro[i] >= peaks[i])
					{
						peaks[i] = espectro[i];
						peak_time[i] = 120;
					}
					peak_time[i]--;
					if (peak_time[i] < 0)
					{
						peak_time[i] = 0;
						peaks[i]-=peak_down_vel;
					}
					if (peaks[i]<0) peaks[i]=0;
				}
				if (espectro_grande[i]>0)
				{
					espectro_grande[i]-=(it4<<1);
					if (espectro_grande[i]<0) espectro_grande[i]=0;
				}

 				val = spectrum[i];
				val *= 512.0;
				val = MIN(val, 512);
				if (val > espectro_grande[i]) espectro_grande[i] = int(val);
				if (espectro_grande[i] >= peaks_grandes[i])
				{
					peaks_grandes[i] = espectro_grande[i];
					peak_time_grande[i] = 120;
				}
				peak_time_grande[i]--;
				if (peak_time_grande[i] < 0)
				{
					peak_time_grande[i] = 0;
					peaks_grandes[i]-=(peak_down_vel<<1);
				}
				if (peaks_grandes[i]<0) peaks_grandes[i]=0;
			}
			break;
		}
	
		break;
		
	case 1:
		if (key[KEY_SPACE])
		{
			if (state)
			{
				midi_pause();
				state=0;
			}
			else
			{
				midi_resume();
				state=1;
			}
			clear_keys();
		}
		if (key[KEY_RIGHT])
		{
			if (modo < max_modo) modo++;
			clear_keys();
		}
		if (key[KEY_LEFT])
		{
			if (modo > min_modo) modo--;
			clear_keys();
		}
		if (modo == 3 && key[KEY_ESC])
		{
			modo = min_modo;
			clear_keys();
		}
		break;

	case 2:
		if (musica_finalizada()) break;
		rectfill (dst, 360, 90, 600, 451, 0);
		rect (dst, 359, 89, 601, 452, makecol(50, 255, 192));
		textout_centre (dst, menu, state?TEXT_musica_reproduciendo():TEXT_musica_pausa(), 480, 110, state?makecol(32, 255, 32):makecol(255, 255, 32));
		textout (dst, roman, TEXT_musica_grupo(), 380, 160, makecol(192, 192, 192));
		textout (dst, roman, music[music_elem].nombre, 390, 190, makecol(255, 255, 255));
		textout (dst, roman, TEXT_musica_nombre(), 380, 230, makecol(192, 192, 192));
		textprintf (dst, roman, 390, 260, makecol(255, 255, 255), "%s", music[music_elem].cancion[music_num].nombre);
//		textprintf (dst, roman, 390, 320, makecol(255, 255, 255), "%d", midi_pos);

	//	circlefill(dst, 460, 340, 10, makecol(intensidad, 0, 0));
	//	circlefill(dst, 430, 370, 10, makecol(in1, 0, 0));
	//	circlefill(dst, 460, 370, 10, makecol(in2, 0, 0));
	//	circlefill(dst, 490, 370, 10, makecol(in3, 0, 0));

		int v1, v2;
		//		static int c1=makecol(0, 191, 255), c2=makecol(0, 63, 91), c3=makecol(255, 0, 0), c4=makecol(91, 0, 0);

		switch (modo)
		{
		case 0:
			for(i=0; i<16;i++)
			{
	//			hsv_to_rgb(0, 1.0, (volum[i])/255.0, &r, &g, &b);
				circlefill(dst, 365+nota[i], 303+i*9, 4, makecol(volum[i], 0, 0));
	//			circlefill(dst, 365+nota[i], 303+i*9, 4, makecol(r, g, b));
			}
			break;
		case 1:
			for(i=0; i<16; i++)
			{
				v1 = 369+i*14;
				v2 = v1+12;
				blit (barra_deact, dst, 0, 0, v1, 446-128, 13, 128);
				blit (barra_act, dst, 0, 128-barras[i]/2, v1, 446-barras[i]/2, 13, barras[i]/2);
			}
			break;
		case 2:
/*			if (fmod_music_stream)
			{
				textprintf(dst, roman12, 370, 300, makecol(255,255,255), "Pos: %d/%d", FSOUND_Stream_GetTime(fmod_music_stream), FSOUND_Stream_GetLengthMs(fmod_music_stream));
			}
*/
			v1 = 369;
			for(i=0; i<32; i++)
			{
				blit (barra_deact, dst, 0, 0, v1, 446-128, 6, 128);
				blit (barra_act, dst, 0, 128-espectro[i]/2, v1, 446-espectro[i]/2, 6, espectro[i]/2);
				blit (barra_act, dst, 0, 128-peaks[i]/2, v1, 446-peaks[i]/2, 6, 2);
				v1+=7;
			}
			break;
		case 3:
			clear_bitmap(dst);
			if (cur_music_type == 2)
			{
				textprintf (dst, book, 20, 20, makecol(255,255,255), "Ttulo: %s", FMUSIC_GetName(fmod_music_module));
				textprintf (dst, book, 20, 40, makecol(255,255,255), "Canales: %d", FMUSIC_GetNumChannels(fmod_music_module));
				textprintf (dst, book, 20, 60, makecol(255,255,255), "Partitura: %d/%d", FMUSIC_GetPattern(fmod_music_module), FMUSIC_GetNumPatterns(fmod_music_module));
				textprintf (dst, book, 20, 80, makecol(255,255,255), "Orden: %d/%d", FMUSIC_GetOrder(fmod_music_module), FMUSIC_GetNumOrders(fmod_music_module));
				textprintf (dst, book, 20, 100, makecol(255,255,255), "Fila: %d/%d", FMUSIC_GetRow(fmod_music_module), FMUSIC_GetPatternLength(fmod_music_module, FMUSIC_GetOrder(fmod_music_module)));
				song_time = FMUSIC_GetTime(fmod_music_module)/1000;
				textprintf (dst, book, 20, 120, makecol(255,255,255), "Tiempo: %2.2d:%2.2d", song_time/60, song_time%60);
			}
			v1 = 13;
			for(i=0; i<88; i++)
			{
				blit (barra_grande_deact, dst, 0, 0, v1, 446-256, 6, 256);
				blit (barra_grande_act, dst, 0, 256-espectro_grande[i]/2, v1, 446-espectro_grande[i]/2, 6, espectro_grande[i]/2);
				blit (barra_grande_act, dst, 0, 256-peaks_grandes[i]/2, v1, 446-peaks_grandes[i]/2, 6, 2);
				v1+=7;
			}
			break;
		}

	/*	for(i=0; i<9; i++)
		{
			textprintf (buffer, font, 400, 380+i*10, makecol(255, 255, 255), "%4x, %4x, %4x", event_list[i], b1_list[i], b2_list[i]);
		}
	*/
		break;
	}
//	textprintf (buffer, font, 500, 360, makecol(255, 255, 255), "*%8x, %d*", t1, l1);

	return (modo != 3 || musica_finalizada());
}

void mostrar_musica(BITMAP *fondo)
{
	char elem[NUM_LISTA_ELEM][100];
	int music_ptr[NUM_LISTA_ELEM];
	int ini_ptr[MAX_MUSICA];
	int i, j, k;
	int n=0;
	FSOUND_DSP_SetActive(FSOUND_DSP_GetFFTUnit(), TRUE);

	static int c1=makecol(0, 191, 255), c2=makecol(0, 63, 91), c3=makecol(255, 0, 0), c4=makecol(91, 0, 0);

	barra_act = video.CrearBitmap(13, 128, Video::hw_blit);
	barra_deact = video.CrearBitmap(13, 128, Video::hw_blit);

	clear_bitmap(barra_act);
	clear_bitmap(barra_deact);

	for(i=1; i<128; i+=2)
	{
		if (i>36)
		{
			hline(barra_act, 0, i, 12, c1);
			hline(barra_deact, 0, i, 12, c2);
		}
		else
		{
			hline(barra_act, 0, i, 12, c3);
			hline(barra_deact, 0, i, 12, c4);
		}
	}

	barra_grande_act = video.CrearBitmap(13, 256, Video::hw_blit);
	barra_grande_deact = video.CrearBitmap(13, 256, Video::hw_blit);

	clear_bitmap(barra_grande_act);
	clear_bitmap(barra_grande_deact);

	for(i=1; i<256; i+=2)
	{
		if (i>72)
		{
			hline(barra_grande_act, 0, i, 12, c1);
			hline(barra_grande_deact, 0, i, 12, c2);
		}
		else
		{
			hline(barra_grande_act, 0, i, 12, c3);
			hline(barra_grande_deact, 0, i, 12, c4);
		}
	}

	spectrum = FSOUND_DSP_GetSpectrum();

	LOCK_FUNCTION(midi_msg);
	LOCK_FUNCTION(midi_meta);
	LOCK_FUNCTION(midi_sysex);

	LOCK_VARIABLE(var1);
	LOCK_VARIABLE(var2);
	LOCK_VARIABLE(var3);
	LOCK_VARIABLE(event);
	LOCK_VARIABLE(b1);
	LOCK_VARIABLE(b2);
	LOCK_VARIABLE(t1);
	LOCK_VARIABLE(l1);
	for(i=0; i<16; i++)
	{
		LOCK_VARIABLE(canal[i]);
		LOCK_VARIABLE(nota[i]);
		LOCK_VARIABLE(volum[i]);
	}

	midi_msg_callback = midi_msg;
	midi_meta_callback = midi_meta;
	midi_sysex_callback = midi_sysex;

	i = 0;
	k = 0;
	while (i<MAX_MUSICA && music[i].datafile[0] != '\0')
	{
		ini_ptr[i] = k;
		for (j=0; j<music[i].count; j++, k++)
		{
			sprintf(elem[k], "%s - %s", music[i].nombre, music[i].cancion[j].nombre);
			music_ptr[k] = i;
		}
		i++;
	}

	parar_musica();
	music_elem = -1;
	music_num = -1;

	while (n>=0)
	{
		n = lista(fondo, 40, 90, 300, 19, book, k, elem, n, music_info);
		if (n>=0)
		{
			music_change = 1;
			reproducir_musica(n, 0);
			music_elem = act_musica_grupo;
			music_num = act_musica_num;
		}
	}
	destroy_bitmap(barra_act);
	destroy_bitmap(barra_deact);
	destroy_bitmap(barra_grande_act);
	destroy_bitmap(barra_grande_deact);
	FSOUND_DSP_SetActive(FSOUND_DSP_GetFFTUnit(), FALSE);
	reproducir_musica(0, 1);
}

void menu_piezas(BITMAP *fondo)
{
	int fin = 0;
	struct OPC_MENU editor;

	editor.fondo = fondo;
	editor.fuente = menu;
	editor.num = 3;
	editor.esc_item = 2;
	editor.posy[0] = 340;
	editor.posy[1] = 380;
	editor.posy[2] = 420;

	do
	{
		strcpy (editor.menu[0], TEXT_nuevo_set_piezas());
		strcpy (editor.menu[1], TEXT_modif_set_piezas());
		strcpy (editor.menu[2], TEXT_volver());
		editor.enabled[0] = true;
		editor.enabled[1] = true;
		editor.enabled[2] = true;

		switch(mostrar_menu(&editor))
		{
		case 0:
			nuevo_set(fondo);
			break;
		case 1:
			modificar_set(fondo);
			break;
		case 2:
			fin=1;
			break;
		}
	} while (!fin);
}

void menu_extras(BITMAP *fondo)
{
	int fin = 0;
	struct OPC_MENU extras;

	extras.fondo = fondo;
	extras.fuente = menu;
	extras.num = 4;
	extras.esc_item = 3;
	extras.posy[0] = 300;
	extras.posy[1] = 340;
	extras.posy[2] = 380;
	extras.posy[3] = 420;

	do
	{
		strcpy (extras.menu[0], TEXT_ext_galeria());
		strcpy (extras.menu[1], TEXT_ext_musica());
		strcpy (extras.menu[2], TEXT_ext_editor_piezas());
		strcpy (extras.menu[3], TEXT_volver());
		extras.enabled[0] = true;
		extras.enabled[1] = true;
		extras.enabled[2] = true;
		extras.enabled[3] = true;

		switch(mostrar_menu(&extras))
		{
		case 0:
			no_disponible(fondo);
			break;
		case 1:
			mostrar_musica(fondo);
			break;
		case 2:
			menu_piezas(fondo);
			break;
		case 3:
			fin=1;
			break;
		}
	} while (!fin);
}

void mostrar_opciones()
{
	int i, j;
	int sel = 0;
	int fin = 0;
	BITMAP *cuadro;
	BITMAP *fondo;
//	BITMAP *aux;
	BITMAP *dest;
	int anim = 0;
	int flecha_pos = 270;
	int ctrl_player = 1;

	cuadro = video.CrearBitmap(360, 225, Video::hw_trans_blit);
	blit (video.ObtenerPaginaVisible(), cuadro, 140, 230, 0, 0, 360, 225);
	video.CopiarABuffers();

	fondo = video.CrearBitmap(360, 225, Video::hw_blit);
	blit (cuadro, fondo, 0, 0, 0, 0, 360, 225);

//	aux = create_bitmap(360, 225);
//	blit ((BITMAP *)tetris[D_TITULO].dat, aux, 0, 0, 0, 0, 360, 225);

	set_trans_blender (0, 0, 0, 192);
	drawing_mode (DRAW_MODE_TRANS, NULL, 0, 0);
	acquire_bitmap(cuadro);
//	rectfill (cuadro, 0, 0, 360, 225, makecol (128, 0, 0));
	draw_trans_sprite(cuadro, fondo_opciones, 0, 0);
	release_bitmap(cuadro);
	drawing_mode (DRAW_MODE_SOLID, NULL, 0, 0);
//	destroy_bitmap(aux);

	counter = 0;
	for (i=0; i<113; )
	{
		while (counter > 0)
		{
			i+=3;
			counter--;
		}
		if (i<113)
		{
			dest = video.ObtenerPantalla();
			video.IniciarSalida();
			blit (cuadro, dest, 0, 112-i, 140, 342-i, 360, i<<1);
			//draw_sprite (buffer, flecha[0], 155-((112-i)*2), flecha_pos);
			video.Actualizar();
		}
	}

	counter = 0;
	clear_keys();
	while (!fin)
	{
		while (!keypressed())
		{
			dest = video.ObtenerPantalla();
			video.IniciarSalida();
			blit (cuadro, dest, 0, 0, 140, 230, 360, 225);
			textout_centre (dest, comic16, TEXT_opciones_tit(), 320, 240, makecol (96, 192, 255));
			textout (dest, roman, TEXT_opc_idioma(), 245, 290, makecol(255, 255, 255));
			textout (dest, roman, TEXT_language_name(), 375, 290, makecol(0, 255, 96));
			textout (dest, roman, TEXT_opc_volfx(), 245, 320, makecol(255, 255, 255));
			textout (dest, roman, TEXT_opc_volmus(), 245, 350, makecol(255, 255, 255));
			textprintf (dest, roman, 245, 380, makecol(255,255,255), TEXT_opc_ctrl_jug(ctrl_player));
			textout (dest, roman, TEXT_volver(), 245, 410, makecol(255, 255, 255));

			for (i=0, j=0; i<255; i+=5, j+=2)
			{
				if (volfx > i)
				{
					line (dest, 375+j, 325, 375+j, 335, makecol(0, 255, 96));
				}
				else
				{
					line (dest, 375+j, 325, 375+j, 335, makecol(0, 128, 48));
				}
				if (volmus > i)
				{
					line (dest, 375+j, 355, 375+j, 365, makecol(0, 255, 96));
				}
				else
				{
					line (dest, 375+j, 355, 375+j, 365, makecol(0, 128, 48));
				}
			}

			draw_sprite (dest, flecha[anim], 155, flecha_pos);
			video.Actualizar();
			while (counter > 0)
			{
				if (flecha_pos < 270 + sel*30)
				{
					flecha_pos += 6;
				}
				if (flecha_pos > 270 + sel*30)
				{
					flecha_pos -= 6;
				}
				anim++;
				if (anim > 59) anim = 0;
				counter--;
			}
		}
		if ( key[KEY_RIGHT] )
		{
			switch (sel)
			{
			case 0:
//				idioma++;
//				if (idioma >= MI) idioma = MI-1;
				break;
			case 1:
				volfx+=5;
				if (volfx > 255) volfx = 255;
				set_volume (volfx, volmus);
				FSOUND_SetSFXMasterVolume(volfx);
				if (fmod_music_module)
				{
					FMUSIC_SetMasterVolume(fmod_music_module, volfx);
				}
				break;
			case 2:
				volmus+=5;
				if (volmus > 255) volmus = 255;
				set_volume (volfx, volmus);
				break;
			case 3:
				ctrl_player++;
				if (ctrl_player > 4) ctrl_player = 4;
			}
		}
		if ( key[KEY_LEFT] )
		{
			switch (sel)
			{
			case 0:
//				idioma--;
//				if (idioma < 0) idioma = 0;
				break;
			case 1:
				volfx-=5;
				if (volfx < 0) volfx = 0;
				set_volume (volfx, volmus);
				FSOUND_SetSFXMasterVolume(volfx);
				if (fmod_music_module)
				{
					FMUSIC_SetMasterVolume(fmod_music_module, volfx);
				}
				break;
			case 2:
				volmus-=5;
				if (volmus < 0) volmus = 0;
				set_volume (volfx, volmus);
				break;
			case 3:
				ctrl_player--;
				if (ctrl_player < 1) ctrl_player = 1;
			}
		}
		if ( key[KEY_UP] && flecha_pos == 270 + sel*30)
		{
			if (sel > 0)
			{
				sel--;
				//flecha_pos = 270 + sel*30;
			}
		}
		if ( key[KEY_DOWN] && flecha_pos == 270 + sel*30)
		{
			if (sel < 4)
			{
				sel++;
				//flecha_pos = 270 + sel*30;
			}
		}
		if ( key[KEY_ENTER] )
		{
			switch(sel)
			{
			case 3:
				config_controles (cuadro, ctrl_player);
				break;
			case 4:
				fin = 1;
				break;
			}
		}
		if ( key[KEY_ESC] )
		{
			fin = 1;
		}
		clear_keys();
	}

	counter = 0;
	for (i=0; i<113; )
	{
		while (counter > 0)
		{
			i+=3;
			counter--;
		}
		if (i<113)
		{
			dest = video.ObtenerPantalla();
			video.IniciarSalida();
			blit (fondo, dest, 0, 0, 140, 230, 360, i);
			blit (fondo, dest, 0, 225-i, 140, 455-i, 360, i);
			video.Actualizar();
		}
	}

	destroy_bitmap (cuadro);
	destroy_bitmap (fondo);

	guardar_configuracion();
}

void mostrar_creditos(BITMAP *fondo)
{
	BITMAP *dest = video.ObtenerPantalla();

	video.IniciarSalida();
	blit (fondo, dest, 0, 0, 0, 0, 640, 480);
	dibujar_recuadro_trans(dest, 80, 40, 560, 450, 192);

	textprintf_centre(dest, comic16, 320, 50, makecol(200, 200, 255), "Tetris Unlimited v%d.%d.%d build %s", TVER_MAYOR, TVER_MINOR, TVER_SUB, __DATE__);

	textout_centre(dest, roman12, TEXT_creditos_programado_por(), 320, 90, makecol(255, 100, 100));
	textout_centre(dest, roman12, "scar Giner", 320, 110, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_graficos(), 320, 140, makecol(255, 100, 100));
	textout_centre(dest, roman12, "scar Giner", 320, 160, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_musica(), 320, 190, makecol(255, 100, 100));
	textout_centre(dest, roman12, TEXT_creditos_versiones_de_musicas_de_rpg(), 320, 210, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_agradecimientos(), 320, 240, makecol(255, 100, 100));
	textout_centre(dest, roman12, TEXT_creditos_y_otra_mucha_gente_por("Shawn Hargreaves", "Allegro"), 320, 260, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_por("Peter Wang", "Loadpng"), 320, 280, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_por("Doug Eleveld", "Allegttf"), 320, 300, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_por("Firelight Technologies", "fmod"), 320, 320, makecol(255, 255, 255));
	textout_centre(dest, roman12, TEXT_creditos_por("Markus F.X.J. Oberhumer & Laszlo Molnar", "UPX"), 320, 340, makecol(255, 255, 255));

	textout_centre(dest, roman12, "http://www.oginer.tk", 320, 380, makecol(255, 255, 100));
	textout_centre(dest, roman12, TEXT_creditos_si_tienes_alguna_sugerencia_duda_o_problema(), 320, 400, makecol(255, 255, 100));
	textout_centre(dest, roman12, "o_giner@hotmail.com", 320, 420, makecol(255, 255, 100));

	video.Actualizar();
	
	clear_keybuf();
	while (!keypressed() && !key[KEY_ESC] && !key[KEY_ENTER]);
}

void titulo(void)
{
	BITMAP *fondo_tit, *fondo;
	//	int col = makecol(255,255,255);

	con_nueva_linea(consola_main, BLANCO);
	con_escribir(consola_main, "Cargando grficos de mens");

	fondo_tit = video.CargarPng(path_data + "/tetris.dat#titulo", Video::hw_blit);

	if (!fondo_tit)
	{
		TEXTO();
		allegro_message("Error al cargar imagen de titulo");
		exit(-1);
	}
	
	fondo = video.CrearBitmap(SCREEN_W, SCREEN_H, Video::hw_blit);

	if (!fondo)
	{
		TEXTO();
		allegro_message("Error al crear fondo");
		exit(-1);
	}

	blit(fondo_tit, fondo, 0, 0, 0, 0, 640, 480);

	textprintf(fondo, small_font, 595, 460, makecol(255,255,255), "v%d.%d.%d", TVER_MAYOR, TVER_MINOR, TVER_SUB);

	fondo_opciones = video.CargarPng(path_data + "/tetris.dat#opciones", Video::hw_blit);

	brillo_bmp = video.CargarPng(path_data + "/tetris.dat#brillo2_png", Video::hw_blit);

	con_escribir(consola_main, " - OK");

	clear_keys();

	transicion_lineas(fondo, 5);

	int i;
	for (i=0; i<32; i++)
	{
		espectro[i] = 0;
		peaks[i] = 0;
	}

//	menu_piezas(fondo);
	
	struct OPC_MENU titulo;

	titulo.esc_item=6;
	titulo.fondo = fondo;
	titulo.fuente = menu;
	titulo.num=7;
	titulo.posy[0] = 180;
	titulo.posy[1] = 220;
	titulo.posy[2] = 260;
	titulo.posy[3] = 300;
	titulo.posy[4] = 340;
	titulo.posy[5] = 380;
	titulo.posy[6] = 420;

	video.RepintarFondo();

	int fin = 0;
	do
	{
		strcpy (titulo.menu[0], TEXT_juego_nuevo());
		strcpy (titulo.menu[1], TEXT_jugadores());
		strcpy (titulo.menu[2], TEXT_records());
		strcpy (titulo.menu[3], TEXT_opciones());
		strcpy (titulo.menu[4], TEXT_extras());
		strcpy (titulo.menu[5], TEXT_creditos());
		strcpy (titulo.menu[6], TEXT_salir());
		titulo.enabled[0] = true;
		titulo.enabled[1] = true;
		titulo.enabled[2] = true;
		titulo.enabled[3] = true;
		titulo.enabled[4] = true;
		titulo.enabled[5] = true;
		titulo.enabled[6] = true;

		switch (mostrar_menu(&titulo))
		{
		case 0:
			menu_nuevo(fondo);
			break;
		case 1:
			menu_jugadores(fondo);
			break;
		case 2:
			no_disponible(fondo);
			break;
		case 3:
			video.IniciarSalida();
			blit (fondo, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
			video.Actualizar();
			mostrar_opciones();
			guardar_configuracion();
			break;
		case 4:
			menu_extras(fondo);
			break;
		case 5:
			mostrar_creditos(fondo);
			break;
		case 6:
			guardar_jugadores();
			fin = 1;
			break;
		}
	}while(!fin);

	video.Finalizar();

	parar_musica();
}
