//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#define _SYS_PART_CPP_

#include "stdafx.h"

#include "defines.h"
#include "gfx.h"
#include "sis_part.h"


//##ModelId=3FB2143F0380
SistemaDeParticulas::SistemaDeParticulas()
:brillo_bmp(NULL),
part_qual(3),
suelo(0),
g(1),
posx(0),
posy(0),
posx_var(0),
posy_var(0),
vel(0.0),
velocidad_var(0),
vida(100),
fade_out(50),
angulo_max(0.0),
angulo_min(0.0),
frecuencia(0),
cantidad(1),
num_botes(0),
col(0),
nuevas(false)
{
	for(int i=0; i<MAX_PART; i++)
	{
		particulas[i].brillo_color = NULL;
	}
}

//##ModelId=3FB2143F0381
SistemaDeParticulas::SistemaDeParticulas(int calidad,
	double suelo,
	double gravedad,
	double x,
	double y,
	unsigned posx_var,
	unsigned posy_var,
	unsigned velocidad_var,
	unsigned vida,
	unsigned fade_out,
	float angulo_max,
	float angulo_min,
	unsigned frecuencia,
	unsigned cantidad)
:brillo_bmp(NULL),
part_qual(calidad),
suelo(suelo),
g(gravedad),
posx(x),
posy(y),
posx_var(posx_var),
posy_var(posy_var),
vel(0),
velocidad_var(velocidad_var),
vida(vida),
fade_out(fade_out),
angulo_max(angulo_max),
angulo_min(angulo_min),
frecuencia(frecuencia),
cantidad(cantidad),
num_botes(0),
col(0),
nuevas(false)
{
	for(int i=0; i<MAX_PART; i++)
	{
		particulas[i].brillo_color = NULL;
	}
}

//##ModelId=3FB2143F0397
SistemaDeParticulas::~SistemaDeParticulas()
{
	int i;

	if (part_qual == 5)
	{
		for(i=0; i<MAX_PART; i++)
		{
			if (particulas[i].brillo_color)
			{
				destroy_bitmap(particulas[i].brillo_color);
			}
		}

		if (brillo_bmp)
		{
			destroy_bitmap(brillo_bmp);
		}
	}
}

//##ModelId=3FB2143F0399
void SistemaDeParticulas::Iniciar(BITMAP *brillo)
{
	int i;

	n = 0;
	t = 0;
	for(i=0; i<MAX_PART; i++)
	{
		particulas[i].visible = false;
	}

	if (part_qual == 5)
	{
		if (brillo_bmp)
		{
			destroy_bitmap(brillo_bmp);
		}
		brillo_bmp = create_bitmap(brillo->w, brillo->h);
		blit (brillo, brillo_bmp, 0, 0, 0, 0, brillo->w, brillo->h);

		for(i=0; i<MAX_PART; i++)
		{
			if (!particulas[i].brillo_color)
			{
				particulas[i].brillo_color = create_bitmap(brillo_bmp->w, brillo_bmp->h);
			}
		}
	}
}

//##ModelId=3FB214400011
void SistemaDeParticulas::NuevaParticula (double vel, int col)
{
	int i;

	if (n == MAX_PART) n = 0;

	particulas[n].visible = true;
	particulas[n].col = col;
	particulas[n].num_botes = 0;
	particulas[n].vida = 0;

	double angulo = angulo_min+(rand()%int((angulo_max-angulo_min)*50+1))/50.0;
	
	particulas[n].posx = posx+posx_var-(rand()%(posx_var*2+1));
	particulas[n].posy = posy+posy_var-(rand()%(posy_var*2+1));
	for(i=0; i<PART_ANT; i++)
	{
		particulas[n].ant_posx[i] = particulas[n].posx;
		particulas[n].ant_posy[i] = particulas[n].posy;
	}
	particulas[n].velx = vel*cos(angulo*PI/180);
	particulas[n].vely = vel*sin(angulo*PI/180);

	if (part_qual == 5)
	{
		clear_to_color(particulas[n].brillo_color, particulas[n].col);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		set_multiply_blender(0, 0, 0, 255);
		draw_trans_sprite(particulas[n].brillo_color, brillo_bmp, 0, 0);
		solid_mode();
	}

	n++;
}

//##ModelId=3FB2143F039F
void SistemaDeParticulas::Ciclo ()
{
	unsigned i, j;

	//	p->freq += cantidad_part;

	if (nuevas)
	{
		if (t==0)
		{
			for(i=0; i<cantidad; i++)
			{
				NuevaParticula(vel+velocidad_var-(rand()%((velocidad_var*2+1)*100)/100.0), col);
			}
			t=frecuencia;
		}
		else
		{
			t--;
		}
	}

	for (i=0; i<MAX_PART; i++)
	{
		if (particulas[i].visible)
		{
			for(j=PART_ANT-1; j>0; j--)
			{
				particulas[i].ant_posx[j] = particulas[i].ant_posx[j-1];
				particulas[i].ant_posy[j] = particulas[i].ant_posy[j-1];
			}
			particulas[i].ant_posx[0] = particulas[i].posx;
			particulas[i].ant_posy[0] = particulas[i].posy;
			if (particulas[i].posy < -50 ||
				particulas[i].posy > SCREEN_H+50 ||
				particulas[i].posx < -50 ||
				particulas[i].posx > SCREEN_W+50)
			{
				particulas[i].visible = false;
			}
			if (particulas[i].posy > suelo && particulas[i].vely > 0)
			{
				//p->p[i].posy = 475;
				if (particulas[i].num_botes < num_botes)
				{
					particulas[i].vely /= -2.0;
					particulas[i].velx /= 2.0;
					particulas[i].num_botes++;
				}
			}
			if (vida > 0)
			{
				if (particulas[i].vida > vida)
				{
					particulas[i].visible = false;
				}
			}
			particulas[i].posx += particulas[i].velx;
			particulas[i].posy += particulas[i].vely;
			particulas[i].vely += g;
			particulas[i].vida++;
		}
	}
}

//##ModelId=3FB21440001A
void SistemaDeParticulas::draw_pixel(BITMAP *dest, int x, int y, int c, float t, double trans)
{
	int a = int(256*(1-t*t));

	if (a<0) a=0;
	if (a>255) a=255;

	set_trans_blender(0, 0, 0, (int)(a*trans));

	putpixel(dest, x, y, c);
}

//##ModelId=3FB214400026
void SistemaDeParticulas::draw_pixel_add(BITMAP *dest, int x, int y, int c, float t, double trans)
{
	int a = int(256*(1-t*t));

	if (a<0) a=0;
	if (a>255) a=255;

	set_add_blender(0, 0, 0, (int)(a*trans));

	putpixel(dest, x, y, c);
}

//##ModelId=3FB214400033
void SistemaDeParticulas::aaline (BITMAP *dest, int x0, int y0, int x1, int y1, int c, double trans, int add_blender)
{

    int dx = x1-x0;
    int dy = y1-y0;

	//int addr = (y0*640+x0)*4;
	int x=x0;
	int y=y0;

	int du;
	int dv;
	int u;
	int v;
	//int vincr, uincr;
	int x_vincr, y_vincr, x_uincr, y_uincr;

    int uend;
    int d;	    /* Initial value as in Bresenham's */
    int incrS;	/* ?d for straight increments */
    int incrD;	/* ?d for diagonal increments */
    int twovdu;	/* Numerator of distance; starts at 0 */
    double invD;   /* Precomputed inverse denominator */
    double invD2du;   /* Precomputed constant */

    /* By switching to (u,v), we combine all eight octants */
    if (abs(dx) > abs(dy))
    {
		/* Note: If this were actual C, these integers would be lost
		 * at the closing brace.  That's not what I mean to do.  Do what
		 * I mean. */
		du = abs(dx);
		dv = abs(dy);
		u = x1;
		v = y1;
//		uincr = 4;
//		vincr = 640*4;
		x_uincr = 1;
		x_vincr = 0;
		y_uincr = 0;
		y_vincr = 1;
		if (dx < 0)
		{
			//uincr = -uincr;
			x_uincr = -x_uincr;
			y_uincr = -y_uincr;
		}
		if (dy < 0)
		{
			//vincr = -vincr;
			x_vincr = -x_vincr;
			y_vincr = -y_vincr;
		}
	}
	else
	{
		du = abs(dy);
		dv = abs(dx);
		u = y1;
		v = x1;
		//uincr = 640*4;
		//vincr = 4;
		x_uincr = 0;
		x_vincr = 1;
		y_uincr = 1;
		y_vincr = 0;
		if (dy < 0)
		{
			//uincr = -uincr;
			x_uincr = -x_uincr;
			y_uincr = -y_uincr;
		}
		if (dx < 0)
		{
			//vincr = -vincr;
			x_vincr = -x_vincr;
			y_vincr = -y_vincr;
		}
	}

    uend = u + du;
    d = (2 * dv) - du;	    /* Initial value as in Bresenham's */
    incrS = 2 * dv;	/* ?d for straight increments */
    incrD = 2 * (dv - du);	/* ?d for diagonal increments */
    twovdu = 0;	/* Numerator of distance; starts at 0 */
    invD = 1.0 / (2.0*sqrt(double(du*du + dv*dv)));   /* Precomputed inverse denominator */
    invD2du = 2.0 * (du*invD);   /* Precomputed constant */

    do
    {
		/* Note: this pseudocode doesn't ensure that the address is
		 * valid, or that it even represents a pixel on the same side of
		 * the screen as the adjacent pixel */
		if (add_blender)
		{
			draw_pixel_add(dest, x, y, c, twovdu*invD, trans);
			draw_pixel_add(dest, x+x_vincr, y+y_vincr, c, invD2du - twovdu*invD, trans);
			draw_pixel_add(dest, x-x_vincr, y-y_vincr, c, invD2du + twovdu*invD, trans);
		}
		else
		{
			draw_pixel(dest, x, y, c, twovdu*invD, trans);
			draw_pixel(dest, x+x_vincr, y+y_vincr, c, invD2du - twovdu*invD, trans);
			draw_pixel(dest, x-x_vincr, y-y_vincr, c, invD2du + twovdu*invD, trans);
		}

		//draw_pixel(dest, (addr/4)%640, (addr/4)/640, c, twovdu*invD);
		//draw_pixel(dest, ((addr+vincr)/4)%640, ((addr+vincr)/4)/640, c, invD2du - twovdu*invD);
		//draw_pixel(dest, ((addr-vincr)/4)%640, ((addr-vincr)/4)/640, c, invD2du + twovdu*invD);

		if (d < 0)
		{
			/* choose straight (u direction) */
			twovdu = d + du;
			d = d + incrS;
		}
		else
		{
			/* choose diagonal (u+v direction) */
			twovdu = d - du;
			d = d + incrD;
			v = v+1;
			x+=x_vincr;
			y+=y_vincr;
			//addr = addr + vincr;
		}
		u = u+1;
		x+=x_uincr;
		y+=y_uincr;
		//addr = addr + uincr;
    } while (u < uend);
}

//##ModelId=3FB2143F03A0
void SistemaDeParticulas::Dibujar(BITMAP *bmp)
{
	int i;
	int k = fade_out;
	int v = vida;

	switch (part_qual)
	{
	case 5:
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		for (i=0; i<MAX_PART; i++)
		{
			if (particulas[i].visible)
			{
				int t = 255;
				if (k>0 && particulas[i].vida > k)
				{
					t = ((v-particulas[i].vida)*255) / (v-k);
					if (t<0) t=0;
					if (t>255) t=255;
				}
				aaline(bmp, int(particulas[i].posx)-1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx)+1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx), int(particulas[i].posy)-1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx), int(particulas[i].posy)+1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
			}
		}
		for (i=0; i<MAX_PART; i++)
		{
			int t2 = ((v-particulas[i].vida)*255) / (v-k);
			if (t2<0) t2=0;
			if (t2>255) t2=255;
			if (particulas[i].visible)
			{
				int t=255;
				for(int j=0; j<PART_ANT-1; j++)
				{
					t-=PART_TRAIL_DEC;
					if (t<0) t=0;
					if (t>255) t=255;
				
					aaline(bmp, int(particulas[i].ant_posx[j]), int(particulas[i].ant_posy[j]), int(particulas[i].ant_posx[j+1]), int(particulas[i].ant_posy[j+1]), particulas[i].col, t*t2/(255.0*255.0), 1);
				}
			}
		}
//		set_alpha_blender();
		for (i=0; i<MAX_PART; i++)
		{
			if (particulas[i].visible)
			{
				int t = 255;
				if (k>0 && particulas[i].vida > k)
				{
					t = ((v-particulas[i].vida)*255) / (v-k);
					if (t<0) t=0;
					if (t>255) t=255;
				}
				fblend_add(particulas[i].brillo_color, bmp, int(particulas[i].posx)-(brillo_bmp->w>>1), int(particulas[i].posy)-(brillo_bmp->h>>1), t>>1);
//				set_add_blender(0, 0, 0, t>>1);
//				draw_trans_sprite(bmp, particulas[i].brillo_color, int(particulas[i].posx)-(brillo_bmp->w>>1), int(particulas[i].posy)-(brillo_bmp->h>>1));
//				solid_mode();
			}
		}
		solid_mode();
		break;
	case 4:
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		for (i=0; i<MAX_PART; i++)
		{
			if (particulas[i].visible)
			{
				int t = 255;
				if (k>0 && particulas[i].vida > k)
				{
					t = ((v-particulas[i].vida)*255) / (v-k);
					if (t<0) t=0;
					if (t>255) t=255;
				}
				aaline(bmp, int(particulas[i].posx)-1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx)+1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx), int(particulas[i].posy)-1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
				aaline(bmp, int(particulas[i].posx), int(particulas[i].posy)+1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col, t/255.0, 1);
			}
		}
		for (i=0; i<MAX_PART; i++)
		{
			int t2 = ((v-particulas[i].vida)*255) / (v-k);
			if (t2<0) t2=0;
			if (t2>255) t2=255;
			if (particulas[i].visible)
			{
				int t=255;
				for(int j=0; j<PART_ANT-1; j++)
				{
					t-=PART_TRAIL_DEC;
					if (t<0) t=0;
					if (t>255) t=255;
				
					aaline(bmp, int(particulas[i].ant_posx[j]), int(particulas[i].ant_posy[j]), int(particulas[i].ant_posx[j+1]), int(particulas[i].ant_posy[j+1]), particulas[i].col, t*t2/(255.0*255.0), 1);
				}
			}
		}
		solid_mode();
		break;
	case 3:
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		for (i=0; i<MAX_PART; i++)
		{
			int t2 = ((v-particulas[i].vida)*255) / (v-k);
			if (t2<0) t2=0;
			if (t2>255) t2=255;
			if (particulas[i].visible)
			{
				int t=255;
				for(int j=0; j<PART_ANT-1; j++)
				{
					t-=PART_TRAIL_DEC;
					if (t<0) t=0;
					if (t>255) t=255;
				
					set_trans_blender(255, 255, 255, t*t2/255);
					line(bmp, int(particulas[i].ant_posx[j]), int(particulas[i].ant_posy[j]), int(particulas[i].ant_posx[j+1]), int(particulas[i].ant_posy[j+1]), particulas[i].col);
				}
			}
		}
		solid_mode();
	case 2:
		for (i=0; i<MAX_PART; i++)
		{
			if (particulas[i].visible)
			{
				if (k>0 && particulas[i].vida > k)
				{
					drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
					int tr = ((v-particulas[i].vida)*255) / (v-k);
					if (tr<0) tr=0;
					if (tr>255) tr=255;
					set_trans_blender(255, 255, 255, tr);
				}
				line(bmp, int(particulas[i].posx)-1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col);
				line(bmp, int(particulas[i].posx)+1, int(particulas[i].posy), int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col);
				line(bmp, int(particulas[i].posx), int(particulas[i].posy)-1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col);
				line(bmp, int(particulas[i].posx), int(particulas[i].posy)+1, int(particulas[i].ant_posx[0]), int(particulas[i].ant_posy[0]), particulas[i].col);
				solid_mode();
			}
		}
		break;
	case 1:
		for (i=0; i<MAX_PART; i++)
		{
			if (particulas[i].visible)
			{
				rectfill(bmp, int(particulas[i].posx)-1, int(particulas[i].posy)-1, int(particulas[i].posx)+1, int(particulas[i].posy)+1, particulas[i].col);
			}
		}
		break;
	}
}
