//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include <stdafx.h>

#include "defines.h"
#include "consola.h"
#include "musica.h"
#include "globals.h"

static int fmod_music_stream_is_playing = 0;

void parar_musica(void)
{
	stop_midi();
	if (fmod_music_stream != NULL)
	{
		FSOUND_Stream_Stop(fmod_music_stream);
		FSOUND_Stream_Close(fmod_music_stream);
		fmod_music_stream = NULL;
		fmod_music_stream_is_playing = 0;
	}
	if (fmod_music_module != NULL)
	{
		FMUSIC_StopSong(fmod_music_module);
		FMUSIC_FreeSong(fmod_music_module);
		fmod_music_module = NULL;
	}

	if (cur_music != NULL)
	{
		con_nueva_linea(consola, BLANCO);
		con_escribir(consola, "Cancion liberada: ");
		con_escribir(consola, music[act_musica_grupo].nombre);
		con_escribir(consola, " - ");
		con_escribir(consola, music[act_musica_grupo].cancion[act_musica_num].nombre);
		unload_datafile_object(cur_music);
		cur_music = NULL;
	}
}

signed char F_API music_end_callback(FSOUND_STREAM *stream, void *buff, int len, int param)
{
	fmod_music_stream_is_playing = 0;
	return 0;
}

void reproducir_musica(int n, int loop)
{
	char file[1000];

	int k=0;
	int i=0;
	while (music[i].datafile[0] != '\0' && i<MAX_MUSICA)
	{
		if (n < music[i].count+k)
		{
			BITMAP *dst = video.ObtenerPantalla();
			video.IniciarSalida();
			video.CopiarFrameAnterior();
			rectfill(dst, 0, 0, dst->w, 20, 0);
			textprintf_centre(dst, book, dst->w/2, 3, makecol(255,255,255), "%s... %s - %s", TEXT_cargando_musica(), music[i].nombre, music[i].cancion[n-k].nombre);
			video.Actualizar();

			parar_musica();

			sprintf(file, "%s/%s", path_music.c_str(), music[i].datafile);

			cur_music = load_datafile_object(file, music[i].cancion[n-k].objeto);

			if (!cur_music)
			{
				TEXTO();
				allegro_message("Error al cargar msica %s", music[i].cancion[n-k].objeto);
				exit(1);
			}
			
			if (cur_music->type == DAT_MIDI)
			{
				play_midi((MIDI*)cur_music->dat, loop);
				act_musica_grupo = i;
				act_musica_num = n-k;
				cur_music_type = 0;
			}
			else if (cur_music->type == DAT_ID('O', 'N', 'D', 'A'))
			{
				fmod_music_stream = FSOUND_Stream_Open(
					(char*)cur_music->dat,
					FSOUND_2D | FSOUND_LOADMEMORY,
					0,
					cur_music->size);
				if (fmod_music_stream)
				{
					FSOUND_Stream_Play(FSOUND_FREE, fmod_music_stream);
					act_musica_grupo = i;
					act_musica_num = n-k;
					cur_music_type = 1;
					fmod_music_stream_is_playing = 1;
					FSOUND_Stream_SetEndCallback(fmod_music_stream, music_end_callback, 0);
				}
			}
			else if (cur_music->type == DAT_ID('M', 'O', 'D', ' '))
			{
				fmod_music_module = FMUSIC_LoadSongEx(
					(char*)(cur_music->dat),
					0,
					cur_music->size,
					FSOUND_LOADMEMORY,
					NULL,
					0);
				if (fmod_music_module)
				{
					FMUSIC_PlaySong(fmod_music_module);
					FMUSIC_SetLooping(fmod_music_module, loop);
					FMUSIC_SetMasterVolume(fmod_music_module, volfx);
					act_musica_grupo = i;
					act_musica_num = n-k;
					cur_music_type = 2;
				}
			}

			con_nueva_linea(consola, BLANCO);
			con_escribir(consola, "Cancion cargada: ");
			con_escribir(consola, music[act_musica_grupo].nombre);
			con_escribir(consola, " - ");
			con_escribir(consola, music[act_musica_grupo].cancion[act_musica_num].nombre);

			return;
		}
		k+=music[i].count;
		i++;
	}
}

int musica_finalizada(void)
{
	int ret=1;

	switch (cur_music_type)
	{
	case 0:
		ret = (midi_pos >= 0 ? 0 : 1);
		break;
	case 1:
		if (fmod_music_stream)
		{
			ret = !fmod_music_stream_is_playing;
		}
		else
		{
			ret = 1;
		}
		break;
	case 2:
		if (fmod_music_module)
		{
			ret = (FMUSIC_IsFinished(fmod_music_module) &&
				!FMUSIC_IsPlaying(fmod_music_module));
		}
		else
		{
			ret = 1;
		}
		break;
	}

	return ret;
}
