//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "menu.h"
#include "sis_part.h"
#include "globals.h"


int morf (int de, int a, int v)
{
	int res=de;

	if (de < a)
	{
		if (a-de < v)
			res=a;
		else
			res=de+v;
	}
	if (de > a)
	{
		if (de-a < v)
			res=a;
		else
			res=de-v;
	}

	return res;
}

int mostrar_menu(struct OPC_MENU *menu)
{
	int i, j;
	int col[MAX_MENU];
	int opc = 0;
	int mopc = -1, ant_mopc = -1;
	int coln = makecol(255,255,255);
	int colsel = makecol(255,0,0);
	int coldis = makecol(127, 127, 127);
	bool fin;
	SistemaDeParticulas sist_p_i;
	SistemaDeParticulas sist_p_d;
	int ant_mouse = mouse_b;
	int cur_mouse;
	BITMAP *dest;

	srand(time(NULL));

	set_mouse_range(0,0,639,479);

	for (j=0; j<menu->num; j++)
	{
		col[j] = menu->enabled[j] ? coln : coldis;
		menu->sonido[j] = false;
	}

	fin = false;
	i=0;
	while (!fin)
	{
		if (menu->enabled[i])
		{
			opc = i;
			fin = true;
		}
		i++;
	}

	counter=0;
	i=-150;
	const int vel = 150;
	while(i<vel*menu->num+120)
	{
		while (counter>0)
		{
			i+=20;
			counter--;
		}
		dest = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (menu->fondo, dest, 0, 0, 0, 0, 640, 480);
		for (j=0; j<menu->num; j++)
		{
			int posx;
			if (!(j%2)) posx = i-vel*j<320 ? i-vel*j : 320;
			else posx = (640+vel*j)-i>320 ? (640+vel*j)-i : 320;
//			alfont_textout_centre_aa(buffer, alfont_comic16, menu->menu[j], posx, menu->posy[j], col[j]);
			textout_centre(dest, menu->fuente, menu->menu[j], posx, menu->posy[j], col[j]);
		}
		dibujar_raton(dest);
		video.Actualizar();
	}

	int colr[MAX_MENU];
	int colg[MAX_MENU];
	int colb[MAX_MENU];

	for (j=0; j<menu->num; j++)
	{
		colr[j] = getr(col[j]);
		colg[j] = getg(col[j]);
		colb[j] = getb(col[j]);
	}

	int colnr=getr(coln), colng=getg(coln), colnb=getb(coln);
	int colselr=getr(colsel), colselg=getg(colsel), colselb=getb(colsel);
	int coldisr=getr(coldis), coldisg=getg(coldis), coldisb=getb(coldis);

	int rv=0, gv=5, bv=0;

	int vin=20;
	int vout=4;
	int enter = 0;
	clear_keys();
	counter=0;
	poll_joystick();

	sist_p_i.ModificarGravedad(0.2);
	sist_p_i.ModificarPosicionSuelo(475);
	sist_p_i.ModificarNumeroBotes(2);
	sist_p_i.ModificarFrecuencia(0);
	sist_p_i.ModificarCantidad(1);
	sist_p_i.ModificarAngulo(160 /*230*/, 220 /*290*/);
	sist_p_i.ModificarVariavilidadPosicion(2, 3);
	sist_p_i.ModificarVariabilidadVelocidad(0);
	sist_p_i.ModificarVida(70);
	sist_p_i.ModificarFadeOut(20);
	sist_p_i.EmitirParticulas(true);
	sist_p_i.ModificarCalidad(part_qual);

	sist_p_d.ModificarGravedad(0.2);
	sist_p_d.ModificarPosicionSuelo(475);
	sist_p_d.ModificarNumeroBotes(2);
	sist_p_d.ModificarFrecuencia(0);
	sist_p_d.ModificarCantidad(1);
	sist_p_d.ModificarAngulo(-40 /*70*/, 20 /*130*/);
	sist_p_d.ModificarVariavilidadPosicion(2, 3);
	sist_p_d.ModificarVariabilidadVelocidad(0);
	sist_p_d.ModificarVida(70);
	sist_p_d.ModificarFadeOut(20);
	sist_p_d.EmitirParticulas(true);
	sist_p_d.ModificarCalidad(part_qual);

	sist_p_d.Iniciar(brillo_bmp);
	sist_p_i.Iniciar(brillo_bmp);

	int ant_joy_up = 0;
	int ant_joy_down = 0;
	while (!key[KEY_ESC] && (ant_mouse || mouse_b!=2) && !enter)
	{
		poll_joystick();
		while (counter > 0)
		{
			if (ant_joy_up) ant_joy_up--;
			if (ant_joy_down) ant_joy_down--;
			
			sist_p_i.ModificarPosicion(322-text_length(menu->fuente, menu->menu[opc])/2, menu->posy[opc]+14);
			sist_p_i.ModificarColor(makecol(colselr, colselg, colselb));
			sist_p_i.ModificarVelocidad(2.0+(rand()%600)/100.0);
			sist_p_i.Ciclo();

			sist_p_d.ModificarPosicion(318+text_length(menu->fuente, menu->menu[opc])/2, menu->posy[opc]+14);
			sist_p_d.ModificarColor(makecol(colselr, colselg, colselb));
			sist_p_d.ModificarVelocidad(2.0+(rand()%600)/100.0);
			sist_p_d.Ciclo();
			
			mopc=-1;
			for (i=0; i<menu->num; i++)
			{
				if (menu->posy[i] < mouse_y && menu->posy[i]+28 > mouse_y &&
//					mouse_x > 319-alfont_text_length(alfont_comic16, menu->menu[i])/2 &&
//					mouse_x < 321+alfont_text_length(alfont_comic16, menu->menu[i])/2)
					mouse_x > 319-text_length(menu->fuente, menu->menu[i])/2 &&
					mouse_x < 321+text_length(menu->fuente, menu->menu[i])/2)
				{
					if (menu->enabled[i])
					{
						mopc = i;
					}
				}
			}
			if (mopc != -1 && mopc != ant_mopc) opc = mopc;
			ant_mopc = mopc;
			cur_mouse = mouse_b;
			if (key[KEY_UP] || (joy[0].stick[0].axis[1].d1 && !ant_joy_up))
			{
				if (opc>0)
				{
					i=opc;
					fin = false;
					while (i>0 && !fin)
					{
						i--;
						if (menu->enabled[i])
						{
							opc = i;
							fin = true;
						}
					}

				}
				clear_keys();
				if (joy[0].stick[0].axis[1].d1) ant_joy_up+=15;
			}
			if (key[KEY_DOWN] || (joy[0].stick[0].axis[1].d2 && !ant_joy_down))
			{
				if (opc<menu->num-1)
				{
					i=opc;
					fin = false;
					while (i<menu->num-1 && !fin)
					{
						i++;
						if (menu->enabled[i])
						{
							opc = i;
							fin = true;
						}
					}

				}
				clear_keys();
				if (joy[0].stick[0].axis[1].d2) ant_joy_down+=15;
			}
			if (key[KEY_ENTER] || joy[0].button[0].b)
			{
				enter = 1;
			}
			if (!ant_mouse && cur_mouse==1)
			{
				for (i=0; i<menu->num; i++)
				{
					if (menu->posy[i] < mouse_y && menu->posy[i]+28 > mouse_y &&
//						mouse_x > 319-alfont_text_length(alfont_comic16, menu->menu[i])/2 &&
//						mouse_x < 321+alfont_text_length(alfont_comic16, menu->menu[i])/2)
						mouse_x > 319-text_length(menu->fuente, menu->menu[i])/2 &&
						mouse_x < 321+text_length(menu->fuente, menu->menu[i])/2)
					{
						if (menu->enabled[i])
						{
							opc = i;
							enter = 1;
						}
					}
				}
			}

			colselr+=rv;
			colselg+=gv;
			colselb+=bv;

			if (colselr<0) colselr=0;
			if (colselg<0) colselg=0;
			if (colselb<0) colselb=0;
			if (colselr>255) colselr=255;
			if (colselg>255) colselg=255;
			if (colselb>255)colselb=255;

			if (colselr<=0 || colselr>=255) rv=-rv;
			if (colselg<=0 || colselg>=255) gv=-gv;
			if (colselb<=0 || colselb>=255) bv=-bv;

			for (j=0; j<menu->num; j++)
			{
				if (opc==j)
				{
					colr[j] = morf(colr[j], colselr, vin);
					colg[j] = morf(colg[j], colselg, vin);
					colb[j] = morf(colb[j], colselb, vin);
				}
				else
				{
					colr[j] = morf(colr[j], menu->enabled[j] ? colnr : coldisr, vout);
					colg[j] = morf(colg[j], menu->enabled[j] ? colng : coldisg, vout);
					colb[j] = morf(colb[j], menu->enabled[j] ? colnb : coldisb, vout);
				}
			}

			ant_mouse = cur_mouse;
			counter--;
		}

		dest = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (menu->fondo, dest, 0, 0, 0, 0, 640, 480);
		for (j=0; j<menu->num; j++)
		{
//			alfont_textout_centre_aa(buffer, alfont_comic16, menu->menu[j], 320, menu->posy[j], makecol(colr[j], colg[j], colb[j]));
			textout_centre(dest, menu->fuente, menu->menu[j], 320, menu->posy[j], makecol(colr[j], colg[j], colb[j]));
		}
		sist_p_i.Dibujar(dest);
		sist_p_d.Dibujar(dest);
		dibujar_raton(dest);
		video.Actualizar();
	}

	sist_p_i.EmitirParticulas(false);
	sist_p_d.EmitirParticulas(false);

	counter=0;
	i=vel*menu->num+120;
	while(i>-150)
	{
		while (counter>0)
		{
			i-=20;
			sist_p_i.Ciclo();
			sist_p_d.Ciclo();
			counter--;
		}
		dest = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (menu->fondo, dest, 0, 0, 0, 0, 640, 480);
		for (j=0; j<menu->num; j++)
		{
			int posx;
			if (!(j%2)) posx = i-vel*j<320 ? i-vel*j : 320;
			else posx = (640+vel*j)-i>320 ? (640+vel*j)-i : 320;
//			alfont_textout_centre_aa(buffer, alfont_comic16, menu->menu[j], posx, menu->posy[j], makecol(colr[j], colg[j], colb[j]));
			textout_centre(dest, menu->fuente, menu->menu[j], posx, menu->posy[j], makecol(colr[j], colg[j], colb[j]));
		}
		sist_p_i.Dibujar(dest);
		sist_p_d.Dibujar(dest);
		dibujar_raton(dest);
		video.Actualizar();
	}

	if (enter) return opc;
	else return menu->esc_item;
}
