//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------



#include "stdafx.h"
#ifdef _WINDOWS
#include <eh.h>
#endif

#define _MAIN_CPP_

#include "defines.h"
#include "jugador.h"
#include "config.h"
#include "editor.h"
#include "main.h"
#include "gfx.h"
#include "gui.h"
#include "consola.h"
#include "fuentes.h"
#include "musica.h"
#include "globals.h"
#include "funciones.h"
#include "AnimData.h"
#include "ExcepcionTU.h"

#ifdef _WINDOWS
#include "ExcepcionC.h"
#endif

BITMAP *mouse_cursor;

extern ALTEXT_Template tetris_tpl;
//ALTEXT_Template *altext_template=NULL;

void titulo(void);


void handler(void)
{
	counter++;
}
END_OF_FUNCTION(handler);

void clear_keys()
{
	int i;
	clear_keybuf();
	for(i=0; i<KEY_MAX; i++)
	{
		key[i] = 0;
	}
}

static int ant_pos_x[10] = {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
static int ant_pos_y[10] = {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

void mouse_handler()
{
	int posx = mouse_x;
	int posy = mouse_y;

	for(int i=9; i>0; i--)
	{
		ant_pos_x[i] = ant_pos_x[i-1];
		ant_pos_y[i] = ant_pos_y[i-1];
	}
	ant_pos_x[0] = posx;
	ant_pos_y[0] = posy;
}

void dibujar_raton(BITMAP *dest)
{
	int posx = mouse_x;
	int posy = mouse_y;
	int i;
	V3D_f quad[4];
	int colors[11];

	for(i=0; i<4; i++)
	{
		quad[i].z = 0;
	}

	for(i=0; i<10; i++)
	{
		colors[9-i] = makecol(int(i*28*0.4), int(i*28*0.7), int(i*28*0.9));
	}
	colors[10] = 0;

	masked_blit (mouse_cursor, dest, 0, 0, posx-1, posy-1, mouse_cursor->w, mouse_cursor->h);

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_add_blender(0, 0, 0, 255);

	if (ant_pos_x[0] > -1)
	{
		quad[0].x = posx;
		quad[0].y = posy;
		quad[0].c = colors[0];
		quad[1].x = posx+2;
		quad[1].y = posy+20;
		quad[1].c = colors[0];
		quad[2].x = ant_pos_x[0]+2;
		quad[2].y = ant_pos_y[0]+20;
		quad[2].c = colors[1];
		quad[3].x = ant_pos_x[0];
		quad[3].y = ant_pos_y[0];
		quad[3].c = colors[1];
		if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
			quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

		quad[0].x = posx+15;
		quad[0].y = posy+10;
		quad[0].c = colors[0];
		quad[1].x = posx;
		quad[1].y = posy;
		quad[1].c = colors[0];
		quad[2].x = ant_pos_x[0];
		quad[2].y = ant_pos_y[0];
		quad[2].c = colors[1];
		quad[3].x = ant_pos_x[0]+15;
		quad[3].y = ant_pos_y[0]+10;
		quad[3].c = colors[1];
		if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
			quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

		quad[0].x = posx+2;
		quad[0].y = posy+20;
		quad[0].c = colors[0];
		quad[1].x = posx+15;
		quad[1].y = posy+10;
		quad[1].c = colors[0];
		quad[2].x = ant_pos_x[0]+15;
		quad[2].y = ant_pos_y[0]+10;
		quad[2].c = colors[1];
		quad[3].x = ant_pos_x[0]+2;
		quad[3].y = ant_pos_y[0]+20;
		quad[3].c = colors[1];
		if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
			quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

//		aaline(dest, posx, posy, ant_pos_x[0], ant_pos_y[0], makecol(255,255,255), 1.0, true);
	}

	for(i=1; i<10; i++)
	{
		if (ant_pos_x[i-1] > -1 && ant_pos_x[i] > -1)
		{
			quad[0].x = ant_pos_x[i-1];
			quad[0].y = ant_pos_y[i-1];
			quad[0].c = colors[i];
			quad[1].x = ant_pos_x[i-1]+2;
			quad[1].y = ant_pos_y[i-1]+20;
			quad[1].c = colors[i];
			quad[2].x = ant_pos_x[i]+2;
			quad[2].y = ant_pos_y[i]+20;
			quad[2].c = colors[i+1];
			quad[3].x = ant_pos_x[i];
			quad[3].y = ant_pos_y[i];
			quad[3].c = colors[i+1];
			if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
				quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

			quad[0].x = ant_pos_x[i-1]+15;
			quad[0].y = ant_pos_y[i-1]+10;
			quad[0].c = colors[i];
			quad[1].x = ant_pos_x[i-1];
			quad[1].y = ant_pos_y[i-1];
			quad[1].c = colors[i];
			quad[2].x = ant_pos_x[i];
			quad[2].y = ant_pos_y[i];
			quad[2].c = colors[i+1];
			quad[3].x = ant_pos_x[i]+15;
			quad[3].y = ant_pos_y[i]+10;
			quad[3].c = colors[i+1];
			if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
				quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

			quad[0].x = ant_pos_x[i-1]+2;
			quad[0].y = ant_pos_y[i-1]+20;
			quad[0].c = colors[i];
			quad[1].x = ant_pos_x[i-1]+15;
			quad[1].y = ant_pos_y[i-1]+10;
			quad[1].c = colors[i];
			quad[2].x = ant_pos_x[i]+15;
			quad[2].y = ant_pos_y[i]+10;
			quad[2].c = colors[i+1];
			quad[3].x = ant_pos_x[i]+2;
			quad[3].y = ant_pos_y[i]+20;
			quad[3].c = colors[i+1];
			if (polygon_z_normal_f(quad, quad+1, quad+2) > 0)
				quad3d_f(dest, POLYTYPE_FLAT, NULL, quad, quad+1, quad+2, quad+3);

//			set_add_blender(0, 0, 0, 255-i*20);
//			aaline(dest, ant_pos_x[i-1], ant_pos_y[i-1], ant_pos_x[i], ant_pos_y[i], makecol(255,224,192), (10-i)*0.1, true);
		}
	}

	solid_mode();
}

char *leer_linea(char *buf, int n, FILE *fp)
{
	int i;
	int c;

	i = 0;
	do
	{
		c = fgetc(fp);
		buf[i] = c;
		i++;
	} while (c != EOF && c != '\n' && c != '\r' && i<n);

	switch (c)
	{
	case '\r':
		if (fgetc(fp) != '\n')
		{
			fseek(fp, -1, SEEK_CUR);
		}
		break;
	case '\n':
		break;
	}

	buf[i-1] = '\0';

	if (i==1 && c==EOF) return NULL;
	else return buf;
}

void no_disponible(BITMAP *fondo)
{
	string msg = TEXT_opcion_no_disponible();
	string ok = TEXT_aceptar();
	pregunta(fondo, roman, 230, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
}

void onButtonClk_languaje_aceptar(TButton *button)
{
	button->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

void load_translation(const char *lang)
{
	stringstream file;

	altext_language = NULL;

	if (lang && strcmp(lang, ""))
	{
		file << path_text << "/" << lang << ".tra";

		altext_language = ALTEXT_LoadTranslation(&tetris_tpl, file.str().c_str(), 0);
	}
	else
	{
		throw new ExcepcionTU("No hay seleccionada ninguna traduccin. Ejecuta el programa de configuracin", -1);
	}

	if (!altext_language)
	{
		stringstream st;
		string error_msg;
		
		st << "Error al cargar la traduccion " << file.str() << endl;

		switch(ALTEXT_ErrorCode)
		{
		case 1:
			st << "No se pudo leer el archivo" << endl;
			break;
		case 11:
			st << "No se pudo crear la traduccin" << endl;
			break;
		case 12:
			st << "Error de sintaxi: falta '=' en lnea " << ALTEXT_ErrorLine << endl;
			break;
		}

		throw new ExcepcionTU(st.str(), -1);
	}

	ALTEXT_SetTranslation(altext_language);
}

#ifdef _WINDOWS
void trans_func( unsigned int u, _EXCEPTION_POINTERS* pExp )
{
    throw CExcepcionC(u, pExp);
}
#endif

int main(int argc, char *argv[])
{
	int i, j;
	char file[1000];
	char aux[260];
	bool end;
	FILE *fp;
	int val = 0;
	const int max = 17;
	const int barra_y = 225;

	bool ejecutar_setup = false;

	for (i=1; i<argc; i++)
	{
		if (!strcmp(argv[i], "-setup"))
		{
			ejecutar_setup = true;
		}
	}

	set_uformat (U_ASCII);

	key_led_flag=0;
	allegro_init();

	register_bitmap_file_type("jpg", load_jpeg, save_jpeg);

//	alfont_init();
	set_window_title("Tetris");
	set_config_file("tetris.cfg");
	reload_config_texts(NULL);

	consola_main = crear_consola(&video, "tetris.log");

#ifdef _WINDOWS
	_set_se_translator(trans_func);
#endif
	try
	{
		cargar_configuracion();

		while (
			(coldepth != 15 &&
				coldepth != 16 &&
				coldepth != 24 &&
				coldepth != 32) ||
			!get_config_string("system", "language", NULL) ||
			ejecutar_setup
			)
		{
	#ifdef _WINDOWS
			_flushall();

			int exitcode = ejecutar("config.exe");

			if (exitcode != 0) return -1;

			ejecutar_setup = false;

			set_config_file("tetris.cfg");
			reload_config_texts(NULL);
			cargar_configuracion();
	#else
			allegro_message("El valor de la profundidad de color (bpp) del archivo de configuracin es incorrecto.\nSe admite 15, 16, 24 o 32");
			exit(-1);
	#endif
		}

	#ifdef _DEBUG
		fullscreen = 0;
		res_x=800;
		res_y=600;
	#endif

		ALTEXT_Init();

		if (!fullscreen)
		{
			coldepth = desktop_color_depth();

			if (coldepth == 8) coldepth = 16;
		}

		set_color_depth (coldepth);

		set_display_switch_mode(SWITCH_AMNESIA);

		if (fullscreen)
		{
			if (set_gfx_mode (GFX_AUTODETECT, res_x, res_y, 0, 0))
			{
				allegro_message("Error al entrar en modo grfico:\n%s", allegro_error);
				exit(-3);
			}
		}
		else
		{
			if(set_gfx_mode (GFX_AUTODETECT_WINDOWED, res_x, res_y, 0, 0))
			{
				allegro_message("Error al entrar en modo grfico:\n%s", allegro_error);
				exit(-3);
			}
		}

		Video::ModoActualizacion v;

		switch (refresh_mode)
		{
		case 0:
			v = Video::automatico;
			break;
		case 1:
			v = Video::doble_buffer;
			break;
		case 2:
			v = Video::page_flipping;
			break;
		case 3:
			v = Video::triple_buffer;
			break;
		default:
			throw new ExcepcionTU("Modo de actualizacin no vlido", -1);
		}

		if (!video.Iniciar(!disable_hw_accel, v))
		{
			throw new ExcepcionTU("Error al cambiar el modo de actualizacin", -1);
		}

		video.ModificarColorFondo(makecol(0,0,0));
		video.Vaciar();

		buffer = video.CrearBitmap(SCREEN_W, SCREEN_H, Video::hw_blit);

		clear(buffer);

		register_png_file_type();

		text_mode(-1);

//		allegro_message("hola1");
		mouse_cursor = video.CargarPng(path_data + "/tetris.dat#cursor", Video::hw_blit);
		if (!mouse_cursor)
		{
			throw new ExcepcionTU("Error al cargar tetris.dat#cursor", -1);
		}
		font = (FONT*)(load_datafile_object("system.dat", "TERMINAL")->dat);
		if (!font)
		{
			throw new ExcepcionTU("Error al cargar la fuente Terminal", -1);
		}
//		allegro_message("hola2");
		BITMAP *cargando = video.CargarPng(string("system.dat#CARGANDO"), Video::hw_blit);
		if (!cargando)
		{
			TEXTO();
			allegro_message("Error al cargar logo de cargando");
			exit(-1);
		}

//		allegro_message("hola3");
		BITMAP *cargando_barra = video.CargarPng(string("system.dat#BARRA"), Video::hw_blit);
		if (!cargando_barra)
		{
			TEXTO();
			allegro_message("Error al cargar la barra de progreso");
			exit(-1);
		}

		video.ModificarVista(640, 480);
		video.RepintarFondo();

		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		consola_main->num_lines = (SCREEN_H-80)/text_height(font);
		consola_main->visible = false;
		consola = consola_main;

		con_nueva_linea	(consola_main, AMARILLO);
		con_escribir_fn	(consola_main, "Iniciando Tetris Unlimited", AMARILLO);
		con_escribir_fn	(consola_main, "================================================================================", AMARILLO);
		con_escribir	(consola_main, "Tetris Unlimited v");
		con_escribir	(consola_main, TVER_MAYOR);
		con_escribir	(consola_main, ".");
		con_escribir	(consola_main, TVER_MINOR);
		con_escribir	(consola_main, ".");
		con_escribir	(consola_main, TVER_SUB);
		con_escribir	(consola_main, " Build ");
		con_escribir	(consola_main, __DATE__);
		con_escribir	(consola_main, " - Copyright (C) scar Giner Martinez.");
		con_nueva_linea	(consola_main, AMARILLO);
		con_escribir_fn	(consola_main, "Tetris Unlimited comes with ABSOLUTELY NO WARRANTY; for details view readme.txt.", AMARILLO);
		con_escribir_fn	(consola_main, "This is free software, and you are welcome to redistribute it under certain", AMARILLO);
		con_escribir	(consola_main, "conditions; see GPL.txt for details.");
		con_nueva_linea	(consola_main, BLANCO);
		con_nueva_linea	(consola_main, BLANCO);
		con_escribir_fn	(consola_main, "Configuracin leda de tetris.cfg", BLANCO);
		con_escribir	(consola_main, "Modo de vdeo: ");
		con_escribir	(consola_main, SCREEN_W);
		con_escribir	(consola_main, "x");
		con_escribir	(consola_main, SCREEN_H);
		con_escribir	(consola_main, "x");
		con_escribir_fn (consola_main, coldepth, BLANCO);

		con_escribir(consola_main, "Inicializando temporizador");
		if (install_timer())
		{
			string msg = string("Imposible inicializar el timer: \n") + string(allegro_error);
			throw new ExcepcionTU(msg, -1);
		}
		else
		{
			con_escribir_fn(consola_main, " - OK", BLANCO);
			val++;
			video.IniciarSalida();
			blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
			blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
			video.Actualizar();
		}

		LOCK_FUNCTION(handler);
		LOCK_VARIABLE(counter);

		install_int_ex(handler, BPS_TO_TIMER(60));

		counter = 0;
		con_escribir(consola_main, "Inicializando el teclado");
		if (install_keyboard())
		{
			string msg = string("Imposible inicializar el teclado: \n") + string(allegro_error);
			throw new ExcepcionTU(msg, -1);
		}
		else
		{
			con_escribir_fn(consola_main, " - OK", BLANCO);
			val++;
			video.IniciarSalida();
			blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
			blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
			video.Actualizar();
		}
		
		int n_buttons;
		con_escribir(consola_main, "Inicializando el ratn");
		if ((n_buttons = install_mouse()) == -1)
		{
			string msg = string("Imposible inicializar el ratn: ") + string(allegro_error);
			throw new ExcepcionTU(msg, -1);
		}
		else
		{
			set_mouse_sprite(mouse_cursor);
			con_escribir(consola_main, " - Encontrado ratn de ");
			con_escribir(consola_main, n_buttons);
			con_escribir_fn(consola_main, " botones ", BLANCO);
			val++;
			video.IniciarSalida();
			blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
			blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
			video.Actualizar();
		}
		
	//	set_mouse_range((SCREEN_W-640)/2, (SCREEN_H-480)/2, (SCREEN_W-640)/2+639, (SCREEN_H-480)/2+479);

		con_escribir(consola_main, "Inicializando el joystick");
		if (install_joystick(JOY_TYPE_AUTODETECT))
		{
			con_nueva_linea(consola_main, ROJO);
			con_escribir(consola_main, "Imposible inicializar el joystick: ");
			con_escribir_fn(consola_main, allegro_error, BLANCO);
		}
		else
		{
			con_escribir_fn(consola_main, " - OK", BLANCO);
		}
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();
		
		con_escribir(consola_main, "Inicializando el sonido");

		FSOUND_SetOutput(FSOUND_OUTPUT_DSOUND);
		FSOUND_SetDriver(digi_driver_id);
		FSOUND_SetSFXMasterVolume(volfx);
		FSOUND_Init(44100, 128, 0);
		
		if (install_sound (DIGI_NONE, MIDI_AUTODETECT, NULL))
		{
			con_nueva_linea(consola_main, ROJO);
			con_escribir(consola_main, "Imposible inicializar el sonido: ");
			con_escribir_fn(consola_main, allegro_error, BLANCO);
			install_sound (DIGI_NONE, MIDI_NONE, NULL);
		}
		else
		{
			con_escribir_fn(consola_main, " - OK", BLANCO);
		}
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		key_led_flag = 0;

		set_leds(KB_SCROLOCK_FLAG);

		set_volume (volfx, volmus);
		FSOUND_SetSFXMasterVolume(volfx);

		TSkin default_skin;

		default_skin.set_check(video.CargarPng(path_data + "/check_normal.png", Video::hw_blit));
		default_skin.set_check_checked(video.CargarPng(path_data + "/check_checked.png", Video::hw_blit));
		default_skin.set_check_checked_focused(video.CargarPng(path_data + "/check_checked_focused.png", Video::hw_blit));
		default_skin.set_check_focused(video.CargarPng(path_data + "/check_focused.png", Video::hw_blit));

		default_skin.set_radio(video.CargarPng(path_data + "/radio_normal.png", Video::hw_blit));
		default_skin.set_radio_checked(video.CargarPng(path_data + "/radio_checked.png", Video::hw_blit));
		default_skin.set_radio_checked_focused(video.CargarPng(path_data + "/radio_checked_focused.png", Video::hw_blit));
		default_skin.set_radio_focused(video.CargarPng(path_data + "/radio_focused.png", Video::hw_blit));

		default_skin.set_normal_font(font);
		default_skin.set_monospaced_font(font);

		TSkin::t_panel skin_props;

		skin_props = default_skin.get_panel_props(TSkin::pbackground);
		skin_props.fill_color = makecol(32, 48, 48);
		skin_props.light_border_color = makecol(0, 160, 160);
		skin_props.dark_border_color = makecol(0, 64, 64);
		skin_props.text_color = makecol(255, 255, 255);
		skin_props.hover_text_color = makecol(255, 255, 0);
		default_skin.set_panel_props(TSkin::pbackground, skin_props);

		skin_props = default_skin.get_panel_props(TSkin::pbutton);
		skin_props.fill_color = makecol(40, 128, 128);
		skin_props.light_border_color = makecol(0, 160, 160);
		skin_props.dark_border_color = makecol(0, 64, 64);
		skin_props.hover_fill_color = makecol(48, 160, 160);
		skin_props.hover_light_border_color = makecol(0, 192, 192);
		skin_props.hover_dark_border_color = makecol(0, 96, 96);
		skin_props.text_color = makecol(64, 255, 255);
		skin_props.hover_text_color = makecol(64, 255, 255);
		default_skin.set_panel_props(TSkin::pbutton, skin_props);

		skin_props = default_skin.get_panel_props(TSkin::pforeground);
		skin_props.fill_color = makecol(0, 0, 0);
		skin_props.light_border_color = makecol(0, 128, 128);
		skin_props.dark_border_color = makecol(0, 128, 128);
		skin_props.text_color = makecol(255, 255, 255);
		skin_props.hover_text_color = makecol(255, 255, 128);
		default_skin.set_panel_props(TSkin::pforeground, skin_props);

		skin_props = default_skin.get_panel_props(TSkin::pselection);
		skin_props.fill_color = makecol(0, 128, 128);
		skin_props.text_color = makecol(255, 255, 255);
		skin_props.hover_text_color = makecol(255, 255, 128);
		default_skin.set_panel_props(TSkin::pselection, skin_props);

		skin_props = default_skin.get_panel_props(TSkin::pscrollbar);
		skin_props.fill_color = makecol(0, 32, 32);
		skin_props.light_border_color = makecol(0, 160, 160);
		skin_props.dark_border_color = makecol(0, 64, 64);
		skin_props.draw_color = makecol(48, 160, 160);
		skin_props.draw_hover_color = makecol(192, 192, 0);
		default_skin.set_panel_props(TSkin::pscrollbar, skin_props);

		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		TObject::SetSkin(&default_skin);

		load_translation(get_config_string("system", "language", NULL));

	//	install_allegro_gl();

	//	set_gfx_mode (GFX_OPENGL, 640, 480, 0, 0);
	//	allegro_gl_screen_mode (AGL_MODE_DIRECT);

	//	allegro_gl_set_projection();

		cargar_jugadores();
		memset(&jugador_anonimo, 0, sizeof(jugador_anonimo));
		strcpy(jugador_anonimo.nick, TEXT_anonimo());
		jugador_anonimo.key_rate_delay = 150;
		jugador_anonimo.key_rate_repeat = 60;

		install_int_ex(mouse_handler, BPS_TO_TIMER(60));

		sprintf(file, "%s/musica.ini", path_music.c_str());
		if ((fp = fopen (file, "r")) == NULL)
		{
			stringstream st;
			st << "Error al abrir " << file;
			throw new ExcepcionTU(st.str(), -1);
		}

		con_nueva_linea	(consola_main, CIAN);
		con_escribir_fn	(consola_main, "Cargando msica", CIAN);
		con_escribir	(consola_main, "----------------");
		i = 0;
		end = false;
		int num_musica = 0;
		while (!end)
		{
			if (leer_linea (music[i].nombre, 50, fp) == NULL)
			{
				end = true;
			}
			else
			{
				if (i<MAX_MUSICA)
				{
					con_nueva_linea(consola_main, BLANCO);
					con_escribir_fn(consola_main, music[i].nombre, BLANCO);

					if (leer_linea(aux, 256, fp) == NULL)
					{
						stringstream st;
						st << "Error en musica.ini:\nFalta nombre de archivo para el conjunto de msica\n" << music[i].nombre;
						throw new ExcepcionTU(st.str(), -1);
					}
					sprintf (file, "%s/%s", path_music.c_str(), aux);
					con_escribir(consola_main, " ->");
					con_escribir(consola_main, file);
					if (exists(file))
					{
						strcpy(music[i].datafile, aux);
					}
					else
					{
						stringstream st;
						st << "Error al abrir " << file;
						throw new ExcepcionTU(st.str(), -1);
					}

					DATAFILE *obj;
					obj = load_datafile_object(file, " ");
					if (!obj)
					{
						stringstream st;
						st << "Error al cargar " << file;
						throw new ExcepcionTU(st.str(), -1);
					}

					char *text = (char*)obj->dat;
					j=0;

					char *token;

					token = strtok(text, "\n");
					while(token)
					{
						strcpy (music[i].cancion[j].objeto, token);
						token = strtok(NULL, "\n");
						if (!token)
						{
							stringstream st;
							st << "Error al cargar " << file;
							throw new ExcepcionTU(st.str(), -1);
						}
						strcpy (music[i].cancion[j].nombre, token);
						j++;
						token = strtok(NULL, "\n");
					}

					music[i].count = j;
					num_musica+=j;
					i++;
				}
				else
				{
					con_nueva_linea(consola_main, ROJO);
					con_escribir(consola_main, "No se pueden cargar ms archivos de msica: el mximo es ");
					con_escribir(consola_main, MAX_MUSICA);
					end = true;
				}
			}
		}
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();
		con_nueva_linea(consola_main, VERDE);
		con_escribir(consola_main, "Se han cargado ");
		con_escribir(consola_main, num_musica);
		con_escribir(consola_main, " canciones de ");
		con_escribir(consola_main, i);
		con_escribir(consola_main, " archivos");
		con_nueva_linea(consola_main, BLANCO);
		if (i<MAX_MUSICA)
		{
			music[i].datafile[0] = '\0';
		}
		num_canciones = num_musica;

		set_color_conversion(COLORCONV_NONE);

	#ifdef _DEBUG
		#define FONT_QUAL ALLEGTTF_NOSMOOTH
	#else
		#define FONT_QUAL ALLEGTTF_REALSMOOTH
	#endif

		con_nueva_linea(consola_main, CIAN);
		con_escribir_fn(consola_main, "Cargando fuentes", CIAN);
		con_escribir_fn(consola_main, "-----------------", BLANCO);

		sprintf(file, "%s/ttf.dat#times", path_data.c_str());
		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 14");
		roman = load_ttf_font_ex2(file, 14, 14, 32, 255, FONT_QUAL);
		if (!roman)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 12");
		roman12 = load_ttf_font_ex2(file, 12, 12, 32, 255, FONT_QUAL);
		if (!roman12)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		sprintf(file, "%s/ttf.dat#book", path_data.c_str());
		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 11");
		book = load_ttf_font_ex2(file, 11, 11, 32, 255, FONT_QUAL);
		if (!book)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		sprintf(file, "%s/ttf.dat#comic", path_data.c_str());
		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 16");
		comic16 = load_ttf_font_ex2(file, 16, 16, 32, 255, FONT_QUAL);
		if (!comic16)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		sprintf(file, "%s/ttf.dat#amelia", path_data.c_str());
		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 14");
		amelia = load_ttf_font_ex2(file, 14, 14, 32, 255, FONT_QUAL);
		if (!amelia)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		sprintf(file, "%s/ttf.dat#times", path_data.c_str());
		con_escribir(consola_main, file);
		con_escribir(consola_main, " tam 8");
		small_font = load_ttf_font_ex2(file, 8, 8, 32, 255, FONT_QUAL);
		if (!small_font)
		{
			con_escribir(consola_main, " - Fallo");
			stringstream st;
			st << "Error al cargar fuente " << file;
			throw new ExcepcionTU(st.str(), -1);
		}
		con_escribir_fn(consola_main, " - OK", BLANCO);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();
	/*
		sprintf(file, "%s/ttf.dat", path_data);
		DATAFILE *font_obj = load_datafile_object(file, "comic");
		alfont_comic16 = alfont_load_font_from_mem((char *)font_obj->dat, font_obj->size);
		unload_datafile_object(font_obj);
		alfont_set_font_size(alfont_comic16, 32);
	*/

		default_skin.set_normal_font(small_font);
		default_skin.set_monospaced_font(font);

		menu = comic16;

		set_color_conversion(COLORCONV_TOTAL | COLORCONV_DITHER);

		DATAFILE *dflecha;

		sprintf (file, "%s/flecha.dat", path_data.c_str());
		con_nueva_linea(consola_main, BLANCO);
		con_escribir(consola_main, "Cargando ");
		con_escribir(consola_main, file);
		dflecha = load_datafile(file);
		if (dflecha == NULL)
		{
			con_nueva_linea(consola_main, ROJO);
			con_escribir(consola_main, "Error al cargar archivo ");
			con_escribir(consola_main, file);
			stringstream st;
			st << "Error al cargar " << file;
			throw new ExcepcionTU(st.str(), -1);
		}

		con_escribir_fn(consola_main, " (60)", VERDE);
		con_escribir(consola_main, "[");
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		for (i=0; i<60; i++)
		{
			//sprintf(file, "flecha.dat#flecha0%3.3d_bmp_png", i);
			//sprintf(file, "flecha.dat#flecha03.3i_png", i);
			flecha[i] = video.CrearBitmap(80, 60, Video::hw_trans_blit);
			blit ((BITMAP *)dflecha[i].dat, flecha[i], 0, 0, 0, 0, 80, 60);
			con_escribir(consola_main, "-");
		}
		unload_datafile(dflecha);
		con_escribir(consola_main, "] - OK");
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		sound_menu_trans = FSOUND_Sample_Load(FSOUND_FREE, "fx/viento.wav", FSOUND_MONO, 0, 0);
		sound_girar_pieza = FSOUND_Sample_Load(FSOUND_FREE, "fx/piezagir.wav", FSOUND_MONO, 0, 0);
		sound_colocar_pieza = FSOUND_Sample_Load(FSOUND_FREE, "fx/pieza1.wav", FSOUND_MONO, 0, 0);
		sound_linea = FSOUND_Sample_Load(FSOUND_FREE, "fx/linea.wav", FSOUND_MONO, 0, 0);
		sound_tetris = FSOUND_Sample_Load(FSOUND_FREE, "fx/tetris.wav", FSOUND_MONO, 0, 0);

		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		srand(time(NULL));

	//	alfont_text_mode(-1);


		reproducir_musica(0, 1);
		val++;
		video.IniciarSalida();
		blit (cargando, video.ObtenerPantalla(), 0, 0, 0, 0, 640, 480);
		blit (cargando_barra, video.ObtenerPantalla(), 0, 0, 31, barra_y, val*cargando_barra->w/max, cargando_barra->h);
		video.Actualizar();

		destroy_bitmap(cargando);
		destroy_bitmap(cargando_barra);

		while(counter < 120);

		titulo();
		guardar_configuracion();
	}
	catch (ExcepcionTU *e)
	{
		int c = e->ObtenerCodigo();

		con_nueva_linea(consola_main, ROJO);
		con_nueva_linea(consola_main, ROJO);
		con_escribir(consola_main, "Excepcion(");
		con_escribir(consola_main, c);
		con_escribir(consola_main, "): ");
		con_escribir(consola_main, e->ObtenerMensaje().c_str());

		destruir_consola(consola_main);

		FSOUND_Close();
		remove_sound();

		TEXTO();
		allegro_message("%s", e->ObtenerMensaje().c_str());

		delete e;
		return c;
	}
#ifndef _DEBUG
#ifdef _WINDOWS
	catch (CExcepcionC e)
	{
		_EXCEPTION_POINTERS *ep;

		con_nueva_linea(consola_main, ROJO);
		con_nueva_linea(consola_main, ROJO);

		FSOUND_Close();
		remove_sound();

		TEXTO();

		ep = e.OptenerEP();

		stringstream msg;
		switch(e.ObtenerError())
		{
		case EXCEPTION_ACCESS_VIOLATION:
			msg << "Excepcin: Violacin de acceso";
			break;
		case EXCEPTION_FLT_DENORMAL_OPERAND:
			msg << "Excepcin: Operador en coma flotante demasiado pequeo";
			break;
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			msg << "Excepcin: Divisin entre cero";
			break;
		case EXCEPTION_FLT_INEXACT_RESULT:
			msg << "Excepcin: Resultado en coma flotante inexacto";
			break;
		case EXCEPTION_FLT_INVALID_OPERATION:
			msg << "Excepcin: Error en la operacin de coma flotante";
			break;
		case EXCEPTION_FLT_OVERFLOW:
		case EXCEPTION_INT_OVERFLOW:
			msg << "Excepcin: Valor demasiado grande";
			break;
		case EXCEPTION_FLT_STACK_CHECK:
			msg << "Excepcin: Fallo en la pila debido a una operacin en coma flotante";
			break;
		case EXCEPTION_FLT_UNDERFLOW:
			msg << "Excepcin: Exponente del valor en coma flotante demasiado pequeo";
			break;
		case EXCEPTION_ILLEGAL_INSTRUCTION:
			msg << "Excepcin: Instruccin invlida";
			break;
		case EXCEPTION_IN_PAGE_ERROR:
			msg << "Excepcin: Error de pgina";
			break;
		case EXCEPTION_PRIV_INSTRUCTION:
			msg << "Excepcin: No hay suficientes privilegios para ejecutar la instruccin";
			break;
		case EXCEPTION_STACK_OVERFLOW:
			msg << "Excepcin: Desbordamiento de pila";
			break;
		default:
			msg << "Excepcin de C desconocida: " << e.ObtenerError();
		}

		con_escribir(consola_main, msg.str().c_str());

		msg << endl << endl << "Enva el archivo tetris.log y qu hiciste para provocar este error a o_giner@hotmail.com";

		allegro_message("%s", msg.str().c_str());

		return -1;
	}
#endif // #ifdef _WINDOWS
	catch (...)
	{
		con_nueva_linea(consola_main, ROJO);
		con_nueva_linea(consola_main, ROJO);
		con_escribir(consola_main, "Excepcion: Error inesperado");

		FSOUND_Close();
		remove_sound();

		TEXTO();

		allegro_message("%s", "Error inesperado");

		return -1;
	}
#endif // #ifdef _DEBUG

	FSOUND_Close();
//	alfont_destroy_font(alfont_comic16);
//	alfont_exit();
	remove_timer();
	remove_sound();

	TEXTO();

	return 0;
}
END_OF_MAIN();
