//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "gui.h"
#include "consola.h"
#include "main.h"
#include "jugador.h"
#include "globals.h"
#include "ExcepcionTU.h"


//##ModelId=3FB21442032A
typedef struct t_jugador_v00
{
	char nombre[11];
	char apellido[11];
	char nick[11];

	unsigned r_arcade_part;
	unsigned r_arcade_pts[10];
	unsigned r_arcade_lin[10];
	unsigned r_arcade_niv[10];

	unsigned r_normal_part;
	unsigned r_normal_pts[10];
	unsigned r_normal_lin[10];
	unsigned r_normal_niv[10];
	unsigned r_normal_multi_win;
	unsigned r_normal_multi_lose;
	unsigned r_normal_multi_draw;

	unsigned r_coop_part;
	unsigned r_coop_pts[10];
	unsigned r_coop_lin[10];
	unsigned r_coop_niv[10];
	char r_coop_p_n[10][11];
	char r_coop_p_a[10][11];
	char r_coop_p_ni[10][11];
	unsigned r_coop_multi_win;
	unsigned r_coop_multi_lose;
	unsigned r_coop_multi_draw;

	unsigned r_comp_part;
	unsigned r_comp_pts[10];
	unsigned r_comp_lin[10];
	unsigned r_comp_niv[10];
	unsigned r_comp_win;
	unsigned r_comp_lose;
	unsigned r_comp_draw;

	unsigned r_surv_part;
	unsigned r_surv_pts[10];
	unsigned r_surv_lin[10];
	unsigned r_surv_niv[10];
	unsigned r_surv_num[10];
	unsigned r_surv_win;
	unsigned r_surv_lose;
	unsigned r_surv_draw;

	unsigned r_torn_part;
	unsigned r_torn_pts[10];
	unsigned r_torn_lin[10];
	unsigned r_torn_pos[10];
	unsigned r_torn_win;
}t_jugador_v00;


void poner_record_jugador_normal (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, int est)
{
	int i=0;
	int j;
	int fin=0;
	int ant_puntos=0, ant_lineas=0, ant_nivel=0;
	
	while (!fin && i<10)
	{
		if (puntos > jug->r_normal_pts[i] ||
			(puntos == jug->r_normal_pts[i] && lineas > jug->r_normal_lin[i]))
		{
			ant_puntos = jug->r_normal_pts[i];
			ant_lineas = jug->r_normal_lin[i];
			ant_nivel = jug->r_normal_niv[i];
			jug->r_normal_lin[i] = lineas;
			jug->r_normal_niv[i] = nivel;
			jug->r_normal_pts[i] = puntos;
			fin = true;
		}
		i++;
	}

	j=9;
	while (j>i)
	{
		jug->r_normal_pts[j] = jug->r_normal_pts[j-1];
		jug->r_normal_lin[j] = jug->r_normal_lin[j-1];
		jug->r_normal_niv[j] = jug->r_normal_niv[j-1];
		j--;
	}

	if (i<10)
	{
		jug->r_normal_pts[i] = ant_puntos;
		jug->r_normal_lin[i] = ant_lineas;
		jug->r_normal_niv[i] = ant_nivel;
	}

	switch (est)
	{
	case J_WIN:
		jug->r_normal_multi_win++;
		break;
	case J_LOSE:
		jug->r_normal_multi_lose++;
		break;
	case J_DRAW:
		jug->r_normal_multi_draw++;
		break;
	}

	jug->r_normal_part++;
}

void poner_record_jugador_cooperativo (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, t_jugador* companero, int est)
{
	int i=0;
	int j;
	int fin=0;
	int ant_puntos=0, ant_lineas=0, ant_nivel=0;
	char ant_nombre[11], ant_ap[11], ant_nick[11];
	
	while (!fin && i<10)
	{
		if (puntos > jug->r_coop_pts[i] ||
			(puntos == jug->r_coop_pts[i] && lineas > jug->r_coop_lin[i]))
		{
			ant_puntos = jug->r_coop_pts[i];
			ant_lineas = jug->r_coop_lin[i];
			ant_nivel = jug->r_coop_niv[i];
			strcpy(ant_nombre, jug->r_coop_p_n[i]);
			strcpy(ant_ap, jug->r_coop_p_a[i]);
			strcpy(ant_nick, jug->r_coop_p_ni[i]);
			jug->r_coop_lin[i] = lineas;
			jug->r_coop_niv[i] = nivel;
			jug->r_coop_pts[i] = puntos;
			strcpy(jug->r_coop_p_n[i], companero->nombre);
			strcpy(jug->r_coop_p_a[i], companero->apellido);
			strcpy(jug->r_coop_p_ni[i], companero->nick);
			fin = true;
		}
		i++;
	}

	j=9;
	while (j>i)
	{
		jug->r_coop_pts[j] = jug->r_coop_pts[j-1];
		jug->r_coop_lin[j] = jug->r_coop_lin[j-1];
		jug->r_coop_niv[j] = jug->r_coop_niv[j-1];
		strcpy(jug->r_coop_p_n[j], jug->r_coop_p_n[j-1]);
		strcpy(jug->r_coop_p_a[j], jug->r_coop_p_a[j-1]);
		strcpy(jug->r_coop_p_ni[j], jug->r_coop_p_ni[j-1]);
		j--;
	}

	if (i<10)
	{
		jug->r_coop_pts[i] = ant_puntos;
		jug->r_coop_lin[i] = ant_lineas;
		jug->r_coop_niv[i] = ant_nivel;
		strcpy(jug->r_coop_p_n[i], ant_nombre);
		strcpy(jug->r_coop_p_a[i], ant_ap);
		strcpy(jug->r_coop_p_ni[i], ant_nick);
	}

	switch (est)
	{
	case J_WIN:
		jug->r_coop_multi_win++;
		break;
	case J_LOSE:
		jug->r_coop_multi_lose++;
		break;
	case J_DRAW:
		jug->r_coop_multi_draw++;
		break;
	}

	jug->r_coop_part++;
}

void poner_record_jugador_competitivo (t_jugador *jug, unsigned puntos, unsigned lineas, unsigned nivel, int est)
{
	int i=0;
	int j;
	int fin=0;
	int ant_puntos=0, ant_lineas=0, ant_nivel=0;
	
	while (!fin && i<10)
	{
		if (puntos > jug->r_comp_pts[i] ||
			(puntos == jug->r_comp_pts[i] && lineas > jug->r_comp_lin[i]))
		{
			ant_puntos = jug->r_comp_pts[i];
			ant_lineas = jug->r_comp_lin[i];
			ant_nivel = jug->r_comp_niv[i];
			jug->r_comp_lin[i] = lineas;
			jug->r_comp_niv[i] = nivel;
			jug->r_comp_pts[i] = puntos;
			fin = true;
		}
		i++;
	}

	j=9;
	while (j>i)
	{
		jug->r_comp_pts[j] = jug->r_comp_pts[j-1];
		jug->r_comp_lin[j] = jug->r_comp_lin[j-1];
		jug->r_comp_niv[j] = jug->r_comp_niv[j-1];
		j--;
	}

	if (i<10)
	{
		jug->r_comp_pts[i] = ant_puntos;
		jug->r_comp_lin[i] = ant_lineas;
		jug->r_comp_niv[i] = ant_nivel;
	}

	switch (est)
	{
	case J_WIN:
		jug->r_comp_win++;
		break;
	case J_LOSE:
		jug->r_comp_lose++;
		break;
	case J_DRAW:
		jug->r_comp_draw++;
		break;
	}

	jug->r_comp_part++;
}

int buscar_jugador(char *nombre, char *apellido, char *nick)
{
	int ret = -1;
	unsigned int i = 0;

	while (i<num_jug && ret == -1)
	{
		if (!stricmp(jugador[i].nombre, nombre) &&
			!stricmp(jugador[i].apellido, apellido) &&
			!stricmp(jugador[i].nick, nick))
		{
			ret = i;
		}
		i++;
	}

	return ret;
}

int add_jugador (int jug, BITMAP *fondo, FONT *fuente)
{
	BITMAP *aux;
	int i;

	aux = video.CrearBitmap(640, 480, Video::hw_blit);
	acquire_bitmap(aux);
	blit (fondo, aux, 0, 0, 0, 0, 640, 480);
	rectfill (aux, 100, 280, 540, 420, 0);
	rect (aux, 100, 280, 540, 420, makecol(50, 255, 192));
	textout (aux, fuente, TEXT_introduce_nombre(), 120, 300, makecol(0, 255, 128));
	textout (aux, fuente, TEXT_introduce_apellido(), 120, 340, makecol(0, 255, 128));
	textout (aux, fuente, TEXT_introduce_nick(), 120, 380, makecol(0, 255, 128));
	release_bitmap(aux);
	
	caja_texto(jugador[jug].nombre, 10, 320, 300, fuente, makecol(0, 255, 128), aux);
	acquire_bitmap(aux);
	textout (aux, fuente, jugador[jug].nombre, 320, 300, makecol(0, 255, 128));
	release_bitmap(aux);
	
	caja_texto(jugador[jug].apellido, 10, 320, 340, fuente, makecol(0, 255, 128), aux);
	acquire_bitmap(aux);
	textout (aux, fuente, jugador[jug].apellido, 320, 340, makecol(0, 255, 128));
	release_bitmap(aux);

	caja_texto(jugador[jug].nick, 10, 320, 380, fuente, makecol(0, 255, 128), aux);
	acquire_bitmap(aux);
	textout (aux, fuente, jugador[jug].nick, 320, 380, makecol(0, 255, 128));
	release_bitmap(aux);

	clear_keys();

	if (buscar_jugador(jugador[jug].nombre, jugador[jug].apellido, jugador[jug].nick) != -1)
	{
		string msg = TEXT_jugador_ya_existe();
		string ok = TEXT_aceptar();
		pregunta(fondo, fuente, 300, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		return -1;
	}

	jugador[jug].key_rate_delay = 150;
	jugador[jug].key_rate_repeat = 60;

	jugador[jug].r_arcade_part=0;

	jugador[jug].r_normal_part=0;
	jugador[jug].r_normal_multi_win=0;
	jugador[jug].r_normal_multi_lose=0;
	jugador[jug].r_normal_multi_draw=0;
	
	jugador[jug].r_coop_part=0;
	jugador[jug].r_coop_multi_win=0;
	jugador[jug].r_coop_multi_lose=0;
	jugador[jug].r_coop_multi_draw=0;
	
	jugador[jug].r_comp_part=0;
	jugador[jug].r_comp_win=0;
	jugador[jug].r_comp_lose=0;
	jugador[jug].r_comp_draw=0;
	
	jugador[jug].r_surv_part=0;
	jugador[jug].r_surv_win=0;
	jugador[jug].r_surv_lose=0;
	jugador[jug].r_surv_draw=0;
	
	jugador[jug].r_torn_part=0;
	jugador[jug].r_torn_win=0;

	for (i=0; i<10; i++)
	{
		jugador[jug].r_arcade_pts[i]=0;
		jugador[jug].r_arcade_lin[i]=0;
		jugador[jug].r_arcade_niv[i]=0;

		jugador[jug].r_normal_pts[i]=0;
		jugador[jug].r_normal_lin[i]=0;
		jugador[jug].r_normal_niv[i]=0;

		jugador[jug].r_coop_pts[i]=0;
		jugador[jug].r_coop_lin[i]=0;
		jugador[jug].r_coop_niv[i]=0;
		strcpy (jugador[jug].r_coop_p_n[i], "");
		strcpy (jugador[jug].r_coop_p_a[i], "");
		strcpy (jugador[jug].r_coop_p_ni[i], "");

		jugador[jug].r_comp_pts[i]=0;
		jugador[jug].r_comp_lin[i]=0;
		jugador[jug].r_comp_niv[i]=0;

		jugador[jug].r_surv_pts[i]=0;
		jugador[jug].r_surv_lin[i]=0;
		jugador[jug].r_surv_niv[i]=0;
		jugador[jug].r_surv_num[i]=0;

		jugador[jug].r_torn_pts[i]=0;
		jugador[jug].r_torn_lin[i]=0;
		jugador[jug].r_torn_pos[i]=0;
	}

	destroy_bitmap(aux);

	return 0;
}

void eliminar_jugador (BITMAP *fondo, FONT *fuente, FONT *f_list)
{
	unsigned int i;
	char elem[NUM_LISTA_ELEM][100];
	int n;

	for (i=0; i<num_jug; i++)
	{
		sprintf (elem[i], "%s %s (%s)", jugador[i].nombre, jugador[i].apellido, jugador[i].nick);
	}

	do
	{
		n = lista(fondo, 90, 260, 460, 8, f_list, num_jug, elem, 0);
		if (n>=0)
		{
			char buf[100];
	
			sprintf (buf, "%s %s (%s)", jugador[n].nombre, jugador[n].apellido, jugador[n].nick);
			clear_keys();
			string msg = TEXT_q_eliminar_jugador(buf);
			string si = TEXT_si();
			string no = TEXT_no();
			if (pregunta(fondo, fuente, 275, 1, msg.c_str(), NULL, NULL, 2, si.c_str(), no.c_str(), NULL, 1, 1) == 0)
			{
				for (i=n; (unsigned)i<num_jug-1; i++)
				{
					strcpy (jugador[i].nombre, jugador[i+1].nombre);
					strcpy (jugador[i].apellido, jugador[i+1].apellido);
					strcpy (jugador[i].nick, jugador[i+1].nick);

				}
				num_jug--;
				string msg = TEXT_q_eliminar_records();
				if (pregunta(fondo, fuente, 300, 1, msg.c_str(), NULL, NULL, 2, si.c_str(), no.c_str(), NULL, 1, 1) == 0)
				{
				}
				return;
			}
		}
	} while (n>=0);

}

void leer_archivo_jugadores(PACKFILE *fp, char ver_major, char ver_minor)
{
	unsigned i;
	int j;

	if (ver_major == '0' && ver_minor == '1')
	{
		pack_fread (&num_jug, sizeof(num_jug), fp);

		if (!num_jug)
		{
			con_nueva_linea(consola_main, ROJO);
			con_escribir_fn(consola_main, "No hay ningn jugador ", BLANCO);
		}
		else
		{
			con_nueva_linea(consola_main, BLANCO);
		}

		for(i=0; i<num_jug; i++)
		{
			pack_fread (jugador[i].nombre, 11, fp);
			pack_fread (jugador[i].apellido, 11, fp);
			pack_fread (jugador[i].nick, 11, fp);

			pack_fread (&jugador[i].key_rate_delay, sizeof(unsigned), fp);
			pack_fread (&jugador[i].key_rate_repeat, sizeof(unsigned), fp);

			pack_fread (&jugador[i].r_arcade_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_arcade_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_arcade_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_arcade_niv[j], sizeof(unsigned), fp);
			}

			pack_fread (&jugador[i].r_normal_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_normal_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_normal_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_normal_niv[j], sizeof(unsigned), fp);
			}
			pack_fread (&jugador[i].r_normal_multi_win, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_normal_multi_lose, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_normal_multi_draw, sizeof(unsigned), fp);

			pack_fread (&jugador[i].r_coop_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_coop_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_coop_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_coop_niv[j], sizeof(unsigned), fp);
				pack_fread (jugador[i].r_coop_p_n[j], 11, fp);
				pack_fread (jugador[i].r_coop_p_a[j], 11, fp);
				pack_fread (jugador[i].r_coop_p_ni[j], 11, fp);
			}
			pack_fread (&jugador[i].r_coop_multi_win, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_coop_multi_lose, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_coop_multi_draw, sizeof(unsigned), fp);

			pack_fread (&jugador[i].r_comp_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_comp_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_comp_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_comp_niv[j], sizeof(unsigned), fp);
			}
			pack_fread (&jugador[i].r_comp_win, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_comp_lose, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_comp_draw, sizeof(unsigned), fp);

			pack_fread (&jugador[i].r_surv_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_surv_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_surv_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_surv_niv[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_surv_num[j], sizeof(unsigned), fp);
			}
			pack_fread (&jugador[i].r_surv_win, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_surv_lose, sizeof(unsigned), fp);
			pack_fread (&jugador[i].r_surv_draw, sizeof(unsigned), fp);

			pack_fread (&jugador[i].r_torn_part, sizeof(unsigned), fp);
			for(j=0; j<10; j++)
			{
				pack_fread (&jugador[i].r_torn_pts[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_torn_lin[j], sizeof(unsigned), fp);
				pack_fread (&jugador[i].r_torn_pos[j], sizeof(unsigned), fp);
			}
			pack_fread (&jugador[i].r_torn_win, sizeof(unsigned), fp);

			con_escribir(consola_main, " - ");
			con_escribir(consola_main, jugador[i].nombre);
			con_escribir(consola_main, " ");
			con_escribir(consola_main, jugador[i].apellido);
			con_escribir(consola_main, " (");
			con_escribir(consola_main, jugador[i].nick);
			con_escribir_fn(consola_main, ")", BLANCO);
		}
	}
	else if (ver_major=='0' && ver_minor=='0')
	{
		t_jugador_v00 jug_v00;

		pack_fread (&num_jug, sizeof(num_jug), fp);

		if (!num_jug)
		{
			con_nueva_linea(consola_main, ROJO);
			con_escribir_fn(consola_main, "No hay ningn jugador ", BLANCO);
		}
		else
		{
			con_nueva_linea(consola_main, BLANCO);
		}

		for (i=0; i<num_jug; i++)
		{
			pack_fread (&jug_v00, sizeof(jug_v00), fp);

			strcpy(jugador[i].nombre, jug_v00.nombre);
			strcpy(jugador[i].apellido, jug_v00.apellido);
			strcpy(jugador[i].nick, jug_v00.nick);

			jugador[i].r_arcade_part = jug_v00.r_arcade_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_arcade_pts[j] = jug_v00.r_arcade_pts[j];
				jugador[i].r_arcade_lin[j] = jug_v00.r_arcade_lin[j];
				jugador[i].r_arcade_niv[j] = jug_v00.r_arcade_niv[j];
			}

			jugador[i].r_normal_part = jug_v00.r_normal_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_normal_pts[j] = jug_v00.r_normal_pts[j];
				jugador[i].r_normal_lin[j] = jug_v00.r_normal_lin[j];
				jugador[i].r_normal_niv[j] = jug_v00.r_normal_niv[j];
			}
			jugador[i].r_normal_multi_win = jug_v00.r_normal_multi_win;
			jugador[i].r_normal_multi_lose = jug_v00.r_normal_multi_lose;
			jugador[i].r_normal_multi_draw = jug_v00.r_normal_multi_draw;

			jugador[i].r_coop_part = jug_v00.r_coop_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_coop_pts[j] = jug_v00.r_coop_pts[j];
				jugador[i].r_coop_lin[j] = jug_v00.r_coop_lin[j];
				jugador[i].r_coop_niv[j] = jug_v00.r_coop_niv[j];
				strcpy (jugador[i].r_coop_p_n[j], jug_v00.r_coop_p_n[j]);
				strcpy (jugador[i].r_coop_p_a[j], jug_v00.r_coop_p_a[j]);
				strcpy (jugador[i].r_coop_p_ni[j], jug_v00.r_coop_p_ni[j]);
			}
			jugador[i].r_coop_multi_win = jug_v00.r_coop_multi_win;
			jugador[i].r_coop_multi_lose = jug_v00.r_coop_multi_lose;
			jugador[i].r_coop_multi_draw = jug_v00.r_coop_multi_draw;

			jugador[i].r_comp_part = jug_v00.r_comp_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_comp_pts[j] = jug_v00.r_comp_pts[j];
				jugador[i].r_comp_lin[j] = jug_v00.r_comp_lin[j];
				jugador[i].r_comp_niv[j] = jug_v00.r_comp_niv[j];
			}
			jugador[i].r_comp_win = jug_v00.r_comp_win;
			jugador[i].r_comp_lose = jug_v00.r_comp_lose;
			jugador[i].r_comp_draw = jug_v00.r_comp_draw;

			jugador[i].r_surv_part = jug_v00.r_surv_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_surv_pts[j] = jug_v00.r_surv_pts[j];
				jugador[i].r_surv_lin[j] = jug_v00.r_surv_lin[j];
				jugador[i].r_surv_niv[j] = jug_v00.r_surv_niv[j];
				jugador[i].r_surv_num[j] = jug_v00.r_surv_num[j];
			}
			jugador[i].r_surv_win = jug_v00.r_surv_win;
			jugador[i].r_surv_lose = jug_v00.r_surv_lose;
			jugador[i].r_surv_draw = jug_v00.r_surv_draw;

			jugador[i].r_torn_part = jug_v00.r_torn_part;
			for(j=0; j<10; j++)
			{
				jugador[i].r_torn_pts[j] = jug_v00.r_torn_pts[j];
				jugador[i].r_torn_lin[j] = jug_v00.r_torn_lin[j];
				jugador[i].r_torn_pos[j] = jug_v00.r_torn_pos[j];
			}
			jugador[i].r_torn_win = jug_v00.r_torn_win;

			jugador[i].key_rate_delay = 150;
			jugador[i].key_rate_repeat = 60;

			con_escribir(consola_main, " - ");
			con_escribir(consola_main, jugador[i].nombre);
			con_escribir(consola_main, " ");
			con_escribir(consola_main, jugador[i].apellido);
			con_escribir(consola_main, " (");
			con_escribir(consola_main, jugador[i].nick);
			con_escribir_fn(consola_main, ")", BLANCO);
		}
	}
	else
	{
		con_nueva_linea(consola_main, ROJO);
		con_escribir_fn(consola_main, "La versin del archivo de jugadores es ms alta que la soportada", BLANCO);
		num_jug = 0;
	}
}

void cargar_jugadores (void)
{
	PACKFILE *fp;
	char aux[10];
	char file[200];

	con_nueva_linea	(consola_main, CIAN);
	con_escribir_fn(consola_main, "Cargando jugadores", CIAN);
	con_escribir(consola_main, "-------------------");

	sprintf(file, "%s/players.inf", path_players.c_str());
	if ((fp = pack_fopen(file, F_READ_PACKED)) == NULL)
	{
		con_nueva_linea(consola_main, ROJO);
		con_escribir(consola_main, "No se ha podido abrir el archivo ");
		con_escribir_fn(consola_main, file, BLANCO);
		num_jug = 0;
		return;
	}

	pack_fread (&aux, 4, fp);
	if (aux[0] != 'J' || aux[1] != 'U')
	{
		con_nueva_linea(consola_main, ROJO);
		con_escribir_fn(consola_main, "Error al leer el archivo de jugadores", BLANCO);
		num_jug = 0;
		return;
	}

	leer_archivo_jugadores(fp, aux[2], aux[3]);

	pack_fclose(fp);
}

void guardar_jugadores (void)
{
	unsigned i;
	int j;
	PACKFILE *fp;
	char file[200];

	sprintf(file, "%s/players.inf", path_players.c_str());
	if ((fp = pack_fopen(file, F_WRITE_PACKED)) == NULL)
	{
		string msg = string("Error al escribir en el archivo de jugadores ") + string(file);
		throw new ExcepcionTU(msg, -1);
	}

	pack_fwrite ("JU01", 4, fp);
	pack_fwrite (&num_jug, sizeof(num_jug), fp);

	for(i=0; i<num_jug; i++)
	{
		pack_fwrite (jugador[i].nombre, 11, fp);
		pack_fwrite (jugador[i].apellido, 11, fp);
		pack_fwrite (jugador[i].nick, 11, fp);

		pack_fwrite (&jugador[i].key_rate_delay, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].key_rate_repeat, sizeof(unsigned), fp);

		pack_fwrite (&jugador[i].r_arcade_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_arcade_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_arcade_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_arcade_niv[j], sizeof(unsigned), fp);
		}

		pack_fwrite (&jugador[i].r_normal_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_normal_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_normal_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_normal_niv[j], sizeof(unsigned), fp);
		}
		pack_fwrite (&jugador[i].r_normal_multi_win, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_normal_multi_lose, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_normal_multi_draw, sizeof(unsigned), fp);

		pack_fwrite (&jugador[i].r_coop_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_coop_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_coop_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_coop_niv[j], sizeof(unsigned), fp);
			pack_fwrite (jugador[i].r_coop_p_n[j], 11, fp);
			pack_fwrite (jugador[i].r_coop_p_a[j], 11, fp);
			pack_fwrite (jugador[i].r_coop_p_ni[j], 11, fp);
		}
		pack_fwrite (&jugador[i].r_coop_multi_win, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_coop_multi_lose, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_coop_multi_draw, sizeof(unsigned), fp);

		pack_fwrite (&jugador[i].r_comp_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_comp_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_comp_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_comp_niv[j], sizeof(unsigned), fp);
		}
		pack_fwrite (&jugador[i].r_comp_win, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_comp_lose, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_comp_draw, sizeof(unsigned), fp);

		pack_fwrite (&jugador[i].r_surv_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_surv_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_surv_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_surv_niv[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_surv_num[j], sizeof(unsigned), fp);
		}
		pack_fwrite (&jugador[i].r_surv_win, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_surv_lose, sizeof(unsigned), fp);
		pack_fwrite (&jugador[i].r_surv_draw, sizeof(unsigned), fp);

		pack_fwrite (&jugador[i].r_torn_part, sizeof(unsigned), fp);
		for(j=0; j<10; j++)
		{
			pack_fwrite (&jugador[i].r_torn_pts[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_torn_lin[j], sizeof(unsigned), fp);
			pack_fwrite (&jugador[i].r_torn_pos[j], sizeof(unsigned), fp);
		}
		pack_fwrite (&jugador[i].r_torn_win, sizeof(unsigned), fp);
	}
	pack_fclose(fp);
}


int importar_jugador (int jug, BITMAP *fondo, FONT *fuente, FONT *f_list)
{
	int i;
	char elem[NUM_LISTA_ELEM][100];
	char arch[NUM_LISTA_ELEM][128];
	int n;
	PACKFILE *fp;
	al_ffblk findinfo;
	char version[6];
	struct t_jugador aux;
	char file[300];
	
	sprintf(file, "%s/*.*", path_players.c_str());
	i=0;
	if (al_findfirst(file, &findinfo, FA_ARCH))
	{
		string msg = TEXT_no_hay_ningun_archivo_para_importar();
		string aceptar = TEXT_aceptar();
		pregunta(fondo, fuente, 300, 1, msg.c_str(), NULL, NULL, 1, aceptar.c_str(), NULL, NULL, 0, 0);
		al_findclose(&findinfo);
		return -1;
	}
	sprintf (file, "%s/%s", path_players.c_str(), findinfo.name);
	if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
	{
		if (pack_fread(version, 4, fp) == 4)
		if (version[0] == 'T' && version[1] == 'P' && version[2] == '0' && version[3] == '1')
		{
			pack_fread(&aux, sizeof(aux), fp);
			sprintf(elem[i], "%s %s (%s)", aux.nombre, aux.apellido, aux.nick);
			strcpy(arch[i], file);
			i++;
		}
		pack_fclose(fp);
	}
	while (i<NUM_LISTA_ELEM && !al_findnext(&findinfo))
	{
		sprintf (file, "%s/%s", path_players.c_str(), findinfo.name);
		if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
		{
			if (pack_fread(version, 4, fp) == 4)
			if (version[0] == 'T' && version[1] == 'P' && version[2] == '0' && version[3] == '1')
			{
				pack_fread(&aux, sizeof(aux), fp);
				sprintf(elem[i], "%s %s (%s)", aux.nombre, aux.apellido, aux.nick);
				strcpy(arch[i], file);
				i++;
			}
			pack_fclose(fp);
		}
	}
	al_findclose(&findinfo);
	if (i==0)
	{
		string msg = TEXT_no_hay_ningun_archivo_para_importar();
		string aceptar = TEXT_aceptar();
		pregunta(fondo, fuente, 300, 1, msg.c_str(), NULL, NULL, 1, aceptar.c_str(), NULL, NULL, 0, 0);
		return -1;
	}

	n = lista(fondo, 100, 260, 440, 8, f_list, i, elem, 0);

	clear_keys();
	if (n>=0)
	{
		fp = pack_fopen(arch[n], F_READ_PACKED);
		pack_fread(version, 4, fp);
		if (version[0] != 'T' || version[1] != 'P' || version[2] != '0' || version[3] != '1')
		{
			string msg = TEXT_no_se_ha_podido_importar_el_jugador();
			string aceptar = TEXT_aceptar();
			pregunta(fondo, fuente, 300, 1, msg.c_str(), NULL, NULL, 1, aceptar.c_str(), NULL, NULL, 0, 0);
			return -1;
		}
		pack_fread(&jugador[jug], sizeof(jugador[jug]), fp);
		pack_fclose(fp);
		return 0;
	}
	else
	{
		return -1;
	}
}

void exportar_jugador (BITMAP *fondo, FONT *fuente, FONT *f_list)
{
	unsigned int i;
	char elem[NUM_LISTA_ELEM][100];
	int n;
	char arch[300];
	PACKFILE *fp;

	for (i=0; i<num_jug; i++)
	{
		strcpy (elem[i], jugador[i].nombre);
		strcat (elem[i], " ");
		strcat (elem[i], jugador[i].apellido);
		strcat (elem[i], " (");
		strcat (elem[i], jugador[i].nick);
		strcat (elem[i], ")");
	}

	n = lista(fondo, 100, 260, 440, 8, f_list, num_jug, elem, 0);
	clear_keys();
	if (n>=0)
	{
		sprintf (arch, "%s/%s_%s_%s.tpl", path_players.c_str(), jugador[n].nombre, jugador[n].apellido, jugador[n].nick);
		fp = pack_fopen(arch, F_WRITE_PACKED );
		pack_fwrite ("TP01", 4, fp);
		pack_fwrite (&jugador[n], sizeof(jugador[n]), fp);
		pack_fclose(fp);
		string msg = TEXT_se_ha_guardado_el_jugador_en_el_archivo(arch);
		string ok = TEXT_aceptar();
		pregunta(fondo, fuente, 250, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
	}
}

void detail_info(BITMAP *fondo, FONT *fuente, FONT *cabeza, unsigned int sel)
{
	int info = 0;
	int i;

	clear_keys();
	do
	{
		BITMAP *dst = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (fondo, dst, 0, 0, 0, 0, 640, 480);
		textprintf(dst, fuente, 10, 420, makecol(0, 255, 255), "%s %s (%s)", jugador[sel].nombre, jugador[sel].apellido, jugador[sel].nick);
		switch(info)
		{
		case 0:
			textout_centre(dst, fuente, TEXT_arcade(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 140, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_nivel(), 260, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 140, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_arcade_pts[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_arcade_lin[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_arcade_niv[i]);
			}
			break;
		case 1:
			textout_centre(dst, fuente, TEXT_normal(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 140, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_nivel(), 260, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 140, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_normal_pts[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_normal_lin[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_normal_niv[i]);
			}
			textout(dst, fuente, TEXT_partidas_multijugador(), 350, 130, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_ganadas(), 350, 190, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_perdidas(), 350, 250, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_empatadas(), 350, 310, makecol(255, 255, 255));
			textprintf(dst, fuente, 350, 220, makecol(0, 255, 255), "%d", jugador[sel].r_normal_multi_win);
			textprintf(dst, fuente, 350, 280, makecol(255, 0, 0), "%d", jugador[sel].r_normal_multi_lose);
			textprintf(dst, fuente, 350, 340, makecol(255, 255, 0), "%d", jugador[sel].r_normal_multi_draw);
			break;
		case 2:
			textout_centre(dst, fuente, TEXT_cooperativo(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 140, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_nivel(), 260, 60, makecol(255, 255, 255));
			textout(dst, cabeza, TEXT_compannero(), 280, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 140, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_coop_pts[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_coop_lin[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_coop_niv[i]);
				textprintf(dst, fuente, 280, 100+i*30, makecol(0, 255, 255), "%s %s (%s)", jugador[sel].r_coop_p_n[i], jugador[sel].r_coop_p_a[i], jugador[sel].r_coop_p_ni[i]);
			}
			break;
		case 3:
			textout_centre(dst, fuente, TEXT_cooperativo(), 320, 20, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_partidas_multijugador(), 250, 130, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_ganadas(), 250, 190, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_perdidas(), 250, 250, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_empatadas(), 250, 310, makecol(255, 255, 255));
			textprintf(dst, fuente, 250, 220, makecol(0, 255, 255), "%d", jugador[sel].r_coop_multi_win);
			textprintf(dst, fuente, 250, 280, makecol(255, 0, 0), "%d", jugador[sel].r_coop_multi_lose);
			textprintf(dst, fuente, 250, 340, makecol(255, 255, 0), "%d", jugador[sel].r_coop_multi_draw);
			break;
		case 4:
			textout_centre(dst, fuente, TEXT_competitivo(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 140, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_nivel(), 260, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 140, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_comp_pts[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_comp_lin[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_comp_niv[i]);
			}
			textout(dst, fuente, TEXT_partidas_multijugador(), 350, 130, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_ganadas(), 350, 190, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_perdidas(), 350, 250, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_empatadas(), 350, 310, makecol(255, 255, 255));
			textprintf(dst, fuente, 350, 220, makecol(0, 255, 255), "%d", jugador[sel].r_comp_win);
			textprintf(dst, fuente, 350, 280, makecol(255, 0, 0), "%d", jugador[sel].r_comp_lose);
			textprintf(dst, fuente, 350, 340, makecol(255, 255, 0), "%d", jugador[sel].r_comp_draw);
			break;
		case 5:
			textout_centre(dst, fuente, TEXT_survival(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 140, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_nivel(), 260, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, "N", 320, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 140, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_surv_pts[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_surv_lin[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_surv_niv[i]);
				textprintf_right(dst, fuente, 320, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_surv_num[i]);
			}
			textout(dst, fuente, TEXT_partidas_multijugador(), 400, 130, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_ganadas(), 400, 190, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_perdidas(), 400, 250, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_empatadas(), 400, 310, makecol(255, 255, 255));
			textprintf(dst, fuente, 400, 220, makecol(0, 255, 255), "%d", jugador[sel].r_surv_win);
			textprintf(dst, fuente, 400, 280, makecol(255, 0, 0), "%d", jugador[sel].r_surv_lose);
			textprintf(dst, fuente, 400, 340, makecol(255, 255, 0), "%d", jugador[sel].r_surv_draw);
			break;
		case 6:
			textout_centre(dst, fuente, TEXT_campeonato(), 320, 20, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_posicion(), 100, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_puntos(), 200, 60, makecol(255, 255, 255));
			textout_right(dst, cabeza, TEXT_lineas(), 260, 60, makecol(255, 255, 255));
			for (i=0; i<10; i++)
			{
				textprintf(dst, fuente, 10, 100+i*30, makecol(255, 255, 255), "%d-", i+1);
				textprintf_right(dst, fuente, 100, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_torn_pos[i]);
				textprintf_right(dst, fuente, 200, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_torn_pts[i]);
				textprintf_right(dst, fuente, 260, 100+i*30, makecol(0, 255, 255), "%d", jugador[sel].r_torn_lin[i]);
			}
			textout(dst, fuente, TEXT_campeonatos_jugados(), 350, 130, makecol(255, 255, 255));
			textout(dst, fuente, TEXT_ganados(), 350, 190, makecol(255, 255, 255));
			textprintf(dst, fuente, 350, 160, makecol(0, 255, 255), "%d", jugador[sel].r_torn_part);
			textprintf(dst, fuente, 350, 220, makecol(0, 255, 255), "%d", jugador[sel].r_torn_win);
			break;
		}
		video.Actualizar();

		while(!keypressed());
		if (key[KEY_LEFT])
		{
			if (info > 0) info--;
			clear_keys();
		}
		if (key[KEY_RIGHT])
		{
			if (info < 6) info++;
			clear_keys();
		}
		if (key[KEY_UP])
		{
			if (sel > 0) sel--;
			clear_keys();
		}
		if (key[KEY_DOWN])
		{
			if (sel < num_jug-1) sel++;
			clear_keys();
		}


	} while (!key[KEY_ESC] && !key[KEY_ENTER]);
}

void ver_info (BITMAP *fondo, FONT *fuente, FONT *cabeza)
{
	unsigned int i;
	int pos = 0;
	int sel = 0;
	BITMAP *aux;

	aux = video.CrearBitmap(640, 480, Video::hw_blit);

	set_trans_blender (0, 0, 0, 192);
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	blit(fondo, aux, 0, 0, 0, 0, 640, 480);
	rectfill(aux, 0, 90, 640, 400, makecol(0, 0, 0));
	hline(aux, 0, 89, 640, makecol(255, 255, 0));
	hline(aux, 0, 401, 640, makecol(255, 255, 0));
	rectfill(aux, 0, 418, 640, 442, makecol(0, 0, 0));
	hline(aux, 0, 418, 640, makecol(255, 255, 0));
	hline(aux, 0, 443, 640, makecol(255, 255, 0));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	clear_keys();
	do
	{
		BITMAP *dst = video.ObtenerPantalla();
		blit(aux, dst, 0, 0, 0, 0, 640, 480);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		rectfill(dst, 0, 100+30*(sel-pos), 640, 122+30*(sel-pos), makecol(64, 64, 64));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
		textout(dst, cabeza, TEXT_jugadores(), 10, 60, makecol(255, 255, 255));
		textout_right(dst, cabeza, TEXT_arcade(), 230, 60, makecol(255, 255, 255));
		textout_right(dst, cabeza, TEXT_normal(), 330, 60, makecol(255, 255, 255));
		textout_right(dst, cabeza, TEXT_cooperativo(), 430, 60, makecol(255, 255, 255));
		textout_right(dst, cabeza, TEXT_competitivo(), 530, 60, makecol(255, 255, 255));
		textout_right(dst, cabeza, TEXT_survival(), 630, 60, makecol(255, 255, 255));
		textprintf(dst, fuente, 10, 420, makecol(0, 255, 255), "%s %s (%s)", jugador[sel].nombre, jugador[sel].apellido, jugador[sel].nick);
		for (i=0; i+pos<num_jug && i<10; i++)
		{
			textout(dst, fuente, jugador[i+pos].nombre, 10, 100+i*30, makecol(255,255,255));
			textprintf_right(dst, fuente, 230, 100+i*30, makecol(25, 255, 255), "%u", jugador[i+pos].r_arcade_pts[0]);
			textprintf_right(dst, fuente, 330, 100+i*30, makecol(25, 255, 255), "%u", jugador[i+pos].r_normal_pts[0]);
			textprintf_right(dst, fuente, 430, 100+i*30, makecol(25, 255, 255), "%u", jugador[i+pos].r_coop_pts[0]);
			textprintf_right(dst, fuente, 530, 100+i*30, makecol(25, 255, 255), "%u", jugador[i+pos].r_comp_pts[0]);
			textprintf_right(dst, fuente, 630, 100+i*30, makecol(25, 255, 255), "%u", jugador[i+pos].r_surv_pts[0]);
		}

		video.Actualizar();

		while (!keypressed());

		if (key[KEY_UP])
		{
			if (sel > 0)
			{
				sel--;
			}
			clear_keys();
		}
		if (key[KEY_DOWN])
		{
			if (sel < (signed)num_jug-1)
			{
				sel++;
			}
			clear_keys();
		}
		if (key[KEY_ENTER])
		{
			detail_info(aux, fuente, cabeza, sel);
			clear_keys();
		}
		if (sel < pos) pos = sel;
		if (sel >= pos+9) pos = sel-9;

	} while(!key[KEY_ESC]);

	destroy_bitmap(aux);
}
