//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include <stdafx.h>

#include "defines.h"
#include "globals.h"
#include "sis_part.h"
#include "editor.h"
#include "Controles.h"
#include "jugador.h"
#include "juego.h"
#include "juego2.h"
#include "musica.h"


static int ind = 0;

void capturar_pantalla()
{
	BITMAP *save = create_bitmap(SCREEN_W, SCREEN_H);
	BITMAP *dst = video.ObtenerPantalla();
	blit (dst, save, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	char screen_file[13];
	do
	{
		sprintf(screen_file, "shot%4.4d.bmp", ind);
		ind++;
	} while (file_exists(screen_file, FA_RDONLY | FA_ARCH, NULL) && ind < 9999);
	save_bmp(screen_file, save, NULL);
	destroy_bitmap(save);
	counter = 0;
}

void initialize_mini_score(t_mini_score_list& sc_list)
{
	int i;

	sc_list.n = 0;
	for(i=0; i<NUM_SCORE_LIST; i++)
	{
		sc_list.list[i].score_bmp = create_system_bitmap(text_length(font, "      "), text_height(font));
		sc_list.list[i].visible = false;
	}
}

void initialize_stats(t_stats& stats)
{
	int i;

	for(i=0; i<4; i++)
	{
		stats.num_lineas[i] = 0;
	}
	for(i=0; i<12; i++)
	{
		stats.num_piezas[i] = 0;
	}
	stats.puntos_bonus = 0;
	stats.puntos_lineas = 0;
	stats.puntos_piezas = 0;
}

// Thanks to Thomas Harte for this :)
void GetAngleForSpline(int points[8], int npts, float *a, float *v)
{
   int n;
   float t;
   float coefs[3][2];
   float vector[2];

   /* calculate thing to multiply against the square of t */
   coefs[0][0] = 3*(-points[0] + 3*points[2] - 3*points[4] + points[6]); //x
   coefs[0][1] = 3*(-points[1] + 3*points[3] - 3*points[5] + points[7]); //y

   /* calculate thing to multiply against t */
   coefs[1][0] = 2*(3*points[0] - 6*points[2] + 3*points[4]); //x
   coefs[1][1] = 2*(3*points[1] - 6*points[3] + 3*points[5]); //y

   /* calculate constant to add. */
   coefs[2][0] = 3*(-points[0] + points[2]); //x
   coefs[2][1] = 3*(-points[1] + points[3]); //y

   for(n = 0; n < npts; n++)
   {
      t = (float)n / (float)(npts-1);

      /* calculate vector pointing in direction of travel */
      vector[0] = t*t*coefs[0][0] + t*coefs[1][0] + coefs[2][0]; //x
      vector[1] = t*t*coefs[0][1] + t*coefs[1][1] + coefs[2][1]; //y

      /* get angle from vector */
      a[n] = atan2(vector[1], vector[0]);

		/* get vector module */
		v[n] = sqrt(vector[0]*vector[0] + vector[1]*vector[1]);
   }
}

void pause_effect (BITMAP *fondo)
{
	BITMAP* dest;
//	int varx, vary;
//	float angle;
//	int dist;
	int hue = 0;

	int spline_movement[8] = {20, 20, 40, 400, 500, 100, 600, 450};
	int spline_result_points_x[320];
	int spline_result_points_y[320];
	float spline_result_angles[320];
	float spline_result_vel[320];
	int pos = 0;

	calc_spline(spline_movement, 200, spline_result_points_x, spline_result_points_y);
	GetAngleForSpline(spline_movement, 200, spline_result_angles, spline_result_vel);

	SistemaDeParticulas p;
	SistemaDeParticulas p2;
	SistemaDeParticulas p3;

	p.ModificarCalidad(part_qual);
	p.ModificarCantidad(2);
	p.ModificarFrecuencia(0);
	p.ModificarGravedad(0);
	p.ModificarAngulo(spline_result_angles[pos]*180/PI+10, spline_result_angles[pos]*180/PI-10);
	p.ModificarNumeroBotes(3);
	p.ModificarVariavilidadPosicion(0, 0);
	p.ModificarPosicionSuelo(SCREEN_H-5);
	p.ModificarVariabilidadVelocidad(0);
	p.ModificarVida(100);
	p.ModificarFadeOut(60);
	p.ModificarColor(makecol(255, 192, 0));

	p2.ModificarCalidad(part_qual);
	p2.ModificarCantidad(2);
	p2.ModificarFrecuencia(0);
	p2.ModificarGravedad(0.1);
	p2.ModificarPosicion(SCREEN_W/2, SCREEN_H-10);
	p2.ModificarAngulo(270-10, 270+10);
	p2.ModificarNumeroBotes(3);
	p2.ModificarVariavilidadPosicion(0, 0);
	p2.ModificarPosicionSuelo(SCREEN_H-5);
	p2.ModificarVariabilidadVelocidad(0);
	p2.ModificarVida(100);
	p2.ModificarFadeOut(60);
	p2.ModificarColor(makecol(64, 128, 255));

	p3.ModificarCalidad(part_qual);
	p3.ModificarCantidad(5);
	p3.ModificarFrecuencia(0);
	p3.ModificarGravedad(0.01);
	p3.ModificarPosicion(SCREEN_W/2, SCREEN_H/2);
	p3.ModificarAngulo(0, 360);
	p3.ModificarNumeroBotes(0);
	p3.ModificarVariavilidadPosicion(5, 5);
	p3.ModificarPosicionSuelo(SCREEN_H-5);
	p3.ModificarVariabilidadVelocidad(0);
	p3.ModificarVida(100);
	p3.ModificarFadeOut(60);
	p3.ModificarVelocidad(5);

//	p.Iniciar(brillo_bmp);
//	p2.Iniciar(brillo_bmp);
	p3.Iniciar(brillo_bmp);

//	p2.EmitirParticulas(true);
//	p.EmitirParticulas(true);
	p3.EmitirParticulas(true);

	clear_keybuf();

	key[KEY_P] = 0;

	counter = 0;
	while (!key[KEY_P])
	{
		while (counter > 0)
		{
			int r, g, b;
			hue++;
			if (hue>=360) hue=0;
			hsv_to_rgb(hue, 1.0, 1.0, &r, &g, &b);
/*
			if (key[KEY_UP]) fuerza += 0.05;
			if (key[KEY_DOWN]) fuerza -= 0.05;

			p.ModificarPosicion(spline_result_points_x[pos], spline_result_points_y[pos]);
			p.ModificarAngulo(spline_result_angles[pos]*180/PI-10, spline_result_angles[pos]*180/PI+10);

			p2.ModificarVelocidad(fuerza);
*/

			p3.ModificarColor(makecol(r, g, b));

//			p.Ciclo();
//			p2.Ciclo();
			p3.Ciclo();

//			pos++;
//			if (pos >= 200) pos = 0;
			counter--;
		}
		dest = video.ObtenerPantalla();
//		ant_posx = p.ObtenerPosicionX();
//		ant_posy = p.ObtenerPosicionY();
		video.IniciarSalida();
		blit (fondo, dest, 0, 0, 0, 0, dest->w, dest->h);
//		p.Dibujar(dest);
//		p2.Dibujar(dest);
		p3.Dibujar(dest);
		textout_centre (dest, comic16, TEXT_pausa(), dest->w/2, dest->h/2-10, makecol(255, 255, 255));
		video.FinalizarSalida();
		if (key[KEY_F12])
		{
			capturar_pantalla();
		}
		video.Actualizar();
	}
}

void show_stats(t_juego *juego, int *win_lose_array)
{
	int i, j, k;
	int posx, posy;
	FONT *f = roman12;
	int blanco = makecol(192, 192, 192);
	BITMAP *dest;

	const int tam_linea = 16;
	const int tam_parr = 24;

	dest = video.ObtenerPantalla();
	video.IniciarSalida();

	clear(dest);
//	dibujar_recuadro_trans(screen, 10, 10, 630, 470, 127);

	posx = 20;
	posy = 20;
	posy+=tam_parr;
	posy+=tam_parr;
	textout (dest, f, TEXT_stat_nivel(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_lineas(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_puntos(), posx, posy, blanco);
	posy+=tam_parr;
	textout (dest, f, TEXT_stat_puntos_por_lineas(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_puntos_por_piezas(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_puntos_por_caer(), posx, posy, blanco);
	posy+=tam_parr;
	textout (dest, f, TEXT_stat_lineas_simples(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_dobles(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_triples(), posx, posy, blanco);
	posy+=tam_linea;
	textout (dest, f, TEXT_stat_tetris(), posx, posy, blanco);
	posy+=tam_parr;
	for(j=0; j<juego->jug[0]->piezas->num; j++, posy+=tam_linea)
	{
//		textprintf (screen, f, posx, posy+j*tam_linea, blanco, "%d", juego->jug[i]->stats.num_piezas[j]);
			for (k=0; k<16; k++)
			{
				if (juego->jug[0]->piezas->pieza[j][k] != -1)
				{
					rectfill(dest, posx + (k/4)*2, posy+5+(k%4)*2, posx + (k/4)*2+1, posy+5+(k%4)*2+1, blanco);
				}
			}
	}

	for(i=0, posx=200; i<juego->num_jug; i++, posx+=100)
	{
		posy = 20;
		textout (dest, f, juego->jug[i]->jug->nick, posx, posy, makecol(255,255,0));
		posy+=tam_parr;
		switch(win_lose_array[i])
		{
		case J_NONE:
			break;
		case J_WIN:
			textout (dest, f, TEXT_GANADOR(), posx, posy, makecol(0, 255, 0));
			break;
		case J_LOSE:
			textout (dest, f, TEXT_PERDEDOR(), posx, posy, makecol(255, 0, 0));
			break;
		case J_DRAW:
			textout (dest, f, TEXT_EMPATE(), posx, posy, makecol(255, 255, 0));
			break;
		}
		posy+=tam_parr;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->puntos->nivel);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->puntos->lineas);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->puntos->puntos);
		posy+=tam_parr;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.puntos_lineas);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.puntos_piezas);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.puntos_bonus);
		posy+=tam_parr;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.num_lineas[0]);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.num_lineas[1]);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.num_lineas[2]);
		posy+=tam_linea;
		textprintf (dest, f, posx, posy, blanco, "%d", juego->jug[i]->stats.num_lineas[3]);
		posy+=tam_parr;
		for(j=0; j<juego->jug[i]->piezas->num; j++)
		{
			textprintf (dest, f, posx, posy+j*tam_linea, blanco, "%d", juego->jug[i]->stats.num_piezas[j]);
		}
	}
	video.Actualizar();

	clear_keybuf();
	while(!keypressed());
}

void add_mini_score(t_mini_score_list *sc_list, int posx, int posy, int score, int color)
{
	sc_list->list[sc_list->n].live = 300;
	sc_list->list[sc_list->n].posx = posx;
	sc_list->list[sc_list->n].posy = posy;
	sc_list->list[sc_list->n].visible = true;
	sc_list->list[sc_list->n].score = score;
	clear_to_color(sc_list->list[sc_list->n].score_bmp, makecol(255,0,255));

	switch (sc_list->pos)
	{
	case DERECHA:
		textprintf(sc_list->list[sc_list->n].score_bmp, font, 0, 0, color, "%d", score);
		break;
	case IZQUIERDA:
		textprintf_right(sc_list->list[sc_list->n].score_bmp, font, sc_list->list[sc_list->n].score_bmp->w, 0, color, "%d", score);
		break;
	}

	sc_list->n = (sc_list->n+1)%NUM_SCORE_LIST;
}

void mini_score_siguiente_paso(t_mini_score_list *sc_list)
{
	int i;

	for(i=0; i<NUM_SCORE_LIST; i++)
	{
		if (sc_list->list[i].visible)
		{
			if (!(sc_list->list[i].live%5))
			{
				sc_list->list[i].posy--;
			}
			sc_list->list[i].live--;
			if (sc_list->list[i].live<=0)
			{
				sc_list->list[i].visible = false;
			}
		}
	}
}

void dibujar_mini_score(BITMAP *dest, t_mini_score_list *sc_list)
{
	int i;

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	for(i=0; i<NUM_SCORE_LIST; i++)
	{
		if (sc_list->list[i].visible)
		{
			set_trans_blender(0, 0, 0, 255*sc_list->list[i].live/300);
			switch (sc_list->pos)
			{
			case DERECHA:
				draw_trans_sprite(dest, sc_list->list[i].score_bmp, sc_list->list[i].posx, sc_list->list[i].posy);
				break;
			case IZQUIERDA:
				draw_trans_sprite(dest, sc_list->list[i].score_bmp, sc_list->list[i].posx-sc_list->list[i].score_bmp->w, sc_list->list[i].posy);
				break;
			}
		}
	}
	solid_mode();
}

bool tablero_vacio(t_tablero *tab)
{
	int i, j;
	bool ret = true;

	j=0;
	while (j<tab->tamy && ret)
	{
		i=0;
		while (i<tab->tamx && ret)
		{
			if (tab->cuadro[i][j] >= 0)
			{
				ret = false;
			}
			i++;
		}
		j++;
	}

	return ret;
}

int se_puede_mover(t_set_piezas *piezas, int num_pieza, int pieza_pos_x, int pieza_pos_y, int pieza_rot, t_tablero *tab)
{
	int i, j, p;
	int x, y;

	y = pieza_pos_y;
	for(j=0; j<4; j++)
	{
		x = pieza_pos_x;
		for(i=0; i<4; i++)
		{
			p = piezas->pieza_rot[num_pieza][pieza_rot].c[i][j];
			if (piezas->pieza[num_pieza][p] >= 0)
			{
				if (x<0) return 0;
				if (x>tab->tamx-1) return 0;
				if (y>=0)
				{
					if (y>tab->tamy-1) return 0;
					if (tab->cuadro[x][y] >= 0) return 0;
				}
			}
			x++;
		}
		y++;
	}

	return 1;
}

int colisiona_con_pieza(t_jug* jug, t_set_piezas *piezas, int num_pieza, int pieza_pos_x, int pieza_pos_y, int pieza_rot, t_juego* juego, t_tablero *tab)
{
	int i, j, p, p2;
	int x, y, x2, y2;
	int a;

	y = pieza_pos_y;
	for(j=0; j<4; j++)
	{
		x = pieza_pos_x;
		for(i=0; i<4; i++)
		{
			p = piezas->pieza_rot[num_pieza][pieza_rot].c[i][j];
			if (piezas->pieza[num_pieza][p] >= 0)
			{
				for(a=0; a<juego->num_jug; a++)
				{
					if (juego->jug[a] != jug)
					{
						if (juego->jug[a]->tab == tab)
						{
							if (!juego->jug[a]->sacar_siguiente)
							{
								x2 = juego->jug[a]->pieza_pos_x;
								y2 = juego->jug[a]->pieza_pos_y;
								if (x2<=x && x2>x-4 && y2<=y && y2>y-4)
								{
									p2 = juego->jug[a]->piezas->pieza_rot[juego->jug[a]->pieza][juego->jug[a]->pieza_rot].c[x-x2][y-y2];
									if (juego->jug[a]->piezas->pieza[juego->jug[a]->pieza][p2] >= 0)
									{
										return 1;
									}
								}
							}
						}
					}
				}
  			}
			x++;
		}
		y++;
	}

	return 0;
}

int colocar_pieza(t_tablero* tab, t_set_piezas *piezas, int pieza, int pieza_pos_x, int pieza_pos_y, int pieza_rot)
{
	int i, j, p;
	int x, y;
	int ret=0;

	FSOUND_PlaySound(FSOUND_FREE, sound_colocar_pieza);

	y = pieza_pos_y;
	for(j=0; j<4; j++)
	{
		x = pieza_pos_x;
		for(i=0; i<4; i++)
		{
			p = piezas->pieza_rot[pieza][pieza_rot].c[i][j];
			if (piezas->pieza[pieza][p] >= 0)
			{
				if (y>=0)
				{
					tab->cuadro[x][y] = piezas->pieza[pieza][p];
					ret = tab->tamy-y-1;
				}
				else
				{
					tab->estado = EST_GAMEOVER;
				}
			}
			x++;
		}
		y++;
	}

	return ret;
}

void dibujar_tablero(BITMAP* dest, t_tablero* tab, t_set_piezas* piezas, BITMAP *graf_piezas)
{
	int i, j, p;
	int x, y;

	y = tab->posy;
	for(j=0; j<tab->tamy; j++)
	{
		x = tab->posx;
		for(i=0; i<tab->tamx; i++)
		{
			p = tab->cuadro[i][j];
			if(p >= 0)
			{
				blit(graf_piezas, dest, p*20, 0, x, y, 20, 20);
			}
			x+=20;
		}
		y+=20;
	}
	if (tab->nivel_visible)
	{
		textout (dest, roman12, TEXT_NIVEL(), tab->nivel_posx+5, tab->nivel_posy+5, makecol(255,255,255));
		textprintf (dest, roman12, tab->nivel_posx+5, tab->nivel_posy+25, makecol(255,255,255), "%d", tab->nivel);
	}
}

// Usada para dibujar la siguiente pieza
void dibujar_pieza(BITMAP* dest, int posx, int posy, t_set_piezas *piezas, BITMAP *graf_piezas, int pieza, int pieza_rot)
{
	int x, y;
	int i, j, p;

	x = posx;

	for(i=0; i<4; i++)
	{
		y = posy;
		for(j=0; j<4; j++)
		{
			p = piezas->pieza_rot[pieza][pieza_rot].c[i][j];
			if (piezas->pieza[pieza][p] >= 0)
			{
				blit (graf_piezas, dest, piezas->pieza[pieza][p]*20, 0, x, y, 20, 20);
			}
			y+=20;
		}
		x+=20;
	}
}

// Usada para dibujar la pieza actual
void dibujar_pieza(BITMAP* dest, t_jug& ju) //t_tablero *tab, t_set_piezas *piezas, BITMAP *graf_piezas, int pieza, int pieza_pos_x, int pieza_pos_y, int pieza_rot)
{
	int x, y;
	int i, j, p;

	x = ju.tab->posx+ju.pieza_pos_x*20;

	for(i=0; i<4; i++)
	{
		y = ju.tab->posy+ju.pieza_pos_y*20;
		for(j=0; j<4; j++)
		{
			if (ju.pieza_pos_y+j>=0)
			{
//				int y_offset = y-20*ju.pieza_sig_paso/obtener_velocidad(ju.tab->nivel);
				p = ju.piezas->pieza_rot[ju.pieza][ju.pieza_rot].c[i][j];
				if (ju.piezas->pieza[ju.pieza][p] >= 0)
				{
					blit (ju.graf_piezas, dest, ju.piezas->pieza[ju.pieza][p]*20, 0, x, y, 20, 20);
					/*
					if (ju.pieza_pos_y+j == 0)
					{
						blit (ju.graf_piezas, dest, ju.piezas->pieza[ju.pieza][p]*20, 20*ju.pieza_sig_paso/obtener_velocidad(ju.tab->nivel), x, ju.tab->posy, 20, 20-20*ju.pieza_sig_paso/obtener_velocidad(ju.tab->nivel));
					}
					else
					{
						blit (ju.graf_piezas, dest, ju.piezas->pieza[ju.pieza][p]*20, 0, x, y_offset, 20, 20);
					}
					*/
				}
			}
			y+=20;
		}
		x+=20;
	}
}

void eliminar_lineas(t_tablero *tab, int *linea, int num)
{
	int y, x;
	int l=0;

	y = tab->tamy-1;
	while (y >= 0)
	{
		while (l<num && y-l == linea[l])
		{
			l++;
		}
		if (l>0)
		{
			if (y-l >= 0)
			{
				for(x=0; x<tab->tamx; x++)
				{
					tab->cuadro[x][y] = tab->cuadro[x][y-l];
				}
			}
			else
			{
				for(x=0; x<tab->tamx; x++)
				{
					tab->cuadro[x][y] = -1;
				}
			}
		}
		y--;
	}
}

void insertar_linea(t_tablero *tab, char num)
{
	int i, j;

	for(j=0; j<tab->tamy-1; j++)
	{
		for(i=0; i<tab->tamx; i++)
		{
			tab->cuadro[i][j] = tab->cuadro[i][j+1];
		}
	}

	for(i=0; i<tab->tamx; i++)
	{
		tab->cuadro[i][tab->tamy-1] = rand() % num;
	}
	for(i=0; i<4; i++)
	{
		tab->cuadro[rand()%tab->tamx][tab->tamy-1] = -1;
	}
}

void penalizar(t_juego* juego, t_tablero *tab, int lineas)
{
	int i, j, k;
	t_jug *jug = NULL;

	for(i=0; i<lineas; i++)
	{
		for (j=0; j<juego->num_jug && !jug; j++)
		{
			if (juego->jug[j]->tab == tab)
			{
				jug = juego->jug[j];
			}
		}
		for(k=0; k<jug->tab->tamx; k++)
		{
			if (jug->tab->cuadro[k][0] >= 0)
			{
				jug->tab->estado = EST_GAMEOVER;
			}
		}
		insertar_linea(tab, juego->jug[0]->graf_piezas->w/20);

		for (j=0; j<juego->num_jug; j++)
		{
			jug = juego->jug[j];
			if (jug->tab == tab)
			{
				if (!se_puede_mover(jug->piezas, jug->pieza, jug->pieza_pos_x, jug->pieza_pos_y, jug->pieza_rot, jug->tab))
				{
					jug->pieza_pos_y--;
					jug->pieza_sig_paso=0;
				}
			}
		}
	}
}

int comprobar_lineas(t_juego *juego, t_jug *jug)
{
	int x, y, i;
	bool eslinea;
	int linea[4];
	int num_lineas=0;
	int puntos = 0;
	int num_puntos;

	for(y=jug->tab->tamy-1; y>=0; y--)
	{
		eslinea = true;
		x=0;
		while (eslinea && x<jug->tab->tamx)
		{
			if (jug->tab->cuadro[x][y] < 0) eslinea=false;
			x++;
		}
		if (eslinea)
		{
			linea[num_lineas] = y;
			jug->tab->eliminar_lineas[num_lineas] = y;
			num_lineas++;
		}
	}

	if (num_lineas)
	{
		if (num_lineas == 4)
		{
			FSOUND_PlaySound(FSOUND_FREE, sound_tetris);
		}
		else
		{
			FSOUND_PlaySound(FSOUND_FREE, sound_linea);
		}
		jug->puntos->lineas += num_lineas;
		jug->tab->lineas += num_lineas;
		jug->tab->prox_nivel-=num_lineas;
		jug->tab->num_lineas = num_lineas;

		jug->tab->estado = EST_ANIM_LINEAS;

		for(i=0; i<num_lineas; i++)
		{
			puntos+=30*num_lineas;
			jug->tab->sist_particulas[i].ModificarPosicion(jug->tab->posx+5, jug->tab->posy+linea[i]*20+10);
		}
		num_puntos = int((jug->puntos->nivel/2.0+0.5)*puntos);
		jug->puntos->puntos += num_puntos;

		jug->stats.num_lineas[num_lineas-1]++;
		jug->stats.puntos_lineas += num_puntos;

		switch (jug->mini_scores.pos)
		{
		case DERECHA:
			add_mini_score (&jug->mini_scores, jug->tab->posx+jug->tab->tamx*20+3, jug->tab->posy+linea[0]*20-14, num_puntos, makecol(255, 192, 64));
			break;
		case IZQUIERDA:
			add_mini_score (&jug->mini_scores, jug->tab->posx-3, jug->tab->posy+linea[0]*20-14, num_puntos, makecol(255, 192, 64));
			break;
		}

		if (jug->tab->prox_nivel <= 0 && jug->tab->nivel < 10)
		{
			jug->tab->nivel++;
			jug->tab->prox_nivel = 10 + jug->tab->prox_nivel;
			jug->puntos->nivel = jug->tab->nivel;
			reproducir_musica(rand()%num_canciones, 1);
			counter = 0;
		}
	}

	return num_lineas;
}

unsigned short primera_fila_no_libre(const t_pieza &pieza_rot, const signed char pieza[16])
{
	int i;
	bool fin = false;

	for (i=3; i>=0 && !fin; i--)
	{
		if (pieza[pieza_rot.c[0][i]]>=0 ||
			pieza[pieza_rot.c[1][i]]>=0 ||
			pieza[pieza_rot.c[2][i]]>=0 ||
			pieza[pieza_rot.c[3][i]]>=0)
		{
			fin = true;
		}
	}

	return i+1;
}

unsigned short ultima_fila_no_libre(const t_pieza &pieza_rot, const signed char pieza[16])
{
	int i;
	bool fin = false;

	for (i=0; i<4 && !fin; i++)
	{
		if (pieza[pieza_rot.c[0][i]]>=0 ||
			pieza[pieza_rot.c[1][i]]>=0 ||
			pieza[pieza_rot.c[2][i]]>=0 ||
			pieza[pieza_rot.c[3][i]]>=0)
		{
			fin = true;
		}
	}

	return i-1;
}

