//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "gui.h"
#include "gfx.h"
#include "jugador.h"
#include "Controles.h"
#include "ControlTeclado.h"
#include "ControlJoystick.h"
#include "editor.h"
#include "consola.h"
#include "sis_part.h"
#include "juego.h"
#include "juego2.h"
#include "musica.h"
#include "globals.h"
#include "ExcepcionTU.h"
#include "AnimData.h"
#include "Anim.h"


static int intervalo_enviar;
static int barra_recibir_anim;


INLINE int obtener_velocidad(int nivel)
{
	static int vel[10] = {55, 40, 30, 20, 15, 12, 9, 7, 5, 4};

	return vel[nivel-1];
}

CControles *generar_controles(controles *ctrl, t_jugador *jug)
{
	switch(ctrl->tipo)
	{
	case 0:
		{
		CControlTeclado *ct = new CControlTeclado;

		ct->ConfigurarKeyDelay(jug->key_rate_delay);
		ct->ConfigurarKeyRepeat(jug->key_rate_repeat);

		ct->ConfigurarControl(CControles::ctrl_der, ctrl->key_der);
		ct->ConfigurarControl(CControles::ctrl_izq, ctrl->key_izq);
		ct->ConfigurarControl(CControles::ctrl_rotar_izq, ctrl->key_rotar_izq);
		ct->ConfigurarControl(CControles::ctrl_rotar_der, ctrl->key_rotar_der);
		ct->ConfigurarControl(CControles::ctrl_abajo, ctrl->key_abajo);

		return ct;
		}
	case 1:
		{
		CControlJoystick *cj = new CControlJoystick;

		cj->ConfigurarKeyDelay(jug->key_rate_delay);
		cj->ConfigurarKeyRepeat(jug->key_rate_repeat);

		cj->ConfigurarControl(CControles::ctrl_der, ctrl->joy_der);
		cj->ConfigurarControl(CControles::ctrl_izq, ctrl->joy_izq);
		cj->ConfigurarControl(CControles::ctrl_rotar_izq, ctrl->joy_rotar_izq);
		cj->ConfigurarControl(CControles::ctrl_rotar_der, ctrl->joy_rotar_der);
		cj->ConfigurarControl(CControles::ctrl_abajo, ctrl->joy_abajo);

		return cj;
		}
	}

	throw new ExcepcionTU("Error en la configuracin de los controles: tipo de control no vlido", -1);
}

void comenzar_juego(BITMAP* fondo, t_juego *juego, t_modo_juego tipo_juego)
{
	unsigned int tiempo_juego=0;
	bool global_gameover = false;
	struct controles *ctrl_array[4] = {&control_p1, &control_p2, &control_p3, &control_p4};
	int fin=0;
	int i, j;
	int limit_rect_trans = 200;
	int limit_rect_trans_speed = 2;
	int jugador_primer_tetris = -1;


	BITMAP* dst;
	BITMAP* gameover_bmp = video.CargarPng(path_data + "/tetris.dat#GAMEOVER", Video::no_hw);
	BITMAP* timeout_bmp = video.CargarPng(path_data + "/tetris.dat#TIMEOUT", Video::no_hw);
	BITMAP* single_line_bmp = video.CargarPng(path_data + "/tetris.dat#SINGLE", Video::no_hw);

	CAnimData anim_single;
	anim_single.Cargar(path_data + "/single_anim.ani");

	CAnimData anim_double;
	anim_double.Cargar(path_data + "/double_anim.ani");

	CAnimData anim_triple;
	anim_triple.Cargar(path_data + "/triple_anim.ani");

	CAnimData anim_tetris;
	anim_tetris.Cargar(path_data + "/tetris_anim.ani");

//	CAnimData anim_chispas;
//	anim_chispas.Cargar(path_data + "/chispas.ani");

	CAnim animaciones_lineas;
//	CAnim animaciones_chispas;

	dibujar_recuadro_trans(fondo, 6, SCREEN_H-25, SCREEN_W-6, SCREEN_H-5, 127);

	intervalo_enviar = juego->tiempo_entre_lineas;

	barra_recibir_anim = 0;

	for(i=0; i<juego->num_jug; i++)
	{
		if (!juego->jug[i]->jug)
		{
			juego->jug[i]->jug = &jugador_anonimo;
		}

		juego->jug[i]->ctrl = generar_controles(ctrl_array[i], juego->jug[i]->jug);
		juego->jug[i]->ctrl->Iniciar();

		initialize_stats(juego->jug[i]->stats);
		initialize_mini_score(juego->jug[i]->mini_scores);

		juego->jug[i]->sacar_siguiente = true;

		juego->jug[i]->sig_pieza = juego->jug[i]->serie_piezas->rand()%juego->jug[i]->piezas->num;
/*
		juego->jug[i]->pieza = juego->jug[i]->serie_piezas->rand()%juego->jug[i]->piezas->num;
		juego->jug[i]->sig_pieza = juego->jug[i]->serie_piezas->rand()%juego->jug[i]->piezas->num;
		juego->jug[i]->pieza_pos_x = juego->jug[i]->pieza_pos_x_start;
		if (juego->jug[i]->tab->caer_desde_fuera)
		{
			juego->jug[i]->pieza_pos_y = -primera_fila_no_libre(
										juego->jug[i]->piezas->pieza_rot[juego->jug[i]->pieza][0],
										juego->jug[i]->piezas->pieza[juego->jug[i]->pieza]);
		}
		else
		{
			juego->jug[i]->pieza_pos_y = -ultima_fila_no_libre(
										juego->jug[i]->piezas->pieza_rot[juego->jug[i]->pieza][0],
										juego->jug[i]->piezas->pieza[juego->jug[i]->pieza]);
		}
		juego->jug[i]->pieza_rot = 0;
		juego->jug[i]->pieza_sig_paso = 20;
		juego->jug[i]->piece_score = 3+juego->jug[i]->tab->nivel*2;
*/	}

	for(i=0; i<juego->num_tab; i++)
	{
		dibujar_recuadro_trans(fondo, juego->tab[i]->posx , juego->tab[i]->posy, juego->tab[i]->posx+juego->tab[i]->tamx*20, juego->tab[i]->posy+juego->tab[i]->tamy*20, 127);
		juego->tab[i]->enviadas = 0;
		juego->tab[i]->estado = 0;
		juego->tab[i]->recibir_lineas = 0;
		juego->tab[i]->barra_recibir_lineas = 0;
		juego->tab[i]->nueva_pieza = false;

		for (j=0; j<4; j++)
		{
			juego->tab[i]->sist_particulas[j].ModificarPosicionSuelo(SCREEN_H-5);
			juego->tab[i]->sist_particulas[j].ModificarNumeroBotes(2);
			juego->tab[i]->sist_particulas[j].ModificarGravedad(0.2);
			juego->tab[i]->sist_particulas[j].ModificarFrecuencia(0);
			juego->tab[i]->sist_particulas[j].ModificarCantidad(3);
			juego->tab[i]->sist_particulas[j].ModificarAngulo(180, 360);
			juego->tab[i]->sist_particulas[j].ModificarVariavilidadPosicion(10, 10);
			juego->tab[i]->sist_particulas[j].ModificarVariabilidadVelocidad(3);
			juego->tab[i]->sist_particulas[j].ModificarVida(150);
			juego->tab[i]->sist_particulas[j].ModificarFadeOut(40);
			juego->tab[i]->sist_particulas[j].ModificarCalidad(part_qual);
			juego->tab[i]->sist_particulas[j].ModificarVelocidad(5);
			juego->tab[i]->sist_particulas[j].Iniciar(brillo_bmp);
		}
	}

	for(i=0; i<juego->num_tab; i++)
	{
		if (juego->tab[i]->nivel_visible)
		{
			dibujar_recuadro_trans(fondo, juego->tab[i]->nivel_posx, juego->tab[i]->nivel_posy, juego->tab[i]->nivel_posx+80, juego->tab[i]->nivel_posy+50, 127);
		}
	}

	for(i=0; i<juego->num_punt; i++)
	{
		if (juego->puntos[i]->visible)
		{
			dibujar_recuadro_trans(fondo, juego->puntos[i]->posx, juego->puntos[i]->posy, juego->puntos[i]->posx+80, juego->puntos[i]->posy+100, 127);
		}
	}

	for(i=0; i<juego->num_jug; i++)
	{
		t_cuadro_sig_pieza *s = juego->jug[i]->cuadro_sig_pieza;
		if (s->visible)
		{
			dibujar_recuadro_trans(fondo, s->posx, s->posy, s->posx+4*20, s->posy+4*20, 127);
		}
	}

	video.ModificarVista(SCREEN_W, SCREEN_H);

	counter = 0;
	while (!fin)
	{
		int anti_bloqueo = 0;
		while (counter > 0)
		{
			animaciones_lineas.Ciclo();
//			animaciones_chispas.Ciclo();
			limit_rect_trans += limit_rect_trans_speed;
			if (limit_rect_trans >= 255)
			{
				limit_rect_trans = 255;
				limit_rect_trans_speed = -limit_rect_trans_speed;
			}
			else if (limit_rect_trans <= 100)
			{
				limit_rect_trans = 100;
				limit_rect_trans_speed = -limit_rect_trans_speed;
			}
			barra_recibir_anim++;
			if (barra_recibir_anim > 360)
			{
				barra_recibir_anim = 0;
			}
			for (i=0; i<juego->num_jug; i++)
			{
				if (juego->jug[i]->tab->estado != EST_GAMEOVER &&
					juego->jug[i]->tab->estado != EST_ANIM_LINEAS)
				{
					if (juego->jug[i]->sacar_siguiente == true)
					{
						int y;
						if (juego->jug[i]->tab->caer_desde_fuera)
						{
							y = -primera_fila_no_libre(
								juego->jug[i]->piezas->pieza_rot[juego->jug[i]->sig_pieza][0],
								juego->jug[i]->piezas->pieza[juego->jug[i]->sig_pieza]);
						}
						else
						{
							y = -ultima_fila_no_libre(
								juego->jug[i]->piezas->pieza_rot[juego->jug[i]->pieza][0],
								juego->jug[i]->piezas->pieza[juego->jug[i]->pieza]);
						}
						while (colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->sig_pieza, juego->jug[i]->pieza_pos_x_start, y, 0, juego, juego->jug[i]->tab))
						{
							y--;
						}
						juego->jug[i]->piece_score = 3+juego->jug[i]->tab->nivel*2;
						juego->jug[i]->pieza = juego->jug[i]->sig_pieza;
						juego->jug[i]->sig_pieza = juego->jug[i]->serie_piezas->rand()%juego->jug[i]->piezas->num;
						juego->jug[i]->pieza_pos_x = juego->jug[i]->pieza_pos_x_start;
						juego->jug[i]->pieza_pos_y = y;
						juego->jug[i]->pieza_rot = 0;
						juego->jug[i]->pieza_sig_paso = obtener_velocidad(juego->jug[i]->tab->nivel);
						juego->jug[i]->tab->nueva_pieza = true;
						juego->jug[i]->sacar_siguiente = false;
					}
					if (!se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot, juego->jug[i]->tab))
					{
						juego->jug[i]->tab->estado = EST_GAMEOVER;
					}
				}
			}
			if (intervalo_enviar == 0)
			{
				bool all_ok = true;
				for(i=0; i<juego->num_tab; i++)
				{
					if (juego->tab[i]->estado == EST_ANIM_LINEAS) all_ok = false;
				}
				if (all_ok)
				{
					intervalo_enviar = juego->tiempo_entre_lineas;
					for (i=0; i<juego->num_tab; i++)
					{
						if (juego->tab[i]->estado == 0)
						{
							if (juego->tab[i]->recibir_lineas)
							{
								if (!juego->enviar_lineas_esperar_nueva_pieza ||
									juego->tab[i]->nueva_pieza)
								{
									penalizar(juego, juego->tab[i], juego->tab[i]->recibir_lineas);
									juego->tab[i]->recibir_lineas = 0;
								}
							}
						}
					}
				}
			}

			for(i=0; i<juego->num_tab; i++)
			{
				if (juego->tab[i]->estado == 0)
				{
					juego->tab[i]->nueva_pieza = false;
				}
			}

			if (!(global_gameover &&
				(juego->tiempo_extra == 0 ||
				(juego->tiempo>0 && juego->tiempo-tiempo_juego<=0))))
			{
				tiempo_juego++;
				if (intervalo_enviar > 0)
				{
					intervalo_enviar--;
				}
			}
			if (juego->tiempo>0)
			{
				if (juego->tiempo-tiempo_juego<=0)
				{
					global_gameover=true;
					for(i=0; i<juego->num_tab; i++)
					{
//						if (juego->tab[i]->estado != EST_ANIM_LINEAS)
//						{
						if (juego->tab[i]->estado != EST_GAMEOVER)
						{
							juego->tab[i]->estado = EST_TIMEOUT;
						}
//						}
					}
				}
			}
			if (global_gameover && juego->tiempo_extra > 0)
			{
				juego->tiempo_extra--;
			}
			anti_bloqueo++;
			if (anti_bloqueo > 600)
			{
				string sa = string(TEXT_antibloqueo_1()) + string(TEXT_antibloqueo_2());
				throw new ExcepcionTU(sa, -2);
			}
			for (i=0; i<juego->num_jug; i++)
			{
				mini_score_siguiente_paso(&juego->jug[i]->mini_scores);
			}
			for (i=0; i<juego->num_tab; i++)
			{
				for(j=0; j<4; j++)
				{
					if (juego->tab[i]->barra_recibir_lineas < juego->tab[i]->recibir_lineas*20)
					{
						juego->tab[i]->barra_recibir_lineas += 0.5;
					}
					else if (juego->tab[i]->barra_recibir_lineas > juego->tab[i]->recibir_lineas*20)
					{
						juego->tab[i]->barra_recibir_lineas -= 1;
					}

					switch (juego->tab[i]->estado)
					{
					case 0:
					case EST_GAMEOVER:
					case EST_TIMEOUT:
						juego->tab[i]->sist_particulas[j].EmitirParticulas(false);
						juego->tab[i]->sist_particulas[j].Ciclo();
						break;
					case EST_ANIM_LINEAS:
						if (j<juego->tab[i]->num_lineas)
						{
							int del_cuadrado = int((juego->tab[i]->sist_particulas[j].ObtenerPosicionX()
								-juego->tab[i]->posx-15)/20);
							if (del_cuadrado >= 0 && del_cuadrado < juego->tab[i]->tamx)
							{
								juego->tab[i]->cuadro[del_cuadrado][juego->tab[i]->eliminar_lineas[j]] = -1;
							}

							juego->tab[i]->sist_particulas[j].EmitirParticulas(true);
							juego->tab[i]->sist_particulas[j].ModificarColor(makecol(255, rand()%256, 0));
							juego->tab[i]->sist_particulas[j].Ciclo();

							juego->tab[i]->sist_particulas[j].Mover(5, 0);
							if (juego->tab[i]->sist_particulas[j].ObtenerPosicionX() > juego->tab[i]->posx+juego->tab[i]->tamx*20-10)
							{
								juego->tab[i]->estado = 0;
								eliminar_lineas (juego->tab[i], juego->tab[i]->eliminar_lineas, juego->tab[i]->num_lineas);

								int contrarestadas = 0;
								if(juego->tab[i]->recibir_lineas > 0)
								{
									int contrarestar = juego->tab[i]->contrarestar[juego->tab[i]->num_lineas-1];
									if (contrarestar > 0)
									{
										if (juego->tab[i]->recibir_lineas < contrarestar)
										{
											contrarestadas = juego->tab[i]->recibir_lineas;
											juego->tab[i]->recibir_lineas = 0;
										}
										else
										{
											contrarestadas = contrarestar;
											juego->tab[i]->recibir_lineas -= contrarestar;
										}
									}
								}

								for(j=0; j<juego->num_tab; j++)
								{
									if (juego->v == primer_tetris && juego->tab[i]->num_lineas == 4)
									{
										global_gameover = true;
									}
									if (juego->tab[i]->enviar_lineas[j][juego->tab[i]->num_lineas-1] && juego->tab[j]->estado != EST_GAMEOVER)
									{
										int enviar = juego->tab[i]->enviar_lineas[j][juego->tab[i]->num_lineas-1];
										if (i!=j)
										{
											if (contrarestadas > enviar)
											{
												enviar = 0;
											}
											else
											{
												enviar -= contrarestadas;
											}
											juego->tab[i]->enviadas += enviar;
										}
										juego->tab[j]->recibir_lineas += enviar;
									}
								}

/*								if (tablero_vacio(juego->tab[i]))
								{
									for(j=0; j<juego->num_jug; j++)
									{
										if (juego->jug[j]->tab == juego->tab[i])
										{
											switch (juego->jug[i]->mini_scores.pos)
											{
											case DERECHA:
												add_mini_score (&juego->jug[j]->mini_scores, juego->tab[i]->posx+juego->tab[i]->tamx*20+3, juego->tab[i]->posy+juego->tab[i]->tamy*20-17, juego->jug[j]->puntos->puntos*10, makecol(64, 255, 64));
												break;
											case IZQUIERDA:
												add_mini_score (&juego->jug[j]->mini_scores, juego->tab[i]->posx-3,  juego->tab[i]->posy+juego->tab[i]->tamy*20-17, juego->jug[j]->puntos->puntos*10, makecol(64, 255, 64));
												break;
											}
											juego->jug[j]->puntos->puntos += juego->jug[j]->puntos->puntos*10;
										}
									}
								}
*/							}
						}
						else
						{
							juego->tab[i]->sist_particulas[j].EmitirParticulas(false);
							juego->tab[i]->sist_particulas[j].Ciclo();
						}
						break;
					}
				}
			}
			if (!(global_gameover && juego->tiempo_extra == 0))
			{
				for (i=0; i<juego->num_jug; i++)
				{
					if (!juego->jug[i]->sacar_siguiente)
					{
						switch (juego->jug[i]->tab->estado)
						{
						case 0:
							juego->jug[i]->pieza_sig_paso--;
							if (juego->jug[i]->pieza_sig_paso<=0)
							{
								if (se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y+1, juego->jug[i]->pieza_rot, juego->jug[i]->tab))
								{
									if (!colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y+1, juego->jug[i]->pieza_rot, juego, juego->jug[i]->tab))
									{
										juego->jug[i]->pieza_pos_y++;
										juego->jug[i]->pieza_sig_paso = obtener_velocidad(juego->jug[i]->tab->nivel);
									}
								}
								else
								{
									int chispa_y = primera_fila_no_libre(juego->jug[i]->piezas->pieza_rot[juego->jug[i]->pieza][juego->jug[i]->pieza_rot], juego->jug[i]->piezas->pieza[juego->jug[i]->pieza]);

									chispa_y*=20;
									chispa_y+=juego->jug[i]->tab->posy+18;
									chispa_y+=juego->jug[i]->pieza_pos_y*20;
/*
									for(int iter=0, h = 10+juego->jug[i]->tab->posx+juego->jug[i]->pieza_pos_x*20; iter<4; iter++, h+=20)
									{
										animaciones_chispas.Insertar(&anim_chispas, h, chispa_y);
									}
*/
									int pieza_posy = colocar_pieza(juego->jug[i]->tab, juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot);
									juego->jug[i]->stats.num_piezas[juego->jug[i]->pieza]++;
									int puntos = 0;
									if (juego->jug[i]->puntos_dejar_caer)
									{
										puntos += juego->jug[i]->piece_score;
										juego->jug[i]->stats.puntos_piezas += juego->jug[i]->piece_score;
									}
									if (juego->jug[i]->puntos_piezas)
									{
										puntos += (pieza_posy+1)*juego->jug[i]->tab->nivel;
										juego->jug[i]->stats.puntos_bonus += (pieza_posy+1)*juego->jug[i]->tab->nivel;
									}
									juego->jug[i]->puntos->puntos += puntos;

									if (puntos > 0)
									{
										switch (juego->jug[i]->mini_scores.pos)
										{
										case DERECHA:
											add_mini_score (&juego->jug[i]->mini_scores, juego->jug[i]->tab->posx+juego->jug[i]->tab->tamx*20+3, juego->jug[i]->tab->posy+(juego->jug[i]->tab->tamy-pieza_posy)*20-20+3, puntos, makecol(255, 255, 255));
											break;
										case IZQUIERDA:
											add_mini_score (&juego->jug[i]->mini_scores, juego->jug[i]->tab->posx-3, juego->jug[i]->tab->posy+(juego->jug[i]->tab->tamy-pieza_posy)*20-20+3, puntos, makecol(255, 255, 255));
											break;
										}
									}

									if (juego->jug[i]->tab->estado != EST_GAMEOVER)
									{
										for(j=0; j<juego->jug[i]->tab->tamx; j++)
										{
											if (juego->jug[i]->tab->cuadro[j][0] >= 0)
											{
												juego->jug[i]->tab->estado = EST_GAMEOVER;
											}
										}
										if (comprobar_lineas(juego, juego->jug[i]) == 4)
										{
											if (jugador_primer_tetris < 0)
											{
												jugador_primer_tetris = i;
											}
										}

										if (juego->jug[i]->tab->estado == EST_ANIM_LINEAS)
										{
											int anim_x = juego->jug[i]->tab->posx + juego->jug[i]->tab->tamx*10;
											int anim_y = juego->jug[i]->tab->posy + juego->jug[i]->tab->tamy*10;
											switch(juego->jug[i]->tab->num_lineas)
											{
											case 1:
												animaciones_lineas.Insertar(&anim_single, anim_x, anim_y);
												break;
											case 2:
												animaciones_lineas.Insertar(&anim_double, anim_x, anim_y);
												break;
											case 3:
												animaciones_lineas.Insertar(&anim_triple, anim_x, anim_y);
												break;
											case 4:
												animaciones_lineas.Insertar(&anim_tetris, anim_x, anim_y);
												break;
											}
										}
									}
									juego->jug[i]->sacar_siguiente = true;
								}
							}
							break;
						case EST_GAMEOVER:
							break;
						case EST_ANIM_LINEAS:
							break;
						}
					}
				}

				for (i=0; i<juego->num_jug; i++)
				{
					if (!juego->jug[i]->sacar_siguiente)
					{
						switch (juego->jug[i]->tab->estado)
						{
						case 0:

							juego->jug[i]->ctrl->Ciclo();

							if(juego->jug[i]->ctrl->EstadoControl(CControles::ctrl_izq))
							{
								if (se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x-1, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot, juego->jug[i]->tab))
								{
									if (!colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x-1, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot, juego, juego->jug[i]->tab))
									{
										juego->jug[i]->pieza_pos_x--;
									}
								}
							}
							if(juego->jug[i]->ctrl->EstadoControl(CControles::ctrl_der))
							{
								if (se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x+1, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot, juego->jug[i]->tab))
								{
									if (!colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x+1, juego->jug[i]->pieza_pos_y, juego->jug[i]->pieza_rot, juego, juego->jug[i]->tab))
									{
										juego->jug[i]->pieza_pos_x++;
									}
								}
							}
							if(juego->jug[i]->ctrl->EstadoControl(CControles::ctrl_rotar_izq))
							{
								int r = juego->jug[i]->pieza_rot-1;
								if (r<0) r=3;
								if (se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, r, juego->jug[i]->tab))
								{
									if (!colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, r, juego, juego->jug[i]->tab))
									{
										FSOUND_PlaySound(FSOUND_FREE, sound_girar_pieza);
										juego->jug[i]->pieza_rot = r;
									}
								}
							}
							if(juego->jug[i]->ctrl->EstadoControl(CControles::ctrl_rotar_der))
							{
								if (se_puede_mover(juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, (juego->jug[i]->pieza_rot+1)%4, juego->jug[i]->tab))
								{
									if (!colisiona_con_pieza(juego->jug[i], juego->jug[i]->piezas, juego->jug[i]->pieza, juego->jug[i]->pieza_pos_x, juego->jug[i]->pieza_pos_y, (juego->jug[i]->pieza_rot+1)%4, juego, juego->jug[i]->tab))
									{
										FSOUND_PlaySound(FSOUND_FREE, sound_girar_pieza);
										juego->jug[i]->pieza_rot = (juego->jug[i]->pieza_rot+1)%4;
									}
								}
							}
							if(juego->jug[i]->ctrl->EstadoControl(CControles::ctrl_abajo))
							{
								juego->jug[i]->piece_score++;
								juego->jug[i]->pieza_sig_paso=1;
							}

							if(key[KEY_P])
							{
								clear_keybuf();
								pause_effect(fondo);
								key[KEY_P]=0;
								counter = 0;
							}
							break;
						case EST_TIMEOUT:
							if (key[KEY_ENTER]) fin = true;
						case EST_GAMEOVER:
							break;
						case EST_ANIM_LINEAS:
							break;
						}
					}
				}
			}
			else
			{
				if (key[KEY_ENTER]) fin = true;
			}

			if (juego->num_tab > 1)
			{
				int num_game_over=0;
				for(i=0; i<juego->num_tab; i++)
				{
					if (juego->tab[i]->estado == EST_GAMEOVER || juego->tab[i]->estado == EST_TIMEOUT) num_game_over++;
				}
				if (juego->num_tab - num_game_over <= 1)
				{
					global_gameover = true;
				}
				if (juego->num_jug - num_game_over == 0)
				{
					juego->tiempo_extra = 0;
				}
			}
			else
			{
				global_gameover = (juego->tab[0]->estado == EST_GAMEOVER || juego->tab[0]->estado == EST_TIMEOUT);
			}

			counter--;
		}
		anti_bloqueo = 0;

		dst = video.ObtenerPantalla();

		video.IniciarSalida();
		blit(fondo, dst, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

		for(i=0; i<juego->num_tab; i++)
		{
			dibujar_tablero(dst, juego->tab[i], juego->jug[0]->piezas, juego->jug[0]->graf_piezas);
		}
		for(i=0; i<juego->num_jug; i++)
		{
			if (!juego->jug[i]->sacar_siguiente)
			{
				dibujar_pieza(dst, *juego->jug[i]);
			}
			textout_centre (dst, roman12, juego->jug[i]->jug->nick, juego->jug[i]->jug_name_posx, juego->jug[i]->jug_name_posy, makecol(255, 255, 255));
		}
//		animaciones_chispas.Dibujar(dst);
		for(i=0; i<juego->num_tab; i++)
		{
			for(int y=0; y<juego->tab[i]->barra_recibir_lineas; y++)
			{
				int r, g, b;
				const int p1x = -3;
				const int p1w = 2;
				const int p2x = 0;
				const int p2w = 2;

				hsv_to_rgb((y*4+360-barra_recibir_anim)%360, abs(barra_recibir_anim%120-60)/120.0, 1, &r, &g, &b);
				hline (dst, juego->tab[i]->posx+p1x, juego->tab[i]->tamy*20+juego->tab[i]->posy-y-1, juego->tab[i]->posx+p1x+p1w, makecol(r,g,b));
				hline (dst, juego->tab[i]->posx+juego->tab[i]->tamx*20+p2x, juego->tab[i]->tamy*20+juego->tab[i]->posy-y-1, juego->tab[i]->posx+juego->tab[i]->tamx*20+p2x+p2w, makecol(r, g, b));

				drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
//				set_trans_blender (255, 255, 255, juego->tab[i]->barra_recibir_lineas-y<100?(juego->tab[i]->barra_recibir_lineas-y):100);
				int trans;
				trans = ((y*2+(360-barra_recibir_anim)*16)%(360))/2;
//				trans /= 4;
				if (trans > 90) trans = 180-trans;
				trans += 60;
				set_trans_blender (255, 255, 255, trans);
				hline (dst, juego->tab[i]->posx+p1x+p1w+1, juego->tab[i]->tamy*20+juego->tab[i]->posy-y-1, juego->tab[i]->posx+juego->tab[i]->tamx*20+p2x-1, makecol(r,g,b));
				solid_mode();
			}
		}
		set_trans_blender (255, 255, 255, limit_rect_trans);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		for(i=0; i<juego->num_tab; i++)
		{
			hline(dst, juego->tab[i]->posx, juego->tab[i]->posy+20, juego->tab[i]->posx+juego->tab[i]->tamx*20-1, makecol(255,0,0));
		}
		set_trans_blender (255, 255, 255, limit_rect_trans/2);
		for(i=0; i<juego->num_tab; i++)
		{
			rectfill(dst, juego->tab[i]->posx, juego->tab[i]->posy, juego->tab[i]->posx+juego->tab[i]->tamx*20-1, juego->tab[i]->posy+20, makecol(255,0,0));
		}
		solid_mode();
		for(i=0; i<juego->num_punt; i++)
		{
			if (juego->puntos[i]->visible)
			{
				textout (dst, roman12, TEXT_LINEAS(), juego->puntos[i]->posx+5, juego->puntos[i]->posy+5, makecol(255,255,255));
				textprintf (dst, roman12, juego->puntos[i]->posx+5, juego->puntos[i]->posy+25, makecol(255,255,255), "%d", juego->puntos[i]->lineas);
				textout (dst, roman12, TEXT_PUNTOS(), juego->puntos[i]->posx+5, juego->puntos[i]->posy+55, makecol(255,255,255));
				textprintf (dst, roman12, juego->puntos[i]->posx+5, juego->puntos[i]->posy+75, makecol(255,255,255), "%d", juego->puntos[i]->puntos);
			}
		}
		textprintf_centre (dst, roman12, SCREEN_W/2, SCREEN_H-25, makecol(255,255,255), "%s - %s", music[act_musica_grupo].nombre, music[act_musica_grupo].cancion[act_musica_num].nombre);
		for (i=0; i<juego->num_jug; i++)
		{
			if (juego->jug[i]->cuadro_sig_pieza->visible)
			{
				if (juego->jug[i]->mostrar_siguiente)
				{
					dibujar_pieza(dst, juego->jug[i]->cuadro_sig_pieza->posx, juego->jug[i]->cuadro_sig_pieza->posy, juego->jug[i]->piezas, juego->jug[i]->graf_piezas, juego->jug[i]->sig_pieza);
				}
				else
				{
					dibujar_pieza(dst, juego->jug[i]->cuadro_sig_pieza->posx, juego->jug[i]->cuadro_sig_pieza->posy, juego->jug[i]->piezas, juego->jug[i]->graf_piezas, rand()%juego->jug[i]->piezas->num);
				}
			}
			dibujar_mini_score(dst, &juego->jug[i]->mini_scores);
		}

		for (i=0; i<juego->num_tab; i++)
		{
			for(j=0; j<4; j++)
			{
				juego->tab[i]->sist_particulas[j].Dibujar(dst);
			}
		}

		animaciones_lineas.Dibujar(dst);

		set_alpha_blender();
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		for (i=0; i<juego->num_tab; i++)
		{
			if (juego->tab[i]->estado == EST_GAMEOVER)
			{
				draw_trans_sprite (dst, gameover_bmp,
					juego->tab[i]->posx+juego->tab[i]->tamx*10 - gameover_bmp->w/2,
					juego->tab[i]->posy+juego->tab[i]->tamy*10 - gameover_bmp->h/2);
			}
			else if (juego->tab[i]->estado == EST_TIMEOUT)
			{
				draw_trans_sprite (dst, timeout_bmp,
					juego->tab[i]->posx+juego->tab[i]->tamx*10 - timeout_bmp->w/2,
					juego->tab[i]->posy+juego->tab[i]->tamy*10 - timeout_bmp->h/2);
			}
/*			else if (juego->tab[i]->estado == EST_ANIM_LINEAS)
			{
				switch(juego->tab[i]->num_lineas)
				{
//				case 1:
//					draw_trans_sprite (dst, single_line_bmp,
//						juego->tab[i]->posx+juego->tab[i]->tamx*10 - single_line_bmp->w/2,
//						juego->tab[i]->posy+juego->tab[i]->tamy*10 - single_line_bmp->h/2);
//					break;
				case 2:
					textout_centre(dst, comic16, "DOUBLE", juego->tab[i]->posx+juego->tab[i]->tamx*10, juego->tab[i]->posy+juego->tab[i]->tamy*10 - 10, makecol(255,255,255));
					break;
				case 3:
					textout_centre(dst, comic16, "TRIPLE", juego->tab[i]->posx+juego->tab[i]->tamx*10, juego->tab[i]->posy+juego->tab[i]->tamy*10 - 10, makecol(255,255,255));
					break;
				case 4:
					textout_centre(dst, comic16, "TETRIS", juego->tab[i]->posx+juego->tab[i]->tamx*10, juego->tab[i]->posy+juego->tab[i]->tamy*10 - 10, makecol(255,255,255));
					break;
				}
			}
*/		}

		solid_mode();
		if (global_gameover)
		{
		}

		int escribir_tiempo;
		if (juego->tiempo >= 0)
		{
			escribir_tiempo = juego->tiempo-tiempo_juego;
		}
		else
		{
			escribir_tiempo = tiempo_juego;
		}
		int tiempo_msec = (escribir_tiempo%60)*10/6;
		int tiempo_sec = (escribir_tiempo/60)%60;
		int tiempo_min = escribir_tiempo/3600;
		int color = makecol(255,255,255);//makecol(255-tiempo_msec, 255-tiempo_msec, 255-tiempo_msec);
		textprintf_centre(dst, roman12, 12, SCREEN_H-25, color, "%1.1d", tiempo_min/10);
		textprintf_centre(dst, roman12, 20, SCREEN_H-25, color, "%1.1d", tiempo_min%10);
		textout_centre(dst, roman12, ":", 26, SCREEN_H-25, color);
		textprintf_centre(dst, roman12, 32, SCREEN_H-25, color, "%1.1d", tiempo_sec/10);
		textprintf_centre(dst, roman12, 40, SCREEN_H-25, color, "%1.1d", tiempo_sec%10);
		textout_centre(dst, roman12, ":", 46, SCREEN_H-25, color);
		textprintf_centre(dst, roman12, 52, SCREEN_H-25, color, "%1.1d", tiempo_msec/10);
		textprintf_centre(dst, roman12, 60, SCREEN_H-25, color, "%1.1d", tiempo_msec%10);

		if (juego->tiempo_entre_lineas > 0)
		{
			textprintf_centre(dst, roman12, 80, SCREEN_H-25, color, "%1.1d", intervalo_enviar/60/10);
			textprintf_centre(dst, roman12, 88, SCREEN_H-25, color, "%1.1d", intervalo_enviar/60%10);
		}

		video.FinalizarSalida();

		if (key[KEY_F12])
		{
			capturar_pantalla();
		}

		video.Actualizar();

		if(key[KEY_ESC]) fin=true;
	}

	for(i=0; i<juego->num_jug; i++)
	{
		delete juego->jug[i]->ctrl;
	}

	video.DestruirBitmap(gameover_bmp);
	video.DestruirBitmap(timeout_bmp);
	video.DestruirBitmap(single_line_bmp);
	anim_single.Destruir();
	anim_double.Destruir();
	anim_triple.Destruir();
	anim_tetris.Destruir();
//	anim_chispas.Destruir();
	animaciones_lineas.Vaciar();
//	animaciones_chispas.Vaciar();

	int win_lose_array[4];
	if (global_gameover)
	{
		int num_ganadores = 0;
		int maxima_puntuacion = 0;
		int maximo_num_lineas = 0;
		int maximo_num_enviadas = 0;

		for(i=0; i<4; i++)
		{
			win_lose_array[i] = J_NONE;
		}

		switch(tipo_juego)
		{
		case modo_normal:
		case modo_competitivo:
			if (juego->num_jug > 1)
			{
				switch(juego->v)
				{
				case mas_puntos:
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->puntos->puntos >= maxima_puntuacion)
						{
							if (juego->jug[i]->puntos->puntos == maxima_puntuacion)
							{
								num_ganadores++;
							}
							else
							{
								num_ganadores = 1;
							}
							maxima_puntuacion = juego->jug[i]->puntos->puntos;
						}
					}
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->puntos->puntos == maxima_puntuacion)
						{
							if (num_ganadores == 1) win_lose_array[i] = J_WIN;
							else win_lose_array[i] = J_DRAW;
						}
						else
						{
							win_lose_array[i] = J_LOSE;
						}
					}
					break;
				case primer_tetris:
					for(i=0; i<juego->num_jug; i++)
					{
						if (jugador_primer_tetris < 0)
						{
							win_lose_array[i] = J_DRAW;
						}
						else
						{
							if (i == jugador_primer_tetris)
							{
								win_lose_array[i] = J_WIN;
							}
							else
							{
								win_lose_array[i] = J_LOSE;
							}
						}
					}
					break;
				case mas_lineas:
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->puntos->lineas >= maximo_num_lineas)
						{
							if (juego->jug[i]->puntos->lineas == maximo_num_lineas)
							{
								num_ganadores++;
							}
							else
							{
								num_ganadores = 1;
							}
							maximo_num_lineas = juego->jug[i]->puntos->lineas;
						}
					}
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->puntos->lineas == maximo_num_lineas)
						{
							if (num_ganadores == 1) win_lose_array[i] = J_WIN;
							else win_lose_array[i] = J_DRAW;
						}
						else
						{
							win_lose_array[i] = J_LOSE;
						}
					}
					break;
				case mas_enviadas:
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->tab->enviadas >= maximo_num_enviadas)
						{
							if (juego->jug[i]->tab->enviadas == maximo_num_enviadas)
							{
								num_ganadores++;
							}
							else
							{
								num_ganadores = 1;
							}
							maximo_num_enviadas = juego->jug[i]->tab->enviadas;
						}
					}
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->tab->enviadas == maximo_num_enviadas)
						{
							if (num_ganadores == 1) win_lose_array[i] = J_WIN;
							else win_lose_array[i] = J_DRAW;
						}
						else
						{
							win_lose_array[i] = J_LOSE;
						}
					}
					break;
				case superviviente:
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->tab->estado != EST_GAMEOVER)
						{
							num_ganadores++;
						}
					}
					for (i=0; i<juego->num_jug; i++)
					{
						if (num_ganadores == 0)
						{
							win_lose_array[i] = J_DRAW;
						}
						else
						{
							if (juego->jug[i]->tab->estado == EST_GAMEOVER)
							{
								win_lose_array[i] = J_LOSE;
							}
							else
							{
								win_lose_array[i] = J_WIN;
							}
						}
					}
					break;
				}
			}
			break;

		case modo_cooperativo:
			if (juego->num_tab > 1)
			{
				switch(juego->v)
				{
				case mas_puntos:
					for (i=0; i<juego->num_tab; i++)
					{
						for(j=0; j<juego->num_jug; j++)
						{
							if (juego->jug[j]->tab == juego->tab[i])
							{
								if (juego->jug[j]->puntos->puntos >= maxima_puntuacion)
								{
									if (juego->jug[j]->puntos->puntos == maxima_puntuacion)
									{
										num_ganadores++;
									}
									else
									{
										num_ganadores = 1;
									}
									maxima_puntuacion = juego->jug[j]->puntos->puntos;
									break;
								}
							}
						}
					}
					for (i=0; i<juego->num_jug; i++)
					{
						if (juego->jug[i]->puntos->puntos == maxima_puntuacion)
						{
							if (num_ganadores == 1) win_lose_array[i] = J_WIN;
							else win_lose_array[i] = J_DRAW;
						}
						else
						{
							win_lose_array[i] = J_LOSE;
						}
					}
					break;
				case primer_tetris:
					if (jugador_primer_tetris < 0)
					{
						for(i=0; i<juego->num_jug; i++)
						{
							win_lose_array[i] = J_DRAW;
						}
					}
					else
					{
						if (jugador_primer_tetris < 2)
						{
							win_lose_array[0] = win_lose_array[1] = J_WIN;
							win_lose_array[2] = win_lose_array[3] = J_LOSE;
						}
						else
						{
							win_lose_array[0] = win_lose_array[1] = J_LOSE;
							win_lose_array[2] = win_lose_array[3] = J_WIN;
						}
					}
					break;
				case mas_lineas:
					if (juego->jug[0]->puntos->lineas == juego->jug[2]->puntos->lineas)
					{
						for(i=0; i<juego->num_jug; i++)
						{
							win_lose_array[i] = J_DRAW;
						}
					}
					else
					{
						if (juego->jug[0]->puntos->lineas > juego->jug[2]->puntos->lineas)
						{
							win_lose_array[0] = win_lose_array[1] = J_WIN;
							win_lose_array[2] = win_lose_array[3] = J_LOSE;
						}
						else
						{
							win_lose_array[0] = win_lose_array[1] = J_LOSE;
							win_lose_array[2] = win_lose_array[3] = J_WIN;
						}
					}
					break;
				case mas_enviadas:
					if (juego->tab[0]->enviadas == juego->tab[1]->enviadas)
					{
						for(i=0; i<juego->num_jug; i++)
						{
							win_lose_array[i] = J_DRAW;
						}
					}
					else
					{
						if (juego->tab[0]->enviadas > juego->tab[1]->enviadas)
						{
							win_lose_array[0] = win_lose_array[1] = J_WIN;
							win_lose_array[2] = win_lose_array[3] = J_LOSE;
						}
						else
						{
							win_lose_array[0] = win_lose_array[1] = J_LOSE;
							win_lose_array[2] = win_lose_array[3] = J_WIN;
						}
					}
					break;
				case superviviente:
					if (juego->tab[0]->estado == juego->tab[1]->estado)
					{
						for(i=0; i<juego->num_jug; i++)
						{
							win_lose_array[i] = J_DRAW;
						}
					}
					else
					{
						if (juego->tab[0]->estado != EST_GAMEOVER)
						{
							win_lose_array[0] = win_lose_array[1] = J_WIN;
							win_lose_array[2] = win_lose_array[3] = J_LOSE;
						}
						else
						{
							win_lose_array[0] = win_lose_array[1] = J_LOSE;
							win_lose_array[2] = win_lose_array[3] = J_WIN;
						}
					}
					break;
				}
			}
			break;
		default:
			break;
		}

		t_jugador *companero;
		for(i=0; i<juego->num_jug; i++)
		{
			switch(tipo_juego)
			{
			case modo_normal:
				poner_record_jugador_normal(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, win_lose_array[i]);
				break;
			case modo_competitivo:
				poner_record_jugador_competitivo(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, win_lose_array[i]);
				break;
			case modo_cooperativo:
				companero = NULL;
				j=0;
				while (j<juego->num_jug && !companero)
				{
					if (juego->jug[j]->tab == juego->jug[i]->tab)
					{
						if (juego->jug[j] != juego->jug[i])
						{
							companero = juego->jug[j]->jug;
						}
					}
					j++;
				}
				poner_record_jugador_cooperativo(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, companero, win_lose_array[i]);
				break;
			default:
				break;
			}
		}

/*		for (i=0; i<juego->num_jug; i++)
		{
			switch (tipo_juego)
			{
			case modo_normal:
				if (juego->num_jug > 1)
				{
					if (juego->jug[i]->tab->estado == EST_GAMEOVER) aux_win_lose = J_LOSE;
					else aux_win_lose = J_WIN;
				}
				else
				{
					aux_win_lose = J_NONE;
				}
				win_lose_array[i] = aux_win_lose;
				poner_record_jugador_normal(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, aux_win_lose);
				break;
			case modo_cooperativo:
				j=0;
				companero = NULL;
				while (j<juego->num_jug && !companero)
				{
					if (juego->jug[j]->tab == juego->jug[i]->tab)
					{
						if (juego->jug[j] != juego->jug[i])
						{
							companero = juego->jug[j]->jug;
						}
					}
					j++;
				}
				win_lose_array[i] = J_NONE;
				poner_record_jugador_cooperativo(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, companero, J_NONE);
				break;
			case modo_competitivo:
				aux_win_lose = J_WIN;
				j=0;
				while (j<juego->num_jug && aux_win_lose != J_LOSE)
				{
					if (juego->jug[j] != juego->jug[i])
					{
						if (juego->jug[j]->puntos->puntos > juego->jug[i]->puntos->puntos)
						{
							aux_win_lose = J_LOSE;
						}
						else if (juego->jug[j]->puntos->puntos == juego->jug[i]->puntos->puntos)
						{
							aux_win_lose = J_DRAW;
						}
					}
					j++;
				}
				win_lose_array[i] = aux_win_lose;
				poner_record_jugador_competitivo(juego->jug[i]->jug, juego->jug[i]->puntos->puntos, juego->jug[i]->puntos->lineas, juego->jug[i]->puntos->nivel, aux_win_lose);
				break;
			}
		}
*/
		guardar_jugadores();

		show_stats(juego, win_lose_array);
	}

	video.ModificarVista(640, 480);
	video.RepintarFondo();
}
