//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "gfx.h"
#include "gui.h"
#include "sis_part.h"
#include "editor.h"
#include "Controles.h"
#include "jugador.h"
#include "juego.h"
#include "musica.h"
#include "juego_config.h"
#include "globals.h"
#include "dialogs.h"

static int tiempo_table[] = {-1,
							60*60,
							2*60*60,
							3*60*60,
							5*60*60,
							10*60*60,
							15*60*60 };

static int tiempo_extra_table[] = {0, 2*60, 5*60, 10*60, 15*60, 20*60, -1};

static int tiempo_enviar_lineas[] = {0, 0, 5*60, 10*60, 15*60, 20*60, 25*60, 30*60};

static int normal_num_jug = 1;
static t_jugador *normal_jug[4] = {NULL, NULL, NULL, NULL};
static int normal_serie_piezas[4] = {0, 1, 2, 3};
static int normal_tab_tam_x = 6;
static int normal_tab_tam_y = 12;
static int normal_nivel = 0;
static int normal_nivel_max = 9;
static int normal_lineas_iniciales = 0;
//static char normal_piezas[20] = "";
static bool normal_enviar_piezas = true;
static bool normal_contrarestar_envios = false;
static bool normal_kamikaze = false;
static unsigned normal_kamikaze_dificultad = 1;
static int normal_enviar_piezas_cuando = 0;
static int normal_condicion_victoria = 0;
static int normal_tiempo_extra = 0;
static int normal_tiempo = 0;
static bool normal_puntos_dejar_caer = true;
static bool normal_puntos_colocar_piezas = true;
static bool normal_mostrar_siguiente = true;
static bool normal_caer_desde_fuera = true;
//static int normal_res_x = 640;
//static int normal_res_y = 480;

static bool continuar;

static bool normal_do_layout (const int num_tables, t_tablero *tab[4], t_jug *jug[4], const unsigned resx, const unsigned resy)
{
	bool ret = true;
	unsigned tabs_size=0;
	unsigned void_size=0;
	unsigned stats_size=0;
	unsigned pos;
	unsigned left;
	unsigned size;
	bool show_stats;
	int i;

	for(i=0; i<num_tables; i++)
	{
		tabs_size += tab[i]->tamx;
	}
	tabs_size*=20;
	void_size=6*2+10*(num_tables-1);
	if (tabs_size + void_size > resx) return false;

	for(i=0; i<num_tables; i++)
	{
		if (unsigned(tab[i]->tamy*20+30+40) > resy) return false;
	}

	stats_size=num_tables*90;

	if (tabs_size + void_size + stats_size <= resx)
	{
		show_stats = true;
	}
	else
	{
		show_stats = false;
	}

	pos = 6;
	left = resx-6*2-10*(num_tables-1);
	for(i=0; i<num_tables; i++)
	{
		size = left/(num_tables-i);
		if (size < unsigned(tab[i]->tamx*20 + (show_stats?90:0)))
		{
			size = tab[i]->tamx*20 + (show_stats?90:0);
		}
		left-=size;

		if (show_stats)
		{
			if (i+1 < (num_tables+1)/2.0 && num_tables < 4)
			{
				if (num_tables == 2)
				{
					tab[i]->posx = pos+size-tab[i]->tamx*20;
					jug[i]->cuadro_sig_pieza->posx = tab[i]->posx-90;
					jug[i]->cuadro_sig_pieza->posy = tab[i]->posy;
					jug[i]->cuadro_sig_pieza->visible = true;
					tab[i]->nivel_posx = tab[i]->posx-90;
					tab[i]->nivel_posy = tab[i]->posy+90;
					tab[i]->nivel_visible = true;
					jug[i]->puntos->posx = tab[i]->posx-90;
					jug[i]->puntos->posy = tab[i]->posy+150;
					jug[i]->puntos->visible = true;
				}
				else
				{
					tab[i]->posx = pos+size-tab[i]->tamx*20-90;
					jug[i]->cuadro_sig_pieza->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->cuadro_sig_pieza->posy = tab[i]->posy;
					jug[i]->cuadro_sig_pieza->visible = true;
					tab[i]->nivel_posx = tab[i]->posx+tab[i]->tamx*20+10;
					tab[i]->nivel_posy = tab[i]->posy+90;
					tab[i]->nivel_visible = true;
					jug[i]->puntos->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->puntos->posy = tab[i]->posy+150;
					jug[i]->puntos->visible = true;
				}
			}
			else if (i+1 == (num_tables+1)/2.0 || num_tables >= 4)
			{
				if (num_tables > 1)
				{
					tab[i]->posx = pos+(size-tab[i]->tamx*20-90)/2;
					jug[i]->cuadro_sig_pieza->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->cuadro_sig_pieza->posy = tab[i]->posy;
					jug[i]->cuadro_sig_pieza->visible = true;
					tab[i]->nivel_posx = tab[i]->posx+tab[i]->tamx*20+10;
					tab[i]->nivel_posy = tab[i]->posy+90;
					tab[i]->nivel_visible = true;
					jug[i]->puntos->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->puntos->posy = tab[i]->posy+150;
					jug[i]->puntos->visible = true;
				}
				else
				{
					int offset = 0;
					if ((size-tab[i]->tamx*20)/2<90)
					{
						offset = 90 - (size-tab[i]->tamx*20)/2;
					}
					tab[i]->posx = pos+(size-tab[i]->tamx*20)/2-offset;
					jug[i]->cuadro_sig_pieza->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->cuadro_sig_pieza->posy = tab[i]->posy;
					jug[i]->cuadro_sig_pieza->visible = true;
					tab[i]->nivel_posx = tab[i]->posx+tab[i]->tamx*20+10;
					tab[i]->nivel_posy = tab[i]->posy+90;
					tab[i]->nivel_visible = true;
					jug[i]->puntos->posx = tab[i]->posx+tab[i]->tamx*20+10;
					jug[i]->puntos->posy = tab[i]->posy+150;
					jug[i]->puntos->visible = true;
				}
			}
			else if (i+1 > (num_tables+1)/2.0)
			{
				tab[i]->posx = pos;
				jug[i]->cuadro_sig_pieza->posx = tab[i]->posx+tab[i]->tamx*20+10;
				jug[i]->cuadro_sig_pieza->posy = tab[i]->posy;
				jug[i]->cuadro_sig_pieza->visible = true;
				tab[i]->nivel_posx = tab[i]->posx+tab[i]->tamx*20+10;
				tab[i]->nivel_posy = tab[i]->posy+90;
				tab[i]->nivel_visible = true;
				jug[i]->puntos->posx = tab[i]->posx+tab[i]->tamx*20+10;
				jug[i]->puntos->posy = tab[i]->posy+150;
				jug[i]->puntos->visible = true;
			}
		}
		else
		{
			tab[i]->posx = pos+(size-tab[i]->tamx*20)/2;
		}

		pos += size+10;
	}

	return ret;
}


static void handle_atras (TButton *b)
{
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
	continuar = false;
}

static void handle_aceptar (TButton *b)
{
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
	b->GetParent()->UpdateData(true);
	continuar = true;
}

static void handle_sel_jug_1 (TButton *b)
{
	t_jugador *jug_descartar[3]= {normal_jug[1], normal_jug[2], normal_jug[3]};

	show_mouse(NULL);
	normal_jug[0] = seleccionar_jugador(video.ObtenerPaginaVisible(), normal_jug[0], 219, 72, jug_descartar, 3);
	if (normal_jug[0])
	{
		b->SetText(string(normal_jug[0]->nick));
	}
}

static void handle_sel_jug_2 (TButton *b)
{
	t_jugador *jug_descartar[3]= {normal_jug[0], normal_jug[2], normal_jug[3]};

	show_mouse(NULL);
	normal_jug[1] = seleccionar_jugador(video.ObtenerPaginaVisible(), normal_jug[1], 219, 96, jug_descartar, 3);
	if (normal_jug[1])
	{
		b->SetText(string(normal_jug[1]->nick));
	}
}

static void handle_sel_jug_3 (TButton *b)
{
	t_jugador *jug_descartar[3]= {normal_jug[0], normal_jug[1], normal_jug[3]};

	show_mouse(NULL);
	normal_jug[2] = seleccionar_jugador(video.ObtenerPaginaVisible(), normal_jug[2], 219, 120, jug_descartar, 3);
	if (normal_jug[2])
	{
		b->SetText(string(normal_jug[2]->nick));
	}
}

static void handle_sel_jug_4 (TButton *b)
{
	t_jugador *jug_descartar[3]= {normal_jug[0], normal_jug[1], normal_jug[2]};

	show_mouse(NULL);
	normal_jug[3] = seleccionar_jugador(video.ObtenerPaginaVisible(), normal_jug[3], 219, 144, jug_descartar, 3);
	if (normal_jug[3])
	{
		b->SetText(string(normal_jug[3]->nick));
	}
}

void juego_normal(BITMAP* fondo, FONT* f_list)
{
	int i, j, k;
	int required_res = 10;
	int required_min_res = 10;
	BITMAP *dialog_back = create_bitmap(640, 480);
	CRand series[4];

	clear_bitmap(dialog_back);

	blit (fondo, dialog_back, 0, 0, 0, 0, 640, 480);

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender(0, 0, 0, 127);
	rectfill(dialog_back, 0, 0, 639, 479, 0);
	set_add_blender(0, 0, 0, 255);
	dibujar_gradiente(dialog_back, 0, 0, 219, 21, 0, 0, 0, 64, 64, 192);
	dibujar_gradiente(dialog_back, 420, 0, 639, 21, 64, 64, 192, 0, 0, 0);
	rectfill(dialog_back, 220, 0, 419, 21, makecol(64, 64, 192));
	solid_mode();

	textout_centre(dialog_back, roman12, TEXT_normal(), 320,02, makecol(255,255,255));

	TDialog d_normal(0, 0, 640, 480);
	TImage i_fondo(0, 0, 640, 480, dialog_back);
	TPanel p_panel(0, 0, 640, 480);
//	TStatic s_titulo(220, 0, 200, 16, TEXT_normal());

	TRadio r_num_pl_1(10, 30, 149, 20, TEXT_juego_1_jugador(), 1);
	TRadio r_num_pl_2(167, 30, 149, 20, TEXT_juego_2_jugadores(), 1);
	TRadio r_num_pl_3(324, 30, 149, 20, TEXT_juego_3_jugadores(), 1);
	TRadio r_num_pl_4(481, 30, 149, 20, TEXT_juego_4_jugadores(), 1);

	r_num_pl_1.SetCheck(normal_num_jug==1);
	r_num_pl_2.SetCheck(normal_num_jug==2);
	r_num_pl_3.SetCheck(normal_num_jug==3);
	r_num_pl_4.SetCheck(normal_num_jug==4);

	TPanel p_jugador(5, 50, 630, 117);
	p_jugador.SetAlt(-1);

	TStatic s_jug1(10, 74, 59, 12, TEXT_juego_jugador(1));
	TStatic s_jug2(10, 98, 59, 12, TEXT_juego_jugador(2));
	TStatic s_jug3(10, 122, 59, 12, TEXT_juego_jugador(3));
	TStatic s_jug4(10, 146, 59, 12, TEXT_juego_jugador(4));
	TButton b_jug1(70, 72, 149, 16, "");
	TButton b_jug2(70, 96, 149, 16, "");
	TButton b_jug3(70, 120, 149, 16, "");
	TButton b_jug4(70, 144, 149, 16, "");

	b_jug1.SetText(string(normal_jug[0] ? normal_jug[0]->nick : TEXT_anonimo()));
	b_jug2.SetText(string(normal_jug[1] ? normal_jug[1]->nick : TEXT_anonimo()));
	b_jug3.SetText(string(normal_jug[2] ? normal_jug[2]->nick : TEXT_anonimo()));
	b_jug4.SetText(string(normal_jug[3] ? normal_jug[3]->nick : TEXT_anonimo()));

	b_jug1.SetMsgBtnClick(handle_sel_jug_1);
	b_jug2.SetMsgBtnClick(handle_sel_jug_2);
	b_jug3.SetMsgBtnClick(handle_sel_jug_3);
	b_jug4.SetMsgBtnClick(handle_sel_jug_4);

	TStatic s_serie(230, 54, 149, 12, TEXT_juego_serie_piezas());
	TStatic s_serie1(217, 54, 149, 12, TEXT_juego_serie_piezas());
	TStatic s_serie2(217, 86, 149, 12, TEXT_juego_serie_piezas());
	TStatic s_serie3(217, 118, 149, 12, TEXT_juego_serie_piezas());
	TStatic s_serie4(217, 150, 149, 12, TEXT_juego_serie_piezas());
	TSpin sp_serie1(230, 72, 149, 16);
	TSpin sp_serie2(230, 96, 149, 16);
	TSpin sp_serie3(230, 120, 149, 16);
	TSpin sp_serie4(230, 144, 149, 16);

	TPanel p_tab(5, 170, 312, 233);
	p_tab.SetAlt(-1);
	TCheck ch_igual(10, 170, 620, 16, "Igual para todos los jugadores");
	ch_igual.SetCheck(true);

	TStatic s_tab(10, 179, 130, 12, TEXT_tamanyo_tablero());
	TStatic s_tabx(150, 177, 8, 16, "x");
	TSpin sp_tabx(158, 177, 64, 16);
	TStatic s_taby(238, 177, 8, 16, "y");
	TSpin sp_taby(246, 177, 64, 16);

	TStatic s_nivel_ini(10, 201, 130, 12, TEXT_nivel_inicial());
	TStatic s_nivel_fin(10, 223, 130, 12, TEXT_nivel_maximo());
	TSpin sp_nivel_ini(150, 199, 72, 16);
	TSpin sp_nivel_fin(150, 221, 72, 16);

	TStatic s_lineas(10, 245, 130, 12, TEXT_lineas_iniciales());
	TSpin sp_lineas(150, 243, 160, 16);

	TStatic s_set_piezas(330, 177, 70, 12, TEXT_piezas());
	TList l_set_piezas(330+80, 175, 220, text_height(TObject::GetSkin()->get_normal_font())*6+2, "");

	TPanel p_reglas(323, 170, 312, 233);
	p_reglas.SetAlt(-1);

	TCheck ch_enviar(10, 267, 300, 16, TEXT_enviar_lineas());
	ch_enviar.SetCheck(normal_enviar_piezas);
	TSpin sp_enviar(10, 283, 300, 16);
	TCheck ch_contrarestar_envios(10, 283+16, 300, 16, TEXT_contrarrestar_envios());
	ch_contrarestar_envios.SetCheck(normal_contrarestar_envios);
	TCheck ch_kamikaze(10, 299+16, 100, 16, TEXT_kamikaze());
	ch_kamikaze.SetCheck(normal_kamikaze);
	TSpin sp_kamikaze_dificultad(120, 299+16, 190, 16);
	TStatic s_victoria(10, 305+16+16, 300, 12, TEXT_condicion_victoria());
	TSpin sp_victoria(10, 317+16+16, 300, 16);
	TStatic s_tiempo_extra(330, 249+16, 300, 12, TEXT_tiempo_extra());
	TSpin sp_tiempo_extra(330, 261+16, 300, 16);
	TStatic s_tiempo(330, 283+16, 300, 12, TEXT_tiempo_juego());
	TSpin sp_tiempo(330, 295+16, 300, 16);

	TCheck ch_puntos_bonus(330, 316+16, 300, 16, TEXT_puntos_dejar_caer());
	ch_puntos_bonus.SetCheck(normal_puntos_dejar_caer);
	TCheck ch_puntos_colocar(330, 332+16, 300, 16, TEXT_puntos_colocar());
	ch_puntos_colocar.SetCheck(normal_puntos_colocar_piezas);
	TCheck ch_mostrar_sig(330, 348+16, 300, 16, TEXT_mostrar_siguiente());
	ch_mostrar_sig.SetCheck(normal_mostrar_siguiente);
	TCheck ch_posicion(330, 364+16, 300, 16, TEXT_caen_desde_fuera());
	ch_posicion.SetCheck(normal_caer_desde_fuera);
//	TButton b_power_ups(330, 380+16, 300, 20, "Power ups");

	TButton b_presets(10, 420, 150, 20, TEXT_presets());
	TStatic s_presets(160, 408, 150, 12, TEXT_preset_actual());
	TPanel p_presets(160, 420, 150, 20);
	p_presets.SetAlt(-1);
	TStatic s_resolucion(330, 408, 150, 12, TEXT_resolucion());
	TSpin sp_resolucion(330, 420, 145, 20);
	TButton b_musica_fondos(485, 420, 145, 20, TEXT_musica_y_fondos());

	TButton b_atras(10, 450, 300, 20, TEXT_volver());
	TButton b_aceptar(330, 450, 300, 20, TEXT_comenzar());

	b_atras.SetMsgBtnClick(handle_atras);
	b_aceptar.SetMsgBtnClick(handle_aceptar);
	b_musica_fondos.SetMsgBtnClick(handle_musica_fondos);

	char str[20];
	for(i=1; i<11; i++)
	{
		sprintf (str, "%d", i);
		sp_nivel_ini.AddItem(str);
		sp_nivel_fin.AddItem(str);
	}

	for(i=4; i<=(SCREEN_W-10)/20; i++)
	{
		sprintf(str, "%d", i);
		sp_tabx.AddItem(str);
	}
	sp_tabx.SetSel(normal_tab_tam_x);

	const int max_altura = (SCREEN_H-40-30)/20;

	for(i=8; i<=max_altura; i++)
	{
		sprintf(str, "%d", i);
		sp_taby.AddItem(str);
	}
	sp_taby.SetSel(normal_tab_tam_y);

	sp_nivel_ini.SetSel(normal_nivel);
	sp_nivel_fin.SetSel(normal_nivel_max);

	for(i=0; i<max_altura-4; i+=4)
	{
		if (i==0)
		{
			sp_lineas.AddItem(TEXT_tablero_vacio());
		}
		else
		{
			sp_lineas.AddItem(TEXT_n_lineas(i));
		}
	}
	sp_lineas.SetSel(normal_lineas_iniciales);

	for(i=1; i<5; i++)
	{
		sp_serie1.AddItem(TEXT_serie(i));
		sp_serie2.AddItem(TEXT_serie(i));
		sp_serie3.AddItem(TEXT_serie(i));
		sp_serie4.AddItem(TEXT_serie(i));
	}
	sp_serie1.SetSel(normal_serie_piezas[0]);
	sp_serie2.SetSel(normal_serie_piezas[1]);
	sp_serie3.SetSel(normal_serie_piezas[2]);
	sp_serie4.SetSel(normal_serie_piezas[3]);

	sp_kamikaze_dificultad.AddItem(TEXT_facil());
	sp_kamikaze_dificultad.AddItem(TEXT_medio());
	sp_kamikaze_dificultad.AddItem(TEXT_dificil());
	sp_kamikaze_dificultad.SetSel(normal_kamikaze_dificultad);

	sp_enviar.AddItem(TEXT_al_instante());
	sp_enviar.AddItem(TEXT_cuando_receptor_coloque_pieza_actual());
	sp_enviar.AddItem(TEXT_rangos_x_segundos(5));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(10));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(15));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(20));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(25));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(30));
	sp_enviar.SetSel(normal_enviar_piezas_cuando);

	sp_victoria.AddItem(TEXT_quien_tenga_mas_puntos());
	sp_victoria.AddItem(TEXT_quien_quede_vivo());
	sp_victoria.AddItem(TEXT_quien_haga_mas_lineas());
	sp_victoria.AddItem(TEXT_quien_envie_mas_lineas());
	sp_victoria.AddItem(TEXT_quien_haga_primero_un_tetris());
	sp_victoria.SetSel(normal_condicion_victoria);

	sp_tiempo_extra.AddItem(TEXT_sin_tiempo_extra());
	sp_tiempo_extra.AddItem(TEXT_x_segundos(2));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(5));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(10));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(15));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(20));
	sp_tiempo_extra.AddItem(TEXT_esperar_jugadores_acaben());
	sp_tiempo_extra.SetSel(normal_tiempo_extra);

	sp_tiempo.AddItem(TEXT_tiempo_ilimitado());
	sp_tiempo.AddItem(TEXT_1_minuto());
	sp_tiempo.AddItem(TEXT_x_minutos(2));
	sp_tiempo.AddItem(TEXT_x_minutos(3));
	sp_tiempo.AddItem(TEXT_x_minutos(5));
	sp_tiempo.AddItem(TEXT_x_minutos(10));
	sp_tiempo.AddItem(TEXT_x_minutos(15));
	sp_tiempo.SetSel(normal_tiempo);

	sp_resolucion.AddItem("640 x 480");
	sp_resolucion.AddItem("800 x 600");
	sp_resolucion.AddItem("1024 x 768");
	sp_resolucion.AddItem("1280 x 1024");

	sp_resolucion.SetSel(0);

	crear_lista_piezas(&l_set_piezas);

	d_normal.AddObject(&i_fondo);
//	d_normal.AddObject(&p_panel);
//	d_normal.AddObject(&s_titulo);
	d_normal.AddObject(&r_num_pl_1);
	d_normal.AddObject(&r_num_pl_2);
	d_normal.AddObject(&r_num_pl_3);
	d_normal.AddObject(&r_num_pl_4);

//	d_normal.AddObject(&p_jugador);

	d_normal.AddObject(&s_jug1);
	d_normal.AddObject(&s_jug2);
	d_normal.AddObject(&s_jug3);
	d_normal.AddObject(&s_jug4);
	d_normal.AddObject(&b_jug1);
	d_normal.AddObject(&b_jug2);
	d_normal.AddObject(&b_jug3);
	d_normal.AddObject(&b_jug4);

	d_normal.AddObject(&s_serie);
	d_normal.AddObject(&sp_serie1);
	d_normal.AddObject(&sp_serie2);
	d_normal.AddObject(&sp_serie3);
	d_normal.AddObject(&sp_serie4);

//	d_normal.AddObject(&p_tab);

	d_normal.AddObject(&s_tab);

	d_normal.AddObject(&s_tabx);
	d_normal.AddObject(&sp_tabx);
	d_normal.AddObject(&s_taby);
	d_normal.AddObject(&sp_taby);

	d_normal.AddObject(&s_nivel_ini);
	d_normal.AddObject(&s_nivel_fin);
	d_normal.AddObject(&sp_nivel_ini);
	d_normal.AddObject(&sp_nivel_fin);

	d_normal.AddObject(&s_lineas);
	d_normal.AddObject(&sp_lineas);

	d_normal.AddObject(&s_set_piezas);
	d_normal.AddObject(&l_set_piezas);

//	d_normal.AddObject(&p_reglas);

	d_normal.AddObject(&ch_enviar);
	d_normal.AddObject(&sp_enviar);
	d_normal.AddObject(&ch_contrarestar_envios);
	d_normal.AddObject(&ch_kamikaze);
	d_normal.AddObject(&sp_kamikaze_dificultad);
	d_normal.AddObject(&s_victoria);
	d_normal.AddObject(&sp_victoria);
	d_normal.AddObject(&s_tiempo_extra);
	d_normal.AddObject(&sp_tiempo_extra);
	d_normal.AddObject(&s_tiempo);
	d_normal.AddObject(&sp_tiempo);

	d_normal.AddObject(&ch_puntos_bonus);
	d_normal.AddObject(&ch_puntos_colocar);
	d_normal.AddObject(&ch_mostrar_sig);
	d_normal.AddObject(&ch_posicion);
//	d_normal.AddObject(&b_power_ups);

	d_normal.AddObject(&b_presets);
	d_normal.AddObject(&s_presets);
	d_normal.AddObject(&p_presets);
	d_normal.AddObject(&s_resolucion);
	d_normal.AddObject(&sp_resolucion);
	d_normal.AddObject(&b_musica_fondos);
	d_normal.AddObject(&b_atras);
	d_normal.AddObject(&b_aceptar);

	d_normal.SetBuffer(buffer);

	continuar = true;
	while (continuar)
	{
//		blit (fondo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
//		blit (fondo, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		d_normal.ChangeDestinationBitmap(video.ObtenerPaginaVisible());
		TShowDialog(d_normal);

		text_mode(-1);

		if (continuar)
		{
			char piezas_file[300];

			show_mouse(NULL);
			clear_bitmap(video.ObtenerPantalla());
			textout_centre(video.ObtenerPantalla(), comic16, TEXT_cargando(), 320, 200, makecol(255,255,255));
			video.Actualizar();

			if (buscar_pieza(l_set_piezas.GetSelText().c_str(), piezas_file, 300))
			{
				if (r_num_pl_1.GetCheck()) normal_num_jug = 1;
				if (r_num_pl_2.GetCheck()) normal_num_jug = 2;
				if (r_num_pl_3.GetCheck()) normal_num_jug = 3;
				if (r_num_pl_4.GetCheck()) normal_num_jug = 4;
				normal_serie_piezas[0] = sp_serie1.GetSel();
				normal_serie_piezas[1] = sp_serie2.GetSel();
				normal_serie_piezas[2] = sp_serie3.GetSel();
				normal_serie_piezas[3] = sp_serie4.GetSel();
				normal_tab_tam_x = sp_tabx.GetSel();
				normal_tab_tam_y = sp_taby.GetSel();
				normal_nivel = sp_nivel_ini.GetSel();
				normal_nivel_max = sp_nivel_fin.GetSel();
				normal_lineas_iniciales = sp_lineas.GetSel();
				normal_enviar_piezas = ch_enviar.GetCheck();
				normal_enviar_piezas_cuando = sp_enviar.GetSel();
				normal_contrarestar_envios = ch_contrarestar_envios.GetCheck();
				normal_kamikaze = ch_kamikaze.GetCheck();
				normal_kamikaze_dificultad = sp_kamikaze_dificultad.GetSel();
				normal_condicion_victoria = sp_victoria.GetSel();
				normal_tiempo_extra = sp_tiempo_extra.GetSel();
				normal_tiempo = sp_tiempo.GetSel();
				normal_puntos_dejar_caer = ch_puntos_bonus.GetCheck();
				normal_puntos_colocar_piezas = ch_puntos_colocar.GetCheck();
				normal_mostrar_siguiente = ch_mostrar_sig.GetCheck();
				normal_caer_desde_fuera = ch_posicion.GetCheck();


				t_juego* juego = NULL;
				static t_tablero* tab[4] = {NULL, NULL, NULL, NULL};
				t_set_piezas* piezas = NULL;
				t_cuadro_puntuacion* puntos[4] = {NULL, NULL, NULL, NULL};
				t_jug* jug[4] = {NULL, NULL, NULL, NULL};
				t_cuadro_sig_pieza* cuadro_sig_pieza[4] = {NULL, NULL, NULL, NULL};
				BITMAP *graf_piezas;

				juego = new t_juego;

				switch(normal_condicion_victoria)
				{
				case 0:
					juego->v = mas_puntos;
					break;
				case 1:
					juego->v = superviviente;
					break;
				case 2:
					juego->v = mas_lineas;
					break;
				case 3:
					juego->v = mas_enviadas;
					break;
				case 4:
					juego->v = primer_tetris;
					break;
				}

				juego->num_jug = normal_num_jug;
				juego->num_punt = normal_num_jug;
				juego->num_tab = normal_num_jug;

				juego->tiempo = tiempo_table[normal_tiempo];
				juego->tiempo_extra = tiempo_extra_table[normal_tiempo_extra];
				juego->tiempo_entre_lineas = tiempo_enviar_lineas[normal_enviar_piezas_cuando];
				juego->enviar_lineas_esperar_nueva_pieza = (normal_enviar_piezas_cuando == 1);

				piezas = new t_set_piezas;

				if (!cargar_piezas(piezas_file, piezas, &(graf_piezas)))
				{
					set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
					allegro_message ("Error al cargar piezas");
					exit(1);
				}

				for (i=0; i<normal_num_jug; i++)
				{
					required_res+=110;
					required_min_res+=10;
					required_res+=(normal_tab_tam_x+4)*20;
					required_min_res+=(normal_tab_tam_x+4)*20;
					jug[i] = new t_jug;
					jug[i]->jug = normal_jug[i];
					jug[i]->serie_piezas = new CRand(series[normal_serie_piezas[i]]);
					jug[i]->puntos_dejar_caer = normal_puntos_dejar_caer;
					jug[i]->puntos_piezas = normal_puntos_colocar_piezas;

					cuadro_sig_pieza[i] = new t_cuadro_sig_pieza;

					jug[i]->cuadro_sig_pieza = cuadro_sig_pieza[i];
					cuadro_sig_pieza[i]->visible = false;

					tab[i] = new t_tablero;
					tab[i]->tamx = normal_tab_tam_x+4;
					tab[i]->tamy = normal_tab_tam_y+8;
					tab[i]->nivel = normal_nivel+1;
					for(j=0; j<juego->num_tab; j++)
					{
						if (i == j)
						{
							if (normal_kamikaze)
							{
								switch (normal_kamikaze_dificultad)
								{
								case 0:
									tab[i]->enviar_lineas[j][0] = 1;
									tab[i]->enviar_lineas[j][1] = 1;
									tab[i]->enviar_lineas[j][2] = 0;
									tab[i]->enviar_lineas[j][3] = 0;
									break;
								case 1:
									tab[i]->enviar_lineas[j][0] = 2;
									tab[i]->enviar_lineas[j][1] = 1;
									tab[i]->enviar_lineas[j][2] = 1;
									tab[i]->enviar_lineas[j][3] = 0;
									break;
								case 2:
									tab[i]->enviar_lineas[j][0] = 3;
									tab[i]->enviar_lineas[j][1] = 2;
									tab[i]->enviar_lineas[j][2] = 1;
									tab[i]->enviar_lineas[j][3] = 0;
									break;
								}
							}
							else
							{
								tab[i]->enviar_lineas[j][0] =
									tab[i]->enviar_lineas[j][1] =
									tab[i]->enviar_lineas[j][2] =
									tab[i]->enviar_lineas[j][3] = 0;
							}
						}
						else
						{
							if (normal_enviar_piezas)
							{
								tab[i]->enviar_lineas[j][0] = 0;
								tab[i]->enviar_lineas[j][1] = 1;
								tab[i]->enviar_lineas[j][2] = 2;
								tab[i]->enviar_lineas[j][3] = 3;
							}
							else
							{
								tab[i]->enviar_lineas[j][0] =
									tab[i]->enviar_lineas[j][1] =
									tab[i]->enviar_lineas[j][2] =
									tab[i]->enviar_lineas[j][3] = 0;
							}
						}
					}
					if (normal_contrarestar_envios)
					{
						tab[i]->contrarestar[0] = 0;
						tab[i]->contrarestar[1] = 1;
						tab[i]->contrarestar[2] = 2;
						tab[i]->contrarestar[3] = 3;
					}
					else
					{
						tab[i]->contrarestar[0] = 0;
						tab[i]->contrarestar[1] = 0;
						tab[i]->contrarestar[2] = 0;
						tab[i]->contrarestar[3] = 0;
					}

					tab[i]->nivel_visible=false;
					tab[i]->estado = 0;
					tab[i]->posy = 40+(SCREEN_H-80-tab[i]->tamy*20)/2;
					tab[i]->caer_desde_fuera = normal_caer_desde_fuera;

					puntos[i] = new t_cuadro_puntuacion;
					puntos[i]->lineas = 0;
					puntos[i]->nivel = normal_nivel+1;
					puntos[i]->puntos = 0;
					puntos[i]->visible = false;

					juego->jug[i] = jug[i];
					juego->tab[i] = tab[i];
					juego->puntos[i] = puntos[i];

					jug[i]->puntos = puntos[i];
					jug[i]->tab = tab[i];
					tab[i]->lineas = 0;
					tab[i]->num_lineas = 0;
					tab[i]->estado = 0;
					tab[i]->prox_nivel = 10;

					jug[i]->graf_piezas = graf_piezas;
					jug[i]->piezas = piezas;

					if (i==0 && normal_num_jug == 2)
					{
						jug[i]->mini_scores.pos = IZQUIERDA;
					}
					else
					{
						jug[i]->mini_scores.pos = DERECHA;
					}

					jug[i]->mostrar_siguiente = normal_mostrar_siguiente;

					jug[i]->pieza_pos_x_start = (tab[i]->tamx-4)/2;
					for(j=0; j<tab[i]->tamx; j++)
					{
						for (k=0; k<tab[i]->tamy; k++)
						{
							tab[i]->cuadro[j][k] = -1;
						}
					}

					for (j=0; j<normal_lineas_iniciales*4; j++)
					{
						insertar_linea(tab[i], graf_piezas->w/20);
					}
				}

	//			int pos_mult = normal_res_x/normal_num_jug;

	//			if (required_res > normal_res_x)
	//			{
	//				if (required_min_res <= normal_res_x)
	//				{
	//					for(i=0; i<normal_num_jug; i++)
	//					{
	//						tab[i]->posx = i*(pos_mult)+(normal_res_x/normal_num_jug-tab[i]->tamx*20)/2-3;
	//						jug[i]->jug_name_posx = tab[i]->posx + tab[i]->tamx*10;
	//						jug[i]->jug_name_posy = 10;
	//						tab[i]->nivel_posx = tab[i]->posx + tab[i]->tamx*20+10;
	//						tab[i]->nivel_posy = tab[i]->posy;
	//						tab[i]->nivel_visible = true;
	//					}
	//				}
	//			}

				if (!normal_do_layout(normal_num_jug, tab, jug, SCREEN_W, SCREEN_H))
				{
					show_mouse(NULL);
					BITMAP *f = video.CrearBitmap(640, 480, Video::hw_blit);
					blit(video.ObtenerPaginaVisible(), f, 0, 0, 0, 0, 640, 480);
					pregunta(f, small_font, 200, 2, "Resolucin demasiado baja:", "El juego no cabe en pantalla", NULL, 1, "Aceptar", NULL, NULL, 0, 0);
					video.DestruirBitmap(f);
				}
				else
				{
					for(i=0; i<normal_num_jug; i++)
					{
						jug[i]->jug_name_posx = tab[i]->posx + tab[i]->tamx*10;
						jug[i]->jug_name_posy = tab[i]->posy-30;
					}

					BITMAP *resized_fondo;

					string f_str = ObtenerFondo();
					if (f_str != "")
					{
						resized_fondo = cargar_fondo(f_str.c_str());
					}
					else
					{
						resized_fondo = video.CargarPng(path_data + "/tetris.dat#titulo", Video::hw_blit);
					}

					clear_bitmap(fondo);
					blit (resized_fondo, fondo, 0, 0, (SCREEN_W-resized_fondo->w)/2, (SCREEN_H-resized_fondo->h)/2, resized_fondo->w, resized_fondo->h);
					destroy_bitmap(resized_fondo);

					for(i=0; i<juego->num_tab; i++)
					{
						dibujar_recuadro_trans(fondo, juego->tab[i]->posx, juego->tab[i]->posy-30, juego->tab[i]->posx+juego->tab[i]->tamx*20, juego->tab[i]->posy-10, 127);
					}

					reproducir_musica(rand()%num_canciones, 1);

					show_mouse(NULL);

					series[0].initialize();
					series[1].initialize();
					series[2].initialize();
					series[3].initialize();

					comenzar_juego(fondo, juego, modo_normal);
					reproducir_musica(0, 1);
				}

				delete piezas;
				destroy_bitmap(graf_piezas);
				for(i=0; i<normal_num_jug; i++)
				{
					delete jug[i];
					delete tab[i];
					delete puntos[i];
					delete cuadro_sig_pieza[i];
				}

				delete juego;
			}
		}
	}

	BITMAP *aux_fondo = video.CargarPng(path_data + "/tetris.dat#titulo", Video::hw_blit);
	blit (aux_fondo, fondo, 0, 0, 0, 0, 640, 480);
	destroy_bitmap(aux_fondo);
	destroy_bitmap(dialog_back);
	textprintf(fondo, small_font, 595, 460, makecol(255,255,255), "v%d.%d.%d", TVER_MAYOR, TVER_MINOR, TVER_SUB);

	show_mouse(NULL);
}
