//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "gui.h"
#include "gfx.h"
#include "Controles.h"
#include "jugador.h"
#include "editor.h"
#include "consola.h"
#include "sis_part.h"
#include "juego.h"
#include "musica.h"
#include "resize.h"
#include "dialogs.h"
#include "globals.h"



void handle_musica_fondos (TButton *b)
{
	show_mouse(NULL);
	dialogo_musica_y_fondos();
}

int compare_strings(const void *str1, const void *str2)
{
	return strcmp((const char *)str1, (const char *)str2);
}

bool esta_jugador_en_lista (t_jugador *jug, t_jugador *jug_list[], int num)
{
	int i=0;
	bool ret = false;

	while (i<num && !ret)
	{
		if (jug == jug_list[i]) ret = true;
		i++;
	}

	return ret;
}

BITMAP* cargar_fondo(BITMAP* fondo)
{
	BITMAP *ret = NULL;
	int i, j, n;
	char file[300];

	char ext[][5] = {"bmp", "png", "tga", "pcx", "lbm", "jpg"};

	char arch[NUM_LISTA_ELEM][100];
	al_ffblk findinfo;

	i=0;

	for(j=0; j<6; j++)
	{
		sprintf(file, "%s/*.%s", path_backgrounds.c_str(), ext[j]);
		if (!al_findfirst(file, &findinfo, FA_ARCH | FA_RDONLY))
		{
			strcpy(arch[i], findinfo.name);
			i++;
			while (i<NUM_LISTA_ELEM && !al_findnext(&findinfo))
			{
				strcpy(arch[i], findinfo.name);
				i++;
			}
		}
		al_findclose(&findinfo);
	}
	if (i>0)
	{
		qsort(arch, i, sizeof(char)*100, compare_strings);
		n = lista(fondo, 95, 140, 450, 16, book, i, arch, 0);
		if (n>=0)
		{
			sprintf (file, "%s/%s", path_backgrounds.c_str(), arch[n]);
			ret = load_bitmap(file, NULL);
			if (!ret)
			{
				string msg = TEXT_error_al_cargar();
				string ok = TEXT_aceptar();
				pregunta(fondo, book, 200, 2, msg.c_str(), file, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
			}
		}
	}

	return ret;
}

void crear_lista_piezas (TList *lista)
{
	PACKFILE *fp;
	char nom[100];
	char magic[6];
	char file[300];

	al_ffblk findinfo;

//	sprintf(nom, "%s\\%s.tp", path_pieces, "estandard");

	sprintf(file, "%s/*.tp", path_pieces.c_str());
	al_findfirst(file, &findinfo, FA_ARCH | FA_RDONLY);
	sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);

	lista->SetSel(-1);
	if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
	{
		pack_fread(magic, 5, fp);
		magic[5] = '\0';
		pack_fread(nom, 20, fp);
		lista->AddItem(string(nom));
		pack_fclose(fp);
	}
	while (!al_findnext(&findinfo))
	{
		sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
		if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
		{
			pack_fread(magic, 5, fp);
			magic[5] = '\0';
			pack_fread(nom, 20, fp);
			lista->AddItem(string(nom));
			pack_fclose(fp);
		}
	}
	al_findclose(&findinfo);
	lista->SetSel(0);
}

bool select_player;

void handle_aceptar_jugador(TButton *b)
{
	select_player = true;
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

void handle_cancelar_jugador(TButton *b)
{
	select_player = false;
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

t_jugador* seleccionar_jugador (BITMAP* dest, t_jugador *jug, int posx, int posy, t_jugador *list_jug[], int num_list_jug)
{
	int i;
	int height = text_height(TObject::GetSkin()->get_normal_font())*MIN(num_jug+1, 12);
	BITMAP *back;
	BITMAP *local_buffer;
	local_buffer = video.CrearBitmap(202, height+24, Video::hw_blit);
	clear_bitmap(local_buffer);
	back = video.CrearBitmap(202, height+24, Video::hw_blit);
	blit (dest, back, posx, posy, 0, 0, 202, height+24);
	TDialog d_player_select(posx, posy, 202, height+24);
	TPanel p_panel(posx, posy, 202, height+24);
	p_panel.SetAlt(1);
	TList l_jug(posx+1, posy+1, 200, height+2, "");
	TButton b_cancelar(posx+1, posy+height+3, 100, 20, TEXT_cancelar());
	TButton b_aceptar(posx+101, posy+height+3, 100, 20, TEXT_aceptar());

	select_player = false;

	b_aceptar.SetMsgBtnClick(handle_aceptar_jugador);
	b_cancelar.SetMsgBtnClick(handle_cancelar_jugador);

	string ano = string("<") + TEXT_anonimo() + string(">");
	l_jug.AddItem(ano.c_str(), true, NULL);

	l_jug.SetSel(0);
	for(i=0; i<signed(num_jug); i++)
	{
		l_jug.AddItem(string(jugador[i].nombre) + string(" ") +
			string(jugador[i].apellido) + string(" (") +
			string(jugador[i].nick) + string(")"),
			!esta_jugador_en_lista(jugador+i, list_jug, num_list_jug));
		if (jug == &jugador[i]) l_jug.SetSel(i+1);
	}

	d_player_select.AddObject(&p_panel);
	d_player_select.AddObject(&l_jug);
	d_player_select.AddObject(&b_cancelar);
	d_player_select.AddObject(&b_aceptar);

	d_player_select.SetBuffer(local_buffer);

	d_player_select.ChangeDestinationBitmap(dest);

	TShowDialog(d_player_select);

	if (select_player)
	{
		if(l_jug.GetSel()>0) jug = &jugador[l_jug.GetSel()-1];
		else jug = &jugador_anonimo;
	}

	show_mouse(NULL);
	blit (back, dest, 0, 0, posx, posy, 202, height+24);
	destroy_bitmap(back);
	destroy_bitmap(local_buffer);

	return jug;
}

bool select_pieza;

void handle_aceptar_pieza(TButton *b)
{
	select_pieza = true;
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

void handle_cancelar_pieza(TButton *b)
{
	select_pieza = false;
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

t_pieza* seleccionar_piezas (t_pieza *pieza)
{
//	int i;
	BITMAP *back;
	BITMAP *local_buffer;
	local_buffer = video.CrearBitmap(300, 195, Video::hw_blit);
	back = video.CrearBitmap(300, 195, Video::hw_blit);
	blit (screen, back, 170, 140, 0, 0, 300, 195);
	TDialog d_pieza_select(170, 140, 300, 195);
	TPanel p_panel(170, 140, 300, 195);
	p_panel.SetAlt(2);
	TList l_pieza(180, 150, 280, 145, "");
	TButton b_cancelar(180, 305, 135, 20, TEXT_cancelar());
	TButton b_aceptar(325, 305, 135, 20, TEXT_aceptar());

	select_pieza = false;

	b_aceptar.SetMsgBtnClick(handle_aceptar_pieza);
	b_cancelar.SetMsgBtnClick(handle_cancelar_pieza);

	crear_lista_piezas(&l_pieza);

	d_pieza_select.AddObject(&p_panel);
	d_pieza_select.AddObject(&l_pieza);
	d_pieza_select.AddObject(&b_cancelar);
	d_pieza_select.AddObject(&b_aceptar);

	d_pieza_select.SetBuffer(local_buffer);

	TShowDialog(d_pieza_select);

//	if (select_pieza && l_pieza.GetSel()>=0);

	show_mouse(NULL);
	blit (back, screen, 0, 0, 170, 140, 300, 195);
	destroy_bitmap(back);
	destroy_bitmap(local_buffer);

	return pieza;
}

BITMAP *cargar_fondo(const char *file)
{
	char path[1000];
	BITMAP *aux_fondo;
	bool expand_full_screen = true;

	sprintf (path, "%s/%s", path_backgrounds.c_str(), file);
	set_color_conversion(COLORCONV_NONE);
	aux_fondo = load_bitmap(path, NULL);
	set_color_conversion(COLORCONV_TOTAL | COLORCONV_DITHER);
	BITMAP *aux_fondo32 = create_bitmap_ex(32, aux_fondo->w, aux_fondo->h);
	blit(aux_fondo, aux_fondo32, 0, 0, 0, 0, aux_fondo->w, aux_fondo->h);
	destroy_bitmap(aux_fondo);

	int tx=SCREEN_W, ty=SCREEN_H;

	if (((float)aux_fondo32->w/(float)aux_fondo32->h) > (float)tx/(float)ty)
	{
		if (expand_full_screen)
		{
			tx = (ty*aux_fondo32->w)/aux_fondo32->h;
		}
		else
		{
			ty = (tx*aux_fondo32->h)/aux_fondo32->w;
		}
	}
	else
	{
		if (expand_full_screen)
		{
			ty = (tx*aux_fondo32->h)/aux_fondo32->w;
		}
		else
		{
			tx = (ty*aux_fondo32->w)/aux_fondo32->h;
		}
	}


	BITMAP *resized_fondo = create_bitmap_ex(32, tx, ty);

	int mipx, mipy;

	mipx = aux_fondo32->w / tx;
	if (mipx == 0) mipx = 1;
	mipy = aux_fondo32->h / ty;
	if (mipy == 0) mipy = 1;

	if (mipx > 1 || mipy > 1)
	{
		BITMAP *fondo_mipmap = reduce_mipmap(aux_fondo32, mipx, mipy);
		destroy_bitmap(aux_fondo32);
		aux_fondo32 = fondo_mipmap;
	}

	if (tx != aux_fondo32->w || ty != aux_fondo32->h)
	{
		resize_bitmap(aux_fondo32, resized_fondo);
	}
	else
	{
		blit(aux_fondo32, resized_fondo, 0, 0, 0, 0, tx, ty);
	}
	destroy_bitmap(aux_fondo32);

	return resized_fondo;
}
