//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "gfx.h"
#include "gui.h"
#include "sis_part.h"
#include "editor.h"
#include "Controles.h"
#include "jugador.h"
#include "juego.h"
#include "musica.h"
#include "dialogs.h"
#include "juego_config.h"
#include "globals.h"

static int tiempo_table[] = {-1,
							60*60,
							2*60*60,
							3*60*60,
							5*60*60,
							10*60*60,
							15*60*60 };

static int tiempo_extra_table[] = {0, 2*60, 5*60, 10*60, 15*60, 20*60, -1};

static int tiempo_enviar_lineas[] = {0, 5*60, 10*60, 15*60, 20*60, 25*60, 30*60};

static int competitivo_num_jug = 2;
static t_jugador *competitivo_jug[4] = {NULL, NULL, NULL, NULL};
static int competitivo_serie_piezas[4] = {0, 1, 2, 3};
static int competitivo_tab_tam_x = 0;
static int competitivo_tab_tam_y = 12;
static int competitivo_nivel = 0;
static int competitivo_nivel_max = 9;
static int competitivo_lineas_iniciales = 0;
//static char competitivo_piezas[20] = "";
static bool competitivo_kamikaze = false;
static unsigned competitivo_kamikaze_dificultad = 1;
static int competitivo_enviar_piezas_cuando = 0;
static int competitivo_condicion_victoria = 0;
static int competitivo_tiempo_extra = 0;
static int competitivo_tiempo = 0;
static bool competitivo_puntos_dejar_caer = true;
static bool competitivo_puntos_colocar_piezas = true;
static bool competitivo_mostrar_siguiente = true;
static bool competitivo_caer_desde_fuera = true;
//static int competitivo_res_x = 640;
//static int competitivo_res_y = 480;

static bool continuar;

static bool competitivo_do_layout (t_tablero *tab, const int num_jugs, t_jug *jug[4], const unsigned resx, const unsigned resy)
{
	bool ret = true;
	unsigned tabs_size=0;
	unsigned void_size=0;
	unsigned stats_size=0;
	bool show_stats;
	int i;

	tabs_size += tab->tamx;
	tabs_size*=20;
	void_size=6;
	if (tabs_size + void_size > resx) return false;

	if (unsigned(tab->tamy*20+30+40) > resy) return false;

	stats_size=90;

	if (tabs_size + (void_size + stats_size)*(num_jugs) <= resx)
	{
		show_stats = true;
	}
	else
	{
		show_stats = false;
	}

	tab->posx = (resx - tab->tamx*20)/2;
	if (num_jugs == 3 && show_stats) tab->posx+=45;

	if (show_stats)
	{
		tab->nivel_posx = tab->posx + tab->tamx*20 + 10;
		tab->nivel_posy = tab->posy;
		tab->nivel_visible = true;

		if (num_jugs == 2)
		{
			jug[0]->cuadro_sig_pieza->posx = tab->posx-90;
			jug[1]->cuadro_sig_pieza->posx = tab->posx+tab->tamx*20+10;
		}
		else
		{
			jug[0]->cuadro_sig_pieza->posx = tab->posx-180;
			jug[1]->cuadro_sig_pieza->posx = tab->posx-90;
			jug[2]->cuadro_sig_pieza->posx = tab->posx+tab->tamx*20+10;
		}
		if (num_jugs == 4)
		{
			jug[3]->cuadro_sig_pieza->posx = tab->posx+tab->tamx*20+100;
		}


		for (i=0; i<num_jugs; i++)
		{
			jug[i]->cuadro_sig_pieza->posy = tab->posy+60;
			jug[i]->cuadro_sig_pieza->visible = true;
			jug[i]->puntos->posx = jug[i]->cuadro_sig_pieza->posx;
			jug[i]->puntos->posy = tab->posy+150;
			jug[i]->puntos->visible = true;
		}
	}


	return ret;
}


static void handle_atras (TButton *b)
{
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
	continuar = false;
}

static void handle_aceptar (TButton *b)
{
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
	b->GetParent()->UpdateData(true);
	continuar = true;
}

static void handle_sel_jug_1 (TButton *b)
{
	t_jugador *jug_descartar[3]= {competitivo_jug[1], competitivo_jug[2], competitivo_jug[3]};

	show_mouse(NULL);
	competitivo_jug[0] = seleccionar_jugador(b->GetParent()->GetDestinationBitmap(), competitivo_jug[0], 219, 72, jug_descartar, 3);
	if (competitivo_jug[0])
	{
		b->SetText(string(competitivo_jug[0]->nick));
	}
}

static void handle_sel_jug_2 (TButton *b)
{
	t_jugador *jug_descartar[3]= {competitivo_jug[0], competitivo_jug[2], competitivo_jug[3]};

	show_mouse(NULL);
	competitivo_jug[1] = seleccionar_jugador(b->GetParent()->GetDestinationBitmap(), competitivo_jug[1], 219, 96, jug_descartar, 3);
	if (competitivo_jug[1])
	{
		b->SetText(string(competitivo_jug[1]->nick));
	}
}

static void handle_sel_jug_3 (TButton *b)
{
	t_jugador *jug_descartar[3]= {competitivo_jug[0], competitivo_jug[1], competitivo_jug[3]};

	show_mouse(NULL);
	competitivo_jug[2] = seleccionar_jugador(b->GetParent()->GetDestinationBitmap(), competitivo_jug[2], 219, 120, jug_descartar, 3);
	if (competitivo_jug[2])
	{
		b->SetText(string(competitivo_jug[2]->nick));
	}
}

static void handle_sel_jug_4 (TButton *b)
{
	t_jugador *jug_descartar[3]= {competitivo_jug[0], competitivo_jug[1], competitivo_jug[2]};

	show_mouse(NULL);
	competitivo_jug[3] = seleccionar_jugador(b->GetParent()->GetDestinationBitmap(), competitivo_jug[3], 219, 144, jug_descartar, 3);
	if (competitivo_jug[3])
	{
		b->SetText(string(competitivo_jug[3]->nick));
	}
}

void juego_competitivo(BITMAP* fondo, FONT* f_list)
{
	int i, j, k;
	BITMAP *dialog_back = create_bitmap(640, 480);
	CRand series[4];

	clear_bitmap(dialog_back);

	blit (fondo, dialog_back, 0, 0, 0, 0, 640, 480);

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender(0, 0, 0, 127);
	rectfill(dialog_back, 0, 0, 639, 479, 0);
	set_add_blender(0, 0, 0, 255);
	dibujar_gradiente(dialog_back, 0, 0, 219, 21, 0, 0, 0, 192, 64, 64);
	dibujar_gradiente(dialog_back, 420, 0, 639, 21, 192, 64, 64, 0, 0, 0);
	rectfill(dialog_back, 220, 0, 419, 21, makecol(192, 64, 64));
	solid_mode();

	textout_centre(dialog_back, roman12, TEXT_competitivo(), 320,02, makecol(255,255,255));

	TDialog d_normal(0, 0, 640, 480);
	TImage i_fondo(0, 0, 640, 480, dialog_back);
	TPanel p_panel(0, 0, 640, 480);
//	TStatic s_titulo(220, 0, 200, 16, TEXT_competitivo());

	TRadio r_num_pl_1(10, 30, 149, 20, TEXT_juego_2_jugadores(), 1);
	TRadio r_num_pl_2(167, 30, 149, 20, TEXT_juego_3_jugadores(), 1);
	TRadio r_num_pl_3(324, 30, 149, 20, TEXT_juego_4_jugadores(), 1);

	r_num_pl_1.SetCheck(competitivo_num_jug==2);
	r_num_pl_2.SetCheck(competitivo_num_jug==3);
	r_num_pl_3.SetCheck(competitivo_num_jug==4);

	TPanel p_jugador(5, 50, 630, 117);
	p_jugador.SetAlt(-1);

	TStatic s_jug1(10, 74, 59, 12, TEXT_juego_jugador(1));
	TStatic s_jug2(10, 98, 59, 12, TEXT_juego_jugador(2));
	TStatic s_jug3(10, 122, 59, 12, TEXT_juego_jugador(3));
	TStatic s_jug4(10, 146, 59, 12, TEXT_juego_jugador(4));
	TButton b_jug1(70, 72, 149, 16, "");
	TButton b_jug2(70, 96, 149, 16, "");
	TButton b_jug3(70, 120, 149, 16, "");
	TButton b_jug4(70, 144, 149, 16, "");

	b_jug1.SetText(string(competitivo_jug[0] ? competitivo_jug[0]->nick : TEXT_anonimo()));
	b_jug2.SetText(string(competitivo_jug[1] ? competitivo_jug[1]->nick : TEXT_anonimo()));
	b_jug3.SetText(string(competitivo_jug[2] ? competitivo_jug[2]->nick : TEXT_anonimo()));
	b_jug4.SetText(string(competitivo_jug[3] ? competitivo_jug[3]->nick : TEXT_anonimo()));

	b_jug1.SetMsgBtnClick(handle_sel_jug_1);
	b_jug2.SetMsgBtnClick(handle_sel_jug_2);
	b_jug3.SetMsgBtnClick(handle_sel_jug_3);
	b_jug4.SetMsgBtnClick(handle_sel_jug_4);

	TStatic s_serie(230, 54, 149, 12, TEXT_juego_serie_piezas());
	TSpin sp_serie1(230, 72, 149, 16);
	TSpin sp_serie2(230, 96, 149, 16);
	TSpin sp_serie3(230, 120, 149, 16);
	TSpin sp_serie4(230, 144, 149, 16);

	TPanel p_tab(5, 170, 312, 233);
	p_tab.SetAlt(-1);

	TStatic s_tab(10, 179, 130, 12, TEXT_tamanyo_tablero());
	TStatic s_tabx(150, 177, 8, 16, "x");
	TSpin sp_tabx(158, 177, 64, 16);
	TStatic s_taby(238, 177, 8, 16, "y");
	TSpin sp_taby(246, 177, 64, 16);

	TStatic s_nivel_ini(10, 201, 130, 12, TEXT_nivel_inicial());
	TStatic s_nivel_fin(10, 223, 130, 12, TEXT_nivel_maximo());
	TSpin sp_nivel_ini(150, 199, 72, 16);
	TSpin sp_nivel_fin(150, 221, 72, 16);

	TStatic s_lineas(10, 245, 130, 12, TEXT_lineas_iniciales());
	TSpin sp_lineas(150, 243, 160, 16);

	TStatic s_set_piezas(330, 177, 70, 12, TEXT_piezas());
	TList l_set_piezas(330+80, 175, 220, text_height(TObject::GetSkin()->get_normal_font())*6+2, "");

	TPanel p_reglas(323, 170, 312, 233);
	p_reglas.SetAlt(-1);

	TCheck ch_kamikaze(10, 267, 100, 16, TEXT_kamikaze());
	ch_kamikaze.SetCheck(competitivo_kamikaze);
	TSpin sp_kamikaze_dificultad(120, 267, 190, 16);
	TSpin sp_enviar(10, 287, 300, 16);
	TStatic s_victoria(10, 305+16+16, 300, 12, TEXT_condicion_victoria());
	TSpin sp_victoria(10, 317+16+16, 300, 16);
	TStatic s_tiempo_extra(330, 249+16, 300, 12, TEXT_tiempo_extra());
	TSpin sp_tiempo_extra(330, 261+16, 300, 16);
	TStatic s_tiempo(330, 283+16, 300, 12, TEXT_tiempo_juego());
	TSpin sp_tiempo(330, 295+16, 300, 16);

	TCheck ch_puntos_bonus(330, 316+16, 300, 16, TEXT_puntos_dejar_caer());
	ch_puntos_bonus.SetCheck(competitivo_puntos_dejar_caer);
	TCheck ch_puntos_colocar(330, 332+16, 300, 16, TEXT_puntos_colocar());
	ch_puntos_colocar.SetCheck(competitivo_puntos_colocar_piezas);
	TCheck ch_mostrar_sig(330, 348+16, 300, 16, TEXT_mostrar_siguiente());
	ch_mostrar_sig.SetCheck(competitivo_mostrar_siguiente);
	TCheck ch_posicion(330, 364+16, 300, 16, TEXT_caen_desde_fuera());
	ch_posicion.SetCheck(competitivo_caer_desde_fuera);
//	TButton b_power_ups(330, 380+16, 300, 20, "Power ups");

	TButton b_presets(10, 420, 150, 20, TEXT_presets());
	TStatic s_presets(160, 408, 150, 12, TEXT_preset_actual());
	TPanel p_presets(160, 420, 150, 20);
	p_presets.SetAlt(-1);
	TStatic s_resolucion(330, 408, 150, 12, TEXT_resolucion());
	TSpin sp_resolucion(330, 420, 145, 20);
	TButton b_musica_fondos(485, 420, 145, 20, TEXT_musica_y_fondos());

	TButton b_atras(10, 450, 300, 20, TEXT_volver());
	TButton b_aceptar(330, 450, 300, 20, TEXT_comenzar());
	b_musica_fondos.SetMsgBtnClick(handle_musica_fondos);

	b_atras.SetMsgBtnClick(handle_atras);
	b_aceptar.SetMsgBtnClick(handle_aceptar);

	char str[20];
	for(i=1; i<11; i++)
	{
		sprintf (str, "%d", i);
		sp_nivel_ini.AddItem(str);
		sp_nivel_fin.AddItem(str);
	}

	for(i=16; i<=(SCREEN_W-10)/20; i++)
	{
		sprintf(str, "%d", i);
		sp_tabx.AddItem(str);
	}
	sp_tabx.SetSel(competitivo_tab_tam_x);

	const int max_altura = (SCREEN_H-40-30)/20;

	for(i=8; i<=max_altura; i++)
	{
		sprintf(str, "%d", i);
		sp_taby.AddItem(str);
	}
	sp_taby.SetSel(competitivo_tab_tam_y);

	sp_nivel_ini.SetSel(competitivo_nivel);
	sp_nivel_fin.SetSel(competitivo_nivel_max);

	for(i=0; i<max_altura-4; i+=4)
	{
		if (i==0)
		{
			sp_lineas.AddItem(TEXT_tablero_vacio());
		}
		else
		{
			sp_lineas.AddItem(TEXT_n_lineas(i));
		}
	}
	sp_lineas.SetSel(competitivo_lineas_iniciales);

	for(i=1; i<5; i++)
	{
		sp_serie1.AddItem(TEXT_serie(i));
		sp_serie2.AddItem(TEXT_serie(i));
		sp_serie3.AddItem(TEXT_serie(i));
		sp_serie4.AddItem(TEXT_serie(i));
	}
	sp_serie1.SetSel(competitivo_serie_piezas[0]);
	sp_serie2.SetSel(competitivo_serie_piezas[1]);
	sp_serie3.SetSel(competitivo_serie_piezas[2]);
	sp_serie4.SetSel(competitivo_serie_piezas[3]);

	sp_kamikaze_dificultad.AddItem(TEXT_facil());
	sp_kamikaze_dificultad.AddItem(TEXT_medio());
	sp_kamikaze_dificultad.AddItem(TEXT_dificil());
	sp_kamikaze_dificultad.SetSel(competitivo_kamikaze_dificultad);

	sp_enviar.AddItem(TEXT_al_instante());
	sp_enviar.AddItem(TEXT_rangos_x_segundos(5));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(10));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(15));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(20));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(25));
	sp_enviar.AddItem(TEXT_rangos_x_segundos(30));
	sp_enviar.SetSel(competitivo_enviar_piezas_cuando);

	sp_victoria.AddItem(TEXT_quien_tenga_mas_puntos());
	sp_victoria.AddItem(TEXT_quien_haga_mas_lineas());
	sp_victoria.AddItem(TEXT_quien_haga_primero_un_tetris());
	sp_victoria.SetSel(competitivo_condicion_victoria);

	sp_tiempo_extra.AddItem(TEXT_sin_tiempo_extra());
	sp_tiempo_extra.AddItem(TEXT_x_segundos(2));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(5));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(10));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(15));
	sp_tiempo_extra.AddItem(TEXT_x_segundos(20));
	sp_tiempo_extra.AddItem(TEXT_esperar_jugadores_acaben());
	sp_tiempo_extra.SetSel(competitivo_tiempo_extra);

	sp_tiempo.AddItem(TEXT_tiempo_ilimitado());
	sp_tiempo.AddItem(TEXT_1_minuto());
	sp_tiempo.AddItem(TEXT_x_minutos(2));
	sp_tiempo.AddItem(TEXT_x_minutos(3));
	sp_tiempo.AddItem(TEXT_x_minutos(5));
	sp_tiempo.AddItem(TEXT_x_minutos(10));
	sp_tiempo.AddItem(TEXT_x_minutos(15));
	sp_tiempo.SetSel(competitivo_tiempo);

	sp_resolucion.AddItem("640 x 480");
	sp_resolucion.AddItem("800 x 600");
	sp_resolucion.AddItem("1024 x 768");
	sp_resolucion.AddItem("1280 x 1024");

	sp_resolucion.SetSel(0);

	crear_lista_piezas(&l_set_piezas);

	d_normal.AddObject(&i_fondo);
//	d_normal.AddObject(&p_panel);
//	d_normal.AddObject(&s_titulo);
	d_normal.AddObject(&r_num_pl_1);
	d_normal.AddObject(&r_num_pl_2);
	d_normal.AddObject(&r_num_pl_3);

//	d_normal.AddObject(&p_jugador);

	d_normal.AddObject(&s_jug1);
	d_normal.AddObject(&s_jug2);
	d_normal.AddObject(&s_jug3);
	d_normal.AddObject(&s_jug4);
	d_normal.AddObject(&b_jug1);
	d_normal.AddObject(&b_jug2);
	d_normal.AddObject(&b_jug3);
	d_normal.AddObject(&b_jug4);

	d_normal.AddObject(&s_serie);
	d_normal.AddObject(&sp_serie1);
	d_normal.AddObject(&sp_serie2);
	d_normal.AddObject(&sp_serie3);
	d_normal.AddObject(&sp_serie4);

//	d_normal.AddObject(&p_tab);

	d_normal.AddObject(&s_tab);

	d_normal.AddObject(&s_tabx);
	d_normal.AddObject(&sp_tabx);
	d_normal.AddObject(&s_taby);
	d_normal.AddObject(&sp_taby);

	d_normal.AddObject(&s_nivel_ini);
	d_normal.AddObject(&s_nivel_fin);
	d_normal.AddObject(&sp_nivel_ini);
	d_normal.AddObject(&sp_nivel_fin);

	d_normal.AddObject(&s_lineas);
	d_normal.AddObject(&sp_lineas);

	d_normal.AddObject(&s_set_piezas);
	d_normal.AddObject(&l_set_piezas);

//	d_normal.AddObject(&p_reglas);

	d_normal.AddObject(&ch_kamikaze);
	d_normal.AddObject(&sp_kamikaze_dificultad);
	d_normal.AddObject(&sp_enviar);
	d_normal.AddObject(&s_victoria);
	d_normal.AddObject(&sp_victoria);
	d_normal.AddObject(&s_tiempo_extra);
	d_normal.AddObject(&sp_tiempo_extra);
	d_normal.AddObject(&s_tiempo);
	d_normal.AddObject(&sp_tiempo);

	d_normal.AddObject(&ch_puntos_bonus);
	d_normal.AddObject(&ch_puntos_colocar);
	d_normal.AddObject(&ch_mostrar_sig);
	d_normal.AddObject(&ch_posicion);
//	d_normal.AddObject(&b_power_ups);

	d_normal.AddObject(&b_presets);
	d_normal.AddObject(&s_presets);
	d_normal.AddObject(&p_presets);
	d_normal.AddObject(&s_resolucion);
	d_normal.AddObject(&sp_resolucion);
	d_normal.AddObject(&b_musica_fondos);
	d_normal.AddObject(&b_atras);
	d_normal.AddObject(&b_aceptar);

	d_normal.SetBuffer(buffer);

	continuar = true;
	while (continuar)
	{
//		blit (fondo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
//		blit (fondo, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		d_normal.ChangeDestinationBitmap(video.ObtenerPaginaVisible());
		TShowDialog(d_normal);

		text_mode(-1);

		if (continuar)
		{
			char piezas_file[300];

			show_mouse(NULL);
			clear_bitmap(video.ObtenerPantalla());
			textout_centre(video.ObtenerPantalla(), comic16, TEXT_cargando(), 320, 200, makecol(255,255,255));
			video.Actualizar();

			if (buscar_pieza(l_set_piezas.GetSelText().c_str(), piezas_file, 300))
			{
				if (r_num_pl_1.GetCheck()) competitivo_num_jug = 2;
				if (r_num_pl_2.GetCheck()) competitivo_num_jug = 3;
				if (r_num_pl_3.GetCheck()) competitivo_num_jug = 4;
				competitivo_serie_piezas[0] = sp_serie1.GetSel();
				competitivo_serie_piezas[1] = sp_serie2.GetSel();
				competitivo_serie_piezas[2] = sp_serie3.GetSel();
				competitivo_serie_piezas[3] = sp_serie4.GetSel();
				competitivo_tab_tam_x = sp_tabx.GetSel();
				competitivo_tab_tam_y = sp_taby.GetSel();
				competitivo_nivel = sp_nivel_ini.GetSel();
				competitivo_nivel_max = sp_nivel_fin.GetSel();
				competitivo_lineas_iniciales = sp_lineas.GetSel();
				competitivo_enviar_piezas_cuando = sp_enviar.GetSel();
				competitivo_kamikaze = ch_kamikaze.GetCheck();
				competitivo_kamikaze_dificultad = sp_kamikaze_dificultad.GetSel();
				competitivo_condicion_victoria = sp_victoria.GetSel();
				competitivo_tiempo_extra = sp_tiempo_extra.GetSel();
				competitivo_tiempo = sp_tiempo.GetSel();
				competitivo_puntos_dejar_caer = ch_puntos_bonus.GetCheck();
				competitivo_puntos_colocar_piezas = ch_puntos_colocar.GetCheck();
				competitivo_mostrar_siguiente = ch_mostrar_sig.GetCheck();
				competitivo_caer_desde_fuera = ch_posicion.GetCheck();


				t_juego* juego = NULL;
				static t_tablero* tab = NULL;
				t_set_piezas* piezas = NULL;
				t_cuadro_puntuacion* puntos[4] = {NULL, NULL, NULL, NULL};
				t_jug* jug[4] = {NULL, NULL, NULL, NULL};
				t_cuadro_sig_pieza* cuadro_sig_pieza[4] = {NULL, NULL, NULL, NULL};
				BITMAP *graf_piezas;

				juego = new t_juego;
				juego->num_jug = competitivo_num_jug;
				juego->num_punt = competitivo_num_jug;
				juego->num_tab = 1;

				juego->tiempo = tiempo_table[competitivo_tiempo];
				juego->tiempo_extra = tiempo_extra_table[competitivo_tiempo_extra];
				juego->tiempo_entre_lineas = tiempo_enviar_lineas[competitivo_enviar_piezas_cuando];
				juego->enviar_lineas_esperar_nueva_pieza = false;

				piezas = new t_set_piezas;

				if (!cargar_piezas(piezas_file, piezas, &(graf_piezas)))
				{
					set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
					allegro_message ("Error al cargar piezas");
					exit(1);
				}

				tab = new t_tablero;
				tab->tamx = competitivo_tab_tam_x+16;
				tab->tamy = competitivo_tab_tam_y+8;
				tab->nivel = competitivo_nivel+1;

				if (competitivo_kamikaze)
				{
					switch (competitivo_kamikaze_dificultad)
					{
					case 0:
						tab->enviar_lineas[0][0] = 1;
						tab->enviar_lineas[0][1] = 1;
						tab->enviar_lineas[0][2] = 0;
						tab->enviar_lineas[0][3] = 0;
						break;
					case 1:
						tab->enviar_lineas[0][0] = 2;
						tab->enviar_lineas[0][1] = 1;
						tab->enviar_lineas[0][2] = 1;
						tab->enviar_lineas[0][3] = 0;
						break;
					case 2:
						tab->enviar_lineas[0][0] = 3;
						tab->enviar_lineas[0][1] = 2;
						tab->enviar_lineas[0][2] = 1;
						tab->enviar_lineas[0][3] = 0;
						break;
					}
				}
				else
				{
					tab->enviar_lineas[0][0] =
						tab->enviar_lineas[0][1] =
						tab->enviar_lineas[0][2] =
						tab->enviar_lineas[0][3] = 0;
				}

				tab->contrarestar[0] = 0;
				tab->contrarestar[1] = 0;
				tab->contrarestar[2] = 0;
				tab->contrarestar[3] = 0;

				tab->nivel_visible=false;
				tab->estado = 0;
				tab->posy = 40+(SCREEN_H-80-tab->tamy*20)/2;
				tab->caer_desde_fuera = competitivo_caer_desde_fuera;
				tab->lineas = 0;
				tab->num_lineas = 0;
				tab->estado = 0;
				tab->prox_nivel = 10;

				for(j=0; j<tab->tamx; j++)
				{
					for (k=0; k<tab->tamy; k++)
					{
						tab->cuadro[j][k] = -1;
					}
				}

				for (j=0; j<competitivo_lineas_iniciales*4; j++)
				{
					insertar_linea(tab, graf_piezas->w/20);
				}

				juego->tab[0] = tab;

				for(i=0; i<juego->num_jug; i++)
				{
					puntos[i] = new t_cuadro_puntuacion;
					puntos[i]->lineas = 0;
					puntos[i]->nivel = competitivo_nivel+1;
					puntos[i]->puntos = 0;
					puntos[i]->visible = false;

					juego->puntos[i] = puntos[i];
				}

				for (i=0; i<competitivo_num_jug; i++)
				{
					jug[i] = new t_jug;
					jug[i]->jug = competitivo_jug[i];
					jug[i]->serie_piezas = new CRand(series[competitivo_serie_piezas[i]]);
					jug[i]->puntos_dejar_caer = competitivo_puntos_dejar_caer;
					jug[i]->puntos_piezas = competitivo_puntos_colocar_piezas;

					cuadro_sig_pieza[i] = new t_cuadro_sig_pieza;

					jug[i]->cuadro_sig_pieza = cuadro_sig_pieza[i];
					cuadro_sig_pieza[i]->visible = false;

					juego->jug[i] = jug[i];

					jug[i]->puntos = puntos[i];
					jug[i]->tab = tab;

					jug[i]->graf_piezas = graf_piezas;
					jug[i]->piezas = piezas;

					if (competitivo_num_jug / (i+1) >= 2)
					{
						jug[i]->mini_scores.pos = IZQUIERDA;
					}
					else
					{
						jug[i]->mini_scores.pos = DERECHA;
					}

					jug[i]->mostrar_siguiente = competitivo_mostrar_siguiente;

					jug[i]->pieza_pos_x_start = i*tab->tamx/competitivo_num_jug+(tab->tamx/competitivo_num_jug-4)/2;
				}

				if (!competitivo_do_layout(tab, competitivo_num_jug, jug, SCREEN_W, SCREEN_H))
				{
					show_mouse(NULL);
					BITMAP *f = video.CrearBitmap(640, 480, Video::hw_blit);
					blit(video.ObtenerPaginaVisible(), f, 0, 0, 0, 0, 640, 480);
					pregunta(f, small_font, 200, 2, "Resolucin demasiado baja:", "El juego no cabe en pantalla", NULL, 1, "Aceptar", NULL, NULL, 0, 0);
					video.DestruirBitmap(f);
				}
				else
				{
					for(i=0; i<competitivo_num_jug; i++)
					{
						jug[i]->jug_name_posx = tab->posx + i*tab->tamx*20/competitivo_num_jug + tab->tamx*10/competitivo_num_jug;
						jug[i]->jug_name_posy = tab->posy-30;
					}

					BITMAP *resized_fondo;

					string f_str = ObtenerFondo();
					if (f_str != "")
					{
						resized_fondo = cargar_fondo(f_str.c_str());
					}
					else
					{
						resized_fondo = video.CargarPng(path_data + "/tetris.dat#titulo", Video::hw_blit);
					}

					clear_bitmap(fondo);
					blit (resized_fondo, fondo, 0, 0, (SCREEN_W-resized_fondo->w)/2, (SCREEN_H-resized_fondo->h)/2, resized_fondo->w, resized_fondo->h);
					destroy_bitmap(resized_fondo);

					for(i=0; i<juego->num_tab; i++)
					{
						dibujar_recuadro_trans(fondo, juego->tab[i]->posx, juego->tab[i]->posy-30, juego->tab[i]->posx+juego->tab[i]->tamx*20, juego->tab[i]->posy-10, 127);
					}

					reproducir_musica(rand()%num_canciones, 1);

					show_mouse(NULL);

					series[0].initialize();
					series[1].initialize();
					series[2].initialize();
					series[3].initialize();

					comenzar_juego(fondo, juego, modo_competitivo);
					reproducir_musica(0, 1);
				}

				delete piezas;
				destroy_bitmap(graf_piezas);

				delete tab;
				for(i=0; i<competitivo_num_jug; i++)
				{
					delete jug[i];
					delete cuadro_sig_pieza[i];
					delete puntos[i];
				}

				delete juego;
			}
		}
	}

	BITMAP *aux_fondo = video.CargarPng(path_data + "/tetris.dat#titulo", Video::hw_blit);
	blit (aux_fondo, fondo, 0, 0, 0, 0, 640, 480);
	destroy_bitmap(aux_fondo);
	destroy_bitmap(dialog_back);
	textprintf(fondo, small_font, 595, 460, makecol(255,255,255), "v%d.%d.%d", TVER_MAYOR, TVER_MINOR, TVER_SUB);

	show_mouse(NULL);
}
