//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "gui.h"
#include "globals.h"


char volatile cursor = '_';
void handler_cursor(void)
{
	if (cursor == '_') cursor = '\0';
	else cursor = '_';
}
END_OF_FUNCTION(handler_cursor);

void mostrar_error(BITMAP *fondo, char *line1, char *line2, char *line3)
{
	int numl = 1;
	if (line2 != NULL)
	{
		numl = 2;
		if (line3 != NULL) numl = 3;
	}
	pregunta (fondo, roman, 300, numl, line1, line2, line3, 1, TEXT_aceptar(), NULL, NULL, 0, 0);

	exit(1);
}

void mensaje (FONT *fuente, int x, int y, int num_l, char *line[])
{
	int width = 0;
	int height = 0;
	int line_w;
	int i;

	for (i=0; i<num_l; i++)
	{
		line_w = text_length(fuente, line[i]);
		if (line_w > width) width = line_w;
	}
	width+=text_height(fuente);
	height = text_height(fuente)*(num_l+1);

	rectfill (screen, x-(width>>1), y-(height>>1), x+(width>>1), y+(height>>1), makecol(10, 50, 30));
	rect (screen, x-(width>>1), y-(height>>1), x+(width>>1), y+(height>>1), makecol(50, 255, 192));

	for (i=0; i<num_l; i++)
	{
		textout_centre (screen, fuente, line[i], x, y-(height>>1)+(text_height(fuente)>>1)+text_height(fuente)*i, makecol(255, 255, 255));
	}
}

int pregunta (BITMAP *fondo, FONT *fuente, int y, int num_l, const char *line1, const char *line2, const char *line3, int num_b, const char *boton1, const char *boton2, const char *boton3, int def, int esc)
{
	int sel = def;
	int width = 0;
	int height = text_height(fuente) * int(num_l+4.5);
	bool fin = false;
	BITMAP *dst;

	if (num_l>0 && text_length(fuente, line1) > width) width = text_length(fuente, line1);
	if (num_l>1 && text_length(fuente, line2) > width) width = text_length(fuente, line2);
	if (num_l>2 && text_length(fuente, line3) > width) width = text_length(fuente, line3);
	width+=48;
	int x = 319-width/2;

	int col = 96;
	int vcol = 2;
	counter = 0;
	while (!fin)
	{
		while (counter>0)
		{
			col+=vcol;
			if (col>=96)
			{
				vcol = -vcol;
				col = 96;
			}
			if (col<=32)
			{
				vcol = -vcol;
				col = 32;
			}
			counter--;
		}
		if (key[KEY_LEFT])
		{
			if (sel>0) sel--;
			clear_keys();
		}
		if (key[KEY_RIGHT])
		{
			if (sel<num_b-1) sel++;
			clear_keys();
		}
		if (key[KEY_ENTER])
		{
			fin = true;
			clear_keys();
		}
		if (key[KEY_ESC])
		{
			sel = esc;
			fin = true;
			clear_keys();
		}
		
		video.IniciarSalida();
		dst = video.ObtenerPantalla();

		blit (fondo, dst, 0, 0, 0, 0, 640, 480);
		rectfill (dst, x, y, x+width, y+height, makecol(10, 50, 30));
		rect (dst, x, y, x+width, y+height, makecol(50, 255, 192));

		if (num_l>0) textout_centre (dst, fuente, line1, 320, y+text_height(fuente), makecol(0,192,255));
		if (num_l>1) textout_centre (dst, fuente, line2, 320, y+2*text_height(fuente), makecol(0,192,255));
		if (num_l>2) textout_centre (dst, fuente, line3, 320, y+3*text_height(fuente), makecol(0,192,255));

		int x1=0, x2=0, x3=0;
		int boton_w=0;
		if (num_b==1)
		{
			x1 = 320;
			boton_w = width/3;
		}
		if (num_b==2)
		{
			x1 = x+width/3;
			x2 = x+2*(width/3);
			boton_w = width/4;
		}
		if (num_b==3)
		{
			x1 = x+width/4;
			x2 = 320;
			x3 = 320+width/4;
			boton_w = width/5;
		}

		if (sel == 0)
		{
			if (num_b>1) rectfill(dst, x2-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x2+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);
			if (num_b>2) rectfill(dst, x3-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x3+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);

			rectfill(dst, x1-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x1+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,col,col));
		}
		if (sel == 1)
		{
			if (num_b>0) rectfill(dst, x1-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x1+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);
			if (num_b>2) rectfill(dst, x3-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x3+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);

			rectfill(dst, x2-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x2+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,col,col));
		}
		if (sel == 2)
		{
			if (num_b>0) rectfill(dst, x1-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x1+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);
			if (num_b>1) rectfill(dst, x2-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x2+boton_w/2, y+(num_l+3)*text_height(fuente)+5, 0);

			rectfill(dst, x3-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x3+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,col,col));
		}
		if (num_b>0) rect(dst, x1-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x1+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,192,192));
		if (num_b>1) rect(dst, x2-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x2+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,192,192));
		if (num_b>2) rect(dst, x3-boton_w/2, y+(num_l+2)*text_height(fuente)-3, x3+boton_w/2, y+(num_l+3)*text_height(fuente)+5, makecol(0,192,192));

		if (num_b>0) textout_centre(dst, fuente, boton1, x1, y+(num_l+2)*text_height(fuente), makecol(0,255,192));
		if (num_b>1) textout_centre(dst, fuente, boton2, x2, y+(num_l+2)*text_height(fuente), makecol(0,255,192));
		if (num_b>2) textout_centre(dst, fuente, boton3, x3, y+(num_l+2)*text_height(fuente), makecol(0,255,192));

		dibujar_raton(dst);

		video.Actualizar();
	}

	return sel;
}

int lista (BITMAP *fondo, int x, int y, int width, int h, FONT *fuente, int num, char elem[NUM_LISTA_ELEM][100], int sel, int (*call)(int))
{
	int pos = 0;
	bool fin = false;
	int t_height = text_height(fuente)+2;
	int height = t_height*h;
	int i;
	int centro_x =  x+width/2;
	int col = 255;
	int v = -2;
	int pos_sel = y+(sel-pos)*t_height;
	int vel = 5;
	bool can_move = true;
	int active = 1;

	if (sel > h/2)
	{
		pos = sel-h/2;
	}
	if (pos > num-h)
	{
		pos = num-h;
	}
	if (pos < 0)
	{
		pos = 0;
	}
	pos_sel = y+(sel-pos)*t_height;
	
	clear_keys();
	counter = 0;
	while (!fin)
	{
		while (counter > 0)
		{
			if (active)
			{
				col+=v;
				if (col==127) v = 4;
				if (col==255) v = -4;
				if (pos_sel - (y+(sel-pos)*t_height) > vel)
				{
					pos_sel-=vel;
					can_move = false;
				}
				else if ((y+(sel-pos)*t_height) -  pos_sel> vel)
				{
					pos_sel+=vel;
					can_move = false;
				}
				else
				{
					pos_sel = y+(sel-pos)*t_height;
					can_move = true;
				}
			}
			if (call != NULL) active = call(0);
			counter--;
		}

		if (active)
		{
			if (key[KEY_UP])
			{
				if (can_move)
				{
					if (sel > 0) sel--;
					if (sel < pos)
					{
						pos = sel;
						pos_sel+=t_height;
					}
					vel=5;
				}
				clear_keys();
			}
			if (key[KEY_DOWN])
			{
				if (can_move)
				{
					if (sel < num-1) sel++;
					if (sel > pos+h-1)
					{
						pos = sel-h+1;
						pos_sel-=t_height;
					}
					vel=5;
				}
				clear_keys();
			}
			if (key[KEY_PGUP])
			{
				if (can_move)
				{
					sel-=h-1;
					if (sel < 0) sel=0;
					if (sel < pos)
					{
						pos = sel;
						pos_sel+=t_height;
					}
					vel=20;
				}
				clear_keys();
			}
			if (key[KEY_PGDN])
			{
				if (can_move)
				{
					sel+=h-1;
					if (sel > num-1) sel = num-1;
					if (sel > pos+h-1)
					{
						pos = sel-h+1;
						pos_sel-=t_height;
					}
					vel=20;
				}
				clear_keys();
			}
			if (key[KEY_ENTER] && can_move)
			{
				fin = true;
				clear_keys();
			}
			if (key[KEY_ESC] && can_move)
			{
				sel = -1;
				fin = true;
				clear_keys();
			}
		}
		if (call != NULL) call(1);

		BITMAP *dst = video.ObtenerPantalla();
		if (active)
		{
			video.IniciarSalida();
			blit (fondo, dst, 0, 0, 0, 0, 640, 480);
			rectfill (dst, x, y, x+width, y+height, 0);
			rect (dst, x-1, y-1, x+width+1, y+height+1, makecol(50, 255, 192));
			if (pos > 0)
			{
				triangle(dst, centro_x-25, y-1, centro_x, y-16, centro_x+25, y-1, makecol(col,col,0));
			}
			if (pos < num - h)
			{
				triangle(dst, centro_x-25, y+height+2, centro_x, y+height+17, centro_x+25, y+height+2, makecol(col,col,0));
			}
			rectfill (dst, x, pos_sel, x+width, pos_sel+t_height, makecol(0, 128, 128));
			set_clip(dst, x, y, x+width, y+height);
			for (i=0; i<h; i++)
			{
				if (i<num)
					textout_centre(dst, fuente, elem[i+pos], centro_x, y+i*t_height+1, makecol(255,255,255));
			}
		}
		set_clip(dst, 0, 0, dst->w-1, dst->h-1);
		if (call != NULL) call(2);
		dibujar_raton(dst);
		video.Actualizar();
	}

	return sel;
}

void caja_texto(char *s, int max, int x, int y, FONT *fuente, int col, BITMAP *fondo)
{
//	s[0] = '\0';
	clear_keys();
	int fin = 0;
	int i=strlen(s);
	int c;

	LOCK_FUNCTION(handler_cursor);
	LOCK_VARIABLE(cursor);
	install_int_ex(handler_cursor, BPS_TO_TIMER(2));
	cursor = '_';

	do
	{
		BITMAP *dst = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (fondo, dst, 0, 0, 0, 0, 640, 480);
		textprintf (dst, fuente, x, y, col, "%s%c", s, cursor);
		video.Actualizar();

		if (keypressed())
		{
			c = readkey();
			if ( ((c & 0xff) >= ' ' && (c & 0xff) <= 'z') || ((c & 0xff) >= 159 && (c & 0xff) <= 255))
			{
				if (i<max)
				{
					s[i] = c & 0xff;
					i++;
					s[i] = '\0';
				}
			}
			if ( (c >> 8) == KEY_ENTER )
			{
				if (i>0) fin = 1;
			}
			if ( (c >> 8) == KEY_BACKSPACE )
			{
				if (i>0)
				{
					i--;
					s[i] = '\0';
				}
			}
			cursor = '_';
		}
	} while (!fin);

	remove_int (handler_cursor);
}
