//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "main.h"
#include "globals.h"
#include "ExcepcionTU.h"

void transicion_lineas (BITMAP *fondo, int v)
{
	BITMAP *fondo_l, *fondo_r;
	int i;

	video.CopiarABuffers();

	fondo_l = video.CrearBitmap(640, 480, Video::hw_trans_blit);
	if (!fondo_l)
	{
		throw new ExcepcionTU("Error al generar imagen izquierda para transicion", -1);
	}
	acquire_bitmap(fondo_l);
	clear(fondo_l);
	release_bitmap(fondo_l);
	fondo_r = video.CrearBitmap(640, 480, Video::hw_trans_blit);
	if (!fondo_r)
	{
		throw new ExcepcionTU("Error al generar imagen derecha para transicion", -1);
	}
	acquire_bitmap(fondo_r);
	clear(fondo_r);
	release_bitmap(fondo_r);

	if (fondo_l==NULL || fondo_r==NULL)
	{
		throw new ExcepcionTU(TEXT_no_video_mem(), -1);
	}

	acquire_bitmap(fondo_l);
	blit (fondo, fondo_l, 0, 0, 0, 0, 640, 480);
	release_bitmap(fondo_l);
	acquire_bitmap(fondo_r);
	blit (fondo, fondo_r, 0, 0, 0, 0, 640, 480);
	release_bitmap(fondo_r);

	i=0;
	while (i<480)
	{
		acquire_bitmap(fondo_l);
		hline (fondo_l, 0, i, 640, makecol(255,0,255));
		release_bitmap(fondo_l);
		i++;
		acquire_bitmap(fondo_r);
		hline (fondo_r, 0, i, 640, makecol(255,0,255));
		release_bitmap(fondo_r);
		i++;
	}

	counter=0;
	i=0;
	while (i<640)
	{
		while (counter>0)
		{
			i+=v;
			counter--;
		}
		video.IniciarSalida();
		BITMAP *p = video.ObtenerPantalla();
		masked_blit(fondo_l, p, 640-i, 0, 0, 0, i, 480);
		masked_blit(fondo_r, p, 0, 0, 640-i, 0, i, 480);
		video.Actualizar();
	}

	destroy_bitmap(fondo_l);
	destroy_bitmap(fondo_r);
}

void dibujar_recuadro_trans(BITMAP *dest, int x1, int y1, int x2, int y2, int trans)
{
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender(0, 0, 0, trans);
	rectfill(dest, x1, y1, x2, y2, 0);
	solid_mode();

	rect(dest, x1-3, y1-3, x2, y2, makecol(30, 192, 128));
	rect(dest, x1-1, y1-1, x2+2, y2+2, makecol(20, 100, 80));
	rect(dest, x1-2, y1-2, x2+1, y2+1, makecol(80, 255, 225));
}


static void draw_pixel(BITMAP *dest, int x, int y, int c, float t, double trans)
{
	int a = int(256*(1-t*t));

	if (a<0) a=0;
	if (a>255) a=255;

	set_trans_blender(0, 0, 0, (int)(a*trans));

	putpixel(dest, x, y, c);
}

static void draw_pixel_add(BITMAP *dest, int x, int y, int c, float t, double trans)
{
	int a = int(256*(1-t*t));

	if (a<0) a=0;
	if (a>255) a=255;

	set_add_blender(0, 0, 0, (int)(a*trans));

	putpixel(dest, x, y, c);
}

void aaline (BITMAP *dest, int x0, int y0, int x1, int y1, int c, double trans, int add_blender)
{

    int dx = x1-x0;
    int dy = y1-y0;

	//int addr = (y0*640+x0)*4;
	int x=x0;
	int y=y0;

	int du;
	int dv;
	int u;
	int v;
	//int vincr, uincr;
	int x_vincr, y_vincr, x_uincr, y_uincr;

    int uend;
    int d;	    /* Initial value as in Bresenham's */
    int incrS;	/* ?d for straight increments */
    int incrD;	/* ?d for diagonal increments */
    int twovdu;	/* Numerator of distance; starts at 0 */
    double invD;   /* Precomputed inverse denominator */
    double invD2du;   /* Precomputed constant */

    /* By switching to (u,v), we combine all eight octants */
    if (abs(dx) > abs(dy))
    {
		/* Note: If this were actual C, these integers would be lost
		 * at the closing brace.  That's not what I mean to do.  Do what
		 * I mean. */
		du = abs(dx);
		dv = abs(dy);
		u = x1;
		v = y1;
//		uincr = 4;
//		vincr = 640*4;
		x_uincr = 1;
		x_vincr = 0;
		y_uincr = 0;
		y_vincr = 1;
		if (dx < 0)
		{
			//uincr = -uincr;
			x_uincr = -x_uincr;
			y_uincr = -y_uincr;
		}
		if (dy < 0)
		{
			//vincr = -vincr;
			x_vincr = -x_vincr;
			y_vincr = -y_vincr;
		}
	}
	else
	{
		du = abs(dy);
		dv = abs(dx);
		u = y1;
		v = x1;
		//uincr = 640*4;
		//vincr = 4;
		x_uincr = 0;
		x_vincr = 1;
		y_uincr = 1;
		y_vincr = 0;
		if (dy < 0)
		{
			//uincr = -uincr;
			x_uincr = -x_uincr;
			y_uincr = -y_uincr;
		}
		if (dx < 0)
		{
			//vincr = -vincr;
			x_vincr = -x_vincr;
			y_vincr = -y_vincr;
		}
	}

    uend = u + du;
    d = (2 * dv) - du;	    /* Initial value as in Bresenham's */
    incrS = 2 * dv;	/* ?d for straight increments */
    incrD = 2 * (dv - du);	/* ?d for diagonal increments */
    twovdu = 0;	/* Numerator of distance; starts at 0 */
    invD = 1.0 / (2.0*sqrt(double(du*du + dv*dv)));   /* Precomputed inverse denominator */
    invD2du = 2.0 * (du*invD);   /* Precomputed constant */

    do
    {
		/* Note: this pseudocode doesn't ensure that the address is
		 * valid, or that it even represents a pixel on the same side of
		 * the screen as the adjacent pixel */
		if (add_blender)
		{
			draw_pixel_add(dest, x, y, c, twovdu*invD, trans);
			draw_pixel_add(dest, x+x_vincr, y+y_vincr, c, invD2du - twovdu*invD, trans);
			draw_pixel_add(dest, x-x_vincr, y-y_vincr, c, invD2du + twovdu*invD, trans);
		}
		else
		{
			draw_pixel(dest, x, y, c, twovdu*invD, trans);
			draw_pixel(dest, x+x_vincr, y+y_vincr, c, invD2du - twovdu*invD, trans);
			draw_pixel(dest, x-x_vincr, y-y_vincr, c, invD2du + twovdu*invD, trans);
		}

		//draw_pixel(dest, (addr/4)%640, (addr/4)/640, c, twovdu*invD);
		//draw_pixel(dest, ((addr+vincr)/4)%640, ((addr+vincr)/4)/640, c, invD2du - twovdu*invD);
		//draw_pixel(dest, ((addr-vincr)/4)%640, ((addr-vincr)/4)/640, c, invD2du + twovdu*invD);

		if (d < 0)
		{
			/* choose straight (u direction) */
			twovdu = d + du;
			d = d + incrS;
		}
		else
		{
			/* choose diagonal (u+v direction) */
			twovdu = d - du;
			d = d + incrD;
			v = v+1;
			x+=x_vincr;
			y+=y_vincr;
			//addr = addr + vincr;
		}
		u = u+1;
		x+=x_uincr;
		y+=y_uincr;
		//addr = addr + uincr;
    } while (u < uend);
}

void dibujar_gradiente(BITMAP *dest, int x1, int y1, int x2, int y2, int r1, int g1, int b1, int r2, int g2, int b2)
{
	double sx = x2-x1;

	for (int i=x1; i<=x2; i++)
	{
		double p1 = (x2-i)/sx;
		double p2 = (i-x1)/sx;
		vline(dest, i, y1, y2, makecol(int(r1*p1+r2*p2), int(g1*p1+g2*p2), int(b1*p1+b2*p2)));
	}
}
