//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include <stdafx.h>

#ifdef _WINDOWS
#include <winalleg.h>

#include "template.h"

void mostrar_ultimo_error(const char* win_title, const char* message, HWND hWnd)
{
	LPVOID lpMsgBuf;
	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);

	char* msg = new char[strlen((LPTSTR) lpMsgBuf) + strlen((LPTSTR) message) + 2];

	strcpy(msg, message);
	strcat(msg, "\n");
	strcat(msg, (LPTSTR)lpMsgBuf);

	MessageBox( hWnd, msg, win_title, MB_OK | MB_ICONERROR );

	LocalFree( lpMsgBuf );
}
#endif

int ejecutar (char *comando)
{
#ifdef _WINDOWS
	STARTUPINFO si;
	PROCESS_INFORMATION pinfo;

	si.cb = sizeof(STARTUPINFO);
	si.lpReserved = NULL;
	si.lpDesktop = NULL;
	si.lpTitle = NULL;
	si.cbReserved2 = 0;
	si.lpReserved2 = NULL;
	si.dwFlags = 0;

	if (!CreateProcess("config.exe", "", NULL, NULL, TRUE, 0, NULL, NULL, &si, &pinfo))
	{
		mostrar_ultimo_error("Tetris", TEXT_error_ejecutar_prog_config(), win_get_window());
		return -1;
	}

	WaitForInputIdle(pinfo.hProcess, INFINITE);

	DWORD exitcode;

	do
	{
		GetExitCodeProcess(pinfo.hProcess, &exitcode);
	} while (exitcode == STILL_ACTIVE);

	return exitcode;
#else
	return 0;
#endif
}
