//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#define _EDITOR_CPP_

#include "defines.h"
#include "main.h"
#include "gui.h"
#include "editor.h"
#include "globals.h"
#include "ExcepcionTU.h"

BITMAP *piezas_bmp;


bool buscar_pieza(const char *nombre, char *arch, int buf_size)
{
	bool ret = false;

	PACKFILE *fp;
	char magic[6];
	int i;
	char file[300];
	char nom[300];

	al_ffblk findinfo;

	sprintf(file, "%s/*.tp", path_pieces.c_str());
	i=0;
	if (al_findfirst(file, &findinfo, FA_ARCH | FA_RDONLY))
	{
		return false;
	}
	sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
	if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
	{
		pack_fread(magic, 5, fp);
		magic[5] = '\0';
		pack_fread(nom, 20, fp);
		if (ret = !strcmp(nom, nombre))
		{
			strcpy(arch, findinfo.name);
		}
		pack_fclose(fp);
	}
	while (!ret && !al_findnext(&findinfo))
	{
		sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
		if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
		{
			pack_fread(magic, 5, fp);
			magic[5] = '\0';
			pack_fread(nom, 20, fp);
			if (ret = !strcmp(nom, nombre))
			{
				strcpy(arch, findinfo.name);
			}
			pack_fclose(fp);
		}
	}
	al_findclose(&findinfo);

	return ret;
}

bool cargar_piezas(char *nom, t_set_piezas *piezas, BITMAP **graf_piezas)
{
	PACKFILE *fp;
	char magic[6];
	int i, j;
	char file[300];
	DATAFILE *data_graf;

	sprintf (file, "%s/%s", path_pieces.c_str(), nom);
	fp = pack_fopen(file, F_READ_PACKED);
	if (fp == NULL)
	{
		throw new ExcepcionTU("Error al cargar piezas: error al abrir archivo", -1);
	}
	pack_fread(magic, 5, fp);
	magic[5] = '\0';
	pack_fread(piezas->nombre, 20, fp);
	pack_fread(piezas->grafico, 50, fp);
	pack_fread(&(piezas->num), 1, fp);
	pack_fread(piezas->pieza, MAX_PIEZAS*16, fp);
	for (i=0; i<MAX_PIEZAS; i++)
	{
		for (j=0; j<4; j++)
		{
			pack_fread(&(piezas->pieza_rot[i][j].c), 16, fp);
		}
	}
	pack_fread(piezas->prob, MAX_PIEZAS*sizeof(short), fp);
	pack_fclose(fp);

	sprintf(file, "%s/%s", path_pieces.c_str(), piezas->grafico);
	if ((data_graf = load_datafile(file)) != NULL)
	{
		if (data_graf[0].type == DAT_ID('T', 'E', 'X', 'T') &&
			data_graf[1].type == DAT_BITMAP)
		{
			*graf_piezas = video.CrearBitmap(((BITMAP*)data_graf[1].dat)->w, ((BITMAP*)data_graf[1].dat)->h, Video::hw_blit);
			blit ((BITMAP*)data_graf[1].dat, *graf_piezas, 0, 0, 0, 0, (*graf_piezas)->w, (*graf_piezas)->h);
		}
		unload_datafile(data_graf);
		return true;
	}
	else
	{
		throw new ExcepcionTU("Error al cargar piezas: error al cargar grficos", -1);
	}
}

bool cargar_piezas(BITMAP* fondo, t_set_piezas* piezas, BITMAP **graf_piezas, char *arc)
{
	PACKFILE *fp;
	char magic[6];
	int i, n;
	char file[300];
	char nom[300];

	char elem[NUM_LISTA_ELEM][100];
	char arch[NUM_LISTA_ELEM][50];

	al_ffblk findinfo;

	sprintf(file, "%s/*.tp", path_pieces.c_str());
	i=0;
	if (al_findfirst(file, &findinfo, FA_ARCH))
	{
		string msg = TEXT_no_hay_ningun_set_piezas();
		string ok = TEXT_aceptar();
		pregunta(fondo, roman, 300, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		al_findclose(&findinfo);
		return false;
	}
	sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
	if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
	{
		pack_fread(magic, 5, fp);
		magic[5] = '\0';
		pack_fread(nom, 20, fp);
		strcpy(elem[i], nom);
		strcpy(arch[i], findinfo.name);
		i++;
		pack_fclose(fp);
	}
	while (i<NUM_LISTA_ELEM && !al_findnext(&findinfo))
	{
		sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
		if ((fp = pack_fopen(file, F_READ_PACKED)) != NULL)
		{
			pack_fread(magic, 5, fp);
			magic[5] = '\0';
			pack_fread(nom, 20, fp);
			strcpy(elem[i], nom);
			strcpy(arch[i], findinfo.name);
			i++;
			pack_fclose(fp);
		}
	}
	al_findclose(&findinfo);
	if (i==0)
	{
		string msg = TEXT_no_hay_ningun_set_piezas();
		string ok = TEXT_aceptar();
		pregunta(fondo, roman, 300, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		return false;
	}
	n = lista(fondo, 100, 260, 440, 8, book, i, elem, 0);

	if (n<0) return false;

/*	
	fp = pack_fopen(nom, F_READ_PACKED);
	if (fp == NULL)
	{
		return false;
	}
	pack_fread(magic, 5, fp);
	magic[5] = '\0';
	pack_fread(piezas->nombre, 20, fp);
	pack_fread(piezas->grafico, 50, fp);
	pack_fread(&(piezas->num), 1, fp);
	pack_fread(piezas->pieza, MAX_PIEZAS*16, fp);
	for (i=0; i<MAX_PIEZAS; i++)
	{
		for (j=0; j<4; j++)
		{
			pack_fread(&(piezas->pieza_rot[i][j].c), 16, fp);
		}
	}
	pack_fread(piezas->prob, MAX_PIEZAS*sizeof(short), fp);
	pack_fclose(fp);

	sprintf(file, "%s/%s", path_pieces, piezas->grafico);
	if ((data_graf = load_datafile(file)) != NULL)
	{
		if (data_graf[0].type == DAT_ID('T', 'E', 'X', 'T') &&
			data_graf[1].type == DAT_BITMAP)
		{
			CREATE_SPRITE(*graf_piezas ,((BITMAP*)data_graf[1].dat)->w, ((BITMAP*)data_graf[1].dat)->h);
			blit ((BITMAP*)data_graf[1].dat, *graf_piezas, 0, 0, 0, 0, (*graf_piezas)->w, (*graf_piezas)->h);
		}
		unload_datafile(data_graf);
	}
	else
	{
		pregunta(fondo, roman, 300, 2, error_abrir_archivo_graficos[idioma], file, NULL, 1, aceptar[idioma], NULL, NULL, 0, 0);
		return false;
	}

*/

	if (arc) strcpy(arc, arch[n]);
	
	return cargar_piezas(arch[n], piezas, graf_piezas);

//	return true;
}

bool selec_graficos(BITMAP *fondo)
{
	int i;
	char elem[NUM_LISTA_ELEM][100];
	char arch[NUM_LISTA_ELEM][128];
	int n;
	DATAFILE *fp;
	char file[300];
	al_ffblk findinfo;
	
	sprintf(file, "%s/*.dat", path_pieces.c_str());
	i=0;
	if (al_findfirst(file, &findinfo, FA_ARCH))
	{
		string msg = TEXT_no_hay_ningun_archivo_graficos();
		string ok = TEXT_aceptar();
		pregunta(fondo, roman, 300, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		al_findclose(&findinfo);
		return false;
	}
	sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
	if ((fp = load_datafile(file)) != NULL)
	{
		if (fp[0].type == DAT_ID('T', 'E', 'X', 'T') &&
			fp[1].type == DAT_BITMAP)
		{
			strncpy(elem[i], (char *)fp[0].dat, fp[0].size);
			elem[i][fp[0].size] = '\0';
			strcpy(arch[i], findinfo.name);
			i++;
		}
		unload_datafile(fp);
	}
	while (i<NUM_LISTA_ELEM && !al_findnext(&findinfo))
	{
		sprintf (file, "%s/%s", path_pieces.c_str(), findinfo.name);
		if ((fp = load_datafile(file)) != NULL)
		{
			if (fp[0].type == DAT_ID('T', 'E', 'X', 'T') &&
				fp[1].type == DAT_BITMAP)
			{
				strncpy(elem[i], (char *)fp[0].dat, fp[0].size);
				elem[i][fp[0].size] = '\0';
				strcpy(arch[i], findinfo.name);
				i++;
			}
			unload_datafile(fp);
		}
	}
	al_findclose(&findinfo);
	if (i==0)
	{
		string msg = TEXT_no_hay_ningun_archivo_graficos();
		string ok = TEXT_aceptar();
		pregunta(fondo, roman, 300, 1, msg.c_str(), NULL, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		return false;
	}

	n = lista(fondo, 100, 260, 440, 8, book, i, elem, 0);

	clear_keys();
	if (n>=0)
	{
		sprintf(file, "%s/%s", path_pieces.c_str(), arch[n]);
		strcpy(set_piezas[num_sets_piezas].grafico, arch[n]);
		fp = load_datafile(file);
		piezas_bmp = video.CrearBitmap(((BITMAP *)fp[1].dat)->w, ((BITMAP *)fp[1].dat)->h, Video::hw_trans_blit);
		blit ((BITMAP *)fp[1].dat, piezas_bmp, 0, 0, 0, 0, ((BITMAP *)fp[1].dat)->w, ((BITMAP *)fp[1].dat)->h);
		return true;
	}
	else
	{
		return false;
	}
}

void editor_prob(BITMAP *fondo, int x)
{
	int i, j;
	bool fin = false;
	int color;
	int sel = 0;
	int total;

	while (!fin)
	{
		BITMAP *dst = video.ObtenerPantalla();
		video.IniciarSalida();
		blit (fondo, dst, 0, 0, 0, 0, 640, 480);
		total = 0;
		for (i=0; i<set_piezas[x].num; i++)
		{
			if (i == sel) color = makecol(0, 255, 255);
			else color = makecol(255, 255, 255);
			for (j=0; j<16; j++)
			{
				if (set_piezas[x].pieza[i][j] != -1)
				{
					rectfill(dst, 100 + (j/4)*6, i*35+30+(j%4)*6, 100 + (j/4)*6+5, i*35+30+(j%4)*6+5, color);
				}
			}
			total += set_piezas[x].prob[i];
			textprintf(dst, amelia, 150, i*35+32, color, "%d", set_piezas[x].prob[i]);
			rectfill(dst, 200, i*35+40, 200+2*set_piezas[x].prob[i], i*35+45, color);
		}
		textprintf(dst, amelia, 150, 455, makecol(255, 255, 255), "%d", total);
		video.Actualizar();

		if (key[KEY_UP])
		{
			if (sel > 0) sel--;
			clear_keys();
		}
		if (key[KEY_DOWN])
		{
			if (sel < set_piezas[x].num-1) sel++;
			clear_keys();
		}
		if (key[KEY_LEFT])
		{
			if (set_piezas[x].prob[sel] > 1) set_piezas[x].prob[sel]--;
			clear_keys();
		}
		if (key[KEY_RIGHT])
		{
			if (set_piezas[x].prob[sel] < 200) set_piezas[x].prob[sel]++;
			clear_keys();
		}
		if (key[KEY_ESC])
		{
			fin = true;
			clear_keys();
		}
	}
}

void guardar(BITMAP *fondo, int x, char *arc)
{
	BITMAP *aux;
	int i, j;
	FONT *fuente = roman12;
	PACKFILE *fp;
	char nom[100];
	char filename[50];

	aux = video.CrearBitmap(640, 480, Video::hw_blit);
	acquire_bitmap(aux);
	blit (fondo, aux, 0, 0, 0, 0, 640, 480);
	rectfill (aux, 100, 280, 540, 420, 0);
	rect (aux, 100, 280, 540, 420, makecol(50, 255, 192));
	textout (aux, fuente, TEXT_nombre_set_piezas(), 120, 300, makecol(0, 255, 128));
	textout (aux, fuente, TEXT_nombre_archivo(), 120, 340, makecol(0, 255, 128));
	release_bitmap(aux);
	
	caja_texto(set_piezas[x].nombre, 16, 320, 300, fuente, makecol(0, 255, 128), aux);
	acquire_bitmap(aux);
	textout (aux, fuente, set_piezas[x].nombre, 320, 300, makecol(0, 255, 128));
	release_bitmap(aux);
	
	caja_texto(arc, 12, 320, 340, fuente, makecol(0, 255, 128), aux);
	acquire_bitmap(aux);
	textout (aux, fuente, arc, 320, 340, makecol(0, 255, 128));
	release_bitmap(aux);

	clear_keys();

	replace_extension(filename, arc, "tp", 50);

	sprintf(nom, "%s/%s", path_pieces.c_str(), filename);
	
	fp = pack_fopen(nom, F_WRITE_PACKED);
	if (fp == NULL)
	{
		string msg = TEXT_error_guardar_set_en_el_archivo();
		string ok = TEXT_aceptar();
		pregunta(fondo, roman, 300, 2, msg.c_str(), nom, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
		return;
	}
	pack_fwrite("TPZ00", 5, fp);
	pack_fwrite(set_piezas[x].nombre, 20, fp);
	pack_fwrite(set_piezas[x].grafico, 50, fp);
	pack_fwrite(&set_piezas[x].num, 1, fp);
	pack_fwrite(set_piezas[x].pieza, MAX_PIEZAS*16, fp);
	for (i=0; i<MAX_PIEZAS; i++)
	{
		for (j=0; j<4; j++)
		{
			pack_fwrite(set_piezas[x].pieza_rot[i][j].c, 16, fp);
		}
	}
	pack_fwrite(set_piezas[x].prob, MAX_PIEZAS*sizeof(short), fp);
	pack_fclose(fp);

	string msg = TEXT_se_ha_guardado_set_en_archivo();
	string ok = TEXT_aceptar();
	pregunta(fondo, roman, 250, 2, msg.c_str(), nom, NULL, 1, ok.c_str(), NULL, NULL, 0, 0);
}

void dibujar_editor(BITMAP *fondo, int posy, int sel, int rot, int sel_posx, int sel_posy, int s)
{
	int t, i, j, k, a, p, maxi;
	int x = num_sets_piezas;
	int px[4] = {84, 213, 342, 471};
	int py[3] = {90, 210, 330};

	BITMAP *dst = video.ObtenerPantalla();
	video.IniciarSalida();

	blit (fondo, dst, 0, 0, 0, 0, 640, 480);

	maxi = piezas_bmp->w/20;
	for (i=0, j=87; i<maxi; i++, j+=22)
	{
		rect(dst, j-1, 39, j+20, 60, 0);
		blit(piezas_bmp, dst, i*20, 0, j, 40, 20, 20);
	}
	rect (dst, 86+s*22, 39, 107+s*22, 60, makecol(0, 255, 255));
	for (k=posy; k<posy+3 && k<set_piezas[x].num; k++)
	{
		for (t=0; t<4; t++)
		{
			rectfill (dst, px[t], py[k-posy], px[t]+84, py[k-posy]+84, 0);
			for(i=0; i<4; i++)
			{
				for(j=0; j<4; j++)
				{
					p = set_piezas[x].pieza_rot[k][t].c[i][j];
					if ((a=set_piezas[x].pieza[k][p]) >= 0)
					{
						blit (piezas_bmp, dst, a*20, 0,
							px[t]+21*i+1, py[k-posy]+21*j+1, 20, 20);
					}
					rect (dst, px[t]+21*i, py[k-posy]+21*j,
						px[t]+21*i+21, py[k-posy]+21*j+21, 255);
				}
			}
		}
		textprintf_right (dst, amelia, 60, py[k-posy]+30, makecol(255, 255, 255), "%d", set_piezas[x].prob[k]);
	}

	if (rot == 0)
	{
		rect (dst, px[rot]+21*sel_posx, py[sel-posy]+21*sel_posy,
			px[rot]+21*sel_posx+21, py[sel-posy]+21*sel_posy+21, makecol(0, 255, 255));
	}
	else
	{
		rect (dst, px[rot]-1, py[sel-posy]-1, px[rot]+85, py[sel-posy]+85, makecol(0, 255, 255));
	}

	if (rot == 0)
	{
		for (t=1; t<4; t++)
		{
			for (i=0; i<4; i++)
			{
				for (j=0; j<4; j++)
				{
					if (set_piezas[x].pieza_rot[sel][t].c[i][j] == sel_posx*4+sel_posy)
					{
						rect (dst, px[t]+21*i, py[sel-posy]+21*j,
							px[t]+21*i+21, py[sel-posy]+21*j+21, makecol(255, 0, 255));
					}
				}
			}
		}
	}

	video.Actualizar();
}

void editor_piezas(BITMAP *fondo, char *arc)
{
	int x = num_sets_piezas;
	int sel=0, selx=0, sely=0, pos = 0, s = 0, rot = 0;
	int i, j;
	bool fin = false;
	char nombre[40];
	int maxi;
	char elem[NUM_LISTA_ELEM][100];

	strcpy(elem[0], TEXT_numero_piezas());
	strcpy(elem[1], TEXT_probabilidades());
	strcpy(elem[2], TEXT_menu_guardar());
	strcpy(elem[3], TEXT_salir());

	if (arc == NULL) strcpy(nombre, "");
	else strcpy(nombre, arc);

	maxi = piezas_bmp->w/20;

	clear_keys();

	int aux;
	while (!fin)
	{
		dibujar_editor(fondo, pos, sel, rot, selx, sely, s);
		while (!keypressed());
		if (key[KEY_UP])
		{
			if (rot == 0)
			{
				if (sely > 0) sely--;
				else
				{
					if (sel > 0)
					{
						sel--;
						sely = 3;
					}
				}
				if (sel < pos) pos = sel;
			}
			else
			{
				for (i=0; i<4; i++)
				{
					aux = set_piezas[x].pieza_rot[sel][rot].c[i][0];
					for (j=0; j<3; j++)
					{
						set_piezas[x].pieza_rot[sel][rot].c[i][j] =
							set_piezas[x].pieza_rot[sel][rot].c[i][j+1];
					}
					set_piezas[x].pieza_rot[sel][rot].c[i][3] = aux;
				}
			}
			clear_keys();
		}
		if (key[KEY_DOWN])
		{
			if (rot == 0)
			{
				if (sely < 3) sely++;
				else
				{
					if (sel+1 < set_piezas[x].num)
					{
						sel++;
						sely = 0;
					}
				}
				if (sel-2 > pos) pos = sel-2;
			}
			else
			{
				for (i=0; i<4; i++)
				{
					aux = set_piezas[x].pieza_rot[sel][rot].c[i][3];
					for (j=3; j>0; j--)
					{
						set_piezas[x].pieza_rot[sel][rot].c[i][j] =
							set_piezas[x].pieza_rot[sel][rot].c[i][j-1];
					}
					set_piezas[x].pieza_rot[sel][rot].c[i][0] = aux;
				}
			}
			clear_keys();
		}
		if (key[KEY_LEFT])
		{
			if (rot == 0)
			{
				if (selx > 0) selx--;
			}
			else
			{
				for (j=0; j<4; j++)
				{
					aux = set_piezas[x].pieza_rot[sel][rot].c[0][j];
					for (i=0; i<3; i++)
					{
						set_piezas[x].pieza_rot[sel][rot].c[i][j] =
							set_piezas[x].pieza_rot[sel][rot].c[i+1][j];
					}
					set_piezas[x].pieza_rot[sel][rot].c[3][j] = aux;
				}
			}
			clear_keys();
		}
		if (key[KEY_RIGHT])
		{
			if (rot == 0)
			{
				if (selx < 3) selx++;
			}
			else
			{
				for (j=0; j<4; j++)
				{
					aux = set_piezas[x].pieza_rot[sel][rot].c[3][j];
					for (i=3; i>0; i--)
					{
						set_piezas[x].pieza_rot[sel][rot].c[i][j] =
							set_piezas[x].pieza_rot[sel][rot].c[i-1][j];
					}
					set_piezas[x].pieza_rot[sel][rot].c[0][j] = aux;
				}
			}
			clear_keys();
		}
		if (key[KEY_Z])
		{
			if (rot == 0)
			{
				if (s>0) s--;
			}
			else
			{
				if (rot > 1) rot--;
			}
			clear_keys();
		}
		if (key[KEY_X])
		{
			if (rot == 0)
			{
				if (s<maxi-1) s++;
			}
			else
			{
				if (rot < 3) rot++;
			}
			clear_keys();
		}
		if (key[KEY_SPACE])
		{
			if (rot == 0)
			{
				if (set_piezas[x].pieza[sel][selx*4+sely] != s)
				{
					set_piezas[x].pieza[sel][selx*4+sely] = s;
				}
				else
				{
					set_piezas[x].pieza[sel][selx*4+sely] = -1;
				}
			}
			clear_keys();
		}
		if (key[KEY_ENTER])
		{
			if (rot == 0) rot = 1;
			else rot = 0;
			clear_keys();
		}
		if (key[KEY_ESC])
		{
			blit(video.ObtenerPaginaVisible(), buffer, 0, 0, 0, 0, 640, 480);
			switch (lista(buffer, 220, 200, 200, 4, roman, 4, elem, 0))
			{
			case 0:
				while (!key[KEY_ENTER])
				{
					if (key[KEY_DOWN] || key[KEY_LEFT])
					{
						if (set_piezas[x].num > 2) set_piezas[x].num--;
						clear_keys();
					}
					if (key[KEY_UP] || key[KEY_RIGHT])
					{
						if (set_piezas[x].num < MAX_PIEZAS) set_piezas[x].num++;
						clear_keys();
					}
					BITMAP *dst = video.ObtenerPantalla();
					video.IniciarSalida();
					video.CopiarFrameAnterior();
					rectfill (dst, 200, 190, 440, 250, 0);
					rect (dst, 200, 190, 440, 250, makecol(0, 127, 255));
					textprintf (dst, book, 250, 210, makecol(255, 255, 255), "%s: %d", TEXT_numero_piezas(), set_piezas[x].num);
					video.Actualizar();
				}
				if (sel >= set_piezas[x].num) sel = set_piezas[x].num - 1;
				if (sel < pos) pos = sel;

				clear_keys();
				break;
			case 1:
				editor_prob(fondo, x);
				break;
			case 2:
				guardar(fondo, x, nombre);
				break;
			case 3:
				return;
			}
			clear_keys();
		}
	}

	//Preguntar nombre del set	
}

void nuevo_set(BITMAP *fondo)
{
	int i, j, k, r;
	int x=0;

	strcpy(set_piezas[x].nombre, "");
	set_piezas[x].num = 12;
	for (i=0; i<MAX_PIEZAS; i++)
	{
		for (j=0; j<16; j++)
		{
			set_piezas[x].pieza[i][j] = -1;
		}
	}

	for (i=0; i<MAX_PIEZAS; i++)
	{
		set_piezas[x].prob[i] = 1;
	}

	int rx, ry;
	for (i=0; i<MAX_PIEZAS; i++)
	{
		for (r=0; r<4; r++)
		{
			for (j=0; j<4; j++)
			{
				for (k=0; k<4; k++)
				{
					if (r==0) rx = j, ry = k;
					else if (r==1) rx = k, ry = 3-j;
					else if (r==2) rx = 3-j, ry = 3-k;
					else rx = 3-k, ry = j;
					set_piezas[x].pieza_rot[i][r].c[j][k] = rx*4+ry;
				}
			}
		}
	}

	if (selec_graficos(fondo))
	{
		editor_piezas(fondo, NULL);
	}
}

void modificar_set(BITMAP *fondo)
{
	char arc[50];

	if (cargar_piezas(fondo, &set_piezas[0], &piezas_bmp, arc))
	{
		editor_piezas(fondo, arc);
	}
}
