//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "globals.h"
//#include "main.h"
//#include "gui.h"
//#include "gfx.h"
//#include "jugador.h"
//#include "editor.h"
#include "consola.h"
//#include "sis_part.h"
#include "Video.h"


static int fondo_seleccionado=-1;
static int fondo_directorio_seleccionado=0;
static TList* global_lista_fondos;

static string fondo_str = "";


static void ActualizarListaFondos(string &basedir)
{
	int i;
	char ext[][5] = {"bmp", "png", "tga", "pcx", "lbm", "jpg"};
	list<string> archivos;
	list<string>::const_iterator it;
	al_ffblk findinfo;

	for(i=0; i<6; i++)
	{
		string search = path_backgrounds + (basedir=="." ? "" : "/" + basedir) + "/*." + ext[i];
		if (!al_findfirst(search.c_str(), &findinfo, FA_ARCH | FA_RDONLY))
		{
			archivos.push_front(string(findinfo.name));
			while (!al_findnext(&findinfo))
			{
				archivos.push_front(string(findinfo.name));
			}
		}
		al_findclose(&findinfo);
	}

	greater<string> g;
	archivos.sort(g);
	archivos.reverse();

	global_lista_fondos->BeginMultipleItemInsertion();
	for(it=archivos.begin(); it!=archivos.end(); it++)
	{
		global_lista_fondos->AddItem(*it);
	}
	global_lista_fondos->EndMultipleItemInsertion();
}

static void OnAceptarClick(TButton *b)
{
	b->GetParent()->UpdateData(true);
	b->GetParent()->SendMessage(TMSG_CLOSE, 0, 0);
}

static void OnListaDirectoriosChange(TList *l)
{
	global_lista_fondos->Vaciar();
	ActualizarListaFondos(l->GetSelText());

	global_lista_fondos->SetSel(-1);
}

string ObtenerFondo()
{
	return fondo_str;
}

void dialogo_musica_y_fondos()
{
	al_ffblk findinfo;
	list<string> directorios;

	string search = path_backgrounds + "/*.*";
	if (!al_findfirst(search.c_str(), &findinfo, FA_DIREC | FA_RDONLY))
	{
		do
		{
			if (strcmp(findinfo.name, ".") && strcmp(findinfo.name, ".."))
			{
				directorios.push_front(string(findinfo.name));
			}
		} while (!al_findnext(&findinfo));
	}
	al_findclose(&findinfo);
	directorios.push_front(".");

	list<string>::const_iterator it;

	TDialog d(100, 60, 440, 361);
	TPanel p(100, 60, 440, 361);
	p.SetAlt(1);
	TList lista_directorios(110, 70, 205, 301, "");
	lista_directorios.SetMsgSelChange(OnListaDirectoriosChange);
	lista_directorios.SetDataVar(&fondo_directorio_seleccionado);
	TList lista_fondos(325, 70, 205, 301, "");
	lista_fondos.SetDataVar(&fondo_seleccionado);
	global_lista_fondos = &lista_fondos;
	TButton aceptar(220, 381, 200, 30, TEXT_aceptar());
	aceptar.SetMsgBtnClick(OnAceptarClick);

	lista_directorios.BeginMultipleItemInsertion();
	for(it=directorios.begin(); it!=directorios.end(); it++)
	{
		lista_directorios.AddItem(*it);
	}
	lista_directorios.EndMultipleItemInsertion();

	d.AddObject(&p);
	d.AddObject(&lista_directorios);
	d.AddObject(&lista_fondos);
	d.AddObject(&aceptar);

	ActualizarListaFondos(lista_directorios.GetItemText(fondo_directorio_seleccionado));
	d.UpdateData(false);

	d.SetBuffer(buffer);

	BITMAP* back = video.CrearBitmap(640, 480, Video::hw_blit);
	blit(video.ObtenerPaginaVisible(), back, 0, 0, 0, 0, 640, 480);
	d.ChangeDestinationBitmap(video.ObtenerPaginaVisible());
	TShowDialog(d);

	if (lista_fondos.GetSel() >= 0)
	{
		fondo_str = "";
		if (lista_directorios.GetSelText() != ".")
		{
			fondo_str = lista_directorios.GetSelText() + "/";
		}
		fondo_str += lista_fondos.GetSelText();
	}
	else
	{
		fondo_str = "";
	}

	show_mouse(NULL);
	blit(back, video.ObtenerPaginaVisible(), 0, 0, 0, 0, 640, 480);
}
