//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "Video.h"
#include "consola.h"
#include "globals.h"

t_consola *crear_consola(Video *v, const char *log)
{
	time_t fecha;
	t_consola* con;

	con = new t_consola;
	con->num_lines = 0;
	con->linea = NULL;
	con->linea_sup = NULL;
	con->ultima_linea = NULL;
	con->v = v;

	if (log)
	{
		con->fp = fopen(log, "w");
	}
	else
	{
		con->fp = NULL;
	}

	time(&fecha);
	if (con->fp)
	{
		fprintf(con->fp, "Log creado el %s\n", ctime(&fecha));
		fflush(con->fp);
	}

	con->visible = false;

	return con;
}

void destruir_consola(t_consola *con)
{
	if (con->fp) fclose(con->fp);
}

void con_nueva_linea(t_consola *con, int color)
{
	int i;
	t_nodo_consola *aux;

	if (con->fp)
	{
		fputs("\n", con->fp);
	}

	if (con->ultima_linea)
	{
		con->ultima_linea->next_line = new t_nodo_consola;
		con->ultima_linea = con->ultima_linea->next_line;
	}
	else
	{
		con->ultima_linea = con->linea_sup = con->linea = new t_nodo_consola;
	}

	con->ultima_linea->line = new char[SCREEN_W/text_length(font, "a")+2];
	con->ultima_linea->color = color;
	strcpy(con->ultima_linea->line, "");
	con->ultima_linea->next_line = NULL;

	i=1;
	aux = con->linea_sup;
	while (aux)
	{
		if (i > con->num_lines)
		{
			con->linea_sup = con->linea_sup->next_line;
			i--;
		}
		aux = aux->next_line;
		i++;
	}
}

void con_escribir(t_consola *con, const char *text)
{
	strcat(con->ultima_linea->line, text);
	if (con->fp)
	{
		fputs(text, con->fp);
		fflush(con->fp);
	}
}

void con_escribir_fn(t_consola *con, const char *text, const int color)
{
	strcat(con->ultima_linea->line, text);
	if (con->fp) fputs(text, con->fp);
	con_nueva_linea(con, color);

	if (con->fp) fflush(con->fp);
}

void con_escribir(t_consola *con, const int num)
{
	char text[50];

	sprintf(text, "%d", num);

	strcat(con->ultima_linea->line, text);

	if (con->fp)
	{
		fputs(text, con->fp);
		fflush(con->fp);
	}
}

void con_escribir_fn(t_consola *con, const int num, const int color)
{
	char text[50];

	sprintf(text, "%d", num);
	if (con->fp) fputs(text, con->fp);

	strcat(con->ultima_linea->line, text);
	con_nueva_linea(con, color);

	if (con->fp) fflush(con->fp);
}

void dibujar_consola(t_consola *con)
{
	if (!con->visible) return;

	t_nodo_consola *aux;

	aux = con->linea_sup;

	con->v->IniciarSalida();
	BITMAP *buffer = con->v->ObtenerPantalla();
	rectfill(buffer, 0, 0, SCREEN_W, con->num_lines*text_height(font), makecol(32, 32, 32));

	int i=0;
	while (aux)
	{
		textout(buffer, font, aux->line, 0, i, aux->color);
		aux = aux->next_line;
		i+=text_height(font);
	}
	con->v->FinalizarSalida();
}
