//--------------------------------------------------------------------------
//
//  Tetris Unlimited
//  Copyright (C) 2001-2003  Oscar Giner Martnez
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//--------------------------------------------------------------------------


#include "stdafx.h"

#include "defines.h"
#include "sis_part.h"
#include "main.h"
#include "globals.h"

void dibujar_joy_ctrl(BITMAP *buffer, struct controles *ctrl[], int pl, int sel, int col, int colsel)
{
	switch (ctrl[pl]->joy_izq.type)
	{
	case -1:
		textout (buffer, roman, "( - )", 310, 290, sel==1 ? colsel:col);
		break;
	case 0:
		textprintf (buffer, roman,  310, 290, sel==1 ? colsel:col,
			"JOY%d Stick%d A%d D%d",
			ctrl[pl]->joy_izq.joy+1,
			ctrl[pl]->joy_izq.stick+1,
			ctrl[pl]->joy_izq.axis+1,
			ctrl[pl]->joy_izq.dir);
		break;
	case 1:
		textprintf (buffer, roman,  310, 290, sel==1 ? colsel:col,
			"JOY%d BUTTON%d",
			ctrl[pl]->joy_izq.joy+1,
			ctrl[pl]->joy_izq.boton+1);
		break;
	}
	switch (ctrl[pl]->joy_der.type)
	{
	case -1:
		textout (buffer, roman, "( - )", 310, 320, sel==2 ? colsel:col);
		break;
	case 0:
		textprintf (buffer, roman,  310, 320, sel==2 ? colsel:col,
			"JOY%d Stick%d A%d D%d",
			ctrl[pl]->joy_der.joy+1,
			ctrl[pl]->joy_der.stick+1,
			ctrl[pl]->joy_der.axis+1,
			ctrl[pl]->joy_der.dir);
		break;
	case 1:
		textprintf (buffer, roman,  310, 320, sel==2 ? colsel:col,
			"JOY%d BUTTON%d",
			ctrl[pl]->joy_der.joy+1,
			ctrl[pl]->joy_der.boton+1);
		break;
	}
	switch (ctrl[pl]->joy_rotar_izq.type)
	{
	case -1:
		textout (buffer, roman, "( - )", 310, 350, sel==3 ? colsel:col);
		break;
	case 0:
		textprintf (buffer, roman,  310, 350, sel==3 ? colsel:col,
			"JOY%d Stick%d A%d D%d",
			ctrl[pl]->joy_rotar_izq.joy+1,
			ctrl[pl]->joy_rotar_izq.stick+1,
			ctrl[pl]->joy_rotar_izq.axis+1,
			ctrl[pl]->joy_rotar_izq.dir);
		break;
	case 1:
		textprintf (buffer, roman,  310, 350, sel==3 ? colsel:col,
			"JOY%d BUTTON%d",
			ctrl[pl]->joy_rotar_izq.joy+1,
			ctrl[pl]->joy_rotar_izq.boton+1);
		break;
	}
	switch (ctrl[pl]->joy_rotar_der.type)
	{
	case -1:
		textout (buffer, roman, "( - )", 310, 380, sel==4 ? colsel:col);
		break;
	case 0:
		textprintf (buffer, roman,  310, 380, sel==4 ? colsel:col,
			"JOY%d Stick%d A%d D%d",
			ctrl[pl]->joy_rotar_der.joy+1,
			ctrl[pl]->joy_rotar_der.stick+1,
			ctrl[pl]->joy_rotar_der.axis+1,
			ctrl[pl]->joy_rotar_der.dir);
		break;
	case 1:
		textprintf (buffer, roman,  310, 380, sel==4 ? colsel:col,
			"JOY%d BUTTON%d",
			ctrl[pl]->joy_rotar_der.joy+1,
			ctrl[pl]->joy_rotar_der.boton+1);
		break;
	}
	switch (ctrl[pl]->joy_abajo.type)
	{
	case -1:
		textout (buffer, roman, "( - )", 310, 410, sel==5 ? colsel:col);
		break;
	case 0:
		textprintf (buffer, roman,  310, 410, sel==5 ? colsel:col,
			"JOY%d Stick%d A%d D%d",
			ctrl[pl]->joy_abajo.joy+1,
			ctrl[pl]->joy_abajo.stick+1,
			ctrl[pl]->joy_abajo.axis+1,
			ctrl[pl]->joy_abajo.dir);
		break;
	case 1:
		textprintf (buffer, roman,  310, 410, sel==5 ? colsel:col,
			"JOY%d BUTTON%d",
			ctrl[pl]->joy_abajo.joy+1,
			ctrl[pl]->joy_abajo.boton+1);
		break;
	}
}

void escribir_scancode(BITMAP *buffer, FONT *font, unsigned scancode, int x, int y, int col)
{
	char buf[10];

	if (scancode <= 0x7f)
	{
		textout (buffer, roman, ALTEXT_Text(99+scancode), x, y, col);
	}
	else
	{
		sprintf (buf, "??? 0x%x", scancode);
		textout (buffer, roman, buf, x, y, col);
	}
}

void config_controles(BITMAP *cuadro, int pl)
{
	int i=0, j=0, k=0, b=0;
	bool kp = false;
	int sel = 0;
	int col = makecol(255, 255, 255);
	int colsel = makecol(255, 255, 0);
	struct controles *ctrl[4] = {&control_p1, &control_p2, &control_p3, &control_p4};

	pl--;
	clear_keys();
	while (!key[KEY_ESC])
	{
		BITMAP *dst = video.ObtenerPantalla();
		video.IniciarSalida();
		video.CopiarFrameAnterior();
		blit (cuadro, dst, 0, 0, 140, 230, 360, 225);
		textout (dst, roman, TEXT_controles(), 170, 250, sel==0 ? colsel : col);
		textout (dst, roman, ctrl[pl]->tipo ? TEXT_ctrl_joystick_pad(): TEXT_ctrl_teclado(), 310, 250, sel==0 ? colsel:col);
		textout (dst, roman, TEXT_ctrl_izquierda(), 170, 290, sel==1 ? colsel : col);
		textout (dst, roman, TEXT_ctrl_derecha(), 170, 320, sel==2 ? colsel : col);
		textout (dst, roman, TEXT_ctrl_rotar_pieza_izq(), 170, 350, sel==3 ? colsel : col);
		textout (dst, roman, TEXT_ctrl_rotar_pieza_der(), 170, 380, sel==4 ? colsel : col);
		textout (dst, roman, TEXT_ctrl_abajo(), 170, 410, sel==5 ? colsel : col);
		if (ctrl[pl]->tipo)
		{
			int dir = 0;
			char type = 0;

			dibujar_joy_ctrl(dst, ctrl, pl, sel, col, colsel);

			if (key[KEY_ENTER] && sel > 0)
			{
				rectfill (dst, 305, 260+sel*30, 480, 280+sel*30, makecol(128, 64, 255));
				dibujar_joy_ctrl(dst, ctrl, pl, sel, col, colsel);
				video.Actualizar();
				clear_keys();
				while (!kp && !key[KEY_ESC])
				{
					poll_joystick();
					i=0;
					while (i<num_joysticks && !kp)
					{
						j=0;
						while (j<joy[i].num_sticks && !kp)
						{
							k=0;
							while (k<joy[i].stick[j].num_axis && !kp)
							{
								if (joy[i].stick[j].axis[k].d1)
								{
									type = 's';
									dir = 1;
									kp = true;
								}
								if (joy[i].stick[j].axis[k].d2)
								{
									type = 's';
									dir = 2;
									kp = true;
								}
								k++;
							}
							j++;
						}
						b=0;
						while (b<joy[i].num_buttons && !kp)
						{
							if (joy[i].button[b].b)
							{
								type = 'b';
								kp = true;
							}
							b++;
						}
						i++;
					}
				}

				if (!kp)
				{
					i=1;
					b=1;
					j=1;
					k=1;
					dir=1;
				}

				switch (sel)
				{
				case 1:
					ctrl[pl]->joy_izq.joy = i-1;
					if (kp)
						ctrl[pl]->joy_izq.type = type=='s' ? 0:1;
					else
						ctrl[pl]->joy_izq.type = -1;
					ctrl[pl]->joy_izq.boton = b-1;
					ctrl[pl]->joy_izq.stick = j-1;
					ctrl[pl]->joy_izq.axis = k-1;
					ctrl[pl]->joy_izq.dir = dir;
					break;
				case 2:
					ctrl[pl]->joy_der.joy = i-1;
					if (kp)
						ctrl[pl]->joy_der.type = type=='s' ? 0:1;
					else
						ctrl[pl]->joy_der.type = -1;
					ctrl[pl]->joy_der.boton = b-1;
					ctrl[pl]->joy_der.stick = j-1;
					ctrl[pl]->joy_der.axis = k-1;
					ctrl[pl]->joy_der.dir = dir;
					break;
				case 3:
					ctrl[pl]->joy_rotar_izq.joy = i-1;
					if (kp)
						ctrl[pl]->joy_rotar_izq.type = type=='s' ? 0:1;
					else
						ctrl[pl]->joy_rotar_izq.type = -1;
					ctrl[pl]->joy_rotar_izq.boton = b-1;
					ctrl[pl]->joy_rotar_izq.stick = j-1;
					ctrl[pl]->joy_rotar_izq.axis = k-1;
					ctrl[pl]->joy_rotar_izq.dir = dir;
					break;
				case 4:
					ctrl[pl]->joy_rotar_der.joy = i-1;
					if (kp)
						ctrl[pl]->joy_rotar_der.type = type=='s' ? 0:1;
					else
						ctrl[pl]->joy_rotar_der.type = -1;
					ctrl[pl]->joy_rotar_der.boton = b-1;
					ctrl[pl]->joy_rotar_der.stick = j-1;
					ctrl[pl]->joy_rotar_der.axis = k-1;
					ctrl[pl]->joy_rotar_der.dir = dir;
					break;
				case 5:
					ctrl[pl]->joy_abajo.joy = i-1;
					if (kp)
						ctrl[pl]->joy_abajo.type = type=='s' ? 0:1;
					else
						ctrl[pl]->joy_abajo.type = -1;
					ctrl[pl]->joy_abajo.boton = b-1;
					ctrl[pl]->joy_abajo.stick = j-1;
					ctrl[pl]->joy_abajo.axis = k-1;
					ctrl[pl]->joy_abajo.dir = dir;
					break;
				}
				kp = false;
				clear_keys();
			}
		}
		else
		{
			escribir_scancode (dst, roman, ctrl[pl]->key_izq, 310, 290, sel==1 ? colsel:col);
			escribir_scancode (dst, roman, ctrl[pl]->key_der, 310, 320, sel==2 ? colsel:col);
			escribir_scancode (dst, roman, ctrl[pl]->key_rotar_izq, 310, 350, sel==3 ? colsel:col);
			escribir_scancode (dst, roman, ctrl[pl]->key_rotar_der, 310, 380, sel==4 ? colsel:col);
			escribir_scancode (dst, roman, ctrl[pl]->key_abajo, 310, 410, sel==5 ? colsel:col);
			if (key[KEY_ENTER] && sel > 0)
			{
				rectfill (dst, 305, 260+sel*30, 460, 280+sel*30, makecol(128, 64, 255));
				escribir_scancode (dst, roman, ctrl[pl]->key_izq, 310, 290, sel==1 ? colsel:col);
				escribir_scancode (dst, roman, ctrl[pl]->key_der, 310, 320, sel==2 ? colsel:col);
				escribir_scancode (dst, roman, ctrl[pl]->key_rotar_izq, 310, 350, sel==3 ? colsel:col);
				escribir_scancode (dst, roman, ctrl[pl]->key_rotar_der, 310, 380, sel==4 ? colsel:col);
				escribir_scancode (dst, roman, ctrl[pl]->key_abajo, 310, 410, sel==5 ? colsel:col);
				video.Actualizar();
				clear_keys();
				while (!kp)
				{
					for (i=1; i<128; i++)
					{
						if (key[i])
						{
							kp = true;
							if (i==KEY_ESC)
							{
								switch(sel)
								{
								case 1: ctrl[pl]->key_izq = 0; break;
								case 2: ctrl[pl]->key_der = 0; break;
								case 3: ctrl[pl]->key_rotar_izq = 0; break;
								case 4: ctrl[pl]->key_rotar_der = 0; break;
								case 5: ctrl[pl]->key_abajo = 0; break;
								}
							}
							else
							{
								switch(sel)
								{
								case 1: ctrl[pl]->key_izq = i; break;
								case 2: ctrl[pl]->key_der = i; break;
								case 3: ctrl[pl]->key_rotar_izq = i; break;
								case 4: ctrl[pl]->key_rotar_der = i; break;
								case 5: ctrl[pl]->key_abajo = i; break;
								}
							}
						}
					}
				}
				kp = false;
				clear_keys();
			}
		}
		if (key[KEY_DOWN])
		{
			sel++;
			if (sel > 5) sel = 5;
			clear_keys();
		}
		if (key[KEY_UP])
		{
			sel--;
			if (sel < 0) sel = 0;
			clear_keys();
		}
		if (key[KEY_ENTER] && sel==0)
		{
			if (num_joysticks > 0 && ctrl[pl]->tipo==0) ctrl[pl]->tipo = 1;
			else ctrl[pl]->tipo = 0;
			clear_keys();
		}
		video.Actualizar();
	}
	clear_keys();
}

void cargar_configuracion(void)
{
	coldepth = get_config_int ("graphics", "bpp", -1);
	fullscreen = get_config_int ("graphics", "fullscreen", -1);
	res_x = get_config_int ("graphics", "width", 640);
	res_y = get_config_int ("graphics", "height", 480);
	refresh_mode = get_config_int ("graphics", "refresh_mode", 0);
	disable_hw_accel = get_config_int ("graphics", "disable_hw_acceleration", 0);
//	idioma = get_config_int ("options", "lang", -1);
	volfx =  get_config_int ("sound", "digi_volume", 255);
	volmus = get_config_int ("sound", "midi_volume", 255);
	digi_driver_id = get_config_int ("sound", "digi_card", 0);
	part_qual = get_config_int("graphics", "particle_quality", 3);

	path_music			= get_config_string("paths", "music", "./musica");
	path_pieces			= get_config_string("paths", "pieces", "./piezas");
	path_players		= get_config_string("paths", "players", "./jugadores");
	path_data			= get_config_string("paths", "data", "./data");
	path_text			= get_config_string("paths", "text", "./text");
	path_backgrounds	= get_config_string("paths", "backgrounds", "./fondos");

	control_p1.tipo = get_config_int ("player_1", "type", 0);
	control_p1.key_abajo     = get_config_int ("player_1", "key_down", 0);
	control_p1.key_rotar_der = get_config_int ("player_1", "key_turn_right", 0);
	control_p1.key_rotar_izq = get_config_int ("player_1", "key_turn_left", 0);
	control_p1.key_der       = get_config_int ("player_1", "key_left", 0);
	control_p1.key_izq       = get_config_int ("player_1", "key_right", 0);
	control_p1.joy_abajo.joy =   get_config_int ("player_1", "joy_down_joy", 0);
	control_p1.joy_abajo.type =  get_config_int ("player_1", "joy_down_type", -1);
	control_p1.joy_abajo.boton = get_config_int ("player_1", "joy_down_button", 0);
	control_p1.joy_abajo.stick = get_config_int ("player_1", "joy_down_stick", 0);
	control_p1.joy_abajo.axis =  get_config_int ("player_1", "joy_down_axis", 0);
	control_p1.joy_abajo.dir =   get_config_int ("player_1", "joy_down_dir", 0);
	control_p1.joy_rotar_der.joy =   get_config_int ("player_1", "joy_turn_right_joy", 0);
	control_p1.joy_rotar_der.type =  get_config_int ("player_1", "joy_turn_right_type", -1);
	control_p1.joy_rotar_der.boton = get_config_int ("player_1", "joy_turn_right_button", 0);
	control_p1.joy_rotar_der.stick = get_config_int ("player_1", "joy_turn_right_stick", 0);
	control_p1.joy_rotar_der.axis =  get_config_int ("player_1", "joy_turn_right_axis", 0);
	control_p1.joy_rotar_der.dir =   get_config_int ("player_1", "joy_turn_right_dir", 0);
	control_p1.joy_rotar_izq.joy =   get_config_int ("player_1", "joy_turn_left_joy", 0);
	control_p1.joy_rotar_izq.type =  get_config_int ("player_1", "joy_turn_left_type", -1);
	control_p1.joy_rotar_izq.boton = get_config_int ("player_1", "joy_turn_left_button", 0);
	control_p1.joy_rotar_izq.stick = get_config_int ("player_1", "joy_turn_left_stick", 0);
	control_p1.joy_rotar_izq.axis =  get_config_int ("player_1", "joy_turn_left_axis", 0);
	control_p1.joy_rotar_der.dir =   get_config_int ("player_1", "joy_turn_left_dir", 0);
	control_p1.joy_izq.joy =     get_config_int ("player_1", "joy_left_joy", 0);
	control_p1.joy_izq.type =    get_config_int ("player_1", "joy_left_type", -1);
	control_p1.joy_izq.boton =   get_config_int ("player_1", "joy_left_button", 0);
	control_p1.joy_izq.stick =   get_config_int ("player_1", "joy_left_stick", 0);
	control_p1.joy_izq.axis =    get_config_int ("player_1", "joy_left_axis", 0);
	control_p1.joy_izq.dir =     get_config_int ("player_1", "joy_left_dir", 0);
	control_p1.joy_der.joy =     get_config_int ("player_1", "joy_right_joy", 0);
	control_p1.joy_der.type =    get_config_int ("player_1", "joy_right_type", -1);
	control_p1.joy_der.boton =   get_config_int ("player_1", "joy_right_button", 0);
	control_p1.joy_der.stick =   get_config_int ("player_1", "joy_right_stick", 0);
	control_p1.joy_der.axis =    get_config_int ("player_1", "joy_right_axis", 0);
	control_p1.joy_der.dir =     get_config_int ("player_1", "joy_right_dir", 0);

	control_p2.tipo = get_config_int ("player_2", "type", 0);
	control_p2.key_abajo = get_config_int ("player_2", "key_down", 0);
	control_p2.key_rotar_der = get_config_int ("player_2", "key_turn_right", 0);
	control_p2.key_rotar_izq = get_config_int ("player_2", "key_turn_left", 0);
	control_p2.key_der   = get_config_int ("player_2", "key_left", 0);
	control_p2.key_izq   = get_config_int ("player_2", "key_right", 0);
	control_p2.joy_abajo.joy =   get_config_int ("player_2", "joy_down_joy", 0);
	control_p2.joy_abajo.type =  get_config_int ("player_2", "joy_down_type", -1);
	control_p2.joy_abajo.boton = get_config_int ("player_2", "joy_down_button", 0);
	control_p2.joy_abajo.stick = get_config_int ("player_2", "joy_down_stick", 0);
	control_p2.joy_abajo.axis =  get_config_int ("player_2", "joy_down_axis", 0);
	control_p2.joy_abajo.dir =   get_config_int ("player_2", "joy_down_dir", 0);
	control_p2.joy_rotar_der.joy =   get_config_int ("player_2", "joy_turn_right_joy", 0);
	control_p2.joy_rotar_der.type =  get_config_int ("player_2", "joy_turn_right_type", -1);
	control_p2.joy_rotar_der.boton = get_config_int ("player_2", "joy_turn_right_button", 0);
	control_p2.joy_rotar_der.stick = get_config_int ("player_2", "joy_turn_right_stick", 0);
	control_p2.joy_rotar_der.axis =  get_config_int ("player_2", "joy_turn_right_axis", 0);
	control_p2.joy_rotar_der.dir =   get_config_int ("player_2", "joy_turn_right_dir", 0);
	control_p2.joy_rotar_izq.joy =   get_config_int ("player_2", "joy_turn_left_joy", 0);
	control_p2.joy_rotar_izq.type =  get_config_int ("player_2", "joy_turn_left_type", -1);
	control_p2.joy_rotar_izq.boton = get_config_int ("player_2", "joy_turn_left_button", 0);
	control_p2.joy_rotar_izq.stick = get_config_int ("player_2", "joy_turn_left_stick", 0);
	control_p2.joy_rotar_izq.axis =  get_config_int ("player_2", "joy_turn_left_axis", 0);
	control_p2.joy_rotar_der.dir =   get_config_int ("player_2", "joy_turn_left_dir", 0);
	control_p2.joy_izq.joy =     get_config_int ("player_2", "joy_left_joy", 0);
	control_p2.joy_izq.type =    get_config_int ("player_2", "joy_left_type", -1);
	control_p2.joy_izq.boton =   get_config_int ("player_2", "joy_left_button", 0);
	control_p2.joy_izq.stick =   get_config_int ("player_2", "joy_left_stick", 0);
	control_p2.joy_izq.axis =    get_config_int ("player_2", "joy_left_axis", 0);
	control_p2.joy_izq.dir =     get_config_int ("player_2", "joy_left_dir", 0);
	control_p2.joy_der.joy =     get_config_int ("player_2", "joy_right_joy", 0);
	control_p2.joy_der.type =    get_config_int ("player_2", "joy_right_type", -1);
	control_p2.joy_der.boton =   get_config_int ("player_2", "joy_right_button", 0);
	control_p2.joy_der.stick =   get_config_int ("player_2", "joy_right_stick", 0);
	control_p2.joy_der.axis =    get_config_int ("player_2", "joy_right_axis", 0);
	control_p2.joy_der.dir =     get_config_int ("player_2", "joy_right_dir", 0);

	control_p3.tipo = get_config_int ("player_3", "type", 0);
	control_p3.key_abajo = get_config_int ("player_3", "key_down", 0);
	control_p3.key_rotar_der = get_config_int ("player_3", "key_turn_right", 0);
	control_p3.key_rotar_izq = get_config_int ("player_3", "key_turn_left", 0);
	control_p3.key_der   = get_config_int ("player_3", "key_left", 0);
	control_p3.key_izq   = get_config_int ("player_3", "key_right", 0);
	control_p3.joy_abajo.joy =   get_config_int ("player_3", "joy_down_joy", 0);
	control_p3.joy_abajo.type =  get_config_int ("player_3", "joy_down_type", -1);
	control_p3.joy_abajo.boton = get_config_int ("player_3", "joy_down_button", 0);
	control_p3.joy_abajo.stick = get_config_int ("player_3", "joy_down_stick", 0);
	control_p3.joy_abajo.axis =  get_config_int ("player_3", "joy_down_axis", 0);
	control_p3.joy_abajo.dir =   get_config_int ("player_3", "joy_down_dir", 0);
	control_p3.joy_rotar_der.joy =   get_config_int ("player_3", "joy_turn_right_joy", 0);
	control_p3.joy_rotar_der.type =  get_config_int ("player_3", "joy_turn_right_type", -1);
	control_p3.joy_rotar_der.boton = get_config_int ("player_3", "joy_turn_right_button", 0);
	control_p3.joy_rotar_der.stick = get_config_int ("player_3", "joy_turn_right_stick", 0);
	control_p3.joy_rotar_der.axis =  get_config_int ("player_3", "joy_turn_right_axis", 0);
	control_p3.joy_rotar_der.dir =   get_config_int ("player_3", "joy_turn_right_dir", 0);
	control_p3.joy_rotar_izq.joy =   get_config_int ("player_3", "joy_turn_left_joy", 0);
	control_p3.joy_rotar_izq.type =  get_config_int ("player_3", "joy_turn_left_type", -1);
	control_p3.joy_rotar_izq.boton = get_config_int ("player_3", "joy_turn_left_button", 0);
	control_p3.joy_rotar_izq.stick = get_config_int ("player_3", "joy_turn_left_stick", 0);
	control_p3.joy_rotar_izq.axis =  get_config_int ("player_3", "joy_turn_left_axis", 0);
	control_p3.joy_rotar_der.dir =   get_config_int ("player_3", "joy_turn_left_dir", 0);
	control_p3.joy_izq.joy =     get_config_int ("player_3", "joy_left_joy", 0);
	control_p3.joy_izq.type =    get_config_int ("player_3", "joy_left_type", -1);
	control_p3.joy_izq.boton =   get_config_int ("player_3", "joy_left_button", 0);
	control_p3.joy_izq.stick =   get_config_int ("player_3", "joy_left_stick", 0);
	control_p3.joy_izq.axis =    get_config_int ("player_3", "joy_left_axis", 0);
	control_p3.joy_izq.dir =     get_config_int ("player_3", "joy_left_dir", 0);
	control_p3.joy_der.joy =     get_config_int ("player_3", "joy_right_joy", 0);
	control_p3.joy_der.type =    get_config_int ("player_3", "joy_right_type", -1);
	control_p3.joy_der.boton =   get_config_int ("player_3", "joy_right_button", 0);
	control_p3.joy_der.stick =   get_config_int ("player_3", "joy_right_stick", 0);
	control_p3.joy_der.axis =    get_config_int ("player_3", "joy_right_axis", 0);
	control_p3.joy_der.dir =     get_config_int ("player_3", "joy_right_dir", 0);

	control_p4.tipo = get_config_int ("player_4", "type", 0);
	control_p4.key_abajo = get_config_int ("player_4", "key_down", 0);
	control_p4.key_rotar_der = get_config_int ("player_4", "key_turn_right", 0);
	control_p4.key_rotar_izq = get_config_int ("player_4", "key_turn_left", 0);
	control_p4.key_der   = get_config_int ("player_4", "key_left", 0);
	control_p4.key_izq   = get_config_int ("player_4", "key_right", 0);
	control_p4.joy_abajo.joy =   get_config_int ("player_4", "joy_down_joy", 0);
	control_p4.joy_abajo.type =  get_config_int ("player_4", "joy_down_type", -1);
	control_p4.joy_abajo.boton = get_config_int ("player_4", "joy_down_button", 0);
	control_p4.joy_abajo.stick = get_config_int ("player_4", "joy_down_stick", 0);
	control_p4.joy_abajo.axis =  get_config_int ("player_4", "joy_down_axis", 0);
	control_p4.joy_abajo.dir =   get_config_int ("player_4", "joy_down_dir", 0);
	control_p4.joy_rotar_der.joy =   get_config_int ("player_4", "joy_turn_right_joy", 0);
	control_p4.joy_rotar_der.type =  get_config_int ("player_4", "joy_turn_right_type", -1);
	control_p4.joy_rotar_der.boton = get_config_int ("player_4", "joy_turn_right_button", 0);
	control_p4.joy_rotar_der.stick = get_config_int ("player_4", "joy_turn_right_stick", 0);
	control_p4.joy_rotar_der.axis =  get_config_int ("player_4", "joy_turn_right_axis", 0);
	control_p4.joy_rotar_der.dir =   get_config_int ("player_4", "joy_turn_right_dir", 0);
	control_p4.joy_rotar_izq.joy =   get_config_int ("player_4", "joy_turn_left_joy", 0);
	control_p4.joy_rotar_izq.type =  get_config_int ("player_4", "joy_turn_left_type", -1);
	control_p4.joy_rotar_izq.boton = get_config_int ("player_4", "joy_turn_left_button", 0);
	control_p4.joy_rotar_izq.stick = get_config_int ("player_4", "joy_turn_left_stick", 0);
	control_p4.joy_rotar_izq.axis =  get_config_int ("player_4", "joy_turn_left_axis", 0);
	control_p4.joy_rotar_der.dir =   get_config_int ("player_4", "joy_turn_left_dir", 0);
	control_p4.joy_izq.joy =     get_config_int ("player_4", "joy_left_joy", 0);
	control_p4.joy_izq.type =    get_config_int ("player_4", "joy_left_type", -1);
	control_p4.joy_izq.boton =   get_config_int ("player_4", "joy_left_button", 0);
	control_p4.joy_izq.stick =   get_config_int ("player_4", "joy_left_stick", 0);
	control_p4.joy_izq.axis =    get_config_int ("player_4", "joy_left_axis", 0);
	control_p4.joy_izq.dir =     get_config_int ("player_4", "joy_left_dir", 0);
	control_p4.joy_der.joy =     get_config_int ("player_4", "joy_right_joy", 0);
	control_p4.joy_der.type =    get_config_int ("player_4", "joy_right_type", -1);
	control_p4.joy_der.boton =   get_config_int ("player_4", "joy_right_button", 0);
	control_p4.joy_der.stick =   get_config_int ("player_4", "joy_right_stick", 0);
	control_p4.joy_der.axis =    get_config_int ("player_4", "joy_right_axis", 0);
	control_p4.joy_der.dir =     get_config_int ("player_4", "joy_right_dir", 0);
}

void guardar_configuracion(void)
{
//	set_config_int ("options", "lang",        idioma);
	set_config_int ("sound",   "digi_volume", volfx);
	set_config_int ("sound",   "midi_volume", volmus);

	set_config_int("graphics", "particle_quality", part_qual);

	set_config_string ("paths", "music",		path_music.c_str());
	set_config_string ("paths", "pieces",		path_pieces.c_str());
	set_config_string ("paths", "players",		path_players.c_str());
	set_config_string ("paths", "data",			path_data.c_str());
	set_config_string ("paths", "text",			path_text.c_str());
	set_config_string ("paths", "backgrounds",	path_backgrounds.c_str());

	set_config_int ("player_1", "type",      control_p1.tipo);
	set_config_int ("player_1", "key_down",  control_p1.key_abajo);
	set_config_int ("player_1", "key_turn_right",  control_p1.key_rotar_izq);
	set_config_int ("player_1", "key_turn_left",  control_p1.key_rotar_der);
	set_config_int ("player_1", "key_left",  control_p1.key_der);
	set_config_int ("player_1", "key_right", control_p1.key_izq);
	set_config_int ("player_1", "joy_down_joy",     control_p1.joy_abajo.joy);
	set_config_int ("player_1", "joy_down_type",    control_p1.joy_abajo.type);
	set_config_int ("player_1", "joy_down_button",  control_p1.joy_abajo.boton);
	set_config_int ("player_1", "joy_down_stick",   control_p1.joy_abajo.stick);
	set_config_int ("player_1", "joy_down_axis",    control_p1.joy_abajo.axis);
	set_config_int ("player_1", "joy_down_dir",     control_p1.joy_abajo.dir);
	set_config_int ("player_1", "joy_turn_left_joy",     control_p1.joy_rotar_izq.joy);
	set_config_int ("player_1", "joy_turn_left_type",    control_p1.joy_rotar_izq.type);
	set_config_int ("player_1", "joy_turn_left_button",  control_p1.joy_rotar_izq.boton);
	set_config_int ("player_1", "joy_turn_left_stick",   control_p1.joy_rotar_izq.stick);
	set_config_int ("player_1", "joy_turn_left_axis",    control_p1.joy_rotar_izq.axis);
	set_config_int ("player_1", "joy_turn_left_dir",     control_p1.joy_rotar_izq.dir);
	set_config_int ("player_1", "joy_turn_right_joy",     control_p1.joy_rotar_der.joy);
	set_config_int ("player_1", "joy_turn_right_type",    control_p1.joy_rotar_der.type);
	set_config_int ("player_1", "joy_turn_right_button",  control_p1.joy_rotar_der.boton);
	set_config_int ("player_1", "joy_turn_right_stick",   control_p1.joy_rotar_der.stick);
	set_config_int ("player_1", "joy_turn_right_axis",    control_p1.joy_rotar_der.axis);
	set_config_int ("player_1", "joy_turn_right_dir",     control_p1.joy_rotar_der.dir);
	set_config_int ("player_1", "joy_left_joy",     control_p1.joy_izq.joy);
	set_config_int ("player_1", "joy_left_type",    control_p1.joy_izq.type);
	set_config_int ("player_1", "joy_left_button",  control_p1.joy_izq.boton);
	set_config_int ("player_1", "joy_left_stick",   control_p1.joy_izq.stick);
	set_config_int ("player_1", "joy_left_axis",    control_p1.joy_izq.axis);
	set_config_int ("player_1", "joy_left_dir",     control_p1.joy_izq.dir);
	set_config_int ("player_1", "joy_right_joy",    control_p1.joy_der.joy);
	set_config_int ("player_1", "joy_right_type",   control_p1.joy_der.type);
	set_config_int ("player_1", "joy_right_button", control_p1.joy_der.boton);
	set_config_int ("player_1", "joy_right_stick",  control_p1.joy_der.stick);
	set_config_int ("player_1", "joy_right_axis",   control_p1.joy_der.axis);
	set_config_int ("player_1", "joy_right_dir",    control_p1.joy_der.dir);

	set_config_int ("player_2", "type",      control_p2.tipo);
	set_config_int ("player_2", "key_down",  control_p2.key_abajo);
	set_config_int ("player_2", "key_turn_right",  control_p2.key_rotar_izq);
	set_config_int ("player_2", "key_turn_left",  control_p2.key_rotar_der);
	set_config_int ("player_2", "key_left",  control_p2.key_der);
	set_config_int ("player_2", "key_right", control_p2.key_izq);
	set_config_int ("player_2", "joy_down_joy",     control_p2.joy_abajo.joy);
	set_config_int ("player_2", "joy_down_type",    control_p2.joy_abajo.type);
	set_config_int ("player_2", "joy_down_button",  control_p2.joy_abajo.boton);
	set_config_int ("player_2", "joy_down_stick",   control_p2.joy_abajo.stick);
	set_config_int ("player_2", "joy_down_axis",    control_p2.joy_abajo.axis);
	set_config_int ("player_2", "joy_down_dir",     control_p2.joy_abajo.dir);
	set_config_int ("player_2", "joy_turn_left_joy",     control_p2.joy_rotar_izq.joy);
	set_config_int ("player_2", "joy_turn_left_type",    control_p2.joy_rotar_izq.type);
	set_config_int ("player_2", "joy_turn_left_button",  control_p2.joy_rotar_izq.boton);
	set_config_int ("player_2", "joy_turn_left_stick",   control_p2.joy_rotar_izq.stick);
	set_config_int ("player_2", "joy_turn_left_axis",    control_p2.joy_rotar_izq.axis);
	set_config_int ("player_2", "joy_turn_left_dir",     control_p2.joy_rotar_izq.dir);
	set_config_int ("player_2", "joy_turn_right_joy",     control_p2.joy_rotar_der.joy);
	set_config_int ("player_2", "joy_turn_right_type",    control_p2.joy_rotar_der.type);
	set_config_int ("player_2", "joy_turn_right_button",  control_p2.joy_rotar_der.boton);
	set_config_int ("player_2", "joy_turn_right_stick",   control_p2.joy_rotar_der.stick);
	set_config_int ("player_2", "joy_turn_right_axis",    control_p2.joy_rotar_der.axis);
	set_config_int ("player_2", "joy_turn_right_dir",     control_p2.joy_rotar_der.dir);
	set_config_int ("player_2", "joy_left_joy",     control_p2.joy_izq.joy);
	set_config_int ("player_2", "joy_left_type",    control_p2.joy_izq.type);
	set_config_int ("player_2", "joy_left_button",  control_p2.joy_izq.boton);
	set_config_int ("player_2", "joy_left_stick",   control_p2.joy_izq.stick);
	set_config_int ("player_2", "joy_left_axis",    control_p2.joy_izq.axis);
	set_config_int ("player_2", "joy_left_dir",     control_p2.joy_izq.dir);
	set_config_int ("player_2", "joy_right_joy",    control_p2.joy_der.joy);
	set_config_int ("player_2", "joy_right_type",   control_p2.joy_der.type);
	set_config_int ("player_2", "joy_right_button", control_p2.joy_der.boton);
	set_config_int ("player_2", "joy_right_stick",  control_p2.joy_der.stick);
	set_config_int ("player_2", "joy_right_axis",   control_p2.joy_der.axis);
	set_config_int ("player_2", "joy_right_dir",    control_p2.joy_der.dir);

	set_config_int ("player_3", "type",      control_p3.tipo);
	set_config_int ("player_3", "key_down",  control_p3.key_abajo);
	set_config_int ("player_3", "key_turn_right",  control_p3.key_rotar_izq);
	set_config_int ("player_3", "key_turn_left",  control_p3.key_rotar_der);
	set_config_int ("player_3", "key_left",  control_p3.key_der);
	set_config_int ("player_3", "key_right", control_p3.key_izq);
	set_config_int ("player_3", "joy_down_joy",     control_p3.joy_abajo.joy);
	set_config_int ("player_3", "joy_down_type",    control_p3.joy_abajo.type);
	set_config_int ("player_3", "joy_down_button",  control_p3.joy_abajo.boton);
	set_config_int ("player_3", "joy_down_stick",   control_p3.joy_abajo.stick);
	set_config_int ("player_3", "joy_down_axis",    control_p3.joy_abajo.axis);
	set_config_int ("player_3", "joy_down_dir",     control_p3.joy_abajo.dir);
	set_config_int ("player_3", "joy_turn_left_joy",     control_p3.joy_rotar_izq.joy);
	set_config_int ("player_3", "joy_turn_left_type",    control_p3.joy_rotar_izq.type);
	set_config_int ("player_3", "joy_turn_left_button",  control_p3.joy_rotar_izq.boton);
	set_config_int ("player_3", "joy_turn_left_stick",   control_p3.joy_rotar_izq.stick);
	set_config_int ("player_3", "joy_turn_left_axis",    control_p3.joy_rotar_izq.axis);
	set_config_int ("player_3", "joy_turn_left_dir",     control_p3.joy_rotar_izq.dir);
	set_config_int ("player_3", "joy_turn_right_joy",     control_p3.joy_rotar_der.joy);
	set_config_int ("player_3", "joy_turn_right_type",    control_p3.joy_rotar_der.type);
	set_config_int ("player_3", "joy_turn_right_button",  control_p3.joy_rotar_der.boton);
	set_config_int ("player_3", "joy_turn_right_stick",   control_p3.joy_rotar_der.stick);
	set_config_int ("player_3", "joy_turn_right_axis",    control_p3.joy_rotar_der.axis);
	set_config_int ("player_3", "joy_turn_right_dir",     control_p3.joy_rotar_der.dir);
	set_config_int ("player_3", "joy_left_joy",     control_p3.joy_izq.joy);
	set_config_int ("player_3", "joy_left_type",    control_p3.joy_izq.type);
	set_config_int ("player_3", "joy_left_button",  control_p3.joy_izq.boton);
	set_config_int ("player_3", "joy_left_stick",   control_p3.joy_izq.stick);
	set_config_int ("player_3", "joy_left_axis",    control_p3.joy_izq.axis);
	set_config_int ("player_3", "joy_left_dir",     control_p3.joy_izq.dir);
	set_config_int ("player_3", "joy_right_joy",    control_p3.joy_der.joy);
	set_config_int ("player_3", "joy_right_type",   control_p3.joy_der.type);
	set_config_int ("player_3", "joy_right_button", control_p3.joy_der.boton);
	set_config_int ("player_3", "joy_right_stick",  control_p3.joy_der.stick);
	set_config_int ("player_3", "joy_right_axis",   control_p3.joy_der.axis);
	set_config_int ("player_3", "joy_right_dir",    control_p3.joy_der.dir);

	set_config_int ("player_4", "type",      control_p4.tipo);
	set_config_int ("player_4", "key_down",  control_p4.key_abajo);
	set_config_int ("player_4", "key_turn_right",  control_p4.key_rotar_izq);
	set_config_int ("player_4", "key_turn_left",  control_p4.key_rotar_der);
	set_config_int ("player_4", "key_left",  control_p4.key_der);
	set_config_int ("player_4", "key_right", control_p4.key_izq);
	set_config_int ("player_4", "joy_down_joy",     control_p4.joy_abajo.joy);
	set_config_int ("player_4", "joy_down_type",    control_p4.joy_abajo.type);
	set_config_int ("player_4", "joy_down_button",  control_p4.joy_abajo.boton);
	set_config_int ("player_4", "joy_down_stick",   control_p4.joy_abajo.stick);
	set_config_int ("player_4", "joy_down_axis",    control_p4.joy_abajo.axis);
	set_config_int ("player_4", "joy_down_dir",     control_p4.joy_abajo.dir);
	set_config_int ("player_4", "joy_turn_left_joy",     control_p4.joy_rotar_izq.joy);
	set_config_int ("player_4", "joy_turn_left_type",    control_p4.joy_rotar_izq.type);
	set_config_int ("player_4", "joy_turn_left_button",  control_p4.joy_rotar_izq.boton);
	set_config_int ("player_4", "joy_turn_left_stick",   control_p4.joy_rotar_izq.stick);
	set_config_int ("player_4", "joy_turn_left_axis",    control_p4.joy_rotar_izq.axis);
	set_config_int ("player_4", "joy_turn_left_dir",     control_p4.joy_rotar_izq.dir);
	set_config_int ("player_4", "joy_turn_right_joy",     control_p4.joy_rotar_der.joy);
	set_config_int ("player_4", "joy_turn_right_type",    control_p4.joy_rotar_der.type);
	set_config_int ("player_4", "joy_turn_right_button",  control_p4.joy_rotar_der.boton);
	set_config_int ("player_4", "joy_turn_right_stick",   control_p4.joy_rotar_der.stick);
	set_config_int ("player_4", "joy_turn_right_axis",    control_p4.joy_rotar_der.axis);
	set_config_int ("player_4", "joy_turn_right_dir",     control_p4.joy_rotar_der.dir);
	set_config_int ("player_4", "joy_left_joy",     control_p4.joy_izq.joy);
	set_config_int ("player_4", "joy_left_type",    control_p4.joy_izq.type);
	set_config_int ("player_4", "joy_left_button",  control_p4.joy_izq.boton);
	set_config_int ("player_4", "joy_left_stick",   control_p4.joy_izq.stick);
	set_config_int ("player_4", "joy_left_axis",    control_p4.joy_izq.axis);
	set_config_int ("player_4", "joy_left_dir",     control_p4.joy_izq.dir);
	set_config_int ("player_4", "joy_right_joy",    control_p4.joy_der.joy);
	set_config_int ("player_4", "joy_right_type",   control_p4.joy_der.type);
	set_config_int ("player_4", "joy_right_button", control_p4.joy_der.boton);
	set_config_int ("player_4", "joy_right_stick",  control_p4.joy_der.stick);
	set_config_int ("player_4", "joy_right_axis",   control_p4.joy_der.axis);
	set_config_int ("player_4", "joy_right_dir",    control_p4.joy_der.dir);
}
